/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.D8Checker;
import org.jetbrains.kotlin.generators.util.GeneratorsFileUtil;
import org.jetbrains.kotlin.test.backend.BlackBoxCodegenSuppressorKt;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManager;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManagerKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/DxCheckerHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "tests-common-new"})
public final class DxCheckerHandler
extends JvmBinaryArtifactHandler {
    public DxCheckerHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getRUN_DEX_CHECKER()) || module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_DEXING())) {
            return;
        }
        CompiledClassesManager compiledClassesManager = CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices());
        try {
            D8Checker.check(info.getClassFileFactory());
        }
        catch (Throwable e) {
            if (!GeneratorsFileUtil.INSTANCE.isTeamCityBuild() && !BlackBoxCodegenSuppressorKt.getCodegenSuppressionChecker(this.getTestServices()).failuresInModuleAreIgnored(module)) {
                try {
                    File javaDir = compiledClassesManager.getCompiledJavaDirForModule(module);
                    if (javaDir != null) {
                        System.out.println((Object)("Compiled Java files: " + javaDir.getAbsolutePath()));
                    }
                    File kotlinDir = CompiledClassesManager.getCompiledKotlinDirForModule$default(compiledClassesManager, module, null, 2, null);
                    System.out.println((Object)("Compiled Kotlin files: " + kotlinDir.getAbsolutePath()));
                    Iterable $this$forEach$iv = ClassFileUtilsKt.getClassFiles((ClassFileFactory)info.getClassFileFactory());
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        OutputFile it = (OutputFile)element$iv;
                        boolean bl = false;
                        System.out.println((Object)(" * " + it.getRelativePath()));
                    }
                    System.out.println((Object)info.getClassFileFactory().createText());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }
}

