/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.BytecodeTextUtilsKt;
import org.jetbrains.kotlin.codegen.OccurrenceInfo;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.backend.BlackBoxCodegenSuppressorKt;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J.\u0010\u0014\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/BytecodeTextHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "shouldEnableExplicitly", "", "(Lorg/jetbrains/kotlin/test/services/TestServices;Z)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processAfterAllModules", "", "someAssertionWasFailed", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "processMultiFileTest", "files", "Lorg/jetbrains/kotlin/test/model/TestFile;", "targetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "reportProblems", "Companion", "tests-common-new"})
public final class BytecodeTextHandler
extends JvmBinaryArtifactHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean shouldEnableExplicitly;
    @NotNull
    private static final String IGNORED_PREFIX = "helpers/";

    public BytecodeTextHandler(@NotNull TestServices testServices, boolean shouldEnableExplicitly) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
        this.shouldEnableExplicitly = shouldEnableExplicitly;
    }

    public /* synthetic */ BytecodeTextHandler(TestServices testServices, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(testServices, bl);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.shouldEnableExplicitly && !module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getCHECK_BYTECODE_TEXT())) {
            return;
        }
        TargetBackend targetBackend = module.getTargetBackend();
        Intrinsics.checkNotNull((Object)((Object)targetBackend));
        TargetBackend targetBackend2 = targetBackend;
        boolean isIgnored = BlackBoxCodegenSuppressorKt.getCodegenSuppressionChecker(this.getTestServices()).failuresInModuleAreIgnored(module);
        Iterable $this$filter$iv = module.getFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestFile it = (TestFile)element$iv$iv;
            boolean bl = false;
            if (!SourceFileProviderKt.isKtFile(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files = (List)destination$iv$iv;
        if (files.size() > 1 && !module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getTREAT_AS_ONE_FILE())) {
            this.processMultiFileTest(files, info, targetBackend2, !isIgnored);
        } else {
            Object element$iv2;
            block5: {
                Iterable $this$first$iv = files;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    TestFile it = (TestFile)element$iv2;
                    boolean bl = false;
                    if (!(!it.isAdditional())) continue;
                    break block5;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            TestFile file = (TestFile)element$iv2;
            String[] $i$f$first = new String[]{"\n"};
            List<OccurrenceInfo> expected = BytecodeTextUtilsKt.readExpectedOccurrences(StringsKt.split$default((CharSequence)file.getOriginalContent(), (String[])$i$f$first, (boolean)false, (int)0, (int)6, null));
            String string = info.getClassFileFactory().createText(IGNORED_PREFIX);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"info.classFileFactory.createText(IGNORED_PREFIX)");
            String actual = string;
            BytecodeTextUtilsKt.checkGeneratedTextAgainstExpectedOccurrences(actual, expected, targetBackend2, !isIgnored, this.getAssertions());
        }
    }

    private final void processMultiFileTest(List<TestFile> files, BinaryArtifacts.Jvm info, TargetBackend targetBackend, boolean reportProblems) {
        LinkedHashMap expectedOccurrencesByOutputFile = new LinkedHashMap();
        ArrayList globalOccurrences = new ArrayList();
        for (TestFile file : files) {
            BytecodeTextUtilsKt.readExpectedOccurrencesForMultiFileTest(file.getName(), file.getOriginalContent(), expectedOccurrencesByOutputFile, globalOccurrences);
        }
        if (!((Collection)globalOccurrences).isEmpty()) {
            String string = info.getClassFileFactory().createText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"info.classFileFactory.createText()");
            String generatedText = string;
            BytecodeTextUtilsKt.checkGeneratedTextAgainstExpectedOccurrences(generatedText, globalOccurrences, targetBackend, reportProblems, this.getAssertions());
        }
        Map map = info.getClassFileFactory().createTextForEachFile();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"info.classFileFactory.createTextForEachFile()");
        Map generatedByFile = map;
        for (String expectedOutputFile : expectedOccurrencesByOutputFile.keySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)expectedOutputFile, (String)"expectedOutputFile");
            BytecodeTextUtilsKt.assertTextWasGenerated(expectedOutputFile, generatedByFile, this.getAssertions());
            Object v = generatedByFile.get(expectedOutputFile);
            Intrinsics.checkNotNull(v);
            String generatedText = (String)v;
            Object v2 = expectedOccurrencesByOutputFile.get(expectedOutputFile);
            Intrinsics.checkNotNull(v2);
            List expectedOccurrences = (List)v2;
            BytecodeTextUtilsKt.checkGeneratedTextAgainstExpectedOccurrences(generatedText, expectedOccurrences, targetBackend, reportProblems, this.getAssertions());
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/BytecodeTextHandler$Companion;", "", "()V", "IGNORED_PREFIX", "", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

