/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirIdenticalChecker;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.FirIdenticalCheckerHelper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirIdenticalChecker;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "helper", "org/jetbrains/kotlin/test/frontend/fir/handlers/FirIdenticalChecker$helper$1", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirIdenticalChecker$helper$1;", "check", "", "failedAssertions", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "removeFirFileIfExist", "testDataFile", "Ljava/io/File;", "tests-common-new"})
public final class FirIdenticalChecker
extends AfterAnalysisChecker {
    @NotNull
    private final helper.1 helper;

    public FirIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
        this.helper = new FirIdenticalCheckerHelper(testServices){

            @NotNull
            public File getClassicFileToCompare(@NotNull File testDataFile) {
                Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                return FileUtilsKt.isFirTestData(testDataFile) ? FileUtilsKt.getOriginalTestDataFile(testDataFile) : testDataFile;
            }

            @NotNull
            public File getFirFileToCompare(@NotNull File testDataFile) {
                Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                return FileUtilsKt.isFirTestData(testDataFile) ? testDataFile : FileUtilsKt.getFirTestDataFile(testDataFile);
            }
        };
    }

    @Override
    public void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        if (!((Collection)failedAssertions).isEmpty()) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        if (FileUtilsKt.isFirTestData(testDataFile)) {
            File firFile = this.helper.getFirFileToCompare(testDataFile);
            File classicFile = this.helper.getClassicFileToCompare(testDataFile);
            if (this.helper.contentsAreEquals(classicFile, firFile, true)) {
                this.helper.deleteFirFile(testDataFile);
                this.helper.addDirectiveToClassicFileAndAssert(classicFile);
            }
        } else {
            this.removeFirFileIfExist(testDataFile);
        }
    }

    private final void removeFirFileIfExist(File testDataFile) {
        File firFile = this.helper.getFirFileToCompare(testDataFile);
        firFile.delete();
    }
}

