/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.jvm;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.output.OutputUtilsKt;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.test.model.ArtifactKinds;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u0007J\u001a\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0007R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/test/services/jvm/CompiledClassesManager;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "compiledJavaCache", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Ljava/io/File;", "compiledKotlinCache", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "getCompiledJavaDirForModule", "module", "getCompiledKotlinDirForModule", "classFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "getOrCreateCompiledJavaDirForModule", "tests-common-new"})
public final class CompiledClassesManager
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Map<TestModule, File> compiledKotlinCache;
    @NotNull
    private final Map<TestModule, File> compiledJavaCache;

    public CompiledClassesManager(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
        this.compiledKotlinCache = new LinkedHashMap();
        this.compiledJavaCache = new LinkedHashMap();
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @NotNull
    public final File getCompiledKotlinDirForModule(@NotNull TestModule module, @Nullable ClassFileFactory classFileFactory) {
        File file;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map<TestModule, File> $this$getOrPut$iv = this.compiledKotlinCache;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(module);
        if (value$iv == null) {
            boolean bl = false;
            File outputDir = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.testServices, "module_" + module.getName() + "_kotlin-classes");
            ClassFileFactory classFileFactory2 = classFileFactory;
            if (classFileFactory2 == null) {
                classFileFactory2 = ((BinaryArtifacts.Jvm)DependencyProviderKt.getDependencyProvider(this.testServices).getArtifact(module, ArtifactKinds.Jvm.INSTANCE)).getClassFileFactory();
            }
            ClassFileFactory classFileFactory3 = classFileFactory2;
            List list = classFileFactory3.getCurrentOutput();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classFileFactory.currentOutput");
            SimpleOutputFileCollection outputFileCollection = new SimpleOutputFileCollection(list);
            Object object = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.testServices).getCompilerConfiguration(module).getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testServices.compilerCon\u2026ys.MESSAGE_COLLECTOR_KEY)");
            MessageCollector messageCollector = (MessageCollector)object;
            OutputUtilsKt.writeAll((OutputFileCollection)((OutputFileCollection)outputFileCollection), (File)outputDir, (MessageCollector)messageCollector, (boolean)false);
            File answer$iv = outputDir;
            $this$getOrPut$iv.put(module, answer$iv);
            file = answer$iv;
        } else {
            file = value$iv;
        }
        return file;
    }

    public static /* synthetic */ File getCompiledKotlinDirForModule$default(CompiledClassesManager compiledClassesManager, TestModule testModule, ClassFileFactory classFileFactory, int n, Object object) {
        if ((n & 2) != 0) {
            classFileFactory = null;
        }
        return compiledClassesManager.getCompiledKotlinDirForModule(testModule, classFileFactory);
    }

    @Nullable
    public final File getCompiledJavaDirForModule(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.compiledJavaCache.get(module);
    }

    @NotNull
    public final File getOrCreateCompiledJavaDirForModule(@NotNull TestModule module) {
        File file;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map<TestModule, File> $this$getOrPut$iv = this.compiledJavaCache;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(module);
        if (value$iv == null) {
            boolean bl = false;
            File answer$iv = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.testServices, "module_" + module.getName() + "_java-classes");
            $this$getOrPut$iv.put(module, answer$iv);
            file = answer$iv;
        } else {
            file = value$iv;
        }
        return file;
    }
}

