/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.services.SourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.SourceFileProvider;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0010H\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0010H\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u0010H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u0010H\u0016R\u001b\u0010\b\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\r\u001a\u0004\b\u0013\u0010\u000bR\u001b\u0010\u0015\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0016\u0010\u000bR\u001b\u0010\u0018\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\r\u001a\u0004\b\u0019\u0010\u000bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/test/services/SourceFileProviderImpl;", "Lorg/jetbrains/kotlin/test/services/SourceFileProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "preprocessors", "", "Lorg/jetbrains/kotlin/test/services/SourceFilePreprocessor;", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;)V", "additionalFilesDirectory", "Ljava/io/File;", "getAdditionalFilesDirectory", "()Ljava/io/File;", "additionalFilesDirectory$delegate", "Lkotlin/Lazy;", "contentOfFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "", "javaBinaryDirectory", "getJavaBinaryDirectory", "javaBinaryDirectory$delegate", "javaSourceDirectory", "getJavaSourceDirectory", "javaSourceDirectory$delegate", "kotlinSourceDirectory", "getKotlinSourceDirectory", "kotlinSourceDirectory$delegate", "getPreprocessors", "()Ljava/util/List;", "realFileMap", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "generateFinalContent", "testFile", "getContentOfSourceFile", "getRealFileForBinaryFile", "getRealFileForSourceFile", "test-infrastructure"})
public final class SourceFileProviderImpl
extends SourceFileProvider {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final List<SourceFilePreprocessor> preprocessors;
    @NotNull
    private final Lazy kotlinSourceDirectory$delegate;
    @NotNull
    private final Lazy javaSourceDirectory$delegate;
    @NotNull
    private final Lazy javaBinaryDirectory$delegate;
    @NotNull
    private final Lazy additionalFilesDirectory$delegate;
    @NotNull
    private final Map<TestFile, String> contentOfFiles;
    @NotNull
    private final Map<TestFile, File> realFileMap;

    public SourceFileProviderImpl(@NotNull TestServices testServices, @NotNull List<? extends SourceFilePreprocessor> preprocessors) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(preprocessors, (String)"preprocessors");
        this.testServices = testServices;
        this.preprocessors = preprocessors;
        this.kotlinSourceDirectory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ SourceFileProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.this$0.getTestServices(), "kotlin-files");
            }
        }));
        this.javaSourceDirectory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ SourceFileProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.this$0.getTestServices(), "java-files");
            }
        }));
        this.javaBinaryDirectory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ SourceFileProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.this$0.getTestServices(), "java-binary-files");
            }
        }));
        this.additionalFilesDirectory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ SourceFileProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.this$0.getTestServices(), "additional-files");
            }
        }));
        this.contentOfFiles = new LinkedHashMap();
        this.realFileMap = new LinkedHashMap();
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @Override
    @NotNull
    public List<SourceFilePreprocessor> getPreprocessors() {
        return this.preprocessors;
    }

    @Override
    @NotNull
    public File getKotlinSourceDirectory() {
        Lazy lazy = this.kotlinSourceDirectory$delegate;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public File getJavaSourceDirectory() {
        Lazy lazy = this.javaSourceDirectory$delegate;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public File getJavaBinaryDirectory() {
        Lazy lazy = this.javaBinaryDirectory$delegate;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public File getAdditionalFilesDirectory() {
        Lazy lazy = this.additionalFilesDirectory$delegate;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public String getContentOfSourceFile(@NotNull TestFile testFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Map<TestFile, String> $this$getOrPut$iv = this.contentOfFiles;
        boolean $i$f$getOrPut = false;
        String value$iv = $this$getOrPut$iv.get(testFile);
        if (value$iv == null) {
            boolean bl = false;
            String answer$iv = this.generateFinalContent(testFile);
            $this$getOrPut$iv.put(testFile, answer$iv);
            string = answer$iv;
        } else {
            string = value$iv;
        }
        return string;
    }

    @Override
    @NotNull
    public File getRealFileForSourceFile(@NotNull TestFile testFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Map<TestFile, File> $this$getOrPut$iv = this.realFileMap;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(testFile);
        if (value$iv == null) {
            File file2;
            boolean bl = false;
            File directory = SourceFileProviderKt.isKtFile(testFile) ? this.getKotlinSourceDirectory() : (SourceFileProviderKt.isJavaFile(testFile) ? this.getJavaSourceDirectory() : this.getAdditionalFilesDirectory());
            File it = file2 = FilesKt.resolve((File)directory, (String)testFile.getRelativePath());
            boolean bl2 = false;
            it.getParentFile().mkdirs();
            FilesKt.writeText$default((File)it, (String)this.getContentOfSourceFile(testFile), null, (int)2, null);
            File answer$iv = file2;
            $this$getOrPut$iv.put(testFile, answer$iv);
            file = answer$iv;
        } else {
            file = value$iv;
        }
        return file;
    }

    @Override
    @NotNull
    public File getRealFileForBinaryFile(@NotNull TestFile testFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Map<TestFile, File> $this$getOrPut$iv = this.realFileMap;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(testFile);
        if (value$iv == null) {
            File file2;
            boolean bl = false;
            if (!SourceFileProviderKt.isJavaFile(testFile)) {
                throw new IllegalStateException(("Unknown file type: " + testFile.getName()).toString());
            }
            File directory = this.getJavaBinaryDirectory();
            File it = file2 = FilesKt.resolve((File)directory, (String)testFile.getRelativePath());
            boolean bl2 = false;
            it.getParentFile().mkdirs();
            FilesKt.writeText$default((File)it, (String)this.getContentOfSourceFile(testFile), null, (int)2, null);
            File answer$iv = file2;
            $this$getOrPut$iv.put(testFile, answer$iv);
            file = answer$iv;
        } else {
            file = value$iv;
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateFinalContent(TestFile testFile) {
        void $this$fold$iv;
        Iterable iterable = this.getPreprocessors();
        String initial$iv = testFile.getOriginalContent();
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void preprocessor;
            SourceFilePreprocessor sourceFilePreprocessor = (SourceFilePreprocessor)element$iv;
            String content = accumulator$iv;
            boolean bl = false;
            accumulator$iv = preprocessor.process(testFile, content);
        }
        return accumulator$iv;
    }
}

