/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AbstractEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.ApplicationDisposableProviderKt;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProvider;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\fH\u0014J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\fH\u0014R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProviderImpl;", "Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "testRootDisposable", "Lcom/intellij/openapi/Disposable;", "configurators", "", "Lorg/jetbrains/kotlin/test/services/AbstractEnvironmentConfigurator;", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lcom/intellij/openapi/Disposable;Ljava/util/List;)V", "cache", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getConfigurators", "()Ljava/util/List;", "getTestRootDisposable", "()Lcom/intellij/openapi/Disposable;", "createCompilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "createKotlinCoreEnvironment", "getKotlinCoreEnvironment", "tests-common-new"})
public class CompilerConfigurationProviderImpl
extends CompilerConfigurationProvider {
    @NotNull
    private final Disposable testRootDisposable;
    @NotNull
    private final List<AbstractEnvironmentConfigurator> configurators;
    @NotNull
    private final Map<TestModule, KotlinCoreEnvironment> cache;

    public CompilerConfigurationProviderImpl(@NotNull TestServices testServices, @NotNull Disposable testRootDisposable, @NotNull List<? extends AbstractEnvironmentConfigurator> configurators) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)testRootDisposable, (String)"testRootDisposable");
        Intrinsics.checkNotNullParameter(configurators, (String)"configurators");
        super(testServices);
        this.testRootDisposable = testRootDisposable;
        this.configurators = configurators;
        this.cache = new LinkedHashMap();
    }

    @Override
    @NotNull
    public Disposable getTestRootDisposable() {
        return this.testRootDisposable;
    }

    @Override
    @NotNull
    public List<AbstractEnvironmentConfigurator> getConfigurators() {
        return this.configurators;
    }

    @Override
    @NotNull
    protected KotlinCoreEnvironment getKotlinCoreEnvironment(@NotNull TestModule module) {
        KotlinCoreEnvironment kotlinCoreEnvironment;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map<TestModule, KotlinCoreEnvironment> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        KotlinCoreEnvironment value$iv = $this$getOrPut$iv.get(module);
        if (value$iv == null) {
            boolean bl = false;
            KotlinCoreEnvironment answer$iv = this.createKotlinCoreEnvironment(module);
            $this$getOrPut$iv.put(module, answer$iv);
            kotlinCoreEnvironment = answer$iv;
        } else {
            kotlinCoreEnvironment = value$iv;
        }
        return kotlinCoreEnvironment;
    }

    @NotNull
    protected KotlinCoreEnvironment createKotlinCoreEnvironment(@NotNull TestModule module) {
        KotlinCoreEnvironment kotlinCoreEnvironment;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        TargetPlatform platform = module.getTargetPlatform();
        EnvironmentConfigFiles configFiles = CompilerConfigurationProviderKt.platformToEnvironmentConfigFiles(platform);
        KotlinCoreApplicationEnvironment applicationEnvironment = KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForTests(ApplicationDisposableProviderKt.getApplicationDisposableProvider(this.getTestServices()).getApplicationRootDisposable(), new CompilerConfiguration());
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.createCompilerConfiguration(module, this.getConfigurators());
        KotlinCoreEnvironment.ProjectEnvironment projectEnv = new KotlinCoreEnvironment.ProjectEnvironment(this.getTestRootDisposable(), applicationEnvironment, configuration2);
        KotlinCoreEnvironment it = kotlinCoreEnvironment = KotlinCoreEnvironment.Companion.createForTests(projectEnv, configuration2, configFiles);
        boolean bl = false;
        MockProject mockProject = projectEnv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"projectEnv.project");
        this.registerCompilerExtensions((Project)mockProject, module, configuration2);
        return kotlinCoreEnvironment;
    }

    @NotNull
    public final CompilerConfiguration createCompilerConfiguration(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return CompilerConfigurationProviderKt.createCompilerConfiguration(module, this.getConfigurators());
    }
}

