/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.test.frontend.classic.CompositeAnalysisTargetEnvironment;
import org.jetbrains.kotlin.test.frontend.classic.ModuleDescriptorProvider;
import org.jetbrains.kotlin.test.frontend.classic.MultiplatformAnalysisConfiguration;
import org.jetbrains.kotlin.test.frontend.classic.MultiplatformAnalysisConfigurationKt;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DependencyProvider;
import org.jetbrains.kotlin.test.services.SourceFileProvider;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/MultiplatformCompositeAnalysisConfiguration;", "Lorg/jetbrains/kotlin/test/frontend/classic/MultiplatformAnalysisConfiguration;", "dependencyProvider", "Lorg/jetbrains/kotlin/test/services/DependencyProvider;", "sourceFileProvider", "Lorg/jetbrains/kotlin/test/services/SourceFileProvider;", "moduleDescriptorProvider", "Lorg/jetbrains/kotlin/test/frontend/classic/ModuleDescriptorProvider;", "(Lorg/jetbrains/kotlin/test/services/DependencyProvider;Lorg/jetbrains/kotlin/test/services/SourceFileProvider;Lorg/jetbrains/kotlin/test/frontend/classic/ModuleDescriptorProvider;)V", "getCompilerEnvironment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "getDependencyDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "getDependsOnDescriptors", "getFriendDescriptors", "getKtFilesForForSourceFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "tests-common-new"})
public final class MultiplatformCompositeAnalysisConfiguration
implements MultiplatformAnalysisConfiguration {
    @NotNull
    private final DependencyProvider dependencyProvider;
    @NotNull
    private final SourceFileProvider sourceFileProvider;
    @NotNull
    private final ModuleDescriptorProvider moduleDescriptorProvider;

    public MultiplatformCompositeAnalysisConfiguration(@NotNull DependencyProvider dependencyProvider, @NotNull SourceFileProvider sourceFileProvider, @NotNull ModuleDescriptorProvider moduleDescriptorProvider) {
        Intrinsics.checkNotNullParameter((Object)dependencyProvider, (String)"dependencyProvider");
        Intrinsics.checkNotNullParameter((Object)sourceFileProvider, (String)"sourceFileProvider");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptorProvider, (String)"moduleDescriptorProvider");
        this.dependencyProvider = dependencyProvider;
        this.sourceFileProvider = sourceFileProvider;
        this.moduleDescriptorProvider = moduleDescriptorProvider;
    }

    @Override
    @NotNull
    public TargetEnvironment getCompilerEnvironment(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return CompositeAnalysisTargetEnvironment.INSTANCE;
    }

    @Override
    @NotNull
    public Map<TestFile, KtFile> getKtFilesForForSourceFiles(@NotNull Project project, @NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return SourceFileProviderKt.getKtFilesForSourceFiles(this.sourceFileProvider, (Collection<TestFile>)module.getFiles(), project);
    }

    @Override
    @NotNull
    public List<ModuleDescriptorImpl> getDependencyDescriptors(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Collection allDependsOnDependencies2 = TypeUtilsKt.closure((Collection)module.getDependsOnDependencies(), (boolean)true, (Function1)((Function1)new Function1<DependencyDescription, Collection<? extends DependencyDescription>>(this){
            final /* synthetic */ MultiplatformCompositeAnalysisConfiguration this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Collection<DependencyDescription> invoke(@NotNull DependencyDescription dependsOnDependency) {
                Intrinsics.checkNotNullParameter((Object)dependsOnDependency, (String)"dependsOnDependency");
                return MultiplatformCompositeAnalysisConfiguration.access$getDependencyProvider$p(this.this$0).getTestModule(dependsOnDependency.getModuleName()).getDependsOnDependencies();
            }
        }));
        List allDependencies = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)module.getAllDependencies(), (Iterable)allDependsOnDependencies2));
        return MultiplatformAnalysisConfigurationKt.access$getDescriptors(allDependencies, this.dependencyProvider, this.moduleDescriptorProvider);
    }

    @Override
    @NotNull
    public List<ModuleDescriptorImpl> getDependsOnDescriptors(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return MultiplatformAnalysisConfigurationKt.access$getDescriptors(module.getDependsOnDependencies(), this.dependencyProvider, this.moduleDescriptorProvider);
    }

    @Override
    @NotNull
    public List<ModuleDescriptorImpl> getFriendDescriptors(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return MultiplatformAnalysisConfigurationKt.access$getDescriptors(module.getFriendDependencies(), this.dependencyProvider, this.moduleDescriptorProvider);
    }

    public static final /* synthetic */ DependencyProvider access$getDependencyProvider$p(MultiplatformCompositeAnalysisConfiguration $this) {
        return $this.dependencyProvider;
    }
}

