/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectivesImpl;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005BM\b\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n\u0012\u001c\u0010\u000e\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\f0\n\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0004J\u0015\u0010\u0012\u001a\u00020\u0013*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\rH\u0086\u0002J=\u0010\u0015\u001a\u00020\u0013\"\b\b\u0000\u0010\u0016*\u00020\u0017\"\u0004\b\u0001\u0010\u0018*\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00180\n2\u0006\u0010\u0019\u001a\u0002H\u00162\u0006\u0010\u0014\u001a\u0002H\u0018H\u0002\u00a2\u0006\u0002\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0013*\u00020\bH\u0086\u0002J\r\u0010\u001b\u001a\u00020\u0013*\u00020\u000bH\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u000fH\u0086\u0002J\r\u0010\u001c\u001a\u00020\u0013*\u00020\bH\u0086\u0002J\u0015\u0010\u001d\u001a\u00020\u0013*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\rH\u0086\u0004J\u001b\u0010\u001d\u001a\u00020\u0013*\u00020\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0086\u0004J*\u0010\u001d\u001a\u00020\u0013\"\b\b\u0000\u0010\u001f*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u001f0\u000f2\u0006\u0010\u0014\u001a\u0002H\u001fH\u0086\u0004\u00a2\u0006\u0002\u0010 J+\u0010\u001d\u001a\u00020\u0013\"\b\b\u0000\u0010\u001f*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u001f0\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001f0\fH\u0086\u0004R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/test/builders/RegisteredDirectivesBuilder;", "", "()V", "old", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "(Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;)V", "simpleDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "stringDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "", "", "valueDirectives", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "(Ljava/util/List;Ljava/util/Map;Ljava/util/Map;)V", "build", "plus", "", "value", "putWithExistsCheck", "K", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "V", "key", "(Ljava/util/Map;Lorg/jetbrains/kotlin/test/directives/model/Directive;Ljava/lang/Object;)V", "unaryMinus", "unaryPlus", "with", "values", "T", "(Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;Ljava/lang/Object;)V", "tests-common-new"})
public final class RegisteredDirectivesBuilder {
    @NotNull
    private final List<SimpleDirective> simpleDirectives;
    @NotNull
    private final Map<StringDirective, List<String>> stringDirectives;
    @NotNull
    private final Map<ValueDirective<?>, List<Object>> valueDirectives;

    private RegisteredDirectivesBuilder(List<SimpleDirective> simpleDirectives, Map<StringDirective, List<String>> stringDirectives, Map<ValueDirective<?>, List<Object>> valueDirectives) {
        this.simpleDirectives = simpleDirectives;
        this.stringDirectives = stringDirectives;
        this.valueDirectives = valueDirectives;
    }

    public RegisteredDirectivesBuilder() {
        this(new ArrayList(), new LinkedHashMap(), new LinkedHashMap());
    }

    public RegisteredDirectivesBuilder(@NotNull RegisteredDirectives old) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        this();
        for (Directive directive2 : old) {
            Directive directive3 = directive2;
            if (directive3 instanceof SimpleDirective) {
                this.unaryPlus((SimpleDirective)directive2);
                continue;
            }
            if (directive3 instanceof StringDirective) {
                this.with((StringDirective)directive2, old.get((StringDirective)directive2));
                continue;
            }
            if (!(directive3 instanceof ValueDirective)) continue;
            this.valueDirectives.put((ValueDirective<?>)directive2, old.get((ValueDirective)directive2));
        }
    }

    public final void unaryPlus(@NotNull SimpleDirective $this$unaryPlus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
        ((Collection)this.simpleDirectives).add($this$unaryPlus);
    }

    public final void unaryMinus(@NotNull SimpleDirective $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        this.simpleDirectives.remove($this$unaryMinus);
    }

    public final void with(@NotNull StringDirective $this$with, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.with($this$with, CollectionsKt.listOf((Object)value));
    }

    public final void with(@NotNull StringDirective $this$with, @NotNull List<String> values2) {
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.putWithExistsCheck(this.stringDirectives, (Directive)$this$with, values2);
    }

    public final void plus(@NotNull StringDirective $this$plus, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        List list = this.stringDirectives.get($this$plus);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List previous = list;
        this.stringDirectives.put($this$plus, CollectionsKt.plus((Collection)previous, (Object)value));
    }

    public final void unaryMinus(@NotNull StringDirective $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        this.stringDirectives.remove($this$unaryMinus);
    }

    public final <T> void with(@NotNull ValueDirective<T> $this$with, @NotNull T value) {
        Intrinsics.checkNotNullParameter($this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.with($this$with, CollectionsKt.listOf(value));
    }

    public final <T> void with(@NotNull ValueDirective<T> $this$with, @NotNull List<? extends T> values2) {
        Intrinsics.checkNotNullParameter($this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.putWithExistsCheck(this.valueDirectives, (Directive)$this$with, values2);
    }

    public final void unaryMinus(@NotNull ValueDirective<?> $this$unaryMinus) {
        Intrinsics.checkNotNullParameter($this$unaryMinus, (String)"<this>");
        this.valueDirectives.remove($this$unaryMinus);
    }

    private final <K extends Directive, V> void putWithExistsCheck(Map<K, V> $this$putWithExistsCheck, K key, V value) {
        V alreadyRegistered = $this$putWithExistsCheck.put(key, value);
        if (alreadyRegistered != null) {
            throw new IllegalStateException(("Default values for " + key + " directive already registered").toString());
        }
    }

    @NotNull
    public final RegisteredDirectives build() {
        return new RegisteredDirectivesImpl(this.simpleDirectives, this.stringDirectives, this.valueDirectives);
    }
}

