/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.descriptors.FirModuleDescriptor;
import org.jetbrains.kotlin.test.backend.handlers.IrInterpreterDumpHandler;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.backend.handlers.PhasedIrDumpHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrInterpreterDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "checkInitializersAreConst", "", "text", "", "propertiesStart", "", "", "findConstProperties", "getDump", "Lkotlin/Pair;", "Ljava/io/File;", "processAfterAllModules", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "tests-common-new"})
public final class IrInterpreterDumpHandler
extends JvmBinaryArtifactHandler {
    public IrInterpreterDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
    }

    private final Pair<File, File> getDump() {
        File file;
        int n;
        File[] dumpFiles;
        File dumpDirectory = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.getTestServices(), "dumped_ir");
        String string = FirModuleDescriptor.Companion.getFIR_MODULE_NAME().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FirModuleDescriptor.FIR_MODULE_NAME.asString()");
        if (dumpFiles != null) {
            File[] $this$single$iv = dumpFiles = FilesKt.resolve((File)dumpDirectory, (String)string).listFiles();
            boolean $i$f$single = false;
            File single$iv = null;
            boolean found$iv = false;
            n = $this$single$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$single$iv[i];
                boolean bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)PhasedIrDumpHandler.Companion.getBEFORE_PREFIX(), (boolean)false, (int)2, null)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            file = single$iv;
        } else {
            file = null;
        }
        if (file == null) {
            return null;
        }
        File before = file;
        Intrinsics.checkNotNullExpressionValue((Object)dumpFiles, (String)"dumpFiles");
        File[] $this$single$iv = dumpFiles;
        boolean $i$f$single = false;
        File single$iv = null;
        boolean found$iv = false;
        int n2 = $this$single$iv.length;
        for (n = 0; n < n2; ++n) {
            File element$iv;
            File it = element$iv = $this$single$iv[n];
            boolean bl = false;
            String string3 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name");
            if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)PhasedIrDumpHandler.Companion.getAFTER_PREFIX(), (boolean)false, (int)2, null)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Array contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        File file2 = single$iv;
        if (file2 == null) {
            return null;
        }
        File after = file2;
        return new Pair(before, after);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> findConstProperties(String text) {
        void $this$mapTo$iv$iv;
        Pair it;
        Iterable $this$filterTo$iv$iv;
        Collection collection;
        Iterable $this$mapIndexedTo$iv$iv;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$mapIndexed$iv = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void line;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)((int)index), (Object)line));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapIndexedTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)((String)it.getSecond()))).toString(), (String)"PROPERTY", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)((CharSequence)it.getSecond()), (CharSequence)"[const,val]", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)it.getFirst()).intValue());
        }
        return (List)destination$iv$iv;
    }

    private final void checkInitializersAreConst(String text, List<Integer> propertiesStart) {
        Object object = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)text, (String[])object, (boolean)false, (int)0, (int)6, null);
        object = propertiesStart.iterator();
        while (object.hasNext()) {
            int index = ((Number)object.next()).intValue();
            AssertionsKt.getAssertions(this.getTestServices()).assertTrue(StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)((String)lines.get(index + 3)))).toString(), (String)"CONST", (boolean)false, (int)2, null), (Function0<String>)((Function0)new Function0<String>(index){
                final /* synthetic */ int $index;
                {
                    this.$index = $index;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Property at " + this.$index + " wasn't converted to const";
                }
            }));
        }
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR_FOR_GIVEN_PHASES())) {
            return;
        }
        Pair<File, File> pair = this.getDump();
        if (pair == null) {
            AssertionsKt.getAssertions(this.getTestServices()).fail((Function0<String>)((Function0)processModule.1.INSTANCE));
            throw null;
        }
        Pair<File, File> pair2 = pair;
        File before = (File)pair2.component1();
        File after = (File)pair2.component2();
        String beforeText = FilesKt.readText$default((File)before, null, (int)1, null);
        String afterText = FilesKt.readText$default((File)after, null, (int)1, null);
        List<Integer> propertiesBefore = this.findConstProperties(beforeText);
        List<Integer> propertiesAfter = this.findConstProperties(afterText);
        AssertionsKt.getAssertions(this.getTestServices()).assertTrue(!((Collection)propertiesBefore).isEmpty(), (Function0<String>)((Function0)processModule.2.INSTANCE));
        AssertionsKt.getAssertions(this.getTestServices()).assertEquals(propertiesBefore.size(), propertiesAfter.size(), (Function0<String>)((Function0)processModule.3.INSTANCE));
        this.checkInitializersAreConst(afterText, propertiesAfter);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }
}

