/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.test.PatternWithExtractor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00018\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00018\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/test/ValuePatternWithExtractor;", "E", "", "Lorg/jetbrains/kotlin/test/PatternWithExtractor;", "directive", "", "configurationKey", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "extractor", "Lkotlin/Function1;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;Lkotlin/jvm/functions/Function1;)V", "getConfigurationKey", "()Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "getDirective", "()Ljava/lang/String;", "getExtractor", "()Lkotlin/jvm/functions/Function1;", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "extract", "matcher", "Ljava/util/regex/Matcher;", "(Ljava/util/regex/Matcher;)Ljava/lang/Object;", "tests-compiler-utils"})
final class ValuePatternWithExtractor<E>
extends PatternWithExtractor<E> {
    @NotNull
    private final String directive;
    @NotNull
    private final CompilerConfigurationKey<E> configurationKey;
    @NotNull
    private final Function1<String, E> extractor;
    @NotNull
    private final Pattern pattern;

    public ValuePatternWithExtractor(@NotNull String directive2, @NotNull CompilerConfigurationKey<E> configurationKey, @NotNull Function1<? super String, ? extends E> extractor) {
        Intrinsics.checkNotNullParameter((Object)directive2, (String)"directive");
        Intrinsics.checkNotNullParameter(configurationKey, (String)"configurationKey");
        Intrinsics.checkNotNullParameter(extractor, (String)"extractor");
        super(null);
        this.directive = directive2;
        this.configurationKey = configurationKey;
        this.extractor = extractor;
        Pattern pattern = Pattern.compile(this.directive + "=([a-zA-Z_0-9-]*)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"$directive=([a-zA-Z_0-9-]*)\")");
        this.pattern = pattern;
    }

    @NotNull
    public final String getDirective() {
        return this.directive;
    }

    @Override
    @NotNull
    public CompilerConfigurationKey<E> getConfigurationKey() {
        return this.configurationKey;
    }

    @NotNull
    public final Function1<String, E> getExtractor() {
        return this.extractor;
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    @NotNull
    public E extract(@NotNull Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String stringValue = matcher.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)stringValue, (String)"stringValue");
        Object object = this.extractor.invoke((Object)stringValue);
        if (object == null) {
            throw new IllegalStateException(("Wrong " + this.directive + " value: " + stringValue).toString());
        }
        return (E)object;
    }
}

