/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationSession;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationStatus;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0014J)\u0010\u0017\u001a\u0002H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u0002H\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirApplySupertypesTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "", "supertypeComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;)V", "applyResolvedSupertypesToClass", "", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getResolvedSupertypeRefs", "", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "classLikeDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "transformAnonymousObject", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "data", "transformDeclarationContent", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "resolve"})
public class FirApplySupertypesTransformer
extends FirDefaultTransformer<Object> {
    @NotNull
    private final SupertypeComputationSession supertypeComputationSession;

    public FirApplySupertypesTransformer(@NotNull SupertypeComputationSession supertypeComputationSession) {
        Intrinsics.checkNotNullParameter((Object)supertypeComputationSession, (String)"supertypeComputationSession");
        this.supertypeComputationSession = supertypeComputationSession;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element;
    }

    @NotNull
    protected FirDeclaration transformDeclarationContent(@NotNull FirDeclaration declaration, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirElement firElement = declaration.transformChildren(this, null);
        Intrinsics.checkNotNull((Object)firElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirDeclaration");
        return (FirDeclaration)firElement;
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FirDeclaration firDeclaration = this.transformDeclarationContent(file2, null);
        Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirFile");
        return (FirFile)firDeclaration;
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        this.applyResolvedSupertypesToClass(regularClass);
        FirDeclaration firDeclaration = this.transformDeclarationContent(regularClass, null);
        Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
        return (FirRegularClass)firDeclaration;
    }

    private final void applyResolvedSupertypesToClass(FirClass firClass2) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = firClass2.getSuperTypeRefs();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl2 = false;
                    if (!(!(it instanceof FirResolvedTypeRef) || it instanceof FirImplicitBuiltinTypeRef)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            List<FirResolvedTypeRef> supertypeRefs = this.getResolvedSupertypeRefs(firClass2);
            firClass2.replaceSuperTypeRefs(supertypeRefs);
        }
    }

    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        this.applyResolvedSupertypesToClass(anonymousObject);
        FirElement firElement = anonymousObject.transformChildren(this, data);
        Intrinsics.checkNotNull((Object)firElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirAnonymousObject");
        return (FirAnonymousObject)firElement;
    }

    private final List<FirResolvedTypeRef> getResolvedSupertypeRefs(FirClassLikeDeclaration classLikeDeclaration) {
        SupertypeComputationStatus status2 = this.supertypeComputationSession.getSupertypesComputationStatus(classLikeDeclaration);
        if (!(status2 instanceof SupertypeComputationStatus.Computed)) {
            boolean bl = false;
            String string2 = "Unexpected status at FirApplySupertypesTransformer: " + status2 + " for " + classLikeDeclaration.getSymbol().getClassId();
            throw new IllegalArgumentException(string2.toString());
        }
        return ((SupertypeComputationStatus.Computed)status2).getSupertypeRefs();
    }

    @Override
    @NotNull
    public FirStatement transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        if (typeAlias.getExpandedTypeRef() instanceof FirResolvedTypeRef) {
            return typeAlias;
        }
        List<FirResolvedTypeRef> supertypeRefs = this.getResolvedSupertypeRefs(typeAlias);
        boolean bl2 = bl = supertypeRefs.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Expected single supertypeRefs, but found " + supertypeRefs.size() + " in " + typeAlias.getSymbol().getClassId();
            throw new AssertionError((Object)string2);
        }
        typeAlias.replaceExpandedTypeRef(supertypeRefs.get(0));
        return typeAlias;
    }
}

