/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.ir.backend.js.lower.JsScopesCollector;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/KotlinLocalsUsageCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "scopeInfo", "Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector;", "findValueDeclarationWithName", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector;Lkotlin/jvm/functions/Function1;)V", "functionStack", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "kotlinLocalsUsedInJs", "processedNames", "", "usedLocals", "", "getUsedLocals", "()Ljava/util/List;", "visitFunction", "", "x", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "isDeclaredInsideJsCode", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "backend.js"})
final class KotlinLocalsUsageCollector
extends RecursiveJsVisitor {
    @NotNull
    private final JsScopesCollector scopeInfo;
    @NotNull
    private final Function1<String, IrValueDeclaration> findValueDeclarationWithName;
    @NotNull
    private final List<JsFunction> functionStack;
    @NotNull
    private final Set<String> processedNames;
    @NotNull
    private final List<IrValueDeclaration> kotlinLocalsUsedInJs;

    public KotlinLocalsUsageCollector(@NotNull JsScopesCollector scopeInfo, @NotNull Function1<? super String, ? extends IrValueDeclaration> findValueDeclarationWithName) {
        Intrinsics.checkNotNullParameter((Object)scopeInfo, (String)"scopeInfo");
        Intrinsics.checkNotNullParameter(findValueDeclarationWithName, (String)"findValueDeclarationWithName");
        this.scopeInfo = scopeInfo;
        this.findValueDeclarationWithName = findValueDeclarationWithName;
        Object[] objectArray = new JsFunction[]{null};
        this.functionStack = kotlin.collections.CollectionsKt.mutableListOf((Object[])objectArray);
        this.processedNames = new LinkedHashSet();
        this.kotlinLocalsUsedInJs = new ArrayList();
    }

    @NotNull
    public final List<IrValueDeclaration> getUsedLocals() {
        return this.kotlinLocalsUsedInJs;
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        UtilsKt.push(this.functionStack, x);
        super.visitFunction(x);
        UtilsKt.pop(this.functionStack);
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
        super.visitNameRef(nameRef);
        JsName it = jsName = nameRef.getName();
        boolean bl = false;
        JsName jsName2 = nameRef.getQualifier() == null ? jsName : null;
        if (jsName2 == null) {
            return;
        }
        JsName name2 = jsName2;
        String string2 = name2.getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.ident");
        if (this.processedNames.add(string2) && !this.isDeclaredInsideJsCode(name2)) {
            Collection collection = this.kotlinLocalsUsedInJs;
            String string3 = name2.getIdent();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name.ident");
            CollectionsKt.addIfNotNull(collection, this.findValueDeclarationWithName.invoke((Object)string3));
        }
    }

    private final boolean isDeclaredInsideJsCode(JsName $this$isDeclaredInsideJsCode) {
        String string2 = $this$isDeclaredInsideJsCode.getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ident");
        return this.scopeInfo.varWithNameExistsInScopeOf(UtilsKt.peek(this.functionStack), string2);
    }
}

