/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codeMetaInfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codeMetaInfo.CodeMetaInfoParser;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/codeMetaInfo/CodeMetaInfoParser;", "", "()V", "closingRegex", "Lkotlin/text/Regex;", "getClosingRegex", "()Lkotlin/text/Regex;", "openingOrClosingRegex", "getOpeningOrClosingRegex", "openingRegex", "getOpeningRegex", "tagRegex", "getCodeMetaInfoFromText", "", "Lorg/jetbrains/kotlin/codeMetaInfo/model/ParsedCodeMetaInfo;", "renderedText", "", "Opening", "test-infrastructure-utils"})
public final class CodeMetaInfoParser {
    @NotNull
    public static final CodeMetaInfoParser INSTANCE = new CodeMetaInfoParser();
    @NotNull
    private static final Regex openingRegex = new Regex("(<!([^\"]*?((\".*?\")(, \".*?\")*?)?[^\"]*?)!>)");
    @NotNull
    private static final Regex closingRegex = new Regex("(<!>)");
    @NotNull
    private static final Regex openingOrClosingRegex = new Regex('(' + closingRegex.getPattern() + '|' + openingRegex.getPattern() + ')');
    @NotNull
    private static final Regex tagRegex = new Regex("([\\S&&[^,(){}]]+)([{](.*?)[}])?(\\(\"(.*?)\"\\))?(, )?");

    private CodeMetaInfoParser() {
    }

    @NotNull
    public final Regex getOpeningRegex() {
        return openingRegex;
    }

    @NotNull
    public final Regex getClosingRegex() {
        return closingRegex;
    }

    @NotNull
    public final Regex getOpeningOrClosingRegex() {
        return openingOrClosingRegex;
    }

    @NotNull
    public final List<ParsedCodeMetaInfo> getCodeMetaInfoFromText(@NotNull String renderedText) {
        Intrinsics.checkNotNullParameter((Object)renderedText, (String)"renderedText");
        String text2 = renderedText;
        ArrayDeque openings = new ArrayDeque();
        ArrayDeque stackOfOpenings = new ArrayDeque();
        Map closingOffsets = new LinkedHashMap();
        List result2 = new ArrayList();
        int counter = 0;
        while (true) {
            String string2;
            Object openingMatch;
            int openingStartOffset = Integer.MAX_VALUE;
            int closingStartOffset = Integer.MAX_VALUE;
            MatchResult opening = Regex.find$default((Regex)openingRegex, (CharSequence)text2, (int)0, (int)2, null);
            MatchResult closing = Regex.find$default((Regex)closingRegex, (CharSequence)text2, (int)0, (int)2, null);
            if (opening == null && closing == null) break;
            if (opening != null) {
                openingStartOffset = opening.getRange().getFirst();
            }
            if (closing != null) {
                closingStartOffset = closing.getRange().getFirst();
            }
            if (openingStartOffset < closingStartOffset) {
                if (opening == null) {
                    String string3 = "Required value was null.";
                    throw new IllegalArgumentException(string3.toString());
                }
                int n = counter++;
                MatchGroup matchGroup = opening.getGroups().get(2);
                Intrinsics.checkNotNull((Object)matchGroup);
                openingMatch = new Opening(n, matchGroup.getValue(), opening.getRange().getFirst());
                openings.addLast(openingMatch);
                stackOfOpenings.addLast(openingMatch);
                String string4 = text2;
                int n2 = opening.getRange().getLast() + 1;
                string2 = ((Object)StringsKt.removeRange((CharSequence)string4, (int)openingStartOffset, (int)n2)).toString();
            } else {
                if (closing == null) {
                    openingMatch = "Required value was null.";
                    throw new IllegalArgumentException(openingMatch.toString());
                }
                closingOffsets.put(stackOfOpenings.removeLast(), closing.getRange().getFirst());
                openingMatch = text2;
                int n = closing.getRange().getLast() + 1;
                string2 = ((Object)StringsKt.removeRange((CharSequence)((CharSequence)openingMatch), (int)closingStartOffset, (int)n)).toString();
            }
            text2 = string2;
        }
        if (openings.size() != closingOffsets.size()) {
            throw new IllegalStateException("Opening and closing tags counts are not equals".toString());
        }
        while (!openings.isEmpty()) {
            Opening openingMatchResult = (Opening)openings.removeLast();
            int closingMatchResult = ((Number)MapsKt.getValue((Map)closingOffsets, (Object)openingMatchResult)).intValue();
            String allMetaInfos = openingMatchResult.getTags();
            Sequence $this$forEach$iv = SequencesKt.map((Sequence)Regex.findAll$default((Regex)tagRegex, (CharSequence)allMetaInfos, (int)0, (int)2, null), (Function1)getCodeMetaInfoFromText.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String[] stringArray;
                MatchGroupCollection it = (MatchGroupCollection)element$iv;
                boolean bl = false;
                MatchGroup matchGroup = it.get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String tag = matchGroup.getValue();
                Object object = it.get(3);
                if (object == null || (object = object.getValue()) == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{";"}), (boolean)false, (int)0, (int)6, null)) == null) {
                    object = CollectionsKt.emptyList();
                }
                Object attributes2 = object;
                MatchGroup matchGroup2 = it.get(5);
                String description2 = matchGroup2 != null ? matchGroup2.getValue() : null;
                result2.add(new ParsedCodeMetaInfo(openingMatchResult.getStartOffset(), closingMatchResult, CollectionsKt.toMutableList((Collection)((Collection)attributes2)), tag, description2));
            }
        }
        return result2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/codeMetaInfo/CodeMetaInfoParser$Opening;", "", "index", "", "tags", "", "startOffset", "(ILjava/lang/String;I)V", "getIndex", "()I", "getStartOffset", "getTags", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "test-infrastructure-utils"})
    private static final class Opening {
        private final int index;
        @NotNull
        private final String tags;
        private final int startOffset;

        public Opening(int index2, @NotNull String tags, int startOffset) {
            Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
            this.index = index2;
            this.tags = tags;
            this.startOffset = startOffset;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final String getTags() {
            return this.tags;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.codeMetaInfo.CodeMetaInfoParser.Opening");
            Opening cfr_ignored_0 = (Opening)other;
            return this.index == ((Opening)other).index;
        }

        public int hashCode() {
            return this.index;
        }
    }
}

