/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.model;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.model.AbstractTestFacade;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.SourcesKind;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H&\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001b\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001aR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/model/FrontendFacade;", "R", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact$FrontendOutput;", "Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact$Source;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "outputKind", "Lorg/jetbrains/kotlin/test/model/FrontendKind;", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/model/FrontendKind;)V", "inputKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getInputKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getOutputKind", "()Lorg/jetbrains/kotlin/test/model/FrontendKind;", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "analyze", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "(Lorg/jetbrains/kotlin/test/model/TestModule;)Lorg/jetbrains/kotlin/test/model/ResultingArtifact$FrontendOutput;", "shouldRunAnalysis", "", "transform", "inputArtifact", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/ResultingArtifact$Source;)Lorg/jetbrains/kotlin/test/model/ResultingArtifact$FrontendOutput;", "test-infrastructure"})
public abstract class FrontendFacade<R extends ResultingArtifact.FrontendOutput<R>>
extends AbstractTestFacade<ResultingArtifact.Source, R> {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final FrontendKind<R> outputKind;

    public FrontendFacade(@NotNull TestServices testServices, @NotNull FrontendKind<R> outputKind) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter(outputKind, (String)"outputKind");
        this.testServices = testServices;
        this.outputKind = outputKind;
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @Override
    @NotNull
    public final FrontendKind<R> getOutputKind() {
        return this.outputKind;
    }

    @Override
    @NotNull
    public final TestArtifactKind<ResultingArtifact.Source> getInputKind() {
        return SourcesKind.INSTANCE;
    }

    @Override
    public boolean shouldRunAnalysis(@NotNull TestModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return Intrinsics.areEqual(module2.getFrontendKind(), this.outputKind);
    }

    @NotNull
    public abstract R analyze(@NotNull TestModule var1);

    @Override
    @NotNull
    public final R transform(@NotNull TestModule module2, @NotNull ResultingArtifact.Source inputArtifact) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)inputArtifact, (String)"inputArtifact");
        return this.analyze(module2);
    }
}

