/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import com.intellij.rt.execution.junit.FileComparisonFailure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.util.StringUtilsKt;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.AssertionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J,\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J:\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00112\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J \u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00042\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J,\u0010\u0019\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J\"\u0010\u001a\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J:\u0010\u001b\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u001c2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001d2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001d2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J \u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00042\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J\u0016\u0010\u001f\u001a\u00020 2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/test/services/JUnit5Assertions;", "Lorg/jetbrains/kotlin/test/services/AssertionsService;", "()V", "isTeamCityBuild", "", "()Z", "assertAll", "", "exceptions", "", "", "assertEquals", "expected", "", "actual", "message", "Lkotlin/Function0;", "", "assertEqualsToFile", "expectedFile", "Ljava/io/File;", "sanitizer", "Lkotlin/Function1;", "assertFalse", "value", "assertNotEquals", "assertNotNull", "assertSameElements", "T", "", "assertTrue", "fail", "", "FileComparisonFailureFirst", "tests-common-new"})
public final class JUnit5Assertions
extends AssertionsService {
    @NotNull
    public static final JUnit5Assertions INSTANCE = new JUnit5Assertions();
    private static final boolean isTeamCityBuild = System.getenv("TEAMCITY_VERSION") != null;

    private JUnit5Assertions() {
    }

    public final boolean isTeamCityBuild() {
        return isTeamCityBuild;
    }

    @Override
    public void assertEqualsToFile(@NotNull File expectedFile, @NotNull String actual, @NotNull Function1<? super String, String> sanitizer, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter((Object)expectedFile, (String)"expectedFile");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter(sanitizer, (String)"sanitizer");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        try {
            String expectedText;
            String expected;
            String $this$trim$iv = actual;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String actualText = StringUtilsKt.trimTrailingWhitespacesAndAddNewlineAtEOF(StringUtilsKt.convertLineSeparators$default(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), null, 1, null));
            if (!expectedFile.exists()) {
                if (isTeamCityBuild) {
                    AssertionsKt.fail$default((String)("Expected data file did not exist `" + expectedFile + '`'), null, (int)2, null);
                    throw null;
                }
                expectedFile.getParentFile().mkdirs();
                FilesKt.writeText$default((File)expectedFile, (String)actualText, null, (int)2, null);
                AssertionsKt.fail$default((String)("Expected data file did not exist. Generating: " + expectedFile), null, (int)2, null);
                throw null;
            }
            String $this$trim$iv2 = expected = StringUtilsKt.convertLineSeparators$default(FilesKt.readText$default((File)expectedFile, null, (int)1, null), null, 1, null);
            $i$f$trim2 = false;
            CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
            boolean $i$f$trim3 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            if (!Intrinsics.areEqual((Object)sanitizer.invoke((Object)(expectedText = StringUtilsKt.trimTrailingWhitespacesAndAddNewlineAtEOF(((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString()))), (Object)sanitizer.invoke((Object)actualText))) {
                throw new FileComparisonFailure((String)message.invoke() + ": " + expectedFile.getName(), expected, actual, expectedFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
    }

    @Override
    public void assertEquals(@Nullable Object expected, @Nullable Object actual, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assertions.assertEquals((Object)expected, (Object)actual, function0 != null ? () -> JUnit5Assertions.assertEquals$lambda-2(function0) : null);
    }

    @Override
    public void assertNotEquals(@Nullable Object expected, @Nullable Object actual, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assertions.assertNotEquals((Object)expected, (Object)actual, function0 != null ? () -> JUnit5Assertions.assertNotEquals$lambda-3(function0) : null);
    }

    @Override
    public void assertTrue(boolean value2, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assertions.assertTrue((boolean)value2, function0 != null ? () -> JUnit5Assertions.assertTrue$lambda-4(function0) : null);
    }

    @Override
    public void assertFalse(boolean value2, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assertions.assertFalse((boolean)value2, function0 != null ? () -> JUnit5Assertions.assertFalse$lambda-5(function0) : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void assertAll(@NotNull List<? extends Throwable> exceptions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        Throwable throwable = (Throwable)CollectionsKt.singleOrNull(exceptions);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw it;
        }
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)exceptions, (Comparator)FileComparisonFailureFirst.INSTANCE);
        boolean $i$f$map = false;
        Iterable it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Throwable throwable2 = (Throwable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(() -> JUnit5Assertions.assertAll$lambda-8$lambda-7((Throwable)it2));
        }
        Assertions.assertAll((Collection)((List)destination$iv$iv));
    }

    @Override
    public void assertNotNull(@Nullable Object value2, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assertions.assertNotNull((Object)value2, function0 != null ? () -> JUnit5Assertions.assertNotNull$lambda-9(function0) : null);
    }

    @Override
    public <T> void assertSameElements(@NotNull Collection<? extends T> expected, @NotNull Collection<? extends T> actual, @Nullable Function0<String> message) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        Function0<String> function0 = message;
        Assertions.assertIterableEquals((Iterable)expected, (Iterable)actual, function0 != null ? () -> JUnit5Assertions.assertSameElements$lambda-10(function0) : null);
    }

    @Override
    @NotNull
    public Void fail(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        AssertionsKt.fail(message);
        throw null;
    }

    private static final String assertEquals$lambda-2(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final String assertNotEquals$lambda-3(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final String assertTrue$lambda-4(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final String assertFalse$lambda-5(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final void assertAll$lambda-8$lambda-7(Throwable $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        throw $it;
    }

    private static final String assertNotNull$lambda-9(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final String assertSameElements$lambda-10(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/test/services/JUnit5Assertions$FileComparisonFailureFirst;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "()V", "compare", "", "o1", "o2", "tests-common-new"})
    private static final class FileComparisonFailureFirst
    implements Comparator<Throwable> {
        @NotNull
        public static final FileComparisonFailureFirst INSTANCE = new FileComparisonFailureFirst();

        private FileComparisonFailureFirst() {
        }

        @Override
        public int compare(@NotNull Throwable o1, @NotNull Throwable o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return o1 instanceof FileComparisonFailure && o2 instanceof FileComparisonFailure ? 0 : (o1 instanceof FileComparisonFailure ? -1 : (o2 instanceof FileComparisonFailure ? 1 : 0));
        }
    }
}

