/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImplKt;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.FunctionPlaceholders;
import org.jetbrains.kotlin.types.FunctionPlaceholdersKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonExpressionResolver;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ArgumentTypeResolver {
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final ReflectionTypes reflectionTypes;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final FunctionPlaceholders functionPlaceholders;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final KotlinTypeChecker kotlinTypeChecker;
    private ExpressionTypingServices expressionTypingServices;
    private DoubleColonExpressionResolver doubleColonExpressionResolver;

    public ArgumentTypeResolver(@NotNull TypeResolver typeResolver, @NotNull KotlinBuiltIns builtIns, @NotNull ReflectionTypes reflectionTypes, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull FunctionPlaceholders functionPlaceholders, @NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinTypeChecker kotlinTypeChecker) {
        if (typeResolver == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(0);
        }
        if (builtIns == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(1);
        }
        if (reflectionTypes == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(2);
        }
        if (constantExpressionEvaluator == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(3);
        }
        if (functionPlaceholders == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(4);
        }
        if (moduleDescriptor == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(5);
        }
        if (kotlinTypeChecker == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(6);
        }
        this.typeResolver = typeResolver;
        this.builtIns = builtIns;
        this.reflectionTypes = reflectionTypes;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.functionPlaceholders = functionPlaceholders;
        this.moduleDescriptor = moduleDescriptor;
        this.kotlinTypeChecker = kotlinTypeChecker;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(7);
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setDoubleColonExpressionResolver(@NotNull DoubleColonExpressionResolver doubleColonExpressionResolver) {
        if (doubleColonExpressionResolver == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(8);
        }
        this.doubleColonExpressionResolver = doubleColonExpressionResolver;
    }

    public boolean isSubtypeOfForArgumentType(@NotNull KotlinType actualType, @NotNull KotlinType expectedType) {
        if (actualType == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(9);
        }
        if (expectedType == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(10);
        }
        if (FunctionPlaceholdersKt.isFunctionPlaceholder(actualType)) {
            KotlinType functionType = ConstraintSystemBuilderImplKt.createTypeForFunctionPlaceholder(actualType, expectedType);
            return this.kotlinTypeChecker.isSubtypeOf(functionType, expectedType);
        }
        return this.kotlinTypeChecker.isSubtypeOf(actualType, expectedType);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context) {
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(11);
        }
        if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || argumentExpression instanceof KtLambdaExpression) continue;
            this.checkArgumentTypeWithNoCallee(context, argumentExpression);
        }
        this.checkTypesForFunctionArgumentsWithNoCallee(context);
        for (KtTypeProjection ktTypeProjection : context.call.getTypeArguments()) {
            KtTypeReference typeReference = ktTypeProjection.getTypeReference();
            if (typeReference == null) {
                context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(ktTypeProjection));
                continue;
            }
            this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
        }
    }

    private void checkTypesForFunctionArgumentsWithNoCallee(@NotNull CallResolutionContext<?> context) {
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(12);
        }
        if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || !ArgumentTypeResolver.isFunctionLiteralArgument(argumentExpression, context)) continue;
            this.checkArgumentTypeWithNoCallee(context, argumentExpression);
        }
    }

    private void checkArgumentTypeWithNoCallee(CallResolutionContext<?> context, KtExpression argumentExpression) {
        this.expressionTypingServices.getTypeInfo(argumentExpression, (ResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        this.updateResultArgumentTypeIfNotDenotable(context, argumentExpression);
    }

    public static boolean isFunctionLiteralArgument(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(13);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(14);
        }
        return ArgumentTypeResolver.isFunctionLiteralArgument(expression2, context.statementFilter);
    }

    private static boolean isFunctionLiteralArgument(@NotNull KtExpression expression2, @NotNull StatementFilter statementFilter) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(15);
        }
        if (statementFilter == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(16);
        }
        return ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, statementFilter) != null;
    }

    public static boolean isCallableReferenceArgument(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(17);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(18);
        }
        return ArgumentTypeResolver.isCallableReferenceArgument(expression2, context.statementFilter);
    }

    private static boolean isCallableReferenceArgument(@NotNull KtExpression expression2, @NotNull StatementFilter statementFilter) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(19);
        }
        if (statementFilter == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(20);
        }
        return ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, statementFilter) != null;
    }

    public static boolean isFunctionLiteralOrCallableReference(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(21);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(22);
        }
        return ArgumentTypeResolver.isFunctionLiteralOrCallableReference(expression2, context.statementFilter);
    }

    public static boolean isFunctionLiteralOrCallableReference(@NotNull KtExpression expression2, @NotNull StatementFilter statementFilter) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(23);
        }
        if (statementFilter == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(24);
        }
        return ArgumentTypeResolver.isFunctionLiteralArgument(expression2, statementFilter) || ArgumentTypeResolver.isCallableReferenceArgument(expression2, statementFilter);
    }

    @Nullable
    public static KtFunction getFunctionLiteralArgumentIfAny(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(25);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(26);
        }
        return ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context.statementFilter);
    }

    @Nullable
    public static KtFunction getFunctionLiteralArgumentIfAny(@NotNull KtExpression expression2, @NotNull StatementFilter statementFilter) {
        KtExpression deparenthesizedExpression;
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(27);
        }
        if (statementFilter == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(28);
        }
        if ((deparenthesizedExpression = KtPsiUtil.getLastElementDeparenthesized(expression2, statementFilter)) instanceof KtLambdaExpression) {
            return ((KtLambdaExpression)deparenthesizedExpression).getFunctionLiteral();
        }
        if (deparenthesizedExpression instanceof KtFunction) {
            return (KtFunction)deparenthesizedExpression;
        }
        return null;
    }

    @Nullable
    public static KtCallableReferenceExpression getCallableReferenceExpressionIfAny(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(29);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(30);
        }
        return ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context.statementFilter);
    }

    @Nullable
    public static KtCallableReferenceExpression getCallableReferenceExpressionIfAny(@NotNull KtExpression expression2, @NotNull StatementFilter statementFilter) {
        KtExpression deparenthesizedExpression;
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(31);
        }
        if (statementFilter == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(32);
        }
        if ((deparenthesizedExpression = KtPsiUtil.getLastElementDeparenthesized(expression2, statementFilter)) instanceof KtCallableReferenceExpression) {
            return (KtCallableReferenceExpression)deparenthesizedExpression;
        }
        return null;
    }

    @NotNull
    public KotlinTypeInfo getArgumentTypeInfo(@Nullable KtExpression expression2, @NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode, boolean suspendFunctionTypeExpected) {
        KotlinTypeInfo recordedTypeInfo;
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(33);
        }
        if (resolveArgumentsMode == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(34);
        }
        if (expression2 == null) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(35);
            }
            return kotlinTypeInfo;
        }
        KtFunction functionLiteralArgument = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context);
        if (functionLiteralArgument != null) {
            KotlinTypeInfo kotlinTypeInfo = this.getFunctionLiteralTypeInfo(expression2, functionLiteralArgument, context, resolveArgumentsMode, suspendFunctionTypeExpected);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(36);
            }
            return kotlinTypeInfo;
        }
        KtCallableReferenceExpression callableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context);
        if (callableReferenceExpression != null) {
            KotlinTypeInfo kotlinTypeInfo = this.getCallableReferenceTypeInfo(expression2, callableReferenceExpression, context, resolveArgumentsMode);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(37);
            }
            return kotlinTypeInfo;
        }
        if (ArgumentTypeResolver.isCollectionLiteralInsideAnnotation(expression2, context)) {
            Object newContext = context.replaceContextDependency(ContextDependency.INDEPENDENT);
            KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)newContext);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(38);
            }
            return kotlinTypeInfo;
        }
        if (UnsignedTypes.isUnsignedType(context.expectedType)) {
            this.convertSignedConstantToUnsigned(expression2, context);
        }
        if ((recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression2, context.trace.getBindingContext())) != null) {
            KotlinTypeInfo kotlinTypeInfo = recordedTypeInfo;
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(39);
            }
            return kotlinTypeInfo;
        }
        Object newContext = ((CallResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.DEPENDENT);
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)newContext);
        if (kotlinTypeInfo == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(40);
        }
        return kotlinTypeInfo;
    }

    private void convertSignedConstantToUnsigned(@NotNull KtExpression expression2, @NotNull CallResolutionContext<?> context) {
        CompileTimeConstant<?> constant;
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(41);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(42);
        }
        if (!((constant = context.trace.get(BindingContext.COMPILE_TIME_VALUE, expression2)) instanceof IntegerValueTypeConstant) || !ArgumentTypeResolver.constantCanBeConvertedToUnsigned(constant)) {
            return;
        }
        IntegerValueTypeConstant unsignedConstant = IntegerValueTypeConstant.convertToUnsignedConstant((IntegerValueTypeConstant)constant, this.moduleDescriptor);
        context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression2, unsignedConstant);
        this.updateResultArgumentTypeIfNotDenotable(context.trace, context.statementFilter, context.expectedType, unsignedConstant.getUnknownIntegerType(), expression2);
    }

    public static boolean constantCanBeConvertedToUnsigned(@NotNull CompileTimeConstant<?> constant) {
        if (constant == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(43);
        }
        return !constant.isError() && constant.getParameters().isPure();
    }

    @NotNull
    public KotlinTypeInfo getCallableReferenceTypeInfo(@NotNull KtExpression expression2, @NotNull KtCallableReferenceExpression callableReferenceExpression, @NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(44);
        }
        if (callableReferenceExpression == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(45);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(46);
        }
        if (resolveArgumentsMode == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(47);
        }
        if (resolveArgumentsMode == ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            KotlinType type2 = this.getShapeTypeOfCallableReference(callableReferenceExpression, context, true);
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(48);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)context.replaceContextDependency(ContextDependency.INDEPENDENT));
        if (kotlinTypeInfo == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(49);
        }
        return kotlinTypeInfo;
    }

    @Nullable
    public KotlinType getShapeTypeOfCallableReference(@NotNull KtCallableReferenceExpression callableReferenceExpression, @NotNull CallResolutionContext<?> context, boolean expectedTypeIsUnknown) {
        if (callableReferenceExpression == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(50);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(51);
        }
        Pair<DoubleColonLHS, OverloadResolutionResults<?>> pair = this.doubleColonExpressionResolver.resolveCallableReference(callableReferenceExpression, ExpressionTypingContext.newContext(context), ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
        DoubleColonLHS lhs = (DoubleColonLHS)pair.getFirst();
        OverloadResolutionResults overloadResolutionResults = (OverloadResolutionResults)pair.getSecond();
        if (overloadResolutionResults == null) {
            return null;
        }
        if (ArgumentTypeResolver.isSingleAndPossibleTransformToSuccess(overloadResolutionResults)) {
            ResolvedCall resolvedCall2 = OverloadResolutionResultsUtil.getResultingCall(overloadResolutionResults, context);
            if (resolvedCall2 == null) {
                return null;
            }
            return DoubleColonExpressionResolver.Companion.createKCallableTypeForReference((CallableDescriptor)resolvedCall2.getResultingDescriptor(), lhs, this.reflectionTypes, context.scope.getOwnerDescriptor());
        }
        if (expectedTypeIsUnknown) {
            return this.functionPlaceholders.createFunctionPlaceholderType(Collections.emptyList(), false);
        }
        return FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, Collections.emptyList(), Collections.emptyList(), null, TypeUtils.DONT_CARE);
    }

    private static boolean isSingleAndPossibleTransformToSuccess(@NotNull OverloadResolutionResults<?> overloadResolutionResults) {
        if (overloadResolutionResults == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(52);
        }
        if (!overloadResolutionResults.isSingleResult()) {
            return false;
        }
        ResolvedCall call2 = (ResolvedCall)CollectionsKt.singleOrNull(overloadResolutionResults.getResultingCalls());
        return call2 != null && call2.getStatus().possibleTransformToSuccess();
    }

    @NotNull
    public KotlinTypeInfo getFunctionLiteralTypeInfo(@NotNull KtExpression expression2, @NotNull KtFunction functionLiteral, @NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode, boolean suspendFunctionTypeExpected) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(53);
        }
        if (functionLiteral == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(54);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(55);
        }
        if (resolveArgumentsMode == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(56);
        }
        if (resolveArgumentsMode == ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            KotlinType type2 = this.getShapeTypeOfFunctionLiteral(functionLiteral, context.scope, context.trace, true, suspendFunctionTypeExpected);
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2, context);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(57);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)context.replaceContextDependency(ContextDependency.INDEPENDENT));
        if (kotlinTypeInfo == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(58);
        }
        return kotlinTypeInfo;
    }

    @Nullable
    public KotlinType getShapeTypeOfFunctionLiteral(@NotNull KtFunction function2, @NotNull LexicalScope scope2, @NotNull BindingTrace trace, boolean expectedTypeIsUnknown, boolean suspendFunctionTypeExpected) {
        if (function2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(59);
        }
        if (scope2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(60);
        }
        if (trace == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(61);
        }
        boolean isFunctionLiteral = function2 instanceof KtFunctionLiteral;
        if (function2.getValueParameterList() == null && isFunctionLiteral) {
            return expectedTypeIsUnknown ? this.functionPlaceholders.createFunctionPlaceholderType(Collections.emptyList(), false) : FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, Collections.emptyList(), Collections.emptyList(), null, TypeUtils.DONT_CARE);
        }
        List<KtParameter> valueParameters2 = function2.getValueParameters();
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "trace to resolve function literal parameter types");
        ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(valueParameters2.size());
        ArrayList<Name> parameterNames = new ArrayList<Name>(valueParameters2.size());
        for (KtParameter parameter : valueParameters2) {
            parameterTypes.add(this.resolveTypeRefWithDefault(parameter.getTypeReference(), scope2, temporaryTrace, TypeUtils.DONT_CARE));
            Name name2 = parameter.getNameAsName();
            if (name2 == null) {
                name2 = SpecialNames.NO_NAME_PROVIDED;
            }
            parameterNames.add(name2);
        }
        KotlinType returnType2 = this.resolveTypeRefWithDefault(function2.getTypeReference(), scope2, temporaryTrace, TypeUtils.DONT_CARE);
        assert (returnType2 != null);
        KotlinType receiverType = this.resolveTypeRefWithDefault(function2.getReceiverTypeReference(), scope2, temporaryTrace, null);
        List contextReceiversTypes = function2.getContextReceivers().stream().map(contextReceiver -> this.resolveTypeRefWithDefault(contextReceiver.typeReference(), scope2, temporaryTrace, null)).collect(Collectors.toList());
        return expectedTypeIsUnknown && isFunctionLiteral ? this.functionPlaceholders.createFunctionPlaceholderType(parameterTypes, true) : FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), receiverType, contextReceiversTypes, parameterTypes, parameterNames, returnType2, suspendFunctionTypeExpected);
    }

    @Nullable
    public KotlinType resolveTypeRefWithDefault(@Nullable KtTypeReference returnTypeRef, @NotNull LexicalScope scope2, @NotNull BindingTrace trace, @Nullable KotlinType defaultValue) {
        if (scope2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(62);
        }
        if (trace == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(63);
        }
        if (returnTypeRef != null) {
            return this.typeResolver.resolveType(scope2, returnTypeRef, trace, true);
        }
        return defaultValue;
    }

    public void analyzeArgumentsAndRecordTypes(@NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(64);
        }
        if (resolveArgumentsMode == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(65);
        }
        MutableDataFlowInfoForArguments infoForArguments = context.dataFlowInfoForArguments;
        Call call2 = context.call;
        for (ValueArgument valueArgument : call2.getValueArguments()) {
            KtExpression expression2 = valueArgument.getArgumentExpression();
            if (expression2 == null || ArgumentTypeResolver.isCollectionLiteralInsideAnnotation(expression2, context)) continue;
            CallResolutionContext newContext = (CallResolutionContext)context.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            KotlinTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression2, newContext, resolveArgumentsMode, false);
            infoForArguments.updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        }
    }

    @Nullable
    public KotlinType updateResultArgumentTypeIfNotDenotable(@NotNull ResolutionContext context, @NotNull KtExpression expression2) {
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(66);
        }
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(67);
        }
        return this.updateResultArgumentTypeIfNotDenotable(context.trace, context.statementFilter, context.expectedType, expression2);
    }

    @Nullable
    public KotlinType updateResultArgumentTypeIfNotDenotable(@NotNull BindingTrace trace, @NotNull StatementFilter statementFilter, @NotNull KotlinType expectedType, @NotNull KtExpression expression2) {
        KotlinType type2;
        if (trace == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(68);
        }
        if (statementFilter == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(69);
        }
        if (expectedType == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(70);
        }
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(71);
        }
        return (type2 = trace.getType(expression2)) != null ? this.updateResultArgumentTypeIfNotDenotable(trace, statementFilter, expectedType, type2, expression2) : null;
    }

    @Nullable
    public KotlinType updateResultArgumentTypeIfNotDenotable(@NotNull BindingTrace trace, @NotNull StatementFilter statementFilter, @NotNull KotlinType expectedType, @NotNull KotlinType targetType, @NotNull KtExpression expression2) {
        TypeConstructor typeConstructor2;
        if (trace == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(72);
        }
        if (statementFilter == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(73);
        }
        if (expectedType == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(74);
        }
        if (targetType == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(75);
        }
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(76);
        }
        if (!(typeConstructor2 = targetType.getConstructor()).isDenotable()) {
            if (typeConstructor2 instanceof IntegerValueTypeConstructor) {
                IntegerValueTypeConstructor constructor2 = (IntegerValueTypeConstructor)typeConstructor2;
                KotlinType primitiveType = TypeUtils.getPrimitiveNumberType(constructor2, expectedType);
                this.constantExpressionEvaluator.updateNumberType(primitiveType, expression2, statementFilter, trace);
                return primitiveType;
            }
            if (typeConstructor2 instanceof IntegerLiteralTypeConstructor) {
                IntegerLiteralTypeConstructor constructor3 = (IntegerLiteralTypeConstructor)typeConstructor2;
                KotlinType primitiveType = TypeUtils.getPrimitiveNumberType(constructor3, expectedType);
                this.constantExpressionEvaluator.updateNumberType(primitiveType, expression2, statementFilter, trace);
                return primitiveType;
            }
        }
        return null;
    }

    private static boolean isCollectionLiteralInsideAnnotation(KtExpression expression2, CallResolutionContext<?> context) {
        return expression2 instanceof KtCollectionLiteralExpression && context.call.getCallElement() instanceof KtAnnotationEntry;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 48: 
            case 49: 
            case 57: 
            case 58: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 48: 
            case 49: 
            case 57: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reflectionTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantExpressionEvaluator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionPlaceholders";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinTypeChecker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionTypingServices";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doubleColonExpressionResolver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 10: 
            case 70: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 33: 
            case 42: 
            case 46: 
            case 51: 
            case 55: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 41: 
            case 44: 
            case 53: 
            case 67: 
            case 71: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 69: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementFilter";
                break;
            }
            case 34: 
            case 47: 
            case 56: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveArgumentsMode";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 48: 
            case 49: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableReferenceExpression";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloadResolutionResults";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionLiteral";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 61: 
            case 63: 
            case 68: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypeInfo";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallableReferenceTypeInfo";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionLiteralTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setExpressionTypingServices";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDoubleColonExpressionResolver";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSubtypeOfForArgumentType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesWithNoCallee";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesForFunctionArgumentsWithNoCallee";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionLiteralArgument";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isCallableReferenceArgument";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionLiteralOrCallableReference";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionLiteralArgumentIfAny";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCallableReferenceExpressionIfAny";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypeInfo";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 48: 
            case 49: 
            case 57: 
            case 58: {
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "convertSignedConstantToUnsigned";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "constantCanBeConvertedToUnsigned";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCallableReferenceTypeInfo";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getShapeTypeOfCallableReference";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isSingleAndPossibleTransformToSuccess";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionLiteralTypeInfo";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getShapeTypeOfFunctionLiteral";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeRefWithDefault";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "analyzeArgumentsAndRecordTypes";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "updateResultArgumentTypeIfNotDenotable";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 48: 
            case 49: 
            case 57: 
            case 58: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

