/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.CompilationOutputs;
import org.jetbrains.kotlin.ir.backend.js.ic.FileUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.ic.HashCalculatorForICKt;
import org.jetbrains.kotlin.ir.backend.js.ic.ICHash;
import org.jetbrains.kotlin.ir.backend.js.ic.ModuleArtifact;
import org.jetbrains.kotlin.ir.backend.js.ic.SrcFileArtifact;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleReferences;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrModuleHeader;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.CodedOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0003\u0018\u0019\u001aB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u0004J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0003J\u001a\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0011*\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\t*\u00020\u0004H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/JsMultiModuleCache;", "", "moduleArtifacts", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ModuleArtifact;", "(Ljava/util/List;)V", "headerToCachedInfo", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleHeader;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/JsMultiModuleCache$CachedModuleInfo;", "commitCompiledJsCode", "artifact", "compilationOutputs", "Lorg/jetbrains/kotlin/ir/backend/js/CompilationOutputs;", "fetchCompiledJsCode", "loadProgramHeadersFromCache", "loadRequiredJsIrModules", "", "crossModuleReferences", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/CrossModuleReferences;", "commitModuleInfo", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/JsMultiModuleCache$CachedModuleInfo;)Lkotlin/Unit;", "fetchModuleInfo", "CachedModuleInfo", "Companion", "NameType", "backend.js"})
public final class JsMultiModuleCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ModuleArtifact> moduleArtifacts;
    @NotNull
    private final Map<JsIrModuleHeader, CachedModuleInfo> headerToCachedInfo;
    @NotNull
    private static final String cacheModuleHeader = "cache.module.header.info";
    @NotNull
    private static final String cacheJsModuleFile = "cache.module.js";
    @NotNull
    private static final String cacheJsMapModuleFile = "cache.module.js.map";

    public JsMultiModuleCache(@NotNull List<ModuleArtifact> moduleArtifacts) {
        Intrinsics.checkNotNullParameter(moduleArtifacts, (String)"moduleArtifacts");
        this.moduleArtifacts = moduleArtifacts;
        this.headerToCachedInfo = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CachedModuleInfo fetchModuleInfo(ModuleArtifact $this$fetchModuleInfo) {
        CachedModuleInfo cachedModuleInfo;
        File $this$useCodedInputIfExists$iv = new File($this$fetchModuleInfo.getArtifactsDir(), cacheModuleHeader);
        boolean $i$f$useCodedInputIfExists = false;
        File $this$ifExists$iv$iv = $this$useCodedInputIfExists$iv;
        boolean $i$f$ifExists = false;
        if ($this$ifExists$iv$iv.exists()) {
            File $this$useCodedInputIfExists_u24lambda_u2d1$iv = $this$ifExists$iv$iv;
            boolean bl = false;
            Closeable closeable = new FileInputStream($this$useCodedInputIfExists_u24lambda_u2d1$iv);
            Throwable throwable = null;
            try {
                FileInputStream it$iv = (FileInputStream)closeable;
                boolean bl2 = false;
                CodedInputStream codedInputStream = CodedInputStream.newInstance(it$iv);
                Intrinsics.checkNotNullExpressionValue((Object)codedInputStream, (String)"newInstance(it)");
                CodedInputStream $this$fetchModuleInfo_u24lambda_u2d1 = codedInputStream;
                boolean bl3 = false;
                Set definitions = new LinkedHashSet();
                Map nameBindings = new LinkedHashMap();
                long crossModuleReferencesHash = ICHash.Companion.fromProtoStream-TVZkk9w($this$fetchModuleInfo_u24lambda_u2d1);
                boolean hasJsExports = $this$fetchModuleInfo_u24lambda_u2d1.readBool();
                int n = $this$fetchModuleInfo_u24lambda_u2d1.readInt32();
                for (int i = 0; i < n; ++i) {
                    String string2;
                    int it = i;
                    boolean bl4 = false;
                    String tag = $this$fetchModuleInfo_u24lambda_u2d1.readString();
                    int mask = $this$fetchModuleInfo_u24lambda_u2d1.readInt32();
                    if ((mask & NameType.DEFINITIONS.getTypeMask()) != 0) {
                        ((Collection)definitions).add(tag);
                    }
                    if ((mask & NameType.NAME_BINDINGS.getTypeMask()) == 0) continue;
                    Map map = nameBindings;
                    Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
                    String string3 = tag;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$fetchModuleInfo_u24lambda_u2d1.readString(), (String)"readString()");
                    map.put(string3, string2);
                }
                CachedModuleInfo cachedModuleInfo2 = new CachedModuleInfo($this$fetchModuleInfo, new JsIrModuleHeader($this$fetchModuleInfo.getModuleSafeName(), $this$fetchModuleInfo.getModuleSafeName(), definitions, nameBindings, hasJsExports, null), crossModuleReferencesHash, null);
                cachedModuleInfo = cachedModuleInfo2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            cachedModuleInfo = null;
        }
        return cachedModuleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Unit commitModuleInfo(CachedModuleInfo $this$commitModuleInfo) {
        Unit unit2;
        File file2 = $this$commitModuleInfo.getArtifact().getArtifactsDir();
        if (file2 != null) {
            File cacheDir = file2;
            boolean bl = false;
            File $this$useCodedOutput$iv = new File(cacheDir, cacheModuleHeader);
            boolean $i$f$useCodedOutput = false;
            File file3 = $this$useCodedOutput$iv.getParentFile();
            if (file3 != null) {
                file3.mkdirs();
            }
            FileUtilsKt.recreate($this$useCodedOutput$iv);
            Closeable closeable = new FileOutputStream($this$useCodedOutput$iv);
            Throwable throwable = null;
            try {
                Object name2;
                String tag;
                FileOutputStream it$iv = (FileOutputStream)closeable;
                boolean bl2 = false;
                CodedOutputStream out$iv = CodedOutputStream.newInstance(it$iv);
                Intrinsics.checkNotNullExpressionValue((Object)out$iv, (String)"out");
                CodedOutputStream $this$commitModuleInfo_u24lambda_u2d3_u24lambda_u2d2 = out$iv;
                boolean bl3 = false;
                Map names2 = new LinkedHashMap();
                for (Map.Entry<String, String> entry : $this$commitModuleInfo.getJsIrHeader().getNameBindings().entrySet()) {
                    tag = entry.getKey();
                    name2 = entry.getValue();
                    names2.put(tag, TuplesKt.to((Object)NameType.NAME_BINDINGS.getTypeMask(), (Object)name2));
                }
                for (String string2 : $this$commitModuleInfo.getJsIrHeader().getDefinitions()) {
                    Pair maskAndName = (Pair)names2.get(string2);
                    name2 = names2;
                    Pair pair = maskAndName;
                    Pair pair2 = maskAndName;
                    Pair pair3 = TuplesKt.to((Object)((pair != null ? ((Number)pair.getFirst()).intValue() : 0) | NameType.DEFINITIONS.getTypeMask()), (Object)(pair2 != null ? (String)pair2.getSecond() : null));
                    name2.put(string2, pair3);
                }
                ICHash.toProtoStream-impl($this$commitModuleInfo.getCrossModuleReferencesHash-Yd-dAqs(), $this$commitModuleInfo_u24lambda_u2d3_u24lambda_u2d2);
                $this$commitModuleInfo_u24lambda_u2d3_u24lambda_u2d2.writeBoolNoTag($this$commitModuleInfo.getJsIrHeader().getHasJsExports());
                $this$commitModuleInfo_u24lambda_u2d3_u24lambda_u2d2.writeInt32NoTag(names2.size());
                for (Map.Entry entry : names2.entrySet()) {
                    tag = (String)entry.getKey();
                    Pair maskAndName = (Pair)entry.getValue();
                    $this$commitModuleInfo_u24lambda_u2d3_u24lambda_u2d2.writeStringNoTag(tag);
                    $this$commitModuleInfo_u24lambda_u2d3_u24lambda_u2d2.writeInt32NoTag(((Number)maskAndName.getFirst()).intValue());
                    if (maskAndName.getSecond() == null) continue;
                    $this$commitModuleInfo_u24lambda_u2d3_u24lambda_u2d2.writeStringNoTag((String)maskAndName.getSecond());
                }
                out$iv.flush();
                Unit unit3 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        return unit2;
    }

    @Nullable
    public final CompilationOutputs fetchCompiledJsCode(@NotNull ModuleArtifact artifact) {
        CompilationOutputs compilationOutputs;
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        File file2 = artifact.getArtifactsDir();
        if (file2 != null) {
            String string2;
            String string3;
            File cacheDir = file2;
            boolean bl = false;
            File $this$ifExists$iv = new File(cacheDir, cacheJsModuleFile);
            boolean $i$f$ifExists = false;
            if ($this$ifExists$iv.exists()) {
                File $this$fetchCompiledJsCode_u24lambda_u2d7_u24lambda_u2d4 = $this$ifExists$iv;
                boolean bl2 = false;
                string3 = FilesKt.readText$default((File)$this$fetchCompiledJsCode_u24lambda_u2d7_u24lambda_u2d4, null, (int)1, null);
            } else {
                string3 = null;
            }
            String jsCode = string3;
            File $this$ifExists$iv2 = new File(cacheDir, cacheJsMapModuleFile);
            boolean $i$f$ifExists2 = false;
            if ($this$ifExists$iv2.exists()) {
                File $this$fetchCompiledJsCode_u24lambda_u2d7_u24lambda_u2d5 = $this$ifExists$iv2;
                boolean bl3 = false;
                string2 = FilesKt.readText$default((File)$this$fetchCompiledJsCode_u24lambda_u2d7_u24lambda_u2d5, null, (int)1, null);
            } else {
                string2 = null;
            }
            String sourceMap2 = string2;
            String string4 = jsCode;
            if (string4 != null) {
                String it = string4;
                boolean bl4 = false;
                compilationOutputs = new CompilationOutputs(it, null, sourceMap2, null, 8, null);
            } else {
                compilationOutputs = null;
            }
        } else {
            compilationOutputs = null;
        }
        return compilationOutputs;
    }

    @Nullable
    public final Object commitCompiledJsCode(@NotNull ModuleArtifact artifact, @NotNull CompilationOutputs compilationOutputs) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)compilationOutputs, (String)"compilationOutputs");
        File file2 = artifact.getArtifactsDir();
        if (file2 != null) {
            File file3;
            File cacheDir = file2;
            boolean bl = false;
            File $this$commitCompiledJsCode_u24lambda_u2d10_u24lambda_u2d8 = file3 = new File(cacheDir, cacheJsModuleFile);
            boolean bl2 = false;
            FileUtilsKt.recreate($this$commitCompiledJsCode_u24lambda_u2d10_u24lambda_u2d8);
            File jsCodeCache = file3;
            FilesKt.writeText$default((File)jsCodeCache, (String)compilationOutputs.getJsCode(), null, (int)2, null);
            File jsMapCache = new File(cacheDir, cacheJsMapModuleFile);
            if (compilationOutputs.getSourceMap() != null) {
                FileUtilsKt.recreate(jsMapCache);
                FilesKt.writeText$default((File)jsMapCache, (String)compilationOutputs.getSourceMap(), null, (int)2, null);
                object = Unit.INSTANCE;
            } else {
                File $this$ifExists$iv = jsMapCache;
                boolean $i$f$ifExists = false;
                if ($this$ifExists$iv.exists()) {
                    File $this$commitCompiledJsCode_u24lambda_u2d10_u24lambda_u2d9 = $this$ifExists$iv;
                    boolean bl3 = false;
                    object = $this$commitCompiledJsCode_u24lambda_u2d10_u24lambda_u2d9.delete();
                } else {
                    object = null;
                }
            }
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CachedModuleInfo> loadProgramHeadersFromCache() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.moduleArtifacts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CachedModuleInfo cachedModuleInfo;
            void artifact;
            ModuleArtifact moduleArtifact = (ModuleArtifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (artifact.getForceRebuildJs()) {
                cachedModuleInfo = JsMultiModuleCache.loadProgramHeadersFromCache$lambda-12$loadModuleInfo((ModuleArtifact)artifact);
            } else {
                boolean bl2;
                block9: {
                    Iterable $this$any$iv = artifact.getFileArtifacts();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            SrcFileArtifact it = (SrcFileArtifact)element$iv;
                            boolean bl3 = false;
                            if (!it.isModified()) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    cachedModuleInfo = JsMultiModuleCache.loadProgramHeadersFromCache$lambda-12$loadModuleInfo((ModuleArtifact)artifact);
                } else {
                    cachedModuleInfo = this.fetchModuleInfo((ModuleArtifact)artifact);
                    if (cachedModuleInfo == null) {
                        cachedModuleInfo = JsMultiModuleCache.loadProgramHeadersFromCache$lambda-12$loadModuleInfo((ModuleArtifact)artifact);
                    }
                }
            }
            CachedModuleInfo actualInfo = cachedModuleInfo;
            this.headerToCachedInfo.put(actualInfo.getJsIrHeader(), actualInfo);
            collection.add(actualInfo);
        }
        return (List)destination$iv$iv;
    }

    public final void loadRequiredJsIrModules(@NotNull Map<JsIrModuleHeader, CrossModuleReferences> crossModuleReferences) {
        Intrinsics.checkNotNullParameter(crossModuleReferences, (String)"crossModuleReferences");
        for (Map.Entry<JsIrModuleHeader, CrossModuleReferences> entry : crossModuleReferences.entrySet()) {
            CachedModuleInfo cachedInfo;
            JsIrModuleHeader header = entry.getKey();
            CrossModuleReferences references = entry.getValue();
            if (this.headerToCachedInfo.get(header) == null) {
                throw new IllegalStateException(("Internal error: cannot find artifact for module " + header.getModuleName()).toString());
            }
            long actualCrossModuleHash = HashCalculatorForICKt.crossModuleReferencesHashForIC(references);
            if (header.getAssociatedModule() == null && !ICHash.equals-impl0(cachedInfo.getCrossModuleReferencesHash-Yd-dAqs(), actualCrossModuleHash)) {
                header.setAssociatedModule(cachedInfo.getArtifact().loadJsIrModule());
            }
            if (header.getAssociatedModule() == null) continue;
            boolean bl = false;
            cachedInfo.setCrossModuleReferencesHash-ycJ14Ss(actualCrossModuleHash);
            this.commitModuleInfo(cachedInfo);
        }
    }

    private static final CachedModuleInfo loadProgramHeadersFromCache$lambda-12$loadModuleInfo(ModuleArtifact $artifact) {
        return new CachedModuleInfo($artifact, $artifact.loadJsIrModule().makeModuleHeader(), 0L, 4, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/JsMultiModuleCache$Companion;", "", "()V", "cacheJsMapModuleFile", "", "cacheJsModuleFile", "cacheModuleHeader", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/JsMultiModuleCache$NameType;", "", "typeMask", "", "(Ljava/lang/String;II)V", "getTypeMask", "()I", "DEFINITIONS", "NAME_BINDINGS", "backend.js"})
    private static final class NameType
    extends Enum<NameType> {
        private final int typeMask;
        public static final /* enum */ NameType DEFINITIONS = new NameType(1);
        public static final /* enum */ NameType NAME_BINDINGS = new NameType(2);
        private static final /* synthetic */ NameType[] $VALUES;

        private NameType(int typeMask) {
            this.typeMask = typeMask;
        }

        public final int getTypeMask() {
            return this.typeMask;
        }

        public static NameType[] values() {
            return (NameType[])$VALUES.clone();
        }

        public static NameType valueOf(String value2) {
            return Enum.valueOf(NameType.class, value2);
        }

        static {
            $VALUES = nameTypeArray = new NameType[]{NameType.DEFINITIONS, NameType.NAME_BINDINGS};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\"\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR%\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/JsMultiModuleCache$CachedModuleInfo;", "", "artifact", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ModuleArtifact;", "jsIrHeader", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleHeader;", "crossModuleReferencesHash", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ICHash;", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/ModuleArtifact;Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleHeader;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getArtifact", "()Lorg/jetbrains/kotlin/ir/backend/js/ic/ModuleArtifact;", "getCrossModuleReferencesHash-Yd-dAqs", "()J", "setCrossModuleReferencesHash-ycJ14Ss", "(J)V", "J", "getJsIrHeader", "()Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleHeader;", "backend.js"})
    public static final class CachedModuleInfo {
        @NotNull
        private final ModuleArtifact artifact;
        @NotNull
        private final JsIrModuleHeader jsIrHeader;
        private long crossModuleReferencesHash;

        private CachedModuleInfo(ModuleArtifact artifact, JsIrModuleHeader jsIrHeader, long crossModuleReferencesHash) {
            this.artifact = artifact;
            this.jsIrHeader = jsIrHeader;
            this.crossModuleReferencesHash = crossModuleReferencesHash;
        }

        public /* synthetic */ CachedModuleInfo(ModuleArtifact moduleArtifact, JsIrModuleHeader jsIrModuleHeader, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = ICHash.constructor-impl$default(0L, 1, null);
            }
            this(moduleArtifact, jsIrModuleHeader, l, null);
        }

        @NotNull
        public final ModuleArtifact getArtifact() {
            return this.artifact;
        }

        @NotNull
        public final JsIrModuleHeader getJsIrHeader() {
            return this.jsIrHeader;
        }

        public final long getCrossModuleReferencesHash-Yd-dAqs() {
            return this.crossModuleReferencesHash;
        }

        public final void setCrossModuleReferencesHash-ycJ14Ss(long l) {
            this.crossModuleReferencesHash = l;
        }

        public /* synthetic */ CachedModuleInfo(ModuleArtifact artifact, JsIrModuleHeader jsIrHeader, long crossModuleReferencesHash, DefaultConstructorMarker $constructor_marker) {
            this(artifact, jsIrHeader, crossModuleReferencesHash);
        }
    }
}

