/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMappingKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable;", "Lorg/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "typeMapper", "Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "(Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;)V", "getLocalClassIdReplacement", "Lorg/jetbrains/kotlin/name/ClassId;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "jvm-backend"})
public final class FirJvmElementAwareStringTable
extends JvmStringTable
implements FirElementAwareStringTable {
    @NotNull
    private final IrTypeMapper typeMapper;
    @NotNull
    private final Fir2IrComponents components;

    public FirJvmElementAwareStringTable(@NotNull IrTypeMapper typeMapper2, @NotNull Fir2IrComponents components2, @Nullable JvmNameResolver nameResolver2) {
        Intrinsics.checkNotNullParameter((Object)typeMapper2, (String)"typeMapper");
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        super(nameResolver2);
        this.typeMapper = typeMapper2;
        this.components = components2;
    }

    public /* synthetic */ FirJvmElementAwareStringTable(IrTypeMapper irTypeMapper, Fir2IrComponents fir2IrComponents, JvmNameResolver jvmNameResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            jvmNameResolver = null;
        }
        this(irTypeMapper, fir2IrComponents, jvmNameResolver);
    }

    @Override
    @NotNull
    public ClassId getLocalClassIdReplacement(@NotNull FirClass firClass2) {
        Intrinsics.checkNotNullParameter((Object)firClass2, (String)"firClass");
        Object object = this.components.getClassifierStorage().getCachedIrClass(firClass2);
        if (object == null || (object = this.getLocalClassIdReplacement((IrClass)object)) == null) {
            throw new AssertionError((Object)("not a local class: " + firClass2.getSymbol().getClassId()));
        }
        return object;
    }

    private final ClassId getLocalClassIdReplacement(IrClass $this$getLocalClassIdReplacement) {
        ClassId classId;
        IrDeclarationParent parent2 = $this$getLocalClassIdReplacement.getParent();
        if (parent2 instanceof IrClass) {
            ClassId classId2 = this.getLocalClassIdReplacement((IrClass)parent2).createNestedClassId($this$getLocalClassIdReplacement.getName());
            classId = classId2;
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"parent.getLocalClassIdRe\u2026createNestedClassId(name)");
        } else {
            String string2 = IrTypeMappingKt.mapClass(this.typeMapper, $this$getLocalClassIdReplacement).getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeMapper.mapClass(this).internalName");
            FqName fqName2 = new FqName(StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null));
            classId = new ClassId(fqName2.parent(), FqName.topLevel(fqName2.shortName()), true);
        }
        return classId;
    }

    @Override
    public int getQualifiedClassNameIndex(@NotNull ClassId classId) {
        return FirElementAwareStringTable.DefaultImpls.getQualifiedClassNameIndex(this, classId);
    }

    @Override
    public int getFqNameIndex(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        return FirElementAwareStringTable.DefaultImpls.getFqNameIndex(this, classLikeDeclaration);
    }
}

