/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.IndexedGetIterationHandler;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\f*\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/ArrayIterationHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/IndexedGetIterationHandler;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getFunctionName", "Lorg/jetbrains/kotlin/name/Name;", "getGetFunctionName", "()Lorg/jetbrains/kotlin/name/Name;", "supportsUnsignedArrays", "", "getFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getGetFunction", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "sizePropertyGetter", "getSizePropertyGetter", "matchIterable", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.backend.common"})
public final class ArrayIterationHandler
extends IndexedGetIterationHandler {
    private final boolean supportsUnsignedArrays;

    public ArrayIterationHandler(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, true);
        this.supportsUnsignedArrays = context2.getOptimizeLoopsOverUnsignedArrays();
    }

    public boolean matchIterable(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrType $this$matchIterable_u24lambda_u2d0 = expression2.getType();
        boolean bl = false;
        return IrTypePredicatesKt.isArray($this$matchIterable_u24lambda_u2d0) || IrTypeUtilsKt.isPrimitiveArray($this$matchIterable_u24lambda_u2d0) || this.supportsUnsignedArrays && IrTypeUtilsKt.isUnsignedArray($this$matchIterable_u24lambda_u2d0);
    }

    @Override
    @NotNull
    public IrSimpleFunction getSizePropertyGetter(@NotNull IrType $this$sizePropertyGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$sizePropertyGetter, (String)"<this>");
        IrClass irClass2 = IrTypesKt.getClass($this$sizePropertyGetter);
        Intrinsics.checkNotNull((Object)irClass2);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getPropertyGetter(irClass2, "size");
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        return (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
    }

    private final Name getGetFunctionName() {
        Name name2 = this.getContext().getIr().getSymbols().getGetWithoutBoundCheckName();
        if (name2 == null) {
            name2 = OperatorNameConventions.GET;
        }
        return name2;
    }

    @Override
    @NotNull
    public IrSimpleFunction getGetFunction(@NotNull IrType $this$getFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$getFunction, (String)"<this>");
        IrClass irClass2 = IrTypesKt.getClass($this$getFunction);
        Intrinsics.checkNotNull((Object)irClass2);
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(irClass2);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)it.getName(), (Object)this.getGetFunctionName()) && it.getValueParameters().size() == 1 && IrTypePredicatesKt.isInt(it.getValueParameters().get(0).getType());
            if (!bl2) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return single$iv;
    }
}

