/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerIr;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001b\u0010\t\u001a\u00020\u0001\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0005\u001a\u0002H\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00120\u0011\u001a&\u0010\u0013\u001a\u00020\u0014*\u00020\u00142\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u0016\u00a2\u0006\u0002\b\u0017H\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"RESERVED_MEMBER_NAME_SUFFIX", "", "SYNTHETIC_BLOCK_LABEL", "SYNTHETIC_LOOP_LABEL", "jsFunctionSignature", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "mapToKey", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "sanitizeName", "name", "withHash", "", "dump", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "mangleIfNot", "", "predicate", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "backend.js"})
public final class NameTablesKt {
    @NotNull
    private static final String RESERVED_MEMBER_NAME_SUFFIX = "_k$";
    @NotNull
    private static final String SYNTHETIC_LOOP_LABEL = "$l$loop";
    @NotNull
    private static final String SYNTHETIC_BLOCK_LABEL = "$l$block";

    /*
     * WARNING - void declaration
     */
    private static final <T> String mapToKey(T declaration2) {
        String string2;
        JsManglerIr $this$mapToKey_u24lambda_u2d1 = JsManglerIr.INSTANCE;
        boolean bl = false;
        if (declaration2 instanceof IrDeclaration) {
            String string3;
            try {
                string3 = String.valueOf($this$mapToKey_u24lambda_u2d1.hashedMangle(declaration2, false));
            }
            catch (Throwable e) {
                string3 = "wrong_key";
            }
            string2 = string3;
        } else if (declaration2 instanceof String) {
            string2 = String.valueOf($this$mapToKey_u24lambda_u2d1.getHashMangle((String)declaration2));
        } else {
            String string4;
            StringBuilder stringBuilder2 = new StringBuilder().append("Key is not generated for ");
            T t = declaration2;
            if (t != null) {
                void it;
                T e = t;
                StringBuilder stringBuilder3 = stringBuilder2;
                boolean bl2 = false;
                string4 = Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
                stringBuilder2 = stringBuilder3;
            } else {
                string4 = null;
            }
            String string5 = stringBuilder2.append(string4).toString();
            throw new IllegalStateException(string5.toString());
        }
        return string2;
    }

    @NotNull
    public static final String dump(@NotNull NameTable<IrDeclaration> $this$dump) {
        Intrinsics.checkNotNullParameter($this$dump, (String)"<this>");
        return "Names: \n" + CollectionsKt.joinToString$default((Iterable)MapsKt.toList($this$dump.getNames()), (CharSequence)"\n", null, null, (int)0, null, (Function1)dump.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String jsFunctionSignature(@NotNull IrFunction declaration2, @NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(!IrFunctionKt.isStaticMethodOfClass(declaration2))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(declaration2.getDispatchReceiverParameter() != null)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        String string4 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration2).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"declaration.getJsNameOrKotlinName().asString()");
        String declarationName = string4;
        if (MiscKt.hasStableJsName(declaration2, context2)) {
            if (!(!StringsKt.endsWith$default((String)declarationName, (String)RESERVED_MEMBER_NAME_SUFFIX, (boolean)false, (int)2, null))) {
                boolean $i$a$-require-NameTablesKt$jsFunctionSignature$22 = false;
                String $i$a$-require-NameTablesKt$jsFunctionSignature$22 = "Function " + IrUtilsKt.getFqNameWhenAvailable(declaration2) + " uses reserved name suffix \"_k$\"";
                throw new IllegalArgumentException($i$a$-require-NameTablesKt$jsFunctionSignature$22.toString());
            }
            return declarationName;
        }
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(declarationName);
        Collection $this$ifNotEmpty$iv = declaration2.getTypeParameters();
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$jsFunctionSignature_u24lambda_u2d3 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            nameBuilder.append("_$t");
            StringBuilder cfr_ignored_0 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$jsFunctionSignature_u24lambda_u2d3, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)jsFunctionSignature.2.1.INSTANCE, (int)60, null);
        }
        IrValueParameter irValueParameter = declaration2.getExtensionReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter it = irValueParameter;
            boolean bl = false;
            nameBuilder.append("_r$" + IrTypeUtilsKt.asString(it.getType()));
        }
        $this$ifNotEmpty$iv = declaration2.getValueParameters();
        $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$jsFunctionSignature_u24lambda_u2d5 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            StringBuilder cfr_ignored_1 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$jsFunctionSignature_u24lambda_u2d5, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)jsFunctionSignature.4.1.INSTANCE, (int)60, null);
        }
        IrType it = declaration2.getReturnType();
        boolean bl = false;
        if (context2.getInlineClassesUtils().isTypeInlined(it) || IrTypePredicatesKt.isUnit(it)) {
            nameBuilder.append("_ret$" + IrTypeUtilsKt.asString(it));
        }
        String string5 = nameBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"nameBuilder.toString()");
        String signature2 = string5;
        StringBuilder stringBuilder2 = new StringBuilder().append(NameTablesKt.sanitizeName$default(declarationName, false, 2, null)).append('_');
        String string6 = Integer.toString(Math.abs(signature2.hashCode()), CharsKt.checkRadix((int)36));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(this, checkRadix(radix))");
        return stringBuilder2.append(string6).append(RESERVED_MEMBER_NAME_SUFFIX).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeName(@NotNull String name2, boolean withHash2) {
        String string2;
        void p0;
        char first;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (IdentifierPolicyKt.isValidES5Identifier(name2)) {
            return name2;
        }
        if (((CharSequence)name2).length() == 0) {
            return "_";
        }
        StringBuilder builder2 = new StringBuilder();
        char $this$mangleIfNot$iv = first = StringsKt.first((CharSequence)name2);
        boolean $i$f$mangleIfNot = false;
        char c = $this$mangleIfNot$iv;
        StringBuilder stringBuilder2 = builder2;
        boolean bl = false;
        boolean bl2 = IdentifierPolicyKt.isES5IdentifierStart((char)p0);
        stringBuilder2.append(bl2 ? $this$mangleIfNot$iv : (char)'_');
        int idx = 1;
        int n = StringsKt.getLastIndex((CharSequence)name2);
        if (idx <= n) {
            while (true) {
                void p02;
                char c2;
                char $this$mangleIfNot$iv2 = c2 = name2.charAt(idx);
                boolean $i$f$mangleIfNot2 = false;
                char c3 = $this$mangleIfNot$iv2;
                stringBuilder2 = builder2;
                boolean bl3 = false;
                bl2 = IdentifierPolicyKt.isES5IdentifierPart((char)p02);
                stringBuilder2.append(bl2 ? $this$mangleIfNot$iv2 : (char)'_');
                if (idx == n) break;
                ++idx;
            }
        }
        if (withHash2) {
            string2 = builder2 + '_' + UInt.toString-impl((int)UInt.constructor-impl((int)name2.hashCode()));
        } else {
            String string3 = builder2.toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n        builder.toString()\n    }");
        }
        return string2;
    }

    public static /* synthetic */ String sanitizeName$default(String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return NameTablesKt.sanitizeName(string2, bl);
    }

    private static final char mangleIfNot(char $this$mangleIfNot, Function1<? super Character, Boolean> predicate) {
        boolean $i$f$mangleIfNot = false;
        return (Boolean)predicate.invoke((Object)Character.valueOf($this$mangleIfNot)) != false ? $this$mangleIfNot : (char)'_';
    }

    public static final /* synthetic */ String access$mapToKey(Object declaration2) {
        return NameTablesKt.mapToKey(declaration2);
    }
}

