/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleRef;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleReferences;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrModule;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrModuleCrossModuleReferecenceBuilder;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrProgramFragment;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrProgram;", "", "modules", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModule;", "(Ljava/util/List;)V", "mainModule", "getMainModule", "()Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModule;", "getModules", "()Ljava/util/List;", "otherModules", "getOtherModules", "crossModuleDependencies", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/CrossModuleReferences;", "relativeRequirePath", "", "backend.js"})
public final class JsIrProgram {
    @NotNull
    private final List<JsIrModule> modules;
    @NotNull
    private final JsIrModule mainModule;
    @NotNull
    private final List<JsIrModule> otherModules;

    public JsIrProgram(@NotNull List<JsIrModule> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        this.modules = modules;
        this.mainModule = (JsIrModule)CollectionsKt.last(this.modules);
        this.otherModules = CollectionsKt.dropLast(this.modules, (int)1);
    }

    @NotNull
    public final List<JsIrModule> getModules() {
        return this.modules;
    }

    @NotNull
    public final JsIrModule getMainModule() {
        return this.mainModule;
    }

    @NotNull
    public final List<JsIrModule> getOtherModules() {
        return this.otherModules;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<JsIrModule, CrossModuleReferences> crossModuleDependencies(boolean relativeRequirePath) {
        JsIrModuleCrossModuleReferecenceBuilder moduleBuilder;
        Object object;
        Map map;
        Object object2;
        Iterable $this$associateWith$iv = this.modules;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            JsIrModule jsIrModule = (JsIrModule)element$iv$iv;
            object2 = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            object = new JsIrModuleCrossModuleReferecenceBuilder((JsIrModule)it, relativeRequirePath);
            map.put(object2, object);
        }
        Map moduleToBuilder = result$iv;
        Map definitionModule = new LinkedHashMap();
        Object v = moduleToBuilder.get(this.mainModule);
        Intrinsics.checkNotNull(v);
        ((JsIrModuleCrossModuleReferecenceBuilder)v).setTransitiveJsExportFrom(this.otherModules);
        for (JsIrModule module2 : this.modules) {
            Object v2 = moduleToBuilder.get(module2);
            Intrinsics.checkNotNull(v2);
            moduleBuilder = (JsIrModuleCrossModuleReferecenceBuilder)v2;
            for (JsIrProgramFragment fragment : module2.getFragments()) {
                for (String definition : fragment.getDefinitions()) {
                    if (!(!definitionModule.containsKey(definition))) {
                        boolean $i$a$-require-JsIrProgram$crossModuleDependencies$22 = false;
                        String $i$a$-require-JsIrProgram$crossModuleDependencies$22 = "Duplicate definition: " + definition;
                        throw new IllegalArgumentException($i$a$-require-JsIrProgram$crossModuleDependencies$22.toString());
                    }
                    definitionModule.put(definition, moduleBuilder);
                }
            }
        }
        for (JsIrModule module2 : this.modules) {
            Object v3 = moduleToBuilder.get(module2);
            Intrinsics.checkNotNull(v3);
            moduleBuilder = (JsIrModuleCrossModuleReferecenceBuilder)v3;
            for (JsIrProgramFragment fragment : module2.getFragments()) {
                for (String tag : fragment.getNameBindings().keySet()) {
                    JsIrModuleCrossModuleReferecenceBuilder fromModuleBuilder;
                    if ((JsIrModuleCrossModuleReferecenceBuilder)definitionModule.get(tag) == null || Intrinsics.areEqual((Object)fromModuleBuilder, (Object)moduleBuilder)) continue;
                    ((Collection)moduleBuilder.getImports()).add(new CrossModuleRef(fromModuleBuilder, tag));
                    ((Collection)fromModuleBuilder.getExports()).add(tag);
                }
            }
        }
        Iterable $this$associateWith$iv2 = this.modules;
        boolean $i$f$associateWith2 = false;
        LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv2, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv2 = $this$associateWith$iv2;
        boolean $i$f$associateWithTo2 = false;
        for (String element$iv$iv : $this$associateWithTo$iv$iv2) {
            void it;
            JsIrModule fromModuleBuilder = (JsIrModule)((Object)element$iv$iv);
            object2 = element$iv$iv;
            map = result$iv2;
            boolean bl = false;
            Object v4 = moduleToBuilder.get(it);
            Intrinsics.checkNotNull(v4);
            object = ((JsIrModuleCrossModuleReferecenceBuilder)v4).buildCrossModuleRefs();
            map.put(object2, object);
        }
        return result$iv2;
    }
}

