/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners.ir;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.ir.AbstractIrTextTest;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="compiler/testData/ir/irText")
@TestDataPath(value="$PROJECT_ROOT")
public class IrTextTestGenerated
extends AbstractIrTextTest {
    @Test
    public void testAllFilesPresentInIrText() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/types")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Types {
        @Test
        @TestMetadata(value="abbreviatedTypes.kt")
        public void testAbbreviatedTypes() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/abbreviatedTypes.kt");
        }

        @Test
        public void testAllFilesPresentInTypes() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/types"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="asOnPlatformType.kt")
        public void testAsOnPlatformType() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/asOnPlatformType.kt");
        }

        @Test
        @TestMetadata(value="castsInsideCoroutineInference.kt")
        public void testCastsInsideCoroutineInference() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/castsInsideCoroutineInference.kt");
        }

        @Test
        @TestMetadata(value="coercionToUnitInLambdaReturnValue.kt")
        public void testCoercionToUnitInLambdaReturnValue() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/coercionToUnitInLambdaReturnValue.kt");
        }

        @Test
        @TestMetadata(value="definitelyNonNull.kt")
        public void testDefinitelyNonNull() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNonNull.kt");
        }

        @Test
        @TestMetadata(value="definitelyNonNullOverride.kt")
        public void testDefinitelyNonNullOverride() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNonNullOverride.kt");
        }

        @Test
        @TestMetadata(value="definitelyNonNullSAM.kt")
        public void testDefinitelyNonNullSAM() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNonNullSAM.kt");
        }

        @Test
        @TestMetadata(value="definitelyNonNullWithJava.kt")
        public void testDefinitelyNonNullWithJava() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNonNullWithJava.kt");
        }

        @Test
        @TestMetadata(value="definitelyNotNullAsArgument.kt")
        public void testDefinitelyNotNullAsArgument() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNotNullAsArgument.kt");
        }

        @Test
        @TestMetadata(value="definitelyNotNullAsReceiver.kt")
        public void testDefinitelyNotNullAsReceiver() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNotNullAsReceiver.kt");
        }

        @Test
        @TestMetadata(value="definitelyNotNullWithIntersection1.kt")
        public void testDefinitelyNotNullWithIntersection1() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNotNullWithIntersection1.kt");
        }

        @Test
        @TestMetadata(value="genericDelegatedDeepProperty.kt")
        public void testGenericDelegatedDeepProperty() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/genericDelegatedDeepProperty.kt");
        }

        @Test
        @TestMetadata(value="genericFunWithStar.kt")
        public void testGenericFunWithStar() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/genericFunWithStar.kt");
        }

        @Test
        @TestMetadata(value="genericPropertyReferenceType.kt")
        public void testGenericPropertyReferenceType() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/genericPropertyReferenceType.kt");
        }

        @Test
        @TestMetadata(value="inStarProjectionInReceiverType.kt")
        public void testInStarProjectionInReceiverType() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/inStarProjectionInReceiverType.kt");
        }

        @Test
        @TestMetadata(value="intersectionType1.kt")
        public void testIntersectionType1() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/intersectionType1.kt");
        }

        @Test
        @TestMetadata(value="intersectionType2.kt")
        public void testIntersectionType2() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/intersectionType2.kt");
        }

        @Test
        @TestMetadata(value="intersectionType3.kt")
        public void testIntersectionType3() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/intersectionType3.kt");
        }

        @Test
        @TestMetadata(value="intersectionTypeInSamType.kt")
        public void testIntersectionTypeInSamType() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/intersectionTypeInSamType.kt");
        }

        @Test
        @TestMetadata(value="javaWildcardType.kt")
        public void testJavaWildcardType() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/javaWildcardType.kt");
        }

        @Test
        @TestMetadata(value="kt36143.kt")
        public void testKt36143() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/kt36143.kt");
        }

        @Test
        @TestMetadata(value="kt49526.kt")
        public void testKt49526() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/kt49526.kt");
        }

        @Test
        @TestMetadata(value="localVariableOfIntersectionType.kt")
        public void testLocalVariableOfIntersectionType() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/localVariableOfIntersectionType.kt");
        }

        @Test
        @TestMetadata(value="rawTypeInSignature.kt")
        public void testRawTypeInSignature() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/rawTypeInSignature.kt");
        }

        @Test
        @TestMetadata(value="receiverOfIntersectionType.kt")
        public void testReceiverOfIntersectionType() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/receiverOfIntersectionType.kt");
        }

        @Test
        @TestMetadata(value="smartCastOnFakeOverrideReceiver.kt")
        public void testSmartCastOnFakeOverrideReceiver() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/smartCastOnFakeOverrideReceiver.kt");
        }

        @Test
        @TestMetadata(value="smartCastOnFieldReceiverOfGenericType.kt")
        public void testSmartCastOnFieldReceiverOfGenericType() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/smartCastOnFieldReceiverOfGenericType.kt");
        }

        @Test
        @TestMetadata(value="smartCastOnReceiverOfGenericType.kt")
        public void testSmartCastOnReceiverOfGenericType() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/smartCastOnReceiverOfGenericType.kt");
        }

        @Test
        @TestMetadata(value="starProjection.kt")
        public void testStarProjection() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/starProjection.kt");
        }

        @Test
        @TestMetadata(value="typeAliasWithUnsafeVariance.kt")
        public void testTypeAliasWithUnsafeVariance() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/typeAliasWithUnsafeVariance.kt");
        }

        @Test
        @TestMetadata(value="typeCheckOnDefinitelyNotNull.kt")
        public void testTypeCheckOnDefinitelyNotNull() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/typeCheckOnDefinitelyNotNull.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/types/nullChecks")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NullChecks {
            @Test
            public void testAllFilesPresentInNullChecks() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/types/nullChecks"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enhancedNullability.kt")
            public void testEnhancedNullability() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullability.kt");
            }

            @Test
            @TestMetadata(value="enhancedNullabilityInDestructuringAssignment.kt")
            public void testEnhancedNullabilityInDestructuringAssignment() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullabilityInDestructuringAssignment.kt");
            }

            @Test
            @TestMetadata(value="enhancedNullabilityInForLoop.kt")
            public void testEnhancedNullabilityInForLoop() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullabilityInForLoop.kt");
            }

            @Test
            @TestMetadata(value="explicitEqualsAndCompareToCallsOnPlatformTypeReceiver.kt")
            public void testExplicitEqualsAndCompareToCallsOnPlatformTypeReceiver() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/explicitEqualsAndCompareToCallsOnPlatformTypeReceiver.kt");
            }

            @Test
            @TestMetadata(value="implicitNotNullOnPlatformType.kt")
            public void testImplicitNotNullOnPlatformType() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/implicitNotNullOnPlatformType.kt");
            }

            @Test
            @TestMetadata(value="nullCheckInElvisRhs.kt")
            public void testNullCheckInElvisRhs() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckInElvisRhs.kt");
            }

            @Test
            @TestMetadata(value="nullCheckOnInterfaceDelegation.kt")
            public void testNullCheckOnInterfaceDelegation() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnInterfaceDelegation.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAssertionOnExtensionReceiver.kt")
            public void testNullabilityAssertionOnExtensionReceiver() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullabilityAssertionOnExtensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="platformTypeReceiver.kt")
            public void testPlatformTypeReceiver() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/platformTypeReceiver.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithMixedNullableAndNotNullableBounds.kt")
            public void testTypeParameterWithMixedNullableAndNotNullableBounds() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/typeParameterWithMixedNullableAndNotNullableBounds.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithMultipleNotNullableBounds.kt")
            public void testTypeParameterWithMultipleNotNullableBounds() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/typeParameterWithMultipleNotNullableBounds.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithMultipleNullableBounds.kt")
            public void testTypeParameterWithMultipleNullableBounds() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/typeParameterWithMultipleNullableBounds.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult")
            @TestDataPath(value="$PROJECT_ROOT")
            public class NullCheckOnLambdaResult {
                @Test
                public void testAllFilesPresentInNullCheckOnLambdaResult() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="nnStringVsT.kt")
                public void testNnStringVsT() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsT.kt");
                }

                @Test
                @TestMetadata(value="nnStringVsTAny.kt")
                public void testNnStringVsTAny() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTAny.kt");
                }

                @Test
                @TestMetadata(value="nnStringVsTConstrained.kt")
                public void testNnStringVsTConstrained() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTConstrained.kt");
                }

                @Test
                @TestMetadata(value="nnStringVsTXArray.kt")
                public void testNnStringVsTXArray() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTXArray.kt");
                }

                @Test
                @TestMetadata(value="nnStringVsTXString.kt")
                public void testNnStringVsTXString() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTXString.kt");
                }

                @Test
                @TestMetadata(value="stringVsAny.kt")
                public void testStringVsAny() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsAny.kt");
                }

                @Test
                @TestMetadata(value="stringVsT.kt")
                public void testStringVsT() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsT.kt");
                }

                @Test
                @TestMetadata(value="stringVsTAny.kt")
                public void testStringVsTAny() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTAny.kt");
                }

                @Test
                @TestMetadata(value="stringVsTConstrained.kt")
                public void testStringVsTConstrained() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTConstrained.kt");
                }

                @Test
                @TestMetadata(value="stringVsTXArray.kt")
                public void testStringVsTXArray() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTXArray.kt");
                }

                @Test
                @TestMetadata(value="stringVsTXString.kt")
                public void testStringVsTXString() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTXString.kt");
                }
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/stubs")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Stubs {
        @Test
        public void testAllFilesPresentInStubs() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/stubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="builtinMap.kt")
        public void testBuiltinMap() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/builtinMap.kt");
        }

        @Test
        @TestMetadata(value="constFromBuiltins.kt")
        public void testConstFromBuiltins() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/constFromBuiltins.kt");
        }

        @Test
        @TestMetadata(value="genericClassInDifferentModule.kt")
        public void testGenericClassInDifferentModule() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/genericClassInDifferentModule.kt");
        }

        @Test
        @TestMetadata(value="javaConstructorWithTypeParameters.kt")
        public void testJavaConstructorWithTypeParameters() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaConstructorWithTypeParameters.kt");
        }

        @Test
        @TestMetadata(value="javaEnum.kt")
        public void testJavaEnum() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaEnum.kt");
        }

        @Test
        @TestMetadata(value="javaInnerClass.kt")
        public void testJavaInnerClass() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaInnerClass.kt");
        }

        @Test
        @TestMetadata(value="javaMethod.kt")
        public void testJavaMethod() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaMethod.kt");
        }

        @Test
        @TestMetadata(value="javaNestedClass.kt")
        public void testJavaNestedClass() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaNestedClass.kt");
        }

        @Test
        @TestMetadata(value="javaStaticMethod.kt")
        public void testJavaStaticMethod() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaStaticMethod.kt");
        }

        @Test
        @TestMetadata(value="javaSyntheticProperty.kt")
        public void testJavaSyntheticProperty() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaSyntheticProperty.kt");
        }

        @Test
        @TestMetadata(value="jdkClassSyntheticProperty.kt")
        public void testJdkClassSyntheticProperty() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/jdkClassSyntheticProperty.kt");
        }

        @Test
        @TestMetadata(value="kotlinInnerClass.kt")
        public void testKotlinInnerClass() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/kotlinInnerClass.kt");
        }

        @Test
        @TestMetadata(value="simple.kt")
        public void testSimple() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/simple.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/singletons")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Singletons {
        @Test
        public void testAllFilesPresentInSingletons() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/singletons"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="companion.kt")
        public void testCompanion() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/singletons/companion.kt");
        }

        @Test
        @TestMetadata(value="enumEntry.kt")
        public void testEnumEntry() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/singletons/enumEntry.kt");
        }

        @Test
        @TestMetadata(value="object.kt")
        public void testObject() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/singletons/object.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/regressions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Regressions {
        @Test
        public void testAllFilesPresentInRegressions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/regressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="coercionInLoop.kt")
        public void testCoercionInLoop() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/coercionInLoop.kt");
        }

        @Test
        @TestMetadata(value="integerCoercionToT.kt")
        public void testIntegerCoercionToT() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/integerCoercionToT.kt");
        }

        @Test
        @TestMetadata(value="kt24114.kt")
        public void testKt24114() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/kt24114.kt");
        }

        @Test
        @TestMetadata(value="kt44855.kt")
        public void testKt44855() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/kt44855.kt");
        }

        @Test
        @TestMetadata(value="kt45236.kt")
        public void testKt45236() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/kt45236.kt");
        }

        @Test
        @TestMetadata(value="newInferenceFixationOrder1.kt")
        public void testNewInferenceFixationOrder1() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/newInferenceFixationOrder1.kt");
        }

        @Test
        @TestMetadata(value="typeAliasCtorForGenericClass.kt")
        public void testTypeAliasCtorForGenericClass() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/typeAliasCtorForGenericClass.kt");
        }

        @Test
        @TestMetadata(value="typeParametersInImplicitCast.kt")
        public void testTypeParametersInImplicitCast() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/typeParametersInImplicitCast.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/lambdas")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Lambdas {
        @Test
        public void testAllFilesPresentInLambdas() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/lambdas"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="anonymousFunction.kt")
        public void testAnonymousFunction() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/anonymousFunction.kt");
        }

        @Test
        @TestMetadata(value="destructuringInLambda.kt")
        public void testDestructuringInLambda() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/destructuringInLambda.kt");
        }

        @Test
        @TestMetadata(value="extensionLambda.kt")
        public void testExtensionLambda() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/extensionLambda.kt");
        }

        @Test
        @TestMetadata(value="justLambda.kt")
        public void testJustLambda() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/justLambda.kt");
        }

        @Test
        @TestMetadata(value="lambdaReturningUnit.kt")
        public void testLambdaReturningUnit() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/lambdaReturningUnit.kt");
        }

        @Test
        @TestMetadata(value="localFunction.kt")
        public void testLocalFunction() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/localFunction.kt");
        }

        @Test
        @TestMetadata(value="multipleImplicitReceivers.kt")
        public void testMultipleImplicitReceivers() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/multipleImplicitReceivers.kt");
        }

        @Test
        @TestMetadata(value="nonLocalReturn.kt")
        public void testNonLocalReturn() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/nonLocalReturn.kt");
        }

        @Test
        @TestMetadata(value="samAdapter.kt")
        public void testSamAdapter() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/samAdapter.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/firProblems")
    @TestDataPath(value="$PROJECT_ROOT")
    public class FirProblems {
        @Test
        @TestMetadata(value="AbstractMutableMap.kt")
        public void testAbstractMutableMap() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/AbstractMutableMap.kt");
        }

        @Test
        @TestMetadata(value="AllCandidates.kt")
        public void testAllCandidates() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/AllCandidates.kt");
        }

        @Test
        public void testAllFilesPresentInFirProblems() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/firProblems"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="AnnotationInAnnotation.kt")
        public void testAnnotationInAnnotation() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/AnnotationInAnnotation.kt");
        }

        @Test
        @TestMetadata(value="AnnotationLoader.kt")
        public void testAnnotationLoader() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/AnnotationLoader.kt");
        }

        @Test
        @TestMetadata(value="ArrayMap.kt")
        public void testArrayMap() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/ArrayMap.kt");
        }

        @Test
        @TestMetadata(value="candidateSymbol.kt")
        public void testCandidateSymbol() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/candidateSymbol.kt");
        }

        @Test
        @TestMetadata(value="ClashResolutionDescriptor.kt")
        public void testClashResolutionDescriptor() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/ClashResolutionDescriptor.kt");
        }

        @Test
        @TestMetadata(value="coercionToUnitForNestedWhen.kt")
        public void testCoercionToUnitForNestedWhen() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/coercionToUnitForNestedWhen.kt");
        }

        @Test
        @TestMetadata(value="DeepCopyIrTree.kt")
        public void testDeepCopyIrTree() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/DeepCopyIrTree.kt");
        }

        @Test
        @TestMetadata(value="DelegationAndInheritanceFromJava.kt")
        public void testDelegationAndInheritanceFromJava() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/DelegationAndInheritanceFromJava.kt");
        }

        @Test
        @TestMetadata(value="deprecated.kt")
        public void testDeprecated() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/deprecated.kt");
        }

        @Test
        @TestMetadata(value="Fir2IrClassifierStorage.kt")
        public void testFir2IrClassifierStorage() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/Fir2IrClassifierStorage.kt");
        }

        @Test
        @TestMetadata(value="FirBuilder.kt")
        public void testFirBuilder() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/FirBuilder.kt");
        }

        @Test
        @TestMetadata(value="FlushFromAnonymous.kt")
        public void testFlushFromAnonymous() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/FlushFromAnonymous.kt");
        }

        @Test
        @TestMetadata(value="functionLiteralGenericSignature.kt")
        public void testFunctionLiteralGenericSignature() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/functionLiteralGenericSignature.kt");
        }

        @Test
        @TestMetadata(value="ImplicitReceiverStack.kt")
        public void testImplicitReceiverStack() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/ImplicitReceiverStack.kt");
        }

        @Test
        @TestMetadata(value="inapplicableCollectionSet.kt")
        public void testInapplicableCollectionSet() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/inapplicableCollectionSet.kt");
        }

        @Test
        @TestMetadata(value="InnerClassInAnonymous.kt")
        public void testInnerClassInAnonymous() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/InnerClassInAnonymous.kt");
        }

        @Test
        @TestMetadata(value="JCTree.kt")
        public void testJCTree() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/JCTree.kt");
        }

        @Test
        @TestMetadata(value="kt19251.kt")
        public void testKt19251() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/kt19251.kt");
        }

        @Test
        @TestMetadata(value="kt43342.kt")
        public void testKt43342() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/kt43342.kt");
        }

        @Test
        @TestMetadata(value="localClassUsedBeforeDeclaration.kt")
        public void testLocalClassUsedBeforeDeclaration() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/localClassUsedBeforeDeclaration.kt");
        }

        @Test
        @TestMetadata(value="Modality.kt")
        public void testModality() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/Modality.kt");
        }

        @Test
        @TestMetadata(value="MultiList.kt")
        public void testMultiList() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/MultiList.kt");
        }

        @Test
        @TestMetadata(value="putIfAbsent.kt")
        public void testPutIfAbsent() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/putIfAbsent.kt");
        }

        @Test
        @TestMetadata(value="readWriteProperty.kt")
        public void testReadWriteProperty() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/readWriteProperty.kt");
        }

        @Test
        @TestMetadata(value="recursiveCapturedTypeInPropertyReference.kt")
        public void testRecursiveCapturedTypeInPropertyReference() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/recursiveCapturedTypeInPropertyReference.kt");
        }

        @Test
        @TestMetadata(value="SafeLetWithReturn.kt")
        public void testSafeLetWithReturn() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/SafeLetWithReturn.kt");
        }

        @Test
        @TestMetadata(value="SameJavaFieldReferences.kt")
        public void testSameJavaFieldReferences() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/SameJavaFieldReferences.kt");
        }

        @Test
        @TestMetadata(value="SignatureClash.kt")
        public void testSignatureClash() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/SignatureClash.kt");
        }

        @Test
        @TestMetadata(value="SimpleTypeMarker.kt")
        public void testSimpleTypeMarker() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/SimpleTypeMarker.kt");
        }

        @Test
        @TestMetadata(value="SyntheticSetterType.kt")
        public void testSyntheticSetterType() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/SyntheticSetterType.kt");
        }

        @Test
        @TestMetadata(value="throwableStackTrace.kt")
        public void testThrowableStackTrace() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/throwableStackTrace.kt");
        }

        @Test
        @TestMetadata(value="TypeParameterBounds.kt")
        public void testTypeParameterBounds() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/TypeParameterBounds.kt");
        }

        @Test
        @TestMetadata(value="typeParameterFromJavaClass.kt")
        public void testTypeParameterFromJavaClass() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/typeParameterFromJavaClass.kt");
        }

        @Test
        @TestMetadata(value="typeVariableAfterBuildMap.kt")
        public void testTypeVariableAfterBuildMap() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/typeVariableAfterBuildMap.kt");
        }

        @Test
        @TestMetadata(value="V8ArrayToList.kt")
        public void testV8ArrayToList() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/V8ArrayToList.kt");
        }

        @Test
        @TestMetadata(value="VarInInit.kt")
        public void testVarInInit() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/VarInInit.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/expressions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Expressions {
        @Test
        public void testAllFilesPresentInExpressions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="argumentMappedWithError.kt")
        public void testArgumentMappedWithError() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/argumentMappedWithError.kt");
        }

        @Test
        @TestMetadata(value="arrayAccess.kt")
        public void testArrayAccess() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/arrayAccess.kt");
        }

        @Test
        @TestMetadata(value="arrayAssignment.kt")
        public void testArrayAssignment() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/arrayAssignment.kt");
        }

        @Test
        @TestMetadata(value="arrayAugmentedAssignment1.kt")
        public void testArrayAugmentedAssignment1() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/arrayAugmentedAssignment1.kt");
        }

        @Test
        @TestMetadata(value="arrayAugmentedAssignment2.kt")
        public void testArrayAugmentedAssignment2() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/arrayAugmentedAssignment2.kt");
        }

        @Test
        @TestMetadata(value="assignments.kt")
        public void testAssignments() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/assignments.kt");
        }

        @Test
        @TestMetadata(value="augmentedAssignment1.kt")
        public void testAugmentedAssignment1() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/augmentedAssignment1.kt");
        }

        @Test
        @TestMetadata(value="augmentedAssignment2.kt")
        public void testAugmentedAssignment2() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/augmentedAssignment2.kt");
        }

        @Test
        @TestMetadata(value="augmentedAssignmentWithExpression.kt")
        public void testAugmentedAssignmentWithExpression() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/augmentedAssignmentWithExpression.kt");
        }

        @Test
        @TestMetadata(value="badBreakContinue.kt")
        public void testBadBreakContinue() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/badBreakContinue.kt");
        }

        @Test
        @TestMetadata(value="bangbang.kt")
        public void testBangbang() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/bangbang.kt");
        }

        @Test
        @TestMetadata(value="booleanConstsInAndAndOrOr.kt")
        public void testBooleanConstsInAndAndOrOr() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/booleanConstsInAndAndOrOr.kt");
        }

        @Test
        @TestMetadata(value="booleanOperators.kt")
        public void testBooleanOperators() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/booleanOperators.kt");
        }

        @Test
        @TestMetadata(value="boundCallableReferences.kt")
        public void testBoundCallableReferences() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/boundCallableReferences.kt");
        }

        @Test
        @TestMetadata(value="boxOk.kt")
        public void testBoxOk() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/boxOk.kt");
        }

        @Test
        @TestMetadata(value="breakContinue.kt")
        public void testBreakContinue() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/breakContinue.kt");
        }

        @Test
        @TestMetadata(value="breakContinueInLoopHeader.kt")
        public void testBreakContinueInLoopHeader() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/breakContinueInLoopHeader.kt");
        }

        @Test
        @TestMetadata(value="breakContinueInWhen.kt")
        public void testBreakContinueInWhen() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/breakContinueInWhen.kt");
        }

        @Test
        @TestMetadata(value="callWithReorderedArguments.kt")
        public void testCallWithReorderedArguments() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callWithReorderedArguments.kt");
        }

        @Test
        @TestMetadata(value="calls.kt")
        public void testCalls() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/calls.kt");
        }

        @Test
        @TestMetadata(value="castToTypeParameter.kt")
        public void testCastToTypeParameter() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/castToTypeParameter.kt");
        }

        @Test
        @TestMetadata(value="catchParameterAccess.kt")
        public void testCatchParameterAccess() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/catchParameterAccess.kt");
        }

        @Test
        @TestMetadata(value="chainOfSafeCalls.kt")
        public void testChainOfSafeCalls() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/chainOfSafeCalls.kt");
        }

        @Test
        @TestMetadata(value="chainedFunSuspendConversionForSimpleExpression.kt")
        public void testChainedFunSuspendConversionForSimpleExpression() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/chainedFunSuspendConversionForSimpleExpression.kt");
        }

        @Test
        @TestMetadata(value="classReference.kt")
        public void testClassReference() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/classReference.kt");
        }

        @Test
        @TestMetadata(value="coercionToUnit.kt")
        public void testCoercionToUnit() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/coercionToUnit.kt");
        }

        @Test
        @TestMetadata(value="complexAugmentedAssignment.kt")
        public void testComplexAugmentedAssignment() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/complexAugmentedAssignment.kt");
        }

        @Test
        @TestMetadata(value="constructorWithOwnTypeParametersCall.kt")
        public void testConstructorWithOwnTypeParametersCall() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/constructorWithOwnTypeParametersCall.kt");
        }

        @Test
        @TestMetadata(value="contructorCall.kt")
        public void testContructorCall() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/contructorCall.kt");
        }

        @Test
        @TestMetadata(value="conventionComparisons.kt")
        public void testConventionComparisons() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/conventionComparisons.kt");
        }

        @Test
        @TestMetadata(value="destructuring1.kt")
        public void testDestructuring1() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/destructuring1.kt");
        }

        @Test
        @TestMetadata(value="destructuringWithUnderscore.kt")
        public void testDestructuringWithUnderscore() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/destructuringWithUnderscore.kt");
        }

        @Test
        @TestMetadata(value="dotQualified.kt")
        public void testDotQualified() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/dotQualified.kt");
        }

        @Test
        @TestMetadata(value="elvis.kt")
        public void testElvis() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/elvis.kt");
        }

        @Test
        @TestMetadata(value="enumEntryAsReceiver.kt")
        public void testEnumEntryAsReceiver() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/enumEntryAsReceiver.kt");
        }

        @Test
        @TestMetadata(value="enumEntryReferenceFromEnumEntryClass.kt")
        public void testEnumEntryReferenceFromEnumEntryClass() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/enumEntryReferenceFromEnumEntryClass.kt");
        }

        @Test
        @TestMetadata(value="equality.kt")
        public void testEquality() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/equality.kt");
        }

        @Test
        @TestMetadata(value="equals.kt")
        public void testEquals() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/equals.kt");
        }

        @Test
        @TestMetadata(value="exclExclOnPlatformType.kt")
        public void testExclExclOnPlatformType() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/exclExclOnPlatformType.kt");
        }

        @Test
        @TestMetadata(value="exhaustiveWhenElseBranch.kt")
        public void testExhaustiveWhenElseBranch() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/exhaustiveWhenElseBranch.kt");
        }

        @Test
        @TestMetadata(value="extFunInvokeAsFun.kt")
        public void testExtFunInvokeAsFun() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/extFunInvokeAsFun.kt");
        }

        @Test
        @TestMetadata(value="extFunSafeInvoke.kt")
        public void testExtFunSafeInvoke() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/extFunSafeInvoke.kt");
        }

        @Test
        @TestMetadata(value="extensionPropertyGetterCall.kt")
        public void testExtensionPropertyGetterCall() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/extensionPropertyGetterCall.kt");
        }

        @Test
        @TestMetadata(value="field.kt")
        public void testField() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/field.kt");
        }

        @Test
        @TestMetadata(value="for.kt")
        public void testFor() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/for.kt");
        }

        @Test
        @TestMetadata(value="forWithBreakContinue.kt")
        public void testForWithBreakContinue() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/forWithBreakContinue.kt");
        }

        @Test
        @TestMetadata(value="forWithImplicitReceivers.kt")
        public void testForWithImplicitReceivers() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/forWithImplicitReceivers.kt");
        }

        @Test
        @TestMetadata(value="funImportedFromObject.kt")
        public void testFunImportedFromObject() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funImportedFromObject.kt");
        }

        @Test
        @TestMetadata(value="funInterfaceConstructorReference.kt")
        public void testFunInterfaceConstructorReference() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterfaceConstructorReference.kt");
        }

        @Test
        @TestMetadata(value="genericConstructorCallWithTypeArguments.kt")
        public void testGenericConstructorCallWithTypeArguments() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/genericConstructorCallWithTypeArguments.kt");
        }

        @Test
        @TestMetadata(value="genericPropertyCall.kt")
        public void testGenericPropertyCall() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/genericPropertyCall.kt");
        }

        @Test
        @TestMetadata(value="genericPropertyRef.kt")
        public void testGenericPropertyRef() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/genericPropertyRef.kt");
        }

        @Test
        @TestMetadata(value="identity.kt")
        public void testIdentity() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/identity.kt");
        }

        @Test
        @TestMetadata(value="ifElseIf.kt")
        public void testIfElseIf() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/ifElseIf.kt");
        }

        @Test
        @TestMetadata(value="implicitCastInReturnFromConstructor.kt")
        public void testImplicitCastInReturnFromConstructor() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/implicitCastInReturnFromConstructor.kt");
        }

        @Test
        @TestMetadata(value="implicitCastOnPlatformType.kt")
        public void testImplicitCastOnPlatformType() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/implicitCastOnPlatformType.kt");
        }

        @Test
        @TestMetadata(value="implicitCastToNonNull.kt")
        public void testImplicitCastToNonNull() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/implicitCastToNonNull.kt");
        }

        @Test
        @TestMetadata(value="implicitCastToTypeParameter.kt")
        public void testImplicitCastToTypeParameter() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/implicitCastToTypeParameter.kt");
        }

        @Test
        @TestMetadata(value="implicitNotNullInDestructuringAssignment.kt")
        public void testImplicitNotNullInDestructuringAssignment() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/implicitNotNullInDestructuringAssignment.kt");
        }

        @Test
        @TestMetadata(value="in.kt")
        public void testIn() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/in.kt");
        }

        @Test
        @TestMetadata(value="incrementDecrement.kt")
        public void testIncrementDecrement() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/incrementDecrement.kt");
        }

        @Test
        @TestMetadata(value="interfaceThisRef.kt")
        public void testInterfaceThisRef() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/interfaceThisRef.kt");
        }

        @Test
        @TestMetadata(value="javaSyntheticGenericPropretyAccess.kt")
        public void testJavaSyntheticGenericPropretyAccess() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/javaSyntheticGenericPropretyAccess.kt");
        }

        @Test
        @TestMetadata(value="javaSyntheticPropertyAccess.kt")
        public void testJavaSyntheticPropertyAccess() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/javaSyntheticPropertyAccess.kt");
        }

        @Test
        @TestMetadata(value="jvmFieldReferenceWithIntersectionTypes.kt")
        public void testJvmFieldReferenceWithIntersectionTypes() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/jvmFieldReferenceWithIntersectionTypes.kt");
        }

        @Test
        @TestMetadata(value="jvmInstanceFieldReference.kt")
        public void testJvmInstanceFieldReference() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/jvmInstanceFieldReference.kt");
        }

        @Test
        @TestMetadata(value="jvmStaticFieldReference.kt")
        public void testJvmStaticFieldReference() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/jvmStaticFieldReference.kt");
        }

        @Test
        @TestMetadata(value="kt16904.kt")
        public void testKt16904() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt16904.kt");
        }

        @Test
        @TestMetadata(value="kt16905.kt")
        public void testKt16905() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt16905.kt");
        }

        @Test
        @TestMetadata(value="kt23030.kt")
        public void testKt23030() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt23030.kt");
        }

        @Test
        @TestMetadata(value="kt24804.kt")
        public void testKt24804() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt24804.kt");
        }

        @Test
        @TestMetadata(value="kt27933.kt")
        public void testKt27933() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt27933.kt");
        }

        @Test
        @TestMetadata(value="kt28006.kt")
        public void testKt28006() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt28006.kt");
        }

        @Test
        @TestMetadata(value="kt28456.kt")
        public void testKt28456() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt28456.kt");
        }

        @Test
        @TestMetadata(value="kt28456a.kt")
        public void testKt28456a() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt28456a.kt");
        }

        @Test
        @TestMetadata(value="kt28456b.kt")
        public void testKt28456b() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt28456b.kt");
        }

        @Test
        @TestMetadata(value="kt30020.kt")
        public void testKt30020() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt30020.kt");
        }

        @Test
        @TestMetadata(value="kt30796.kt")
        public void testKt30796() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt30796.kt");
        }

        @Test
        @TestMetadata(value="kt35730.kt")
        public void testKt35730() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt35730.kt");
        }

        @Test
        @TestMetadata(value="kt36956.kt")
        public void testKt36956() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt36956.kt");
        }

        @Test
        @TestMetadata(value="kt36963.kt")
        public void testKt36963() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt36963.kt");
        }

        @Test
        @TestMetadata(value="kt37570.kt")
        public void testKt37570() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt37570.kt");
        }

        @Test
        @TestMetadata(value="kt37779.kt")
        public void testKt37779() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt37779.kt");
        }

        @Test
        @TestMetadata(value="kt42321.kt")
        public void testKt42321() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt42321.kt");
        }

        @Test
        @TestMetadata(value="kt44993.kt")
        public void testKt44993() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt44993.kt");
        }

        @Test
        @TestMetadata(value="kt45022.kt")
        public void testKt45022() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt45022.kt");
        }

        @Test
        @TestMetadata(value="kt47082.kt")
        public void testKt47082() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt47082.kt");
        }

        @Test
        @TestMetadata(value="kt47245.kt")
        public void testKt47245() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt47245.kt");
        }

        @Test
        @TestMetadata(value="kt47328.kt")
        public void testKt47328() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt47328.kt");
        }

        @Test
        @TestMetadata(value="kt47450.kt")
        public void testKt47450() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt47450.kt");
        }

        @Test
        @TestMetadata(value="kt48708.kt")
        public void testKt48708() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt48708.kt");
        }

        @Test
        @TestMetadata(value="kt48806.kt")
        public void testKt48806() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt48806.kt");
        }

        @Test
        @TestMetadata(value="kt49203.kt")
        public void testKt49203() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt49203.kt");
        }

        @Test
        @TestMetadata(value="kt50028.kt")
        public void testKt50028() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt50028.kt");
        }

        @Test
        @TestMetadata(value="kt51036.kt")
        public void testKt51036() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt51036.kt");
        }

        @Test
        @TestMetadata(value="lambdaInCAO.kt")
        public void testLambdaInCAO() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/lambdaInCAO.kt");
        }

        @Test
        @TestMetadata(value="literals.kt")
        public void testLiterals() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/literals.kt");
        }

        @Test
        @TestMetadata(value="memberTypeArguments.kt")
        public void testMemberTypeArguments() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/memberTypeArguments.kt");
        }

        @Test
        @TestMetadata(value="membersImportedFromObject.kt")
        public void testMembersImportedFromObject() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/membersImportedFromObject.kt");
        }

        @Test
        @TestMetadata(value="multipleSmartCasts.kt")
        public void testMultipleSmartCasts() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/multipleSmartCasts.kt");
        }

        @Test
        @TestMetadata(value="multipleThisReferences.kt")
        public void testMultipleThisReferences() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/multipleThisReferences.kt");
        }

        @Test
        @TestMetadata(value="nullCheckOnGenericLambdaReturn.kt")
        public void testNullCheckOnGenericLambdaReturn() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/nullCheckOnGenericLambdaReturn.kt");
        }

        @Test
        @TestMetadata(value="nullCheckOnLambdaReturn.kt")
        public void testNullCheckOnLambdaReturn() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/nullCheckOnLambdaReturn.kt");
        }

        @Test
        @TestMetadata(value="objectAsCallable.kt")
        public void testObjectAsCallable() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/objectAsCallable.kt");
        }

        @Test
        @TestMetadata(value="objectByNameInsideObject.kt")
        public void testObjectByNameInsideObject() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/objectByNameInsideObject.kt");
        }

        @Test
        @TestMetadata(value="objectClassReference.kt")
        public void testObjectClassReference() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/objectClassReference.kt");
        }

        @Test
        @TestMetadata(value="objectReference.kt")
        public void testObjectReference() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/objectReference.kt");
        }

        @Test
        @TestMetadata(value="objectReferenceInClosureInSuperConstructorCall.kt")
        public void testObjectReferenceInClosureInSuperConstructorCall() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/objectReferenceInClosureInSuperConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="objectReferenceInFieldInitializer.kt")
        public void testObjectReferenceInFieldInitializer() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/objectReferenceInFieldInitializer.kt");
        }

        @Test
        @TestMetadata(value="outerClassInstanceReference.kt")
        public void testOuterClassInstanceReference() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/outerClassInstanceReference.kt");
        }

        @Test
        @TestMetadata(value="primitiveComparisons.kt")
        public void testPrimitiveComparisons() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/primitiveComparisons.kt");
        }

        @Test
        @TestMetadata(value="primitivesImplicitConversions.kt")
        public void testPrimitivesImplicitConversions() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/primitivesImplicitConversions.kt");
        }

        @Test
        @TestMetadata(value="propertyReferences.kt")
        public void testPropertyReferences() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/propertyReferences.kt");
        }

        @Test
        @TestMetadata(value="protectedJavaFieldRef.kt")
        public void testProtectedJavaFieldRef() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/protectedJavaFieldRef.kt");
        }

        @Test
        @TestMetadata(value="references.kt")
        public void testReferences() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/references.kt");
        }

        @Test
        @TestMetadata(value="reflectionLiterals.kt")
        public void testReflectionLiterals() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/reflectionLiterals.kt");
        }

        @Test
        @TestMetadata(value="safeAssignment.kt")
        public void testSafeAssignment() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/safeAssignment.kt");
        }

        @Test
        @TestMetadata(value="safeCallWithIncrementDecrement.kt")
        public void testSafeCallWithIncrementDecrement() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/safeCallWithIncrementDecrement.kt");
        }

        @Test
        @TestMetadata(value="safeCalls.kt")
        public void testSafeCalls() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/safeCalls.kt");
        }

        @Test
        @TestMetadata(value="setFieldWithImplicitCast.kt")
        public void testSetFieldWithImplicitCast() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/setFieldWithImplicitCast.kt");
        }

        @Test
        @TestMetadata(value="signedToUnsignedConversions.kt")
        public void testSignedToUnsignedConversions() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/signedToUnsignedConversions.kt");
        }

        @Test
        @TestMetadata(value="simpleOperators.kt")
        public void testSimpleOperators() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/simpleOperators.kt");
        }

        @Test
        @TestMetadata(value="simpleUnaryOperators.kt")
        public void testSimpleUnaryOperators() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/simpleUnaryOperators.kt");
        }

        @Test
        @TestMetadata(value="smartCasts.kt")
        public void testSmartCasts() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/smartCasts.kt");
        }

        @Test
        @TestMetadata(value="smartCastsWithDestructuring.kt")
        public void testSmartCastsWithDestructuring() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/smartCastsWithDestructuring.kt");
        }

        @Test
        @TestMetadata(value="specializedTypeAliasConstructorCall.kt")
        public void testSpecializedTypeAliasConstructorCall() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/specializedTypeAliasConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="stringComparisons.kt")
        public void testStringComparisons() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/stringComparisons.kt");
        }

        @Test
        @TestMetadata(value="stringPlus.kt")
        public void testStringPlus() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/stringPlus.kt");
        }

        @Test
        @TestMetadata(value="stringTemplates.kt")
        public void testStringTemplates() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/stringTemplates.kt");
        }

        @Test
        @TestMetadata(value="suspendConversionInVararg.kt")
        public void testSuspendConversionInVararg() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/suspendConversionInVararg.kt");
        }

        @Test
        @TestMetadata(value="suspendConversionOnArbitraryExpression.kt")
        public void testSuspendConversionOnArbitraryExpression() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/suspendConversionOnArbitraryExpression.kt");
        }

        @Test
        @TestMetadata(value="suspendConversionWithFunInterfaces.kt")
        public void testSuspendConversionWithFunInterfaces() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/suspendConversionWithFunInterfaces.kt");
        }

        @Test
        @TestMetadata(value="temporaryInEnumEntryInitializer.kt")
        public void testTemporaryInEnumEntryInitializer() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/temporaryInEnumEntryInitializer.kt");
        }

        @Test
        @TestMetadata(value="temporaryInInitBlock.kt")
        public void testTemporaryInInitBlock() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/temporaryInInitBlock.kt");
        }

        @Test
        @TestMetadata(value="thisOfGenericOuterClass.kt")
        public void testThisOfGenericOuterClass() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/thisOfGenericOuterClass.kt");
        }

        @Test
        @TestMetadata(value="thisRefToObjectInNestedClassConstructorCall.kt")
        public void testThisRefToObjectInNestedClassConstructorCall() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/thisRefToObjectInNestedClassConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="thisReferenceBeforeClassDeclared.kt")
        public void testThisReferenceBeforeClassDeclared() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/thisReferenceBeforeClassDeclared.kt");
        }

        @Test
        @TestMetadata(value="throw.kt")
        public void testThrow() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/throw.kt");
        }

        @Test
        @TestMetadata(value="tryCatch.kt")
        public void testTryCatch() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/tryCatch.kt");
        }

        @Test
        @TestMetadata(value="tryCatchWithImplicitCast.kt")
        public void testTryCatchWithImplicitCast() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/tryCatchWithImplicitCast.kt");
        }

        @Test
        @TestMetadata(value="typeAliasConstructorReference.kt")
        public void testTypeAliasConstructorReference() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/typeAliasConstructorReference.kt");
        }

        @Test
        @TestMetadata(value="typeArguments.kt")
        public void testTypeArguments() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/typeArguments.kt");
        }

        @Test
        @TestMetadata(value="typeOperators.kt")
        public void testTypeOperators() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/typeOperators.kt");
        }

        @Test
        @TestMetadata(value="typeParameterClassLiteral.kt")
        public void testTypeParameterClassLiteral() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/typeParameterClassLiteral.kt");
        }

        @Test
        @TestMetadata(value="unsignedIntegerLiterals.kt")
        public void testUnsignedIntegerLiterals() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/unsignedIntegerLiterals.kt");
        }

        @Test
        @TestMetadata(value="useImportedMember.kt")
        public void testUseImportedMember() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/useImportedMember.kt");
        }

        @Test
        @TestMetadata(value="values.kt")
        public void testValues() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/values.kt");
        }

        @Test
        @TestMetadata(value="vararg.kt")
        public void testVararg() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/vararg.kt");
        }

        @Test
        @TestMetadata(value="varargWithImplicitCast.kt")
        public void testVarargWithImplicitCast() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/varargWithImplicitCast.kt");
        }

        @Test
        @TestMetadata(value="variableAsFunctionCall.kt")
        public void testVariableAsFunctionCall() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/variableAsFunctionCall.kt");
        }

        @Test
        @TestMetadata(value="variableAsFunctionCallWithGenerics.kt")
        public void testVariableAsFunctionCallWithGenerics() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/variableAsFunctionCallWithGenerics.kt");
        }

        @Test
        @TestMetadata(value="when.kt")
        public void testWhen() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/when.kt");
        }

        @Test
        @TestMetadata(value="whenCoercedToUnit.kt")
        public void testWhenCoercedToUnit() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenCoercedToUnit.kt");
        }

        @Test
        @TestMetadata(value="whenElse.kt")
        public void testWhenElse() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenElse.kt");
        }

        @Test
        @TestMetadata(value="whenReturn.kt")
        public void testWhenReturn() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenReturn.kt");
        }

        @Test
        @TestMetadata(value="whenReturnUnit.kt")
        public void testWhenReturnUnit() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenReturnUnit.kt");
        }

        @Test
        @TestMetadata(value="whenSmartCastToEnum.kt")
        public void testWhenSmartCastToEnum() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenSmartCastToEnum.kt");
        }

        @Test
        @TestMetadata(value="whenUnusedExpression.kt")
        public void testWhenUnusedExpression() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenUnusedExpression.kt");
        }

        @Test
        @TestMetadata(value="whenWithSubjectVariable.kt")
        public void testWhenWithSubjectVariable() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenWithSubjectVariable.kt");
        }

        @Test
        @TestMetadata(value="whileDoWhile.kt")
        public void testWhileDoWhile() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whileDoWhile.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/expressions/sam")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Sam {
            @Test
            public void testAllFilesPresentInSam() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayAsVarargAfterSamArgument.kt")
            public void testArrayAsVarargAfterSamArgument() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/arrayAsVarargAfterSamArgument.kt");
            }

            @Test
            @TestMetadata(value="genericSamProjectedOut.kt")
            public void testGenericSamProjectedOut() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/genericSamProjectedOut.kt");
            }

            @Test
            @TestMetadata(value="genericSamSmartcast.kt")
            public void testGenericSamSmartcast() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/genericSamSmartcast.kt");
            }

            @Test
            @TestMetadata(value="samByProjectedType.kt")
            public void testSamByProjectedType() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samByProjectedType.kt");
            }

            @Test
            @TestMetadata(value="samConstructors.kt")
            public void testSamConstructors() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samConstructors.kt");
            }

            @Test
            @TestMetadata(value="samConversionInGenericConstructorCall.kt")
            public void testSamConversionInGenericConstructorCall() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samConversionInGenericConstructorCall.kt");
            }

            @Test
            @TestMetadata(value="samConversionToGeneric.kt")
            public void testSamConversionToGeneric() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samConversionToGeneric.kt");
            }

            @Test
            @TestMetadata(value="samConversions.kt")
            public void testSamConversions() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samConversions.kt");
            }

            @Test
            @TestMetadata(value="samConversionsWithSmartCasts.kt")
            public void testSamConversionsWithSmartCasts() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samConversionsWithSmartCasts.kt");
            }

            @Test
            @TestMetadata(value="samOperators.kt")
            public void testSamOperators() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samOperators.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/expressions/funInterface")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FunInterface {
            @Test
            public void testAllFilesPresentInFunInterface() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayAsVarargAfterSamArgument_fi.kt")
            public void testArrayAsVarargAfterSamArgument_fi() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/arrayAsVarargAfterSamArgument_fi.kt");
            }

            @Test
            @TestMetadata(value="basicFunInterfaceConversion.kt")
            public void testBasicFunInterfaceConversion() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/basicFunInterfaceConversion.kt");
            }

            @Test
            @TestMetadata(value="castFromAny.kt")
            public void testCastFromAny() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/castFromAny.kt");
            }

            @Test
            @TestMetadata(value="functionSupertype.kt")
            public void testFunctionSupertype() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/functionSupertype.kt");
            }

            @Test
            @TestMetadata(value="partialSam.kt")
            public void testPartialSam() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/partialSam.kt");
            }

            @Test
            @TestMetadata(value="samConversionInVarargs.kt")
            public void testSamConversionInVarargs() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionInVarargs.kt");
            }

            @Test
            @TestMetadata(value="samConversionInVarargsMixed.kt")
            public void testSamConversionInVarargsMixed() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionInVarargsMixed.kt");
            }

            @Test
            @TestMetadata(value="samConversionOnCallableReference.kt")
            public void testSamConversionOnCallableReference() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionOnCallableReference.kt");
            }

            @Test
            @TestMetadata(value="samConversionsWithSmartCasts.kt")
            public void testSamConversionsWithSmartCasts() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionsWithSmartCasts.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/expressions/floatingPointComparisons")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FloatingPointComparisons {
            @Test
            public void testAllFilesPresentInFloatingPointComparisons() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/floatingPointComparisons"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="comparableWithDoubleOrFloat.kt")
            public void testComparableWithDoubleOrFloat() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/comparableWithDoubleOrFloat.kt");
            }

            @Test
            @TestMetadata(value="eqeqRhsConditionPossiblyAffectingLhs.kt")
            public void testEqeqRhsConditionPossiblyAffectingLhs() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/eqeqRhsConditionPossiblyAffectingLhs.kt");
            }

            @Test
            @TestMetadata(value="floatingPointCompareTo.kt")
            public void testFloatingPointCompareTo() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointCompareTo.kt");
            }

            @Test
            @TestMetadata(value="floatingPointEqeq.kt")
            public void testFloatingPointEqeq() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointEqeq.kt");
            }

            @Test
            @TestMetadata(value="floatingPointEquals.kt")
            public void testFloatingPointEquals() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointEquals.kt");
            }

            @Test
            @TestMetadata(value="floatingPointExcleq.kt")
            public void testFloatingPointExcleq() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointExcleq.kt");
            }

            @Test
            @TestMetadata(value="floatingPointLess.kt")
            public void testFloatingPointLess() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointLess.kt");
            }

            @Test
            @TestMetadata(value="nullableAnyAsIntToDouble.kt")
            public void testNullableAnyAsIntToDouble() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/nullableAnyAsIntToDouble.kt");
            }

            @Test
            @TestMetadata(value="nullableFloatingPointEqeq.kt")
            public void testNullableFloatingPointEqeq() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/nullableFloatingPointEqeq.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithPrimitiveNumericSupertype.kt")
            public void testTypeParameterWithPrimitiveNumericSupertype() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/typeParameterWithPrimitiveNumericSupertype.kt");
            }

            @Test
            @TestMetadata(value="whenByFloatingPoint.kt")
            public void testWhenByFloatingPoint() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/whenByFloatingPoint.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/expressions/callableReferences")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CallableReferences {
            @Test
            @TestMetadata(value="adaptedExtensionFunctions.kt")
            public void testAdaptedExtensionFunctions() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/adaptedExtensionFunctions.kt");
            }

            @Test
            @TestMetadata(value="adaptedWithCoercionToUnit.kt")
            public void testAdaptedWithCoercionToUnit() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/adaptedWithCoercionToUnit.kt");
            }

            @Test
            public void testAllFilesPresentInCallableReferences() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/callableReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="boundInlineAdaptedReference.kt")
            public void testBoundInlineAdaptedReference() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/boundInlineAdaptedReference.kt");
            }

            @Test
            @TestMetadata(value="boundInnerGenericConstructor.kt")
            public void testBoundInnerGenericConstructor() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/boundInnerGenericConstructor.kt");
            }

            @Test
            @TestMetadata(value="caoWithAdaptationForSam.kt")
            public void testCaoWithAdaptationForSam() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/caoWithAdaptationForSam.kt");
            }

            @Test
            @TestMetadata(value="constructorWithAdaptedArguments.kt")
            public void testConstructorWithAdaptedArguments() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/constructorWithAdaptedArguments.kt");
            }

            @Test
            @TestMetadata(value="funWithDefaultParametersAsKCallableStar.kt")
            public void testFunWithDefaultParametersAsKCallableStar() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/funWithDefaultParametersAsKCallableStar.kt");
            }

            @Test
            @TestMetadata(value="genericLocalClassConstructorReference.kt")
            public void testGenericLocalClassConstructorReference() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/genericLocalClassConstructorReference.kt");
            }

            @Test
            @TestMetadata(value="genericMember.kt")
            public void testGenericMember() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/genericMember.kt");
            }

            @Test
            @TestMetadata(value="importedFromObject.kt")
            public void testImportedFromObject() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/importedFromObject.kt");
            }

            @Test
            @TestMetadata(value="kt37131.kt")
            public void testKt37131() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/kt37131.kt");
            }

            @Test
            @TestMetadata(value="kt46069.kt")
            public void testKt46069() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/kt46069.kt");
            }

            @Test
            @TestMetadata(value="suspendConversion.kt")
            public void testSuspendConversion() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/suspendConversion.kt");
            }

            @Test
            @TestMetadata(value="typeArguments.kt")
            public void testTypeArguments() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/typeArguments.kt");
            }

            @Test
            @TestMetadata(value="unboundMemberReferenceWithAdaptedArguments.kt")
            public void testUnboundMemberReferenceWithAdaptedArguments() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/unboundMemberReferenceWithAdaptedArguments.kt");
            }

            @Test
            @TestMetadata(value="varargFunImportedFromObject.kt")
            public void testVarargFunImportedFromObject() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/varargFunImportedFromObject.kt");
            }

            @Test
            @TestMetadata(value="withAdaptationForSam.kt")
            public void testWithAdaptationForSam() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/withAdaptationForSam.kt");
            }

            @Test
            @TestMetadata(value="withAdaptedArguments.kt")
            public void testWithAdaptedArguments() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/withAdaptedArguments.kt");
            }

            @Test
            @TestMetadata(value="withArgumentAdaptationAndReceiver.kt")
            public void testWithArgumentAdaptationAndReceiver() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/withArgumentAdaptationAndReceiver.kt");
            }

            @Test
            @TestMetadata(value="withVarargViewedAsArray.kt")
            public void testWithVarargViewedAsArray() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/withVarargViewedAsArray.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/errors")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Errors {
        @Test
        public void testAllFilesPresentInErrors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/errors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="suppressedNonPublicCall.kt")
        public void testSuppressedNonPublicCall() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/errors/suppressedNonPublicCall.kt");
        }

        @Test
        @TestMetadata(value="unresolvedReference.kt")
        public void testUnresolvedReference() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/errors/unresolvedReference.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/declarations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Declarations {
        @Test
        public void testAllFilesPresentInDeclarations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="catchParameterInTopLevelProperty.kt")
        public void testCatchParameterInTopLevelProperty() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/catchParameterInTopLevelProperty.kt");
        }

        @Test
        @TestMetadata(value="classLevelProperties.kt")
        public void testClassLevelProperties() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/classLevelProperties.kt");
        }

        @Test
        @TestMetadata(value="constValInitializers.kt")
        public void testConstValInitializers() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/constValInitializers.kt");
        }

        @Test
        @TestMetadata(value="defaultArguments.kt")
        public void testDefaultArguments() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/defaultArguments.kt");
        }

        @Test
        @TestMetadata(value="delegatedProperties.kt")
        public void testDelegatedProperties() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/delegatedProperties.kt");
        }

        @Test
        @TestMetadata(value="deprecatedProperty.kt")
        public void testDeprecatedProperty() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/deprecatedProperty.kt");
        }

        @Test
        @TestMetadata(value="extensionProperties.kt")
        public void testExtensionProperties() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/extensionProperties.kt");
        }

        @Test
        @TestMetadata(value="fakeOverrides.kt")
        public void testFakeOverrides() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/fakeOverrides.kt");
        }

        @Test
        @TestMetadata(value="fileWithAnnotations.kt")
        public void testFileWithAnnotations() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/fileWithAnnotations.kt");
        }

        @Test
        @TestMetadata(value="fileWithTypeAliasesOnly.kt")
        public void testFileWithTypeAliasesOnly() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/fileWithTypeAliasesOnly.kt");
        }

        @Test
        @TestMetadata(value="genericDelegatedProperty.kt")
        public void testGenericDelegatedProperty() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/genericDelegatedProperty.kt");
        }

        @Test
        @TestMetadata(value="inlineCollectionOfInlineClass.kt")
        public void testInlineCollectionOfInlineClass() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/inlineCollectionOfInlineClass.kt");
        }

        @Test
        @TestMetadata(value="interfaceProperties.kt")
        public void testInterfaceProperties() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/interfaceProperties.kt");
        }

        @Test
        @TestMetadata(value="kt27005.kt")
        public void testKt27005() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt27005.kt");
        }

        @Test
        @TestMetadata(value="kt29833.kt")
        public void testKt29833() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt29833.kt");
        }

        @Test
        @TestMetadata(value="kt35550.kt")
        public void testKt35550() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt35550.kt");
        }

        @Test
        @TestMetadata(value="kt45308.kt")
        public void testKt45308() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt45308.kt");
        }

        @Test
        @TestMetadata(value="kt47527.kt")
        public void testKt47527() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt47527.kt");
        }

        @Test
        @TestMetadata(value="localClassWithOverrides.kt")
        public void testLocalClassWithOverrides() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/localClassWithOverrides.kt");
        }

        @Test
        @TestMetadata(value="localDelegatedProperties.kt")
        public void testLocalDelegatedProperties() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/localDelegatedProperties.kt");
        }

        @Test
        @TestMetadata(value="localVarInDoWhile.kt")
        public void testLocalVarInDoWhile() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/localVarInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="packageLevelProperties.kt")
        public void testPackageLevelProperties() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/packageLevelProperties.kt");
        }

        @Test
        @TestMetadata(value="primaryCtorDefaultArguments.kt")
        public void testPrimaryCtorDefaultArguments() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/primaryCtorDefaultArguments.kt");
        }

        @Test
        @TestMetadata(value="primaryCtorProperties.kt")
        public void testPrimaryCtorProperties() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/primaryCtorProperties.kt");
        }

        @Test
        @TestMetadata(value="typeAlias.kt")
        public void testTypeAlias() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/typeAlias.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/declarations/provideDelegate")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ProvideDelegate {
            @Test
            public void testAllFilesPresentInProvideDelegate() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/provideDelegate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="differentReceivers.kt")
            public void testDifferentReceivers() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/differentReceivers.kt");
            }

            @Test
            @TestMetadata(value="javaDelegate.kt")
            public void testJavaDelegate() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/javaDelegate.kt");
            }

            @Test
            @TestMetadata(value="local.kt")
            public void testLocal() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/local.kt");
            }

            @Test
            @TestMetadata(value="localDifferentReceivers.kt")
            public void testLocalDifferentReceivers() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/localDifferentReceivers.kt");
            }

            @Test
            @TestMetadata(value="member.kt")
            public void testMember() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/member.kt");
            }

            @Test
            @TestMetadata(value="memberExtension.kt")
            public void testMemberExtension() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/memberExtension.kt");
            }

            @Test
            @TestMetadata(value="topLevel.kt")
            public void testTopLevel() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/topLevel.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/declarations/parameters")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Parameters {
            @Test
            public void testAllFilesPresentInParameters() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/parameters"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="class.kt")
            public void testClass() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/class.kt");
            }

            @Test
            @TestMetadata(value="constructor.kt")
            public void testConstructor() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/constructor.kt");
            }

            @Test
            @TestMetadata(value="dataClassMembers.kt")
            public void testDataClassMembers() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/dataClassMembers.kt");
            }

            @Test
            @TestMetadata(value="defaultPropertyAccessors.kt")
            public void testDefaultPropertyAccessors() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/defaultPropertyAccessors.kt");
            }

            @Test
            @TestMetadata(value="delegatedMembers.kt")
            public void testDelegatedMembers() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/delegatedMembers.kt");
            }

            @Test
            @TestMetadata(value="fun.kt")
            public void testFun() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/fun.kt");
            }

            @Test
            @TestMetadata(value="genericInnerClass.kt")
            public void testGenericInnerClass() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/genericInnerClass.kt");
            }

            @Test
            @TestMetadata(value="lambdas.kt")
            public void testLambdas() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/lambdas.kt");
            }

            @Test
            @TestMetadata(value="localFun.kt")
            public void testLocalFun() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/localFun.kt");
            }

            @Test
            @TestMetadata(value="propertyAccessors.kt")
            public void testPropertyAccessors() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/propertyAccessors.kt");
            }

            @Test
            @TestMetadata(value="typeParameterBeforeBound.kt")
            public void testTypeParameterBeforeBound() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/typeParameterBeforeBound.kt");
            }

            @Test
            @TestMetadata(value="typeParameterBoundedBySubclass.kt")
            public void testTypeParameterBoundedBySubclass() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/typeParameterBoundedBySubclass.kt");
            }

            @Test
            @TestMetadata(value="useNextParamInLambda.kt")
            public void testUseNextParamInLambda() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/useNextParamInLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/declarations/multiplatform")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Multiplatform {
            @Test
            public void testAllFilesPresentInMultiplatform() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="expectClassInherited.kt")
            public void testExpectClassInherited() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/multiplatform/expectClassInherited.kt");
            }

            @Test
            @TestMetadata(value="expectedEnumClass.kt")
            public void testExpectedEnumClass() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/multiplatform/expectedEnumClass.kt");
            }

            @Test
            @TestMetadata(value="expectedSealedClass.kt")
            public void testExpectedSealedClass() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/multiplatform/expectedSealedClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/declarations/contextReceivers")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ContextReceivers {
            @Test
            public void testAllFilesPresentInContextReceivers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/contextReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayAccessCompositeOperators.kt")
            public void testArrayAccessCompositeOperators() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/arrayAccessCompositeOperators.kt");
            }

            @Test
            @TestMetadata(value="arrayAccessOperators.kt")
            public void testArrayAccessOperators() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/arrayAccessOperators.kt");
            }

            @Test
            @TestMetadata(value="class.kt")
            public void testClass() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/class.kt");
            }

            @Test
            @TestMetadata(value="compoundAssignmentOperators.kt")
            public void testCompoundAssignmentOperators() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/compoundAssignmentOperators.kt");
            }

            @Test
            @TestMetadata(value="contextualFunctionConversion.kt")
            public void testContextualFunctionConversion() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextualFunctionConversion.kt");
            }

            @Test
            @TestMetadata(value="contextualInlineCall.kt")
            public void testContextualInlineCall() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextualInlineCall.kt");
            }

            @Test
            @TestMetadata(value="contextualPrimaryConstructorWithParams.kt")
            public void testContextualPrimaryConstructorWithParams() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextualPrimaryConstructorWithParams.kt");
            }

            @Test
            @TestMetadata(value="delegatedPropertiesOperators.kt")
            public void testDelegatedPropertiesOperators() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/delegatedPropertiesOperators.kt");
            }

            @Test
            @TestMetadata(value="function.kt")
            public void testFunction() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/function.kt");
            }

            @Test
            @TestMetadata(value="functionalType.kt")
            public void testFunctionalType() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/functionalType.kt");
            }

            @Test
            @TestMetadata(value="genericOuterClass.kt")
            public void testGenericOuterClass() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/genericOuterClass.kt");
            }

            @Test
            @TestMetadata(value="iteratorOperator.kt")
            public void testIteratorOperator() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/iteratorOperator.kt");
            }

            @Test
            @TestMetadata(value="lazy.kt")
            public void testLazy() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/lazy.kt");
            }

            @Test
            @TestMetadata(value="overloadPriority.kt")
            public void testOverloadPriority() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/overloadPriority.kt");
            }

            @Test
            @TestMetadata(value="overloading.kt")
            public void testOverloading() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/overloading.kt");
            }

            @Test
            @TestMetadata(value="passingLambdaToContextualParam.kt")
            public void testPassingLambdaToContextualParam() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/passingLambdaToContextualParam.kt");
            }

            @Test
            @TestMetadata(value="plusMatrix.kt")
            public void testPlusMatrix() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/plusMatrix.kt");
            }

            @Test
            @TestMetadata(value="property.kt")
            public void testProperty() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/property.kt");
            }

            @Test
            @TestMetadata(value="thisWithCustomLabel.kt")
            public void testThisWithCustomLabel() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/thisWithCustomLabel.kt");
            }

            @Test
            @TestMetadata(value="typeParameterAsContextReceiver.kt")
            public void testTypeParameterAsContextReceiver() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/typeParameterAsContextReceiver.kt");
            }

            @Test
            @TestMetadata(value="unaryOperators.kt")
            public void testUnaryOperators() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/unaryOperators.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP")
            @TestDataPath(value="$PROJECT_ROOT")
            public class FromKEEP {
                @Test
                public void testAllFilesPresentInFromKEEP() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="canvas.kt")
                public void testCanvas() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/canvas.kt");
                }

                @Test
                @TestMetadata(value="compareTo.kt")
                public void testCompareTo() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/compareTo.kt");
                }

                @Test
                @TestMetadata(value="dp.kt")
                public void testDp() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/dp.kt");
                }

                @Test
                @TestMetadata(value="functionalType.kt")
                public void testFunctionalType() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/functionalType.kt");
                }

                @Test
                @TestMetadata(value="monoidSum.kt")
                public void testMonoidSum() throws Exception {
                    IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/monoidSum.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/declarations/annotations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Annotations {
            @Test
            public void testAllFilesPresentInAnnotations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotationOnClassWithInitializer.kt")
            public void testAnnotationOnClassWithInitializer() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/annotationOnClassWithInitializer.kt");
            }

            @Test
            @TestMetadata(value="annotationsInAnnotationArguments.kt")
            public void testAnnotationsInAnnotationArguments() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/annotationsInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata(value="annotationsOnDelegatedMembers.kt")
            public void testAnnotationsOnDelegatedMembers() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/annotationsOnDelegatedMembers.kt");
            }

            @Test
            @TestMetadata(value="annotationsWithDefaultParameterValues.kt")
            public void testAnnotationsWithDefaultParameterValues() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/annotationsWithDefaultParameterValues.kt");
            }

            @Test
            @TestMetadata(value="annotationsWithVarargParameters.kt")
            public void testAnnotationsWithVarargParameters() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/annotationsWithVarargParameters.kt");
            }

            @Test
            @TestMetadata(value="arrayInAnnotationArguments.kt")
            public void testArrayInAnnotationArguments() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/arrayInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata(value="classLiteralInAnnotation.kt")
            public void testClassLiteralInAnnotation() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/classLiteralInAnnotation.kt");
            }

            @Test
            @TestMetadata(value="classesWithAnnotations.kt")
            public void testClassesWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/classesWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="constExpressionsInAnnotationArguments.kt")
            public void testConstExpressionsInAnnotationArguments() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/constExpressionsInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata(value="constructorsWithAnnotations.kt")
            public void testConstructorsWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/constructorsWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="delegateFieldWithAnnotations.kt")
            public void testDelegateFieldWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/delegateFieldWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="delegatedPropertyAccessorsWithAnnotations.kt")
            public void testDelegatedPropertyAccessorsWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/delegatedPropertyAccessorsWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesWithAnnotations.kt")
            public void testEnumEntriesWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/enumEntriesWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="enumsInAnnotationArguments.kt")
            public void testEnumsInAnnotationArguments() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/enumsInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata(value="fieldsWithAnnotations.kt")
            public void testFieldsWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/fieldsWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="fileAnnotations.kt")
            public void testFileAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/fileAnnotations.kt");
            }

            @Test
            @TestMetadata(value="functionsWithAnnotations.kt")
            public void testFunctionsWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/functionsWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="genericAnnotationClasses.kt")
            public void testGenericAnnotationClasses() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/genericAnnotationClasses.kt");
            }

            @Test
            @TestMetadata(value="inheritingDeprecation.kt")
            public void testInheritingDeprecation() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/inheritingDeprecation.kt");
            }

            @Test
            @TestMetadata(value="javaAnnotation.kt")
            public void testJavaAnnotation() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/javaAnnotation.kt");
            }

            @Test
            @TestMetadata(value="javaAnnotationWithSingleArrayArgument.kt")
            public void testJavaAnnotationWithSingleArrayArgument() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/javaAnnotationWithSingleArrayArgument.kt");
            }

            @Test
            @TestMetadata(value="localDelegatedPropertiesWithAnnotations.kt")
            public void testLocalDelegatedPropertiesWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/localDelegatedPropertiesWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="multipleAnnotationsInSquareBrackets.kt")
            public void testMultipleAnnotationsInSquareBrackets() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/multipleAnnotationsInSquareBrackets.kt");
            }

            @Test
            @TestMetadata(value="primaryConstructorParameterWithAnnotations.kt")
            public void testPrimaryConstructorParameterWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/primaryConstructorParameterWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="propertiesWithAnnotations.kt")
            public void testPropertiesWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/propertiesWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="propertyAccessorsFromClassHeaderWithAnnotations.kt")
            public void testPropertyAccessorsFromClassHeaderWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/propertyAccessorsFromClassHeaderWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="propertyAccessorsWithAnnotations.kt")
            public void testPropertyAccessorsWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/propertyAccessorsWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="propertySetterParameterWithAnnotations.kt")
            public void testPropertySetterParameterWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/propertySetterParameterWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="receiverParameterWithAnnotations.kt")
            public void testReceiverParameterWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/receiverParameterWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="spreadOperatorInAnnotationArguments.kt")
            public void testSpreadOperatorInAnnotationArguments() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/spreadOperatorInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata(value="typeAliasesWithAnnotations.kt")
            public void testTypeAliasesWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/typeAliasesWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="typeParametersWithAnnotations.kt")
            public void testTypeParametersWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/typeParametersWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="valueParametersWithAnnotations.kt")
            public void testValueParametersWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/valueParametersWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="varargsInAnnotationArguments.kt")
            public void testVarargsInAnnotationArguments() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/varargsInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata(value="variablesWithAnnotations.kt")
            public void testVariablesWithAnnotations() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/variablesWithAnnotations.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/classes")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Classes {
        @Test
        @TestMetadata(value="47424.kt")
        public void test47424() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/47424.kt");
        }

        @Test
        @TestMetadata(value="abstractMembers.kt")
        public void testAbstractMembers() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/abstractMembers.kt");
        }

        @Test
        public void testAllFilesPresentInClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/classes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="annotationClasses.kt")
        public void testAnnotationClasses() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/annotationClasses.kt");
        }

        @Test
        @TestMetadata(value="argumentReorderingInDelegatingConstructorCall.kt")
        public void testArgumentReorderingInDelegatingConstructorCall() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/argumentReorderingInDelegatingConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="clashingFakeOverrideSignatures.kt")
        public void testClashingFakeOverrideSignatures() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/clashingFakeOverrideSignatures.kt");
        }

        @Test
        @TestMetadata(value="classMembers.kt")
        public void testClassMembers() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/classMembers.kt");
        }

        @Test
        @TestMetadata(value="classes.kt")
        public void testClasses() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/classes.kt");
        }

        @Test
        @TestMetadata(value="cloneable.kt")
        public void testCloneable() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/cloneable.kt");
        }

        @Test
        @TestMetadata(value="companionObject.kt")
        public void testCompanionObject() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/companionObject.kt");
        }

        @Test
        @TestMetadata(value="delegatedGenericImplementation.kt")
        public void testDelegatedGenericImplementation() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/delegatedGenericImplementation.kt");
        }

        @Test
        @TestMetadata(value="delegatedImplementation.kt")
        public void testDelegatedImplementation() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/delegatedImplementation.kt");
        }

        @Test
        @TestMetadata(value="delegatedImplementationOfJavaInterface.kt")
        public void testDelegatedImplementationOfJavaInterface() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/delegatedImplementationOfJavaInterface.kt");
        }

        @Test
        @TestMetadata(value="delegatedImplementationWithExplicitOverride.kt")
        public void testDelegatedImplementationWithExplicitOverride() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/delegatedImplementationWithExplicitOverride.kt");
        }

        @Test
        @TestMetadata(value="delegatingConstructorCallToTypeAliasConstructor.kt")
        public void testDelegatingConstructorCallToTypeAliasConstructor() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/delegatingConstructorCallToTypeAliasConstructor.kt");
        }

        @Test
        @TestMetadata(value="delegatingConstructorCallsInSecondaryConstructors.kt")
        public void testDelegatingConstructorCallsInSecondaryConstructors() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/delegatingConstructorCallsInSecondaryConstructors.kt");
        }

        @Test
        @TestMetadata(value="enum.kt")
        public void testEnum() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/enum.kt");
        }

        @Test
        @TestMetadata(value="enumClassModality.kt")
        public void testEnumClassModality() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/enumClassModality.kt");
        }

        @Test
        @TestMetadata(value="enumWithMultipleCtors.kt")
        public void testEnumWithMultipleCtors() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/enumWithMultipleCtors.kt");
        }

        @Test
        @TestMetadata(value="enumWithSecondaryCtor.kt")
        public void testEnumWithSecondaryCtor() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/enumWithSecondaryCtor.kt");
        }

        @Test
        @TestMetadata(value="fakeOverridesForJavaStaticMembers.kt")
        public void testFakeOverridesForJavaStaticMembers() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/fakeOverridesForJavaStaticMembers.kt");
        }

        @Test
        @TestMetadata(value="implicitNotNullOnDelegatedImplementation.kt")
        public void testImplicitNotNullOnDelegatedImplementation() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/implicitNotNullOnDelegatedImplementation.kt");
        }

        @Test
        @TestMetadata(value="initBlock.kt")
        public void testInitBlock() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/initBlock.kt");
        }

        @Test
        @TestMetadata(value="initVal.kt")
        public void testInitVal() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/initVal.kt");
        }

        @Test
        @TestMetadata(value="initValInLambda.kt")
        public void testInitValInLambda() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/initValInLambda.kt");
        }

        @Test
        @TestMetadata(value="initVar.kt")
        public void testInitVar() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/initVar.kt");
        }

        @Test
        @TestMetadata(value="inlineClass.kt")
        public void testInlineClass() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/inlineClass.kt");
        }

        @Test
        @TestMetadata(value="inlineClassSyntheticMethods.kt")
        public void testInlineClassSyntheticMethods() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/inlineClassSyntheticMethods.kt");
        }

        @Test
        @TestMetadata(value="innerClass.kt")
        public void testInnerClass() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/innerClass.kt");
        }

        @Test
        @TestMetadata(value="innerClassWithDelegatingConstructor.kt")
        public void testInnerClassWithDelegatingConstructor() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/innerClassWithDelegatingConstructor.kt");
        }

        @Test
        @TestMetadata(value="kt19306.kt")
        public void testKt19306() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/kt19306.kt");
        }

        @Test
        @TestMetadata(value="kt43217.kt")
        public void testKt43217() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/kt43217.kt");
        }

        @Test
        @TestMetadata(value="kt44013.kt")
        public void testKt44013() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/kt44013.kt");
        }

        @Test
        @TestMetadata(value="kt45853.kt")
        public void testKt45853() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/kt45853.kt");
        }

        @Test
        @TestMetadata(value="kt45934.kt")
        public void testKt45934() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/kt45934.kt");
        }

        @Test
        @TestMetadata(value="localClasses.kt")
        public void testLocalClasses() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/localClasses.kt");
        }

        @Test
        @TestMetadata(value="objectLiteralExpressions.kt")
        public void testObjectLiteralExpressions() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/objectLiteralExpressions.kt");
        }

        @Test
        @TestMetadata(value="objectWithInitializers.kt")
        public void testObjectWithInitializers() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/objectWithInitializers.kt");
        }

        @Test
        @TestMetadata(value="outerClassAccess.kt")
        public void testOuterClassAccess() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/outerClassAccess.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructor.kt")
        public void testPrimaryConstructor() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/primaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructorWithSuperConstructorCall.kt")
        public void testPrimaryConstructorWithSuperConstructorCall() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/primaryConstructorWithSuperConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="qualifiedSuperCalls.kt")
        public void testQualifiedSuperCalls() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/qualifiedSuperCalls.kt");
        }

        @Test
        @TestMetadata(value="sealedClasses.kt")
        public void testSealedClasses() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/sealedClasses.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructorWithInitializersFromClassBody.kt")
        public void testSecondaryConstructorWithInitializersFromClassBody() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/secondaryConstructorWithInitializersFromClassBody.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructors.kt")
        public void testSecondaryConstructors() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/secondaryConstructors.kt");
        }

        @Test
        @TestMetadata(value="superCalls.kt")
        public void testSuperCalls() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/superCalls.kt");
        }

        @Test
        @TestMetadata(value="superCallsComposed.kt")
        public void testSuperCallsComposed() throws Exception {
            IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/superCallsComposed.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/classes/dataClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DataClasses {
            @Test
            public void testAllFilesPresentInDataClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/classes/dataClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="dataClassWithArrayMembers.kt")
            public void testDataClassWithArrayMembers() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/dataClassWithArrayMembers.kt");
            }

            @Test
            @TestMetadata(value="dataClasses.kt")
            public void testDataClasses() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/dataClasses.kt");
            }

            @Test
            @TestMetadata(value="dataClassesGeneric.kt")
            public void testDataClassesGeneric() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/dataClassesGeneric.kt");
            }

            @Test
            @TestMetadata(value="kt31649.kt")
            public void testKt31649() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/kt31649.kt");
            }

            @Test
            @TestMetadata(value="kt49936.kt")
            public void testKt49936() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/kt49936.kt");
            }

            @Test
            @TestMetadata(value="lambdaInDataClassDefaultParameter.kt")
            public void testLambdaInDataClassDefaultParameter() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/lambdaInDataClassDefaultParameter.kt");
            }

            @Test
            @TestMetadata(value="openDataClass.kt")
            public void testOpenDataClass() throws Exception {
                IrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/openDataClass.kt");
            }
        }
    }
}

