/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.lower.BridgesConstruction;
import org.jetbrains.kotlin.ir.backend.js.lower.JsNonStableSignature;
import org.jetbrains.kotlin.ir.backend.js.lower.JsSignature;
import org.jetbrains.kotlin.ir.backend.js.lower.JsStableNameSignature;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.TypeTranformerKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsBridgesConstruction;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BridgesConstruction;", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "context", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getBridgeOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "bridge", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getFunctionSignature", "Lorg/jetbrains/kotlin/ir/backend/js/lower/JsSignature;", "function", "getJsInlinedClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.js"})
public final class JsBridgesConstruction
extends BridgesConstruction<JsIrBackendContext> {
    public JsBridgesConstruction(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((JsCommonBackendContext)context2);
    }

    private final IrClass getJsInlinedClass(IrType $this$getJsInlinedClass) {
        return ((JsIrBackendContext)this.getContext()).getInlineClassesUtils().getInlinedClass($this$getJsInlinedClass);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsSignature getFunctionSignature(@NotNull IrSimpleFunction function2) {
        JsSignature jsSignature;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (MiscKt.hasStableJsName(function2, (JsIrBackendContext)this.getContext())) {
            jsSignature = new JsStableNameSignature(AnnotationUtilsKt.getJsNameOrKotlinName(function2));
        } else {
            void it;
            IrType irType;
            Collection<IrType> collection;
            IrType $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = function2.getValueParameters();
            IrAnnotationContainer irAnnotationContainer = function2.getExtensionReceiverParameter();
            IrType irType2 = irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? TypeTranformerKt.eraseGenerics((IrType)irAnnotationContainer, ((JsIrBackendContext)this.getContext()).getIrBuiltIns()) : null;
            Name name2 = function2.getName();
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it2;
                Object item$iv$iv = iterator2.next();
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TypeTranformerKt.eraseGenerics(it2.getType(), ((JsIrBackendContext)this.getContext()).getIrBuiltIns()));
            }
            collection = (List)destination$iv$iv;
            $this$mapTo$iv$iv = irType = function2.getReturnType();
            boolean bl = false;
            boolean bl2 = this.getJsInlinedClass((IrType)it) != null || IrTypePredicatesKt.isUnit((IrType)it);
            object = bl2 ? irType : null;
            IrType irType3 = object != null ? TypeTranformerKt.eraseGenerics((IrType)object, ((JsIrBackendContext)this.getContext()).getIrBuiltIns()) : null;
            Collection<IrType> collection2 = collection;
            IrType irType4 = irType2;
            Name name3 = name2;
            jsSignature = new JsNonStableSignature(name3, irType4, (List<? extends IrType>)collection2, irType3);
        }
        return jsSignature;
    }

    @Override
    @NotNull
    public IrDeclarationOrigin getBridgeOrigin(@NotNull IrSimpleFunction bridge) {
        Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
        return MiscKt.hasStableJsName(bridge, (JsIrBackendContext)this.getContext()) ? (IrDeclarationOrigin)JsLoweredDeclarationOrigin.BRIDGE_WITH_STABLE_NAME.INSTANCE : (IrDeclarationOrigin)JsLoweredDeclarationOrigin.BRIDGE_WITHOUT_STABLE_NAME.INSTANCE;
    }
}

