/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.lower.JsInteropFunctionsLoweringKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0007CDEFGHIB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00162\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0,2\b\u0010.\u001a\u0004\u0018\u00010-H\u0002J\u0014\u0010/\u001a\u00020\u00162\n\u00100\u001a\u000601R\u00020\u0000H\u0002J\u001c\u00102\u001a\u00020\u00162\n\u00100\u001a\u000601R\u00020\u00002\u0006\u00103\u001a\u00020\u0016H\u0002J\u0014\u00104\u001a\u00020\u00162\n\u00100\u001a\u000601R\u00020\u0000H\u0002J\u0014\u00105\u001a\u00020\u00162\n\u00100\u001a\u000601R\u00020\u0000H\u0002J\u0016\u00106\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010,2\u0006\u0010)\u001a\u00020\u0016J\u0016\u00107\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010,2\u0006\u0010)\u001a\u00020\u0016J\u0018\u00108\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010,2\u0006\u00109\u001a\u00020\fH\u0016J\u001c\u0010:\u001a\u00020;*\u0004\u0018\u00010-2\u0006\u0010<\u001a\u00020;2\u0006\u0010'\u001a\u00020=J\u0016\u0010>\u001a\u0004\u0018\u00010-*\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0016\u0010B\u001a\u0004\u0018\u00010-*\u00020?2\u0006\u0010@\u001a\u00020AH\u0002R\u0015\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "adapters", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols$JsInteropAdapters;", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getAdapters", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols$JsInteropAdapters;", "additionalDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getAdditionalDeclarations", "()Ljava/util/List;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "closureCallExports", "", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "currentParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "getCurrentParent", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "setCurrentParent", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;)V", "jsClosureCallers", "jsToKotlinClosures", "kotlinClosureToJsConverters", "symbols", "getSymbols", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "createAdapterFunctionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "function", "functionToCall", "valueParametersAdapters", "", "Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$InteropTypeAdapter;", "resultAdapter", "createJsClosureCaller", "info", "Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$FunctionTypeInfo;", "createJsToKotlinClosureConverter", "jsClosureCaller", "createKotlinClosureCaller", "createKotlinToJsClosureConvertor", "transformExportFunction", "transformExternalFunction", "transformFlat", "declaration", "adaptIfNeeded", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "jsToKotlinAdapterIfNeeded", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isReturn", "", "kotlinToJsAdapterIfNeeded", "FunctionBasedAdapter", "FunctionTypeInfo", "InteropTypeAdapter", "KOTLIN_WASM_CLOSURE_FOR_JS_CLOSURE", "NullOrAdapter", "ReceivingKotlinObjectFromJsAdapter", "SendKotlinObjectToJsAdapter", "backend.wasm"})
public final class JsInteropFunctionsLowering
implements DeclarationTransformer {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final WasmSymbols symbols;
    @NotNull
    private final WasmSymbols.JsInteropAdapters adapters;
    @NotNull
    private final Map<IrSimpleType, IrSimpleFunction> closureCallExports;
    @NotNull
    private final Map<IrSimpleType, IrSimpleFunction> kotlinClosureToJsConverters;
    @NotNull
    private final Map<IrSimpleType, IrSimpleFunction> jsClosureCallers;
    @NotNull
    private final Map<IrSimpleType, IrSimpleFunction> jsToKotlinClosures;
    @NotNull
    private final List<IrDeclaration> additionalDeclarations;
    public IrDeclarationParent currentParent;

    public JsInteropFunctionsLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.builtIns = this.context.getIrBuiltIns();
        this.symbols = this.context.getWasmSymbols();
        this.adapters = this.symbols.getJsInteropAdapters();
        this.closureCallExports = new LinkedHashMap();
        this.kotlinClosureToJsConverters = new LinkedHashMap();
        this.jsClosureCallers = new LinkedHashMap();
        this.jsToKotlinClosures = new LinkedHashMap();
        this.additionalDeclarations = new ArrayList();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final WasmSymbols getSymbols() {
        return this.symbols;
    }

    @NotNull
    public final WasmSymbols.JsInteropAdapters getAdapters() {
        return this.adapters;
    }

    @NotNull
    public final List<IrDeclaration> getAdditionalDeclarations() {
        return this.additionalDeclarations;
    }

    @NotNull
    public final IrDeclarationParent getCurrentParent() {
        IrDeclarationParent irDeclarationParent = this.currentParent;
        if (irDeclarationParent != null) {
            return irDeclarationParent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentParent");
        return null;
    }

    public final void setCurrentParent(@NotNull IrDeclarationParent irDeclarationParent) {
        Intrinsics.checkNotNullParameter((Object)irDeclarationParent, (String)"<set-?>");
        this.currentParent = irDeclarationParent;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (IrFakeOverrideUtilsKt.isFakeOverride(declaration2)) {
            return null;
        }
        if (!(declaration2 instanceof IrSimpleFunction)) {
            return null;
        }
        boolean isExported = DeclarationGeneratorKt.isExported((IrFunction)declaration2);
        boolean isExternal = ((IrSimpleFunction)declaration2).isExternal();
        if (IrSimpleFunctionKt.isPropertyAccessor((IrFunction)declaration2)) {
            return null;
        }
        if (!(declaration2.getParent() instanceof IrPackageFragment)) {
            return null;
        }
        if (!isExported && !isExternal) {
            return null;
        }
        if (!(!isExported || !isExternal)) {
            boolean $i$a$-check-JsInteropFunctionsLowering$transformFlat$32 = false;
            String $i$a$-check-JsInteropFunctionsLowering$transformFlat$32 = "Exported external declarations are not supported: " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)declaration2);
            throw new IllegalStateException($i$a$-check-JsInteropFunctionsLowering$transformFlat$32.toString());
        }
        if (!(!(declaration2.getParent() instanceof IrClass))) {
            boolean bl = false;
            String string2 = "Interop members are not supported:  " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)declaration2);
            throw new IllegalStateException(string2.toString());
        }
        this.additionalDeclarations.clear();
        this.setCurrentParent(declaration2.getParent());
        List<Object> newDeclarations = isExternal ? this.transformExternalFunction((IrSimpleFunction)declaration2) : this.transformExportFunction((IrSimpleFunction)declaration2);
        List<Object> list2 = newDeclarations;
        if (list2 == null) {
            list2 = CollectionsKt.listOf((Object)declaration2);
        }
        return CollectionsKt.plus((Collection)list2, (Iterable)this.additionalDeclarations);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<IrDeclaration> transformExternalFunction(@NotNull IrSimpleFunction function2) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Iterable $this$any$iv = function2.getValueParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv2;
                    boolean bl2 = false;
                    if (!(it.getDefaultValue() != null)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        Iterable $this$map$iv = function2.getValueParameters();
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(this.kotlinToJsAdapterIfNeeded(it.getType(), false));
        }
        List valueParametersAdapters = (List)destination$iv$iv;
        InteropTypeAdapter resultAdapter = this.jsToKotlinAdapterIfNeeded(function2.getReturnType(), true);
        if (resultAdapter == null) {
            boolean bl4;
            block14: {
                Iterable $this$all$iv = valueParametersAdapters;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl4 = true;
                } else {
                    for (Object element$iv3 : $this$all$iv) {
                        InteropTypeAdapter it = (InteropTypeAdapter)element$iv3;
                        boolean bl5 = false;
                        if (it == null) continue;
                        bl4 = false;
                        break block14;
                    }
                    bl4 = true;
                }
            }
            if (bl4) {
                return null;
            }
        }
        IrFactory irFactory = this.context.getIrFactory();
        IrDeclarationParent irDeclarationParent = function2.getParent();
        Name name2 = Name.identifier(function2.getName().asStringStripSpecialMarkers() + "__externalAdapter");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(function.name\u2026() + \"__externalAdapter\")");
        IrSimpleFunction newFun = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createStaticFunctionWithReceivers$default(irFactory, irDeclarationParent, name2, function2, null, null, null, null, false, false, null, 1016, null);
        Iterable $this$forEachIndexed$iv = function2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void newParameter;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter bl3 = (IrValueParameter)item$iv;
            int index2 = n;
            boolean bl6 = false;
            InteropTypeAdapter adapter = (InteropTypeAdapter)valueParametersAdapters.get(index2);
            if (adapter == null) continue;
            newParameter.setType(adapter.getToType());
        }
        InteropTypeAdapter interopTypeAdapter = resultAdapter;
        if (interopTypeAdapter != null) {
            InteropTypeAdapter it = interopTypeAdapter;
            boolean bl7 = false;
            function2.setReturnType(resultAdapter.getFromType());
        }
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)newFun.getSymbol(), 0, 0, 6, null);
        newFun.setBody(this.createAdapterFunctionBody(builder2, newFun, function2, valueParametersAdapters, resultAdapter));
        newFun.setAnnotations(CollectionsKt.emptyList());
        this.context.getMapping().getWasmJsInteropFunctionToWrapper().set((IrSimpleFunction)((IrDeclaration)function2), newFun);
        Object[] objectArray = new IrSimpleFunction[]{function2, newFun};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<IrDeclaration> transformExportFunction(@NotNull IrSimpleFunction function2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void it;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Iterable $this$map$iv = function2.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this.jsToKotlinAdapterIfNeeded(it2.getType(), false));
        }
        List valueParametersAdapters = (List)destination$iv$iv;
        InteropTypeAdapter resultAdapter = this.kotlinToJsAdapterIfNeeded(function2.getReturnType(), true);
        if (resultAdapter == null) {
            boolean bl;
            block10: {
                Iterable $this$all$iv = valueParametersAdapters;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        InteropTypeAdapter it3 = (InteropTypeAdapter)element$iv;
                        boolean bl2 = false;
                        if (it3 == null) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return null;
            }
        }
        IrFactory irFactory = this.context.getIrFactory();
        IrDeclarationParent irDeclarationParent = function2.getParent();
        Name name2 = Name.identifier(function2.getName().asStringStripSpecialMarkers() + "__JsExportAdapter");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(function.name\u2026() + \"__JsExportAdapter\")");
        IrSimpleFunction newFun = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createStaticFunctionWithReceivers$default(irFactory, irDeclarationParent, name2, function2, null, null, null, null, false, false, null, 1016, null);
        Iterable $this$forEachIndexed$iv = newFun.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void newParameter;
            int it2;
            if ((it2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter bl = (IrValueParameter)item$iv;
            int index2 = it2;
            boolean bl3 = false;
            InteropTypeAdapter adapter = (InteropTypeAdapter)valueParametersAdapters.get(index2);
            if (adapter == null) continue;
            newParameter.setType(adapter.getFromType());
        }
        InteropTypeAdapter interopTypeAdapter = resultAdapter;
        if (interopTypeAdapter != null) {
            InteropTypeAdapter it4 = interopTypeAdapter;
            boolean bl = false;
            newFun.setReturnType(resultAdapter.getToType());
        }
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)newFun.getSymbol(), 0, 0, 6, null);
        newFun.setBody(this.createAdapterFunctionBody(builder2, newFun, function2, valueParametersAdapters, resultAdapter));
        Object it4 = ExpressionHelpersKt.irCallConstructor(builder2, this.context.getWasmSymbols().getJsNameConstructor(), CollectionsKt.emptyList());
        IrConstructorCall bl = it4;
        Collection collection = newFun.getAnnotations();
        object = newFun;
        boolean $i$a$-also-JsInteropFunctionsLowering$transformExportFunction$52 = false;
        IrBuilderWithScope irBuilderWithScope = builder2;
        String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(function2).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"function.getJsNameOrKotlinName().identifier");
        it.putValueArgument(0, ExpressionHelpersKt.irString(irBuilderWithScope, string2));
        Unit unit2 = Unit.INSTANCE;
        object.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)it4));
        it4 = function2.getAnnotations();
        object = function2;
        boolean $i$f$filter = false;
        void $i$a$-also-JsInteropFunctionsLowering$transformExportFunction$52 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrConstructorCall it5 = (IrConstructorCall)element$iv$iv;
            boolean bl4 = false;
            if (!(!Intrinsics.areEqual((Object)it5.getSymbol(), (Object)this.context.getWasmSymbols().getJsExportConstructor()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        object.setAnnotations((List)destination$iv$iv2);
        Object[] objectArray = new IrSimpleFunction[]{function2, newFun};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final IrBlockBody createAdapterFunctionBody(DeclarationIrBuilder builder2, IrSimpleFunction function2, IrSimpleFunction functionToCall, List<? extends InteropTypeAdapter> valueParametersAdapters, InteropTypeAdapter resultAdapter) {
        void call2;
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = builder2;
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void $this$createAdapterFunctionBody_u24lambda_u2d14 = this_$iv$iv;
        boolean bl = false;
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createAdapterFunctionBody_u24lambda_u2d14, functionToCall);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createAdapterFunctionBody_u24lambda_u2d14;
        void var16_16 = $this$createAdapterFunctionBody_u24lambda_u2d14;
        boolean bl2 = false;
        Iterator<IrValueParameter> iterator2 = function2.getValueParameters().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            IrValueParameter valueParameter2 = iterator2.next();
            IrGetValueImpl get2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createAdapterFunctionBody_u24lambda_u2d14, valueParameter2);
            call2.putValueArgument(index2, this.adaptIfNeeded(valueParametersAdapters.get(index2), get2, builder2));
        }
        IrExpression irExpression = this.adaptIfNeeded(resultAdapter, (IrExpression)call2, builder2);
        var16_16.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irExpression));
        return this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final InteropTypeAdapter kotlinToJsAdapterIfNeeded(IrType $this$kotlinToJsAdapterIfNeeded, boolean isReturn) {
        if (isReturn && Intrinsics.areEqual((Object)$this$kotlinToJsAdapterIfNeeded, (Object)this.builtIns.getUnitType())) {
            return null;
        }
        IrType irType = $this$kotlinToJsAdapterIfNeeded;
        if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getStringType())) {
            return new FunctionBasedAdapter((IrSimpleFunction)this.adapters.getKotlinToJsStringAdapter().getOwner());
        }
        if (Intrinsics.areEqual((Object)irType, (Object)IrTypesKt.makeNullable(this.builtIns.getStringType()))) {
            return new NullOrAdapter(new FunctionBasedAdapter((IrSimpleFunction)this.adapters.getKotlinToJsStringAdapter().getOwner()));
        }
        if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getBooleanType())) {
            return new FunctionBasedAdapter((IrSimpleFunction)this.adapters.getKotlinToJsBooleanAdapter().getOwner());
        }
        if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getAnyType())) {
            return new FunctionBasedAdapter((IrSimpleFunction)this.adapters.getKotlinToJsAnyAdapter().getOwner());
        }
        if (((((((Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getByteType()) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getShortType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getCharType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getIntType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getLongType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getFloatType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getDoubleType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.context.getWasmSymbols().getVoidType())) {
            return null;
        }
        if (TypeTransformerKt.isExternalType($this$kotlinToJsAdapterIfNeeded)) {
            return null;
        }
        if (TypeTransformerKt.isBuiltInWasmRefType($this$kotlinToJsAdapterIfNeeded)) {
            return null;
        }
        if ($this$kotlinToJsAdapterIfNeeded instanceof IrSimpleType && IrTypeUtilsKt.isFunction($this$kotlinToJsAdapterIfNeeded)) {
            Object object;
            void $this$getOrPut$iv;
            void $this$getOrPut$iv2;
            FunctionTypeInfo functionTypeInfo = new FunctionTypeInfo((IrSimpleType)$this$kotlinToJsAdapterIfNeeded, true);
            Map<IrSimpleType, IrSimpleFunction> map = this.closureCallExports;
            Object key$iv = $this$kotlinToJsAdapterIfNeeded;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv2.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                IrSimpleFunction answer$iv = this.createKotlinClosureCaller(functionTypeInfo);
                $this$getOrPut$iv2.put(key$iv, answer$iv);
            }
            key$iv = this.kotlinClosureToJsConverters;
            IrType key$iv2 = $this$kotlinToJsAdapterIfNeeded;
            boolean $i$f$getOrPut2 = false;
            Object value$iv2 = $this$getOrPut$iv.get(key$iv2);
            if (value$iv2 == null) {
                boolean bl = false;
                IrSimpleFunction answer$iv = this.createKotlinToJsClosureConvertor(functionTypeInfo);
                $this$getOrPut$iv.put(key$iv2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv2;
            }
            IrSimpleFunction kotlinToJsClosureConvertor = (IrSimpleFunction)object;
            return new FunctionBasedAdapter(kotlinToJsClosureConvertor);
        }
        return new SendKotlinObjectToJsAdapter($this$kotlinToJsAdapterIfNeeded);
    }

    /*
     * WARNING - void declaration
     */
    private final InteropTypeAdapter jsToKotlinAdapterIfNeeded(IrType $this$jsToKotlinAdapterIfNeeded, boolean isReturn) {
        if (isReturn && Intrinsics.areEqual((Object)$this$jsToKotlinAdapterIfNeeded, (Object)this.builtIns.getUnitType())) {
            return null;
        }
        IrType irType = $this$jsToKotlinAdapterIfNeeded;
        if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getStringType())) {
            return new FunctionBasedAdapter((IrSimpleFunction)this.adapters.getJsToKotlinStringAdapter().getOwner());
        }
        if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getAnyType())) {
            return new FunctionBasedAdapter((IrSimpleFunction)this.adapters.getJsToKotlinAnyAdapter().getOwner());
        }
        if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getByteType())) {
            return new FunctionBasedAdapter((IrSimpleFunction)this.adapters.getJsToKotlinByteAdapter().getOwner());
        }
        if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getShortType())) {
            return new FunctionBasedAdapter((IrSimpleFunction)this.adapters.getJsToKotlinShortAdapter().getOwner());
        }
        if (Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getCharType())) {
            return new FunctionBasedAdapter((IrSimpleFunction)this.adapters.getJsToKotlinCharAdapter().getOwner());
        }
        if (((((Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getBooleanType()) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getIntType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getLongType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getFloatType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.builtIns.getDoubleType())) ? true : Intrinsics.areEqual((Object)irType, (Object)this.context.getWasmSymbols().getVoidType())) {
            return null;
        }
        if (TypeTransformerKt.isExternalType($this$jsToKotlinAdapterIfNeeded)) {
            return null;
        }
        if (TypeTransformerKt.isBuiltInWasmRefType($this$jsToKotlinAdapterIfNeeded)) {
            return null;
        }
        if ($this$jsToKotlinAdapterIfNeeded instanceof IrSimpleType && IrTypeUtilsKt.isFunction($this$jsToKotlinAdapterIfNeeded)) {
            Object object;
            void $this$getOrPut$iv;
            Object object2;
            void $this$getOrPut$iv2;
            FunctionTypeInfo functionTypeInfo = new FunctionTypeInfo((IrSimpleType)$this$jsToKotlinAdapterIfNeeded, false);
            Map<IrSimpleType, IrSimpleFunction> map = this.jsClosureCallers;
            Object key$iv = $this$jsToKotlinAdapterIfNeeded;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv2.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                IrSimpleFunction answer$iv = this.createJsClosureCaller(functionTypeInfo);
                $this$getOrPut$iv2.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            IrSimpleFunction jsClosureCaller = (IrSimpleFunction)object2;
            key$iv = this.jsToKotlinClosures;
            IrType key$iv2 = $this$jsToKotlinAdapterIfNeeded;
            boolean $i$f$getOrPut2 = false;
            Object value$iv2 = $this$getOrPut$iv.get(key$iv2);
            if (value$iv2 == null) {
                boolean bl = false;
                IrSimpleFunction answer$iv = this.createJsToKotlinClosureConverter(functionTypeInfo, jsClosureCaller);
                $this$getOrPut$iv.put(key$iv2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv2;
            }
            IrSimpleFunction jsToKotlinClosure = (IrSimpleFunction)object;
            return new FunctionBasedAdapter(jsToKotlinClosure);
        }
        return new ReceivingKotlinObjectFromJsAdapter($this$jsToKotlinAdapterIfNeeded);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createKotlinClosureCaller(FunctionTypeInfo info) {
        void $this$createKotlinClosureCaller_u24lambda_u2d25;
        IrCall irCall;
        void this_$iv$iv;
        IrValueParameter irValueParameter;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createKotlinClosureCaller_u24lambda_u2d19 = $this$buildFun_u24lambda_u2d16$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier("__callFunction_" + info.getHashString());
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"__callFunction_${info.hashString}\")");
        $this$createKotlinClosureCaller_u24lambda_u2d19.setName(name2);
        $this$createKotlinClosureCaller_u24lambda_u2d19.setReturnType(info.getAdaptedResultType());
        IrSimpleFunction result2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
        result2.setParent(this.getCurrentParent());
        IrFunction $this$addValueParameter$iv = result2;
        boolean $i$f$addValueParameter = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv = new IrValueParameterBuilder();
        boolean bl3 = false;
        IrValueParameterBuilder $this$createKotlinClosureCaller_u24lambda_u2d20 = $this$addValueParameter_u24lambda_u2d28$iv;
        boolean bl4 = false;
        Name name3 = Name.identifier("f");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(\"f\")");
        $this$createKotlinClosureCaller_u24lambda_u2d20.setName(name3);
        $this$createKotlinClosureCaller_u24lambda_u2d20.setType(this.context.getWasmSymbols().getWasmDataRefType());
        if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2d28$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
        }
        IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv, $this$addValueParameter$iv);
        boolean bl5 = false;
        $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
        int count = 0;
        Iterable $this$forEach$iv = info.getAdaptedParameterTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrType type2 = (IrType)element$iv;
            boolean bl6 = false;
            IrFunction $this$addValueParameter$iv2 = result2;
            boolean $i$f$addValueParameter2 = false;
            IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv2 = new IrValueParameterBuilder();
            $i$a$-run-DeclarationBuildersKt$addValueParameter$1$iv = false;
            IrValueParameterBuilder $this$createKotlinClosureCaller_u24lambda_u2d22_u24lambda_u2d21 = $this$addValueParameter_u24lambda_u2d28$iv2;
            boolean bl7 = false;
            int n = count;
            count = n + 1;
            Name name4 = Name.identifier("" + 'p' + n);
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(\"p\" + count++.toString())");
            $this$createKotlinClosureCaller_u24lambda_u2d22_u24lambda_u2d21.setName(name4);
            $this$createKotlinClosureCaller_u24lambda_u2d22_u24lambda_u2d21.setType(type2);
            if ($this$addValueParameter_u24lambda_u2d28$iv2.getIndex() == -1) {
                $this$addValueParameter_u24lambda_u2d28$iv2.setIndex($this$addValueParameter$iv2.getValueParameters().size());
            }
            IrValueParameter irValueParameter2 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv2.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv2, $this$addValueParameter$iv2);
            IrValueParameter valueParameter$iv2 = irValueParameter2;
            $i$a$-also-DeclarationBuildersKt$addValueParameter$1$1$iv = false;
            $this$addValueParameter$iv2.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv2.getValueParameters(), (Object)valueParameter$iv2));
        }
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)result2.getSymbol(), 0, 0, 6, null);
        IrBuilderWithScope $this$irBlockBody_u24default$iv = builder2;
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder bl6 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void $i$f$addValueParameter2 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction = result2;
        boolean bl8 = false;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(info.getFunctionType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions((IrClass)irClassSymbol.getOwner());
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl9 = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)Name.identifier("invoke"))) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction invokeFun = single$iv;
        IrCall call2 = irCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)$this$createKotlinClosureCaller_u24lambda_u2d25, invokeFun.getSymbol(), info.getOriginalResultType(), 0, 0, null, 28, null);
        boolean bl10 = false;
        IrValueParameter irValueParameter3 = invokeFun.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter3);
        call2.setDispatchReceiver(new ReceivingKotlinObjectFromJsAdapter(irValueParameter3.getType()).adapt(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createKotlinClosureCaller_u24lambda_u2d25, result2.getValueParameters().get(0)), builder2));
        int n = info.getAdaptedParameterTypes().size();
        for (int i = 0; i < n; ++i) {
            call2.putValueArgument(i, this.adaptIfNeeded(info.getParametersAdapters().get(i), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createKotlinClosureCaller_u24lambda_u2d25, result2.getValueParameters().get(i + 1)), builder2));
        }
        IrCall callInvoke = irCall;
        $this$createKotlinClosureCaller_u24lambda_u2d25.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$createKotlinClosureCaller_u24lambda_u2d25, this.adaptIfNeeded(info.getResultAdapter(), callInvoke, builder2)));
        irSimpleFunction.setBody(this_$iv$iv.doBuild());
        result2.setAnnotations(CollectionsKt.plus((Collection)result2.getAnnotations(), (Object)ExpressionHelpersKt.irCallConstructor(builder2, this.context.getWasmSymbols().getJsExportConstructor(), CollectionsKt.emptyList())));
        ((Collection)this.additionalDeclarations).add(result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createKotlinToJsClosureConvertor(FunctionTypeInfo info) {
        void it;
        Object object;
        IrValueParameter irValueParameter;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createKotlinToJsClosureConvertor_u24lambda_u2d26 = $this$buildFun_u24lambda_u2d16$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier("__convertKotlinClosureToJsClosure_" + info.getHashString());
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"__convertKot\u2026sure_${info.hashString}\")");
        $this$createKotlinToJsClosureConvertor_u24lambda_u2d26.setName(name2);
        $this$createKotlinToJsClosureConvertor_u24lambda_u2d26.setReturnType(this.context.getWasmSymbols().getExternalInterfaceType());
        IrSimpleFunction result2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
        result2.setParent(this.getCurrentParent());
        IrFunction $this$addValueParameter$iv = result2;
        boolean $i$f$addValueParameter = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv = new IrValueParameterBuilder();
        boolean bl3 = false;
        IrValueParameterBuilder $this$createKotlinToJsClosureConvertor_u24lambda_u2d27 = $this$addValueParameter_u24lambda_u2d28$iv;
        boolean bl4 = false;
        Name name3 = Name.identifier("f");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(\"f\")");
        $this$createKotlinToJsClosureConvertor_u24lambda_u2d27.setName(name3);
        $this$createKotlinToJsClosureConvertor_u24lambda_u2d27.setType(this.context.getWasmSymbols().getWasmDataRefType());
        if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2d28$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
        }
        IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv, $this$addValueParameter$iv);
        boolean bl5 = false;
        $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)result2.getSymbol(), 0, 0, 6, null);
        int arity = info.getParametersAdapters().size();
        Object $this$createKotlinToJsClosureConvertor_u24lambda_u2d28 = object = new StringBuilder();
        boolean bl6 = false;
        ((StringBuilder)$this$createKotlinToJsClosureConvertor_u24lambda_u2d28).append("(f) => (");
        JsInteropFunctionsLoweringKt.appendParameterList$default((StringBuilder)$this$createKotlinToJsClosureConvertor_u24lambda_u2d28, arity, null, false, 6, null);
        ((StringBuilder)$this$createKotlinToJsClosureConvertor_u24lambda_u2d28).append(") => wasmInstance.exports.__callFunction_");
        ((StringBuilder)$this$createKotlinToJsClosureConvertor_u24lambda_u2d28).append(info.getHashString());
        ((StringBuilder)$this$createKotlinToJsClosureConvertor_u24lambda_u2d28).append("(f, ");
        JsInteropFunctionsLoweringKt.appendParameterList$default((StringBuilder)$this$createKotlinToJsClosureConvertor_u24lambda_u2d28, arity, null, false, 6, null);
        ((StringBuilder)$this$createKotlinToJsClosureConvertor_u24lambda_u2d28).append(")");
        String string2 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String jsCode2 = string2;
        $this$createKotlinToJsClosureConvertor_u24lambda_u2d28 = object = ExpressionHelpersKt.irCallConstructor(builder2, this.context.getWasmSymbols().getJsFunConstructor(), CollectionsKt.emptyList());
        Collection collection = result2.getAnnotations();
        IrSimpleFunction irSimpleFunction = result2;
        boolean bl7 = false;
        it.putValueArgument(0, ExpressionHelpersKt.irString(builder2, jsCode2));
        Unit unit2 = Unit.INSTANCE;
        irSimpleFunction.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)object));
        ((Collection)this.additionalDeclarations).add(result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createJsToKotlinClosureConverter(FunctionTypeInfo info, IrSimpleFunction jsClosureCaller) {
        void $this$createJsToKotlinClosureConverter_u24lambda_u2d47;
        void this_$iv$iv;
        Object it;
        void $this$single$iv;
        void $this$createJsToKotlinClosureConverter_u24lambda_u2d45_u24lambda_u2d43;
        Iterator this_$iv$iv2;
        void $this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d37;
        void this_$iv$iv3;
        void startOffset$iv;
        void $this$irBlockBody$iv;
        Object closureClass;
        IrValueParameter irValueParameter;
        IrSimpleType functionType = info.getFunctionType();
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createJsToKotlinClosureConverter_u24lambda_u2d30 = $this$buildFun_u24lambda_u2d16$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier("__convertJsClosureToKotlinClosure_" + info.getHashString());
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"__convertJsC\u2026sure_${info.hashString}\")");
        $this$createJsToKotlinClosureConverter_u24lambda_u2d30.setName(name2);
        $this$createJsToKotlinClosureConverter_u24lambda_u2d30.setReturnType(functionType);
        IrSimpleFunction result2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
        result2.setParent(this.getCurrentParent());
        IrFunction $this$addValueParameter$iv = result2;
        boolean $i$f$addValueParameter = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv = new IrValueParameterBuilder();
        boolean bl3 = false;
        IrValueParameterBuilder $this$createJsToKotlinClosureConverter_u24lambda_u2d31 = $this$addValueParameter_u24lambda_u2d28$iv;
        boolean bl4 = false;
        Name name3 = Name.identifier("f");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(\"f\")");
        $this$createJsToKotlinClosureConverter_u24lambda_u2d31.setName(name3);
        $this$createJsToKotlinClosureConverter_u24lambda_u2d31.setType(this.context.getWasmSymbols().getExternalInterfaceType());
        if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2d28$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
        }
        IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv, $this$addValueParameter$iv);
        boolean bl5 = false;
        $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
        Object $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u2d1$iv = new IrClassBuilder();
        boolean bl6 = false;
        IrClassBuilder $this$createJsToKotlinClosureConverter_u24lambda_u2d32 = $this$buildClass_u24lambda_u2d1$iv;
        boolean bl7 = false;
        Name name4 = Name.identifier("__JsClosureToKotlinClosure_" + info.getHashString());
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(\"__JsClosureT\u2026sure_${info.hashString}\")");
        $this$createJsToKotlinClosureConverter_u24lambda_u2d32.setName(name4);
        Object $this$createJsToKotlinClosureConverter_u24lambda_u2d33 = $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, $this$buildClass_u24lambda_u2d1$iv);
        boolean bl8 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$createJsToKotlinClosureConverter_u24lambda_u2d33);
        ((IrClass)$this$createJsToKotlinClosureConverter_u24lambda_u2d33).setSuperTypes(CollectionsKt.listOf((Object)functionType));
        $this$createJsToKotlinClosureConverter_u24lambda_u2d33.setParent(this.getCurrentParent());
        Object $this$addField$iv = closureClass = $this$buildClass$iv;
        boolean $i$f$addField = false;
        Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u2d4$iv$iv = new IrFieldBuilder();
        boolean bl9 = false;
        IrFieldBuilder $this$createJsToKotlinClosureConverter_u24lambda_u2d34 = $this$buildField_u24lambda_u2d4$iv$iv;
        boolean bl10 = false;
        Name name5 = Name.identifier("jsClosure");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(\"jsClosure\")");
        $this$createJsToKotlinClosureConverter_u24lambda_u2d34.setName(name5);
        $this$createJsToKotlinClosureConverter_u24lambda_u2d34.setType(this.context.getWasmSymbols().getExternalInterfaceType());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
        $this$createJsToKotlinClosureConverter_u24lambda_u2d34.setVisibility(descriptorVisibility);
        $this$createJsToKotlinClosureConverter_u24lambda_u2d34.setFinal(true);
        Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, $this$buildField_u24lambda_u2d4$iv$iv);
        boolean bl11 = false;
        field$iv.setParent((IrDeclarationParent)$this$addField$iv);
        $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv);
        Object closureClassField = $this$buildField$iv$iv;
        Object $this$addConstructor$iv = closureClass;
        boolean $i$f$addConstructor = false;
        Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2d20$iv$iv = new IrFunctionBuilder();
        boolean bl12 = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2d21$iv = $this$buildConstructor_u24lambda_u2d20$iv$iv;
        boolean bl13 = false;
        IrFunctionBuilder $this$createJsToKotlinClosureConverter_u24lambda_u2d35 = $this$addConstructor_u24lambda_u2d21$iv;
        boolean $i$a$-addConstructor-JsInteropFunctionsLowering$createJsToKotlinClosureConverter$closureClassConstructor$22 = false;
        $this$createJsToKotlinClosureConverter_u24lambda_u2d35.setPrimary(true);
        $this$addConstructor_u24lambda_u2d21$iv.setReturnType(IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2d20$iv$iv);
        boolean bl14 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
        Object $this$createJsToKotlinClosureConverter_u24lambda_u2d38 = $this$addConstructor$iv = $this$buildConstructor$iv$iv;
        boolean bl15 = false;
        Object $this$addValueParameter$iv2 = (IrFunction)$this$createJsToKotlinClosureConverter_u24lambda_u2d38;
        int $i$f$addValueParameter2 = 0;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv2 = new IrValueParameterBuilder();
        $i$a$-run-DeclarationBuildersKt$addValueParameter$1$iv = false;
        Object $this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d36 = $this$addValueParameter_u24lambda_u2d28$iv2;
        boolean bl16 = false;
        ((IrDeclarationBuilder)$this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d36).setName(closureClassField.getName());
        ((IrValueParameterBuilder)$this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d36).setType(((IrField)closureClassField).getType());
        if ($this$addValueParameter_u24lambda_u2d28$iv2.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2d28$iv2.setIndex(((IrFunction)$this$addValueParameter$iv2).getValueParameters().size());
        }
        IrValueParameter valueParameter$iv2 = $i$a$-addConstructor-JsInteropFunctionsLowering$createJsToKotlinClosureConverter$closureClassConstructor$22 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv2.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv2, (IrDeclarationParent)$this$addValueParameter$iv2);
        $i$a$-also-DeclarationBuildersKt$addValueParameter$1$1$iv = false;
        ((IrFunction)$this$addValueParameter$iv2).setValueParameters(CollectionsKt.plus((Collection)((IrFunction)$this$addValueParameter$iv2).getValueParameters(), (Object)valueParameter$iv2));
        IrValueParameter parameter = $i$a$-addConstructor-JsInteropFunctionsLowering$createJsToKotlinClosureConverter$closureClassConstructor$22;
        $this$addValueParameter$iv2 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)((IrConstructor)$this$createJsToKotlinClosureConverter_u24lambda_u2d38).getSymbol(), 0, 0, 6, null);
        $i$f$addValueParameter2 = $this$createJsToKotlinClosureConverter_u24lambda_u2d38.getStartOffset();
        int endOffset$iv = $this$createJsToKotlinClosureConverter_u24lambda_u2d38.getEndOffset();
        boolean $i$f$irBlockBody = false;
        $this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d36 = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        IrValueParameter $i$a$-addConstructor-JsInteropFunctionsLowering$createJsToKotlinClosureConverter$closureClassConstructor$22 = this_$iv$iv3;
        Object object = $this$createJsToKotlinClosureConverter_u24lambda_u2d38;
        boolean bl17 = false;
        $this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d37.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d37, (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d37.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d37;
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d37;
        IrValueParameter irValueParameter2 = ((IrClass)closureClass).getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter2);
        $this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d37.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter2), (IrField)closureClassField, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d37, parameter), null, 8, null));
        $this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d37.unaryPlus(new IrInstanceInitializerCallImpl($this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d37.getStartOffset(), $this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d37.getEndOffset(), ((IrClass)closureClass).getSymbol(), $this$createJsToKotlinClosureConverter_u24lambda_u2d38_u24lambda_u2d37.getContext().getIrBuiltIns().getUnitType()));
        ((IrFunction)object).setBody(this_$iv$iv3.doBuild());
        Object closureClassConstructor = $this$addConstructor$iv;
        Object $this$addFunction$iv = closureClass;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun2 = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv$iv$iv = new IrFunctionBuilder();
        boolean bl18 = false;
        IrFunctionBuilder $this$createJsToKotlinClosureConverter_u24lambda_u2d39 = $this$buildFun_u24lambda_u2d16$iv$iv$iv;
        boolean bl192 = false;
        Name name6 = Name.identifier("invoke");
        Intrinsics.checkNotNullExpressionValue((Object)name6, (String)"identifier(\"invoke\")");
        $this$createJsToKotlinClosureConverter_u24lambda_u2d39.setName(name6);
        $this$createJsToKotlinClosureConverter_u24lambda_u2d39.setReturnType(info.getOriginalResultType());
        Object function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2d16$iv$iv$iv);
        boolean bl20 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
        function$iv$iv.setParent((IrDeclarationContainer)$this$addFunction$iv);
        Object $this$createJsToKotlinClosureConverter_u24lambda_u2d45 = $this$addFunction$iv = $this$buildFun$iv$iv$iv;
        boolean bl21 = false;
        Object $this$addDispatchReceiver$iv = $this$createJsToKotlinClosureConverter_u24lambda_u2d45;
        boolean $i$f$addDispatchReceiver = false;
        IrValueParameterBuilder $this$addDispatchReceiver_u24lambda_u2d31$iv = new IrValueParameterBuilder();
        boolean bl22 = false;
        IrValueParameterBuilder $this$createJsToKotlinClosureConverter_u24lambda_u2d45_u24lambda_u2d40 = $this$addDispatchReceiver_u24lambda_u2d31$iv;
        int $i$a$-addDispatchReceiver-JsInteropFunctionsLowering$createJsToKotlinClosureConverter$3$22 = 0;
        $this$createJsToKotlinClosureConverter_u24lambda_u2d45_u24lambda_u2d40.setType(IrUtilsKt.getDefaultType((IrClass)closureClass));
        $this$addDispatchReceiver_u24lambda_u2d31$iv.setIndex(-1);
        $this$addDispatchReceiver_u24lambda_u2d31$iv.setName(DescriptorUtilsKt.getSynthesizedName("this"));
        IrValueParameter receiver$iv = bl192 = DeclarationBuildersKt.buildValueParameter($this$addDispatchReceiver$iv.getFactory(), $this$addDispatchReceiver_u24lambda_u2d31$iv, (IrDeclarationParent)$this$addDispatchReceiver$iv);
        boolean bl23 = false;
        ((IrFunction)$this$addDispatchReceiver$iv).setDispatchReceiverParameter(receiver$iv);
        Iterable $this$forEachIndexed$iv = info.getOriginalParameterTypes();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            IrValueParameter irValueParameter3;
            void irType;
            if (($i$a$-addDispatchReceiver-JsInteropFunctionsLowering$createJsToKotlinClosureConverter$3$22 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrAnnotationContainer bl192 = (IrType)item$iv;
            int index2 = $i$a$-addDispatchReceiver-JsInteropFunctionsLowering$createJsToKotlinClosureConverter$3$22;
            boolean bl24 = false;
            IrFunction $this$addValueParameter$iv3 = (IrFunction)$this$createJsToKotlinClosureConverter_u24lambda_u2d45;
            boolean $i$f$addValueParameter3 = false;
            IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv3 = new IrValueParameterBuilder();
            $i$a$-run-DeclarationBuildersKt$addValueParameter$1$iv = false;
            IrValueParameterBuilder $this$createJsToKotlinClosureConverter_u24lambda_u2d45_u24lambda_u2d42_u24lambda_u2d41 = $this$addValueParameter_u24lambda_u2d28$iv3;
            boolean bl25 = false;
            Name name7 = Name.identifier("" + 'p' + index2);
            Intrinsics.checkNotNullExpressionValue((Object)name7, (String)"identifier(\"p$index\")");
            $this$createJsToKotlinClosureConverter_u24lambda_u2d45_u24lambda_u2d42_u24lambda_u2d41.setName(name7);
            $this$createJsToKotlinClosureConverter_u24lambda_u2d45_u24lambda_u2d42_u24lambda_u2d41.setType((IrType)irType);
            if ($this$addValueParameter_u24lambda_u2d28$iv3.getIndex() == -1) {
                $this$addValueParameter_u24lambda_u2d28$iv3.setIndex($this$addValueParameter$iv3.getValueParameters().size());
            }
            IrValueParameter valueParameter$iv3 = irValueParameter3 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv3.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv3, $this$addValueParameter$iv3);
            $i$a$-also-DeclarationBuildersKt$addValueParameter$1$1$iv = false;
            $this$addValueParameter$iv3.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv3.getValueParameters(), (Object)valueParameter$iv3));
        }
        DeclarationIrBuilder lambdaBuilder = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)((IrSimpleFunction)$this$createJsToKotlinClosureConverter_u24lambda_u2d45).getSymbol(), 0, 0, 6, null);
        Sequence<IrSimpleFunctionSymbol> $this$irBlockBody_u24default$iv = (Sequence<IrSimpleFunctionSymbol>)lambdaBuilder;
        int startOffset$iv2 = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv2 = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder $i$a$-addDispatchReceiver-JsInteropFunctionsLowering$createJsToKotlinClosureConverter$3$22 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv2, endOffset$iv2);
        boolean $i$f$blockBody2 = false;
        void index2 = this_$iv$iv2;
        Object object2 = $this$createJsToKotlinClosureConverter_u24lambda_u2d45;
        boolean bl26 = false;
        IrFunctionAccessExpression jsClosureCallerCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createJsToKotlinClosureConverter_u24lambda_u2d45_u24lambda_u2d43, jsClosureCaller);
        IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$createJsToKotlinClosureConverter_u24lambda_u2d45_u24lambda_u2d43;
        IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$createJsToKotlinClosureConverter_u24lambda_u2d45_u24lambda_u2d43;
        IrValueParameter irValueParameter4 = ((IrFunction)$this$createJsToKotlinClosureConverter_u24lambda_u2d45).getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter4);
        jsClosureCallerCall.putValueArgument(0, ExpressionHelpersKt.irGetField(irBuilderWithScope3, ExpressionHelpersKt.irGet(irBuilderWithScope4, irValueParameter4), (IrField)closureClassField));
        Iterator<InteropTypeAdapter> $i$f$addValueParameter3 = info.getParametersAdapters().iterator();
        int n = 0;
        while ($i$f$addValueParameter3.hasNext()) {
            int adapterIndex = n++;
            InteropTypeAdapter paramAdapter = $i$f$addValueParameter3.next();
            jsClosureCallerCall.putValueArgument(adapterIndex + 1, this.adaptIfNeeded(paramAdapter, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createJsToKotlinClosureConverter_u24lambda_u2d45_u24lambda_u2d43, ((IrFunction)$this$createJsToKotlinClosureConverter_u24lambda_u2d45).getValueParameters().get(adapterIndex)), lambdaBuilder));
        }
        $this$createJsToKotlinClosureConverter_u24lambda_u2d45_u24lambda_u2d43.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$createJsToKotlinClosureConverter_u24lambda_u2d45_u24lambda_u2d43, this.adaptIfNeeded(info.getResultAdapter(), jsClosureCallerCall, lambdaBuilder)));
        ((IrFunction)object2).setBody(((IrBlockBodyBuilder)((Object)this_$iv$iv2)).doBuild());
        Collection collection = $this$createJsToKotlinClosureConverter_u24lambda_u2d45.getOverriddenSymbols();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(functionType);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        $this$irBlockBody_u24default$iv = IrUtilsKt.getFunctions(irClassSymbol);
        Collection collection2 = collection;
        object2 = $this$createJsToKotlinClosureConverter_u24lambda_u2d45;
        boolean $i$f$single22 = false;
        Object single$iv = null;
        boolean found$iv22 = false;
        for (Object element$iv : $this$single$iv) {
            it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl27 = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName(), (Object)Name.identifier("invoke"))) continue;
            if (found$iv22) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv22 = true;
        }
        if (!found$iv22) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Object var31_103 = single$iv;
        object2.setOverriddenSymbols(CollectionsKt.plus((Collection)collection2, var31_103));
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)result2.getSymbol(), 0, 0, 6, null);
        IrBuilderWithScope $this$irBlockBody_u24default$iv2 = builder2;
        int startOffset$iv3 = $this$irBlockBody_u24default$iv2.getStartOffset();
        int endOffset$iv3 = $this$irBlockBody_u24default$iv2.getEndOffset();
        boolean $i$f$irBlockBody3 = false;
        IrBlockBodyBuilder $i$f$single22 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv2.getContext(), $this$irBlockBody_u24default$iv2.getScope(), startOffset$iv3, endOffset$iv3);
        boolean $i$f$blockBody3 = false;
        void found$iv22 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction = result2;
        boolean bl28 = false;
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createJsToKotlinClosureConverter_u24lambda_u2d47, (IrFunction)closureClassConstructor);
        it = irFunctionAccessExpression;
        IrBuilderWithScope irBuilderWithScope5 = (IrBuilderWithScope)$this$createJsToKotlinClosureConverter_u24lambda_u2d47;
        void var20_88 = $this$createJsToKotlinClosureConverter_u24lambda_u2d47;
        boolean bl29 = false;
        ((IrFunctionAccessExpression)it).putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createJsToKotlinClosureConverter_u24lambda_u2d47, result2.getValueParameters().get(0)));
        Unit unit2 = Unit.INSTANCE;
        var20_88.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope5, irFunctionAccessExpression));
        irSimpleFunction.setBody(this_$iv$iv.doBuild());
        ((Collection)this.additionalDeclarations).add(closureClass);
        ((Collection)this.additionalDeclarations).add(result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createJsClosureCaller(FunctionTypeInfo info) {
        void it;
        Object object;
        IrValueParameter irValueParameter;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createJsClosureCaller_u24lambda_u2d48 = $this$buildFun_u24lambda_u2d16$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier("__callJsClosure_" + info.getHashString());
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"__callJsClosure_${info.hashString}\")");
        $this$createJsClosureCaller_u24lambda_u2d48.setName(name2);
        $this$createJsClosureCaller_u24lambda_u2d48.setReturnType(info.getAdaptedResultType());
        IrSimpleFunction result2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
        result2.setParent(this.getCurrentParent());
        IrFunction $this$addValueParameter$iv = result2;
        int $i$f$addValueParameter = 0;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv = new IrValueParameterBuilder();
        boolean bl3 = false;
        IrValueParameterBuilder $this$createJsClosureCaller_u24lambda_u2d49 = $this$addValueParameter_u24lambda_u2d28$iv;
        boolean bl4 = false;
        Name name3 = Name.identifier("f");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(\"f\")");
        $this$createJsClosureCaller_u24lambda_u2d49.setName(name3);
        $this$createJsClosureCaller_u24lambda_u2d49.setType(this.symbols.getExternalInterfaceType());
        if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2d28$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
        }
        IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv, $this$addValueParameter$iv);
        boolean bl5 = false;
        $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
        int arity = info.getAdaptedParameterTypes().size();
        for ($i$f$addValueParameter = 0; $i$f$addValueParameter < arity; ++$i$f$addValueParameter) {
            IrValueParameter irValueParameter2;
            int paramIndex = $i$f$addValueParameter;
            boolean bl6 = false;
            IrFunction $this$addValueParameter$iv2 = result2;
            boolean $i$f$addValueParameter2 = false;
            IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv2 = new IrValueParameterBuilder();
            $i$a$-run-DeclarationBuildersKt$addValueParameter$1$iv = false;
            IrValueParameterBuilder $this$createJsClosureCaller_u24lambda_u2d51_u24lambda_u2d50 = $this$addValueParameter_u24lambda_u2d28$iv2;
            boolean bl7 = false;
            Name name4 = Name.identifier("" + 'p' + paramIndex);
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(\"p$paramIndex\")");
            $this$createJsClosureCaller_u24lambda_u2d51_u24lambda_u2d50.setName(name4);
            $this$createJsClosureCaller_u24lambda_u2d51_u24lambda_u2d50.setType(info.getAdaptedParameterTypes().get(paramIndex));
            if ($this$addValueParameter_u24lambda_u2d28$iv2.getIndex() == -1) {
                $this$addValueParameter_u24lambda_u2d28$iv2.setIndex($this$addValueParameter$iv2.getValueParameters().size());
            }
            IrValueParameter valueParameter$iv2 = irValueParameter2 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv2.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv2, $this$addValueParameter$iv2);
            $i$a$-also-DeclarationBuildersKt$addValueParameter$1$1$iv = false;
            $this$addValueParameter$iv2.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv2.getValueParameters(), (Object)valueParameter$iv2));
        }
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)result2.getSymbol(), 0, 0, 6, null);
        Object $this$createJsClosureCaller_u24lambda_u2d52 = object = new StringBuilder();
        boolean bl8 = false;
        ((StringBuilder)$this$createJsClosureCaller_u24lambda_u2d52).append("(f, ");
        JsInteropFunctionsLoweringKt.appendParameterList$default((StringBuilder)$this$createJsClosureCaller_u24lambda_u2d52, arity, null, false, 6, null);
        ((StringBuilder)$this$createJsClosureCaller_u24lambda_u2d52).append(") => f(");
        JsInteropFunctionsLoweringKt.appendParameterList$default((StringBuilder)$this$createJsClosureCaller_u24lambda_u2d52, arity, null, false, 6, null);
        ((StringBuilder)$this$createJsClosureCaller_u24lambda_u2d52).append(")");
        String string2 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String jsFun = string2;
        $this$createJsClosureCaller_u24lambda_u2d52 = object = ExpressionHelpersKt.irCallConstructor(builder2, this.context.getWasmSymbols().getJsFunConstructor(), CollectionsKt.emptyList());
        Collection collection = result2.getAnnotations();
        IrSimpleFunction irSimpleFunction = result2;
        boolean bl9 = false;
        it.putValueArgument(0, ExpressionHelpersKt.irString(builder2, jsFun));
        Unit unit2 = Unit.INSTANCE;
        irSimpleFunction.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)object));
        ((Collection)this.additionalDeclarations).add(result2);
        return result2;
    }

    @NotNull
    public final IrExpression adaptIfNeeded(@Nullable InteropTypeAdapter $this$adaptIfNeeded, @NotNull IrExpression expression2, @NotNull IrBuilderWithScope builder2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Object object = $this$adaptIfNeeded;
        if (object == null || (object = object.adapt(expression2, builder2)) == null) {
            object = expression2;
        }
        return object;
    }

    @Override
    public boolean getWithLocalDeclarations() {
        return DeclarationTransformer.DefaultImpls.getWithLocalDeclarations(this);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        DeclarationTransformer.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$KOTLIN_WASM_CLOSURE_FOR_JS_CLOSURE;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "()V", "backend.wasm"})
    public static final class KOTLIN_WASM_CLOSURE_FOR_JS_CLOSURE
    extends IrStatementOriginImpl {
        @NotNull
        public static final KOTLIN_WASM_CLOSURE_FOR_JS_CLOSURE INSTANCE = new KOTLIN_WASM_CLOSURE_FOR_JS_CLOSURE();

        private KOTLIN_WASM_CLOSURE_FOR_JS_CLOSURE() {
            super("KOTLIN_WASM_CLOSURE_FOR_JS_CLOSURE");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0017\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0019\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$FunctionTypeInfo;", "", "functionType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "toJs", "", "(Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering;Lorg/jetbrains/kotlin/ir/types/IrSimpleType;Z)V", "adaptedParameterTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getAdaptedParameterTypes", "()Ljava/util/List;", "adaptedResultType", "getAdaptedResultType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getFunctionType", "()Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "hashString", "", "getHashString", "()Ljava/lang/String;", "originalParameterTypes", "getOriginalParameterTypes", "originalResultType", "getOriginalResultType", "parametersAdapters", "Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$InteropTypeAdapter;", "getParametersAdapters", "resultAdapter", "getResultAdapter", "()Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$InteropTypeAdapter;", "backend.wasm"})
    public final class FunctionTypeInfo {
        @NotNull
        private final IrSimpleType functionType;
        @NotNull
        private final String hashString;
        @NotNull
        private final List<IrType> originalParameterTypes;
        @NotNull
        private final IrType originalResultType;
        @NotNull
        private final List<InteropTypeAdapter> parametersAdapters;
        @Nullable
        private final InteropTypeAdapter resultAdapter;
        @NotNull
        private final List<IrType> adaptedParameterTypes;
        @NotNull
        private final IrType adaptedResultType;

        /*
         * WARNING - void declaration
         */
        public FunctionTypeInfo(IrSimpleType functionType, boolean toJs) {
            IrType irType;
            IrType irType2;
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            Collection collection;
            IrTypeArgument irTypeArgument;
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv;
            boolean bl;
            Iterable $this$all$iv;
            block13: {
                Intrinsics.checkNotNullParameter((Object)functionType, (String)"functionType");
                this.functionType = functionType;
                $this$all$iv = this.functionType.getArguments();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        IrTypeArgument it = (IrTypeArgument)element$iv;
                        boolean bl2 = false;
                        if (it instanceof IrTypeProjection) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                boolean $i$a$-require-JsInteropFunctionsLowering$FunctionTypeInfo$32 = false;
                String $i$a$-require-JsInteropFunctionsLowering$FunctionTypeInfo$32 = "Star projection is not supported in function type interop " + RenderIrElementKt.render(this.functionType);
                throw new IllegalArgumentException($i$a$-require-JsInteropFunctionsLowering$FunctionTypeInfo$32.toString());
            }
            String string2 = Integer.toString(Math.abs(this.functionType.hashCode()), CharsKt.checkRadix((int)36));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
            this.hashString = string2;
            $this$all$iv = CollectionsKt.dropLast(this.functionType.getArguments(), (int)1);
            FunctionTypeInfo functionTypeInfo = this;
            boolean $i$f$map22 = false;
            Iterator iterator2 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                irTypeArgument = (IrTypeArgument)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(((IrTypeProjection)it).getType());
            }
            functionTypeInfo.originalParameterTypes = (List)destination$iv$iv;
            this.originalResultType = ((IrTypeProjection)CollectionsKt.last(this.functionType.getArguments())).getType();
            $this$map$iv = this.originalParameterTypes;
            JsInteropFunctionsLowering $i$f$map22 = JsInteropFunctionsLowering.this;
            functionTypeInfo = this;
            boolean $i$f$map32 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void parameterType;
                IrType bl3 = (IrType)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(toJs ? $i$f$map22.jsToKotlinAdapterIfNeeded((IrType)parameterType, false) : $i$f$map22.kotlinToJsAdapterIfNeeded((IrType)parameterType, false));
            }
            functionTypeInfo.parametersAdapters = (List)destination$iv$iv2;
            this.resultAdapter = toJs ? JsInteropFunctionsLowering.this.kotlinToJsAdapterIfNeeded(this.originalResultType, true) : JsInteropFunctionsLowering.this.jsToKotlinAdapterIfNeeded(this.originalResultType, true);
            $this$map$iv = CollectionsKt.zip((Iterable)this.originalParameterTypes, (Iterable)this.parametersAdapters);
            functionTypeInfo = this;
            boolean $i$f$map = false;
            Iterable $i$f$map32 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrType irType3;
                IrType irType4;
                irTypeArgument = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                IrType parameterType = (IrType)irTypeArgument.component1();
                InteropTypeAdapter adapter = (InteropTypeAdapter)irTypeArgument.component2();
                if (toJs) {
                    InteropTypeAdapter interopTypeAdapter = adapter;
                    irType4 = interopTypeAdapter != null ? interopTypeAdapter.getFromType() : null;
                } else {
                    InteropTypeAdapter interopTypeAdapter = adapter;
                    irType4 = irType3 = interopTypeAdapter != null ? interopTypeAdapter.getToType() : null;
                }
                if (irType4 == null) {
                    irType3 = parameterType;
                }
                collection.add(irType3);
            }
            functionTypeInfo.adaptedParameterTypes = (List)destination$iv$iv;
            if (toJs) {
                InteropTypeAdapter interopTypeAdapter = this.resultAdapter;
                irType2 = interopTypeAdapter != null ? interopTypeAdapter.getToType() : null;
            } else {
                InteropTypeAdapter interopTypeAdapter = this.resultAdapter;
                irType2 = irType = interopTypeAdapter != null ? interopTypeAdapter.getFromType() : null;
            }
            if (irType2 == null) {
                irType = this.originalResultType;
            }
            this.adaptedResultType = irType;
        }

        @NotNull
        public final IrSimpleType getFunctionType() {
            return this.functionType;
        }

        @NotNull
        public final String getHashString() {
            return this.hashString;
        }

        @NotNull
        public final List<IrType> getOriginalParameterTypes() {
            return this.originalParameterTypes;
        }

        @NotNull
        public final IrType getOriginalResultType() {
            return this.originalResultType;
        }

        @NotNull
        public final List<InteropTypeAdapter> getParametersAdapters() {
            return this.parametersAdapters;
        }

        @Nullable
        public final InteropTypeAdapter getResultAdapter() {
            return this.resultAdapter;
        }

        @NotNull
        public final List<IrType> getAdaptedParameterTypes() {
            return this.adaptedParameterTypes;
        }

        @NotNull
        public final IrType getAdaptedResultType() {
            return this.adaptedResultType;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$InteropTypeAdapter;", "", "fromType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getFromType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "toType", "getToType", "adapt", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "builder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "backend.wasm"})
    public static interface InteropTypeAdapter {
        @NotNull
        public IrType getFromType();

        @NotNull
        public IrType getToType();

        @NotNull
        public IrExpression adapt(@NotNull IrExpression var1, @NotNull IrBuilderWithScope var2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$FunctionBasedAdapter;", "Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$InteropTypeAdapter;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)V", "fromType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getFromType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "toType", "getToType", "adapt", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "builder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "backend.wasm"})
    public static final class FunctionBasedAdapter
    implements InteropTypeAdapter {
        @NotNull
        private final IrSimpleFunction function;
        @NotNull
        private final IrType fromType;
        @NotNull
        private final IrType toType;

        public FunctionBasedAdapter(@NotNull IrSimpleFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            this.function = function2;
            this.fromType = this.function.getValueParameters().get(0).getType();
            this.toType = this.function.getReturnType();
        }

        @Override
        @NotNull
        public IrType getFromType() {
            return this.fromType;
        }

        @Override
        @NotNull
        public IrType getToType() {
            return this.toType;
        }

        @Override
        @NotNull
        public IrExpression adapt(@NotNull IrExpression expression2, @NotNull IrBuilderWithScope builder2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            IrFunctionAccessExpression call2 = ExpressionHelpersKt.irCall(builder2, this.function);
            call2.putValueArgument(0, expression2);
            return call2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$SendKotlinObjectToJsAdapter;", "Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$InteropTypeAdapter;", "fromType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getFromType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "toType", "getToType", "adapt", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "builder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "backend.wasm"})
    public final class SendKotlinObjectToJsAdapter
    implements InteropTypeAdapter {
        @NotNull
        private final IrType fromType;
        @NotNull
        private final IrType toType;

        public SendKotlinObjectToJsAdapter(IrType fromType) {
            Intrinsics.checkNotNullParameter((Object)fromType, (String)"fromType");
            this.fromType = fromType;
            this.toType = JsInteropFunctionsLowering.this.getContext().getWasmSymbols().getWasmDataRefType();
        }

        @Override
        @NotNull
        public IrType getFromType() {
            return this.fromType;
        }

        @Override
        @NotNull
        public IrType getToType() {
            return this.toType;
        }

        @Override
        @NotNull
        public IrExpression adapt(@NotNull IrExpression expression2, @NotNull IrBuilderWithScope builder2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            return ExpressionHelpersKt.irReinterpretCast(builder2, expression2, this.getToType());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$ReceivingKotlinObjectFromJsAdapter;", "Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$InteropTypeAdapter;", "toType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "fromType", "getFromType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getToType", "adapt", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "builder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "backend.wasm"})
    public final class ReceivingKotlinObjectFromJsAdapter
    implements InteropTypeAdapter {
        @NotNull
        private final IrType toType;
        @NotNull
        private final IrType fromType;

        public ReceivingKotlinObjectFromJsAdapter(IrType toType) {
            Intrinsics.checkNotNullParameter((Object)toType, (String)"toType");
            this.toType = toType;
            this.fromType = JsInteropFunctionsLowering.this.getContext().getWasmSymbols().getWasmDataRefType();
        }

        @Override
        @NotNull
        public IrType getToType() {
            return this.toType;
        }

        @Override
        @NotNull
        public IrType getFromType() {
            return this.fromType;
        }

        @Override
        @NotNull
        public IrExpression adapt(@NotNull IrExpression expression2, @NotNull IrBuilderWithScope builder2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            IrCall call2 = ExpressionHelpersKt.irCall(builder2, JsInteropFunctionsLowering.this.getContext().getWasmSymbols().getWasmRefCast());
            call2.putValueArgument(0, expression2);
            call2.putTypeArgument(0, this.getToType());
            return call2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$NullOrAdapter;", "Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$InteropTypeAdapter;", "adapter", "(Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering;Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$InteropTypeAdapter;)V", "getAdapter", "()Lorg/jetbrains/kotlin/backend/wasm/lower/JsInteropFunctionsLowering$InteropTypeAdapter;", "fromType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getFromType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "toType", "getToType", "adapt", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "builder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "backend.wasm"})
    public final class NullOrAdapter
    implements InteropTypeAdapter {
        @NotNull
        private final InteropTypeAdapter adapter;
        @NotNull
        private final IrType fromType;
        @NotNull
        private final IrType toType;

        public NullOrAdapter(InteropTypeAdapter adapter) {
            Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
            this.adapter = adapter;
            this.fromType = IrTypesKt.makeNullable(this.adapter.getFromType());
            this.toType = IrTypesKt.makeNullable(this.adapter.getToType());
        }

        @NotNull
        public final InteropTypeAdapter getAdapter() {
            return this.adapter;
        }

        @Override
        @NotNull
        public IrType getFromType() {
            return this.fromType;
        }

        @Override
        @NotNull
        public IrType getToType() {
            return this.toType;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression adapt(@NotNull IrExpression expression2, @NotNull IrBuilderWithScope builder2) {
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            IrBuilderWithScope $this$irComposite_u24default$iv = builder2;
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$adapt_u24lambda_u2d0 = this_$iv$iv;
            boolean bl = false;
            IrVariable tmp = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$adapt_u24lambda_u2d0, this.adapter.adapt(expression2, builder2), null, null, false, 14, null);
            $this$adapt_u24lambda_u2d0.unaryPlus(ExpressionHelpersKt.irIfNull((IrBuilderWithScope)$this$adapt_u24lambda_u2d0, this.getToType(), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$adapt_u24lambda_u2d0, tmp), ExpressionHelpersKt.irNull((IrBuilderWithScope)$this$adapt_u24lambda_u2d0, this.getToType()), ExpressionHelpersKt.irImplicitCast((IrBuilderWithScope)$this$adapt_u24lambda_u2d0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$adapt_u24lambda_u2d0, tmp), this.getToType())));
            return this_$iv$iv.doBuild();
        }
    }
}

