/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.sourceProviders;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AdditionalSourceProvider;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/services/sourceProviders/MainFunctionForBlackBoxTestsSourceProvider;", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "generateMainBody", "", "produceAdditionalFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "globalDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Companion", "tests-common-new"})
public class MainFunctionForBlackBoxTestsSourceProvider
extends AdditionalSourceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex PACKAGE_REGEXP = new Regex("package ([\\w.]+)");
    @NotNull
    private static final Regex START_BOX_METHOD_REGEX = new Regex("^fun box\\(\\)");
    @NotNull
    private static final Regex MIDDLE_BOX_METHOD_REGEX = new Regex("\\nfun box\\(\\)");
    @NotNull
    private static final Regex START_SUSPEND_BOX_METHOD_REGEX = new Regex("^suspend fun box\\(\\)");
    @NotNull
    private static final Regex MIDDLE_SUSPEND_BOX_METHOD_REGEX = new Regex("\\nsuspend fun box\\(\\)");
    @NotNull
    public static final String BOX_MAIN_FILE_NAME = "Generated_Box_Main.kt";

    public MainFunctionForBlackBoxTestsSourceProvider(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    @NotNull
    protected String generateMainBody() {
        return "val res = box()\nif (res != \"OK\") throw AssertionError(res)";
    }

    @Override
    @NotNull
    public List<TestFile> produceAdditionalFiles(@NotNull RegisteredDirectives globalDirectives, @NotNull TestModule module2) {
        StringBuilder stringBuilder2;
        Object v1;
        Object object;
        block6: {
            Intrinsics.checkNotNullParameter((Object)globalDirectives, (String)"globalDirectives");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            if (!module2.getDirectives().contains(CodegenTestDirectives.INSTANCE.getREQUIRES_SEPARATE_PROCESS())) {
                TestJdkKind testJdkKind = DirectiveKt.singleOrZeroValue(module2.getDirectives(), JvmEnvironmentConfigurationDirectives.INSTANCE.getJDK_KIND());
                if (!(testJdkKind != null ? testJdkKind.getRequiresSeparateProcess() : false)) {
                    return CollectionsKt.emptyList();
                }
            }
            Iterable $this$firstOrNull$iv = module2.getFiles();
            boolean $i$f$firstOrNull = false;
            object = $this$firstOrNull$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                TestFile it = (TestFile)element$iv;
                boolean bl = false;
                if (!Companion.containsBoxMethod(it)) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        TestFile testFile = v1;
        if (testFile == null) {
            return CollectionsKt.emptyList();
        }
        TestFile fileWithBox = testFile;
        String suspendModifier2 = Companion.containsSuspendBoxMethod(fileWithBox) ? "suspend " : "";
        String mainBody = this.generateMainBody();
        Object $this$produceAdditionalFiles_u24lambda_u2d2 = object = new StringBuilder();
        boolean bl = false;
        String string2 = Companion.detectPackage(fileWithBox);
        if (string2 != null) {
            String it = string2;
            boolean bl2 = false;
            StringBuilder stringBuilder3 = ((StringBuilder)$this$produceAdditionalFiles_u24lambda_u2d2).append("package " + it);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringBuilder stringBuilder4 = stringBuilder3.append('\n');
            stringBuilder2 = stringBuilder4;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append('\\n')");
        } else {
            stringBuilder2 = null;
        }
        StringBuilder stringBuilder5 = ((StringBuilder)$this$produceAdditionalFiles_u24lambda_u2d2).append(StringsKt.trimIndent((String)("\n                    " + suspendModifier2 + "fun main() {\n                        " + mainBody + "\n                    }\n                ")));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        String string3 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        String code = string3;
        File file2 = FilesKt.resolve((File)TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(this.getTestServices()).getOrCreateTempDirectory("src"), (String)BOX_MAIN_FILE_NAME);
        FilesKt.writeText$default((File)file2, (String)code, null, (int)2, null);
        return CollectionsKt.listOf((Object)this.toTestFile(file2));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/test/services/sourceProviders/MainFunctionForBlackBoxTestsSourceProvider$Companion;", "", "()V", "BOX_MAIN_FILE_NAME", "", "MIDDLE_BOX_METHOD_REGEX", "Lkotlin/text/Regex;", "MIDDLE_SUSPEND_BOX_METHOD_REGEX", "PACKAGE_REGEXP", "START_BOX_METHOD_REGEX", "START_SUSPEND_BOX_METHOD_REGEX", "containsBoxMethod", "", "fileContent", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "containsSuspendBoxMethod", "detectPackage", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String detectPackage(@NotNull TestFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            MatchResult matchResult = Regex.find$default((Regex)PACKAGE_REGEXP, (CharSequence)file2.getOriginalContent(), (int)0, (int)2, null);
            return matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
        }

        public final boolean containsBoxMethod(@NotNull TestFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return this.containsBoxMethod(file2.getOriginalContent());
        }

        public final boolean containsSuspendBoxMethod(@NotNull TestFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return this.containsBoxMethod(file2.getOriginalContent());
        }

        public final boolean containsBoxMethod(@NotNull String fileContent) {
            Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
            return START_BOX_METHOD_REGEX.containsMatchIn((CharSequence)fileContent) || MIDDLE_BOX_METHOD_REGEX.containsMatchIn((CharSequence)fileContent) || this.containsSuspendBoxMethod(fileContent);
        }

        public final boolean containsSuspendBoxMethod(@NotNull String fileContent) {
            Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
            return START_SUSPEND_BOX_METHOD_REGEX.containsMatchIn((CharSequence)fileContent) || MIDDLE_SUSPEND_BOX_METHOD_REGEX.containsMatchIn((CharSequence)fileContent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

