/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirRenderer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.extensions.GeneratedDeclarationsUtilsKt;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDumpHandler;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirDumpHandler;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "FirRendererWithGeneratedDeclarations", "tests-common-new"})
public final class FirDumpHandler
extends FirAnalysisHandler {
    @NotNull
    private final MultiModuleInfoDumper dumper;

    public FirDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices, false, false, 6, null);
        this.dumper = new MultiModuleInfoDumper(null, 1, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module2, @NotNull FirOutputArtifact info) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module2.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_DUMP())) {
            return;
        }
        StringBuilder builderForModule = this.dumper.builderForModule(module2);
        Map<TestFile, FirFile> firFiles2 = info.getFirFiles();
        List $this$processModule_u24lambda_u2d0 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$processModule_u24lambda_u2d0.addAll(firFiles2.values());
        $this$processModule_u24lambda_u2d0.addAll((Collection)ConversionUtilsKt.createFilesWithGeneratedDeclarations(info.getSession()));
        List allFiles = CollectionsKt.build((List)list2);
        FirRendererWithGeneratedDeclarations renderer = new FirRendererWithGeneratedDeclarations(info.getSession(), builderForModule);
        Iterable $this$forEach$iv = allFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirFile it = (FirFile)element$iv;
            boolean bl2 = false;
            it.accept(renderer);
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (this.dumper.isEmpty()) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File file2 = testDataFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"testDataFile.parentFile");
        File expectedFile = FilesKt.resolve((File)file2, (String)(this.getNameWithoutFirExtension(testDataFile) + ".fir.txt"));
        String actualText = this.dumper.generateResultingDump();
        Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, actualText, null, processAfterAllModules.1.INSTANCE, 4, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirDumpHandler$FirRendererWithGeneratedDeclarations;", "Lorg/jetbrains/kotlin/fir/FirRenderer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/lang/StringBuilder;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "renderClassDeclarations", "", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Companion", "tests-common-new"})
    private static final class FirRendererWithGeneratedDeclarations
    extends FirRenderer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final FirSession session;
        @NotNull
        private static final FirRenderer.RenderMode modeWithPackageDirective = FirRenderer.RenderMode.copy$default(FirRenderer.RenderMode.Companion.getNormal(), false, false, false, false, false, false, false, false, false, true, 511, null);

        public FirRendererWithGeneratedDeclarations(@NotNull FirSession session2, @NotNull StringBuilder builder2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            super(builder2, modeWithPackageDirective);
            this.session = session2;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @Override
        protected void renderClassDeclarations(@NotNull FirRegularClass regularClass) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            List $this$renderClassDeclarations_u24lambda_u2d0 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$renderClassDeclarations_u24lambda_u2d0.addAll((Collection)regularClass.getDeclarations());
            $this$renderClassDeclarations_u24lambda_u2d0.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedMembers(regularClass, this.session));
            $this$renderClassDeclarations_u24lambda_u2d0.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedNestedClassifiers(regularClass, this.session));
            List allDeclarations = CollectionsKt.build((List)list2);
            this.renderDeclarations(allDeclarations);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirDumpHandler$FirRendererWithGeneratedDeclarations$Companion;", "", "()V", "modeWithPackageDirective", "Lorg/jetbrains/kotlin/fir/FirRenderer$RenderMode;", "getModeWithPackageDirective", "()Lorg/jetbrains/kotlin/fir/FirRenderer$RenderMode;", "tests-common-new"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FirRenderer.RenderMode getModeWithPackageDirective() {
                return modeWithPackageDirective;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

