/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.model.Directive;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\f\u001a\u00020\b*\u00020\u00042\u0006\u0010\r\u001a\u00020\u0001\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00042\u0006\u0010\r\u001a\u00020\u0010\u001a\u0012\u0010\u0011\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u001a\u0010\u0013\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0015\u0010\n\u001a\u00020\u0004*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006\u00a8\u0006\u0015"}, d2={"FIR_KT", "", "KT", "firTestDataFile", "Ljava/io/File;", "getFirTestDataFile", "(Ljava/io/File;)Ljava/io/File;", "isFirTestData", "", "(Ljava/io/File;)Z", "originalTestDataFile", "getOriginalTestDataFile", "isDirectiveDefined", "directive", "removeDirectiveFromFile", "", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "withExtension", "extension", "withSuffixAndExtension", "suffix", "tests-common-new"})
public final class FileUtilsKt {
    @NotNull
    private static final String FIR_KT = ".fir.kt";
    @NotNull
    private static final String KT = ".kt";

    public static final boolean isFirTestData(@NotNull File $this$isFirTestData) {
        Intrinsics.checkNotNullParameter((Object)$this$isFirTestData, (String)"<this>");
        String string2 = $this$isFirTestData.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        return StringsKt.endsWith$default((String)string2, (String)FIR_KT, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final File getOriginalTestDataFile(@NotNull File $this$originalTestDataFile) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)$this$originalTestDataFile, (String)"<this>");
        if (FileUtilsKt.isFirTestData($this$originalTestDataFile)) {
            File file3 = $this$originalTestDataFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"parentFile");
            StringBuilder stringBuilder2 = new StringBuilder();
            String string2 = $this$originalTestDataFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            file2 = FilesKt.resolve((File)file3, (String)stringBuilder2.append(StringsKt.removeSuffix((String)string2, (CharSequence)FIR_KT)).append(KT).toString());
        } else {
            file2 = $this$originalTestDataFile;
        }
        return file2;
    }

    @NotNull
    public static final File getFirTestDataFile(@NotNull File $this$firTestDataFile) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)$this$firTestDataFile, (String)"<this>");
        if (FileUtilsKt.isFirTestData($this$firTestDataFile)) {
            file2 = $this$firTestDataFile;
        } else {
            File file3 = $this$firTestDataFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"parentFile");
            StringBuilder stringBuilder2 = new StringBuilder();
            String string2 = $this$firTestDataFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            file2 = FilesKt.resolve((File)file3, (String)stringBuilder2.append(StringsKt.removeSuffix((String)string2, (CharSequence)KT)).append(FIR_KT).toString());
        }
        return file2;
    }

    @NotNull
    public static final File withExtension(@NotNull File $this$withExtension, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)$this$withExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return FileUtilsKt.withSuffixAndExtension($this$withExtension, "", extension);
    }

    @NotNull
    public static final File withSuffixAndExtension(@NotNull File $this$withSuffixAndExtension, @NotNull String suffix, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)$this$withSuffixAndExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String extension2 = StringsKt.removePrefix((String)extension, (CharSequence)".");
        File file2 = $this$withSuffixAndExtension.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"parentFile");
        return FilesKt.resolve((File)file2, (String)(FilesKt.getNameWithoutExtension((File)$this$withSuffixAndExtension) + suffix + '.' + extension2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final boolean isDirectiveDefined(@NotNull File $this$isDirectiveDefined, @NotNull String directive2) {
        boolean bl;
        void $this$useLines$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$isDirectiveDefined, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directive2, (String)"directive");
        File $this$useLines_u24default$iv = $this$isDirectiveDefined;
        Charset charset$iv = Charsets.UTF_8;
        File file2 = $this$useLines_u24default$iv;
        Charset charset$iv$iv = charset$iv;
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv$iv;
        int n = 8192;
        Reader reader = closeable;
        reader = new InputStreamReader((InputStream)new FileInputStream((File)((Object)reader)), charset$iv$iv);
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        Throwable throwable = null;
        try {
            boolean bl2;
            block6: {
                BufferedReader it$iv$iv = (BufferedReader)closeable;
                boolean bl3 = false;
                Sequence line = TextStreamsKt.lineSequence((BufferedReader)it$iv$iv);
                boolean bl4 = false;
                Sequence $this$any$iv = line;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)directive2)) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bl;
    }

    public static final void removeDirectiveFromFile(@NotNull File $this$removeDirectiveFromFile, @NotNull Directive directive2) {
        Intrinsics.checkNotNullParameter((Object)$this$removeDirectiveFromFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directive2, (String)"directive");
        String directiveName = directive2.getName();
        Regex directiveRegexp = new Regex("^// " + directiveName + "(:.*)?$(\n)?", RegexOption.MULTILINE);
        String text2 = FilesKt.readText$default((File)$this$removeDirectiveFromFile, null, (int)1, null);
        MatchResult matchResult = Regex.find$default((Regex)directiveRegexp, (CharSequence)text2, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getRange()) == null) {
            throw new IllegalStateException(("Directive " + directiveName + " was not found in " + $this$removeDirectiveFromFile).toString());
        }
        MatchResult directiveRange = matchResult;
        String textWithoutDirective = ((Object)StringsKt.removeRange((CharSequence)text2, (IntRange)directiveRange)).toString();
        FilesKt.writeText$default((File)$this$removeDirectiveFromFile, (String)textWithoutDirective, null, (int)2, null);
    }
}

