/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.jvm.JvmIrCodegenFactory;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporterFactory;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.JsEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontend2IrConverter;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendOutputArtifact;
import org.jetbrains.kotlin.test.model.BackendKinds;
import org.jetbrains.kotlin.test.model.Frontend2BackendConverter;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.JsLibraryProvider;
import org.jetbrains.kotlin.test.services.JsLibraryProviderKt;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/ClassicFrontend2IrConverter;", "Lorg/jetbrains/kotlin/test/model/Frontend2BackendConverter;", "Lorg/jetbrains/kotlin/test/frontend/classic/ClassicFrontendOutputArtifact;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "additionalServices", "", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "()Ljava/util/List;", "transform", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "inputArtifact", "transformToJsIr", "transformToJvmIr", "tests-common-new"})
public final class ClassicFrontend2IrConverter
extends Frontend2BackendConverter<ClassicFrontendOutputArtifact, IrBackendInput> {
    public ClassicFrontend2IrConverter(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices, FrontendKinds.ClassicFrontend.INSTANCE, BackendKinds.IrBackend.INSTANCE);
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        Function1 serviceConstructor$iv = additionalServices.1.INSTANCE;
        boolean $i$f$service = false;
        return CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(JsLibraryProvider.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
    }

    @Override
    @NotNull
    public IrBackendInput transform(@NotNull TestModule module2, @NotNull ClassicFrontendOutputArtifact inputArtifact) {
        IrBackendInput irBackendInput;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)inputArtifact, (String)"inputArtifact");
        TargetBackend targetBackend = module2.getTargetBackend();
        switch (targetBackend == null ? -1 : WhenMappings.$EnumSwitchMapping$0[targetBackend.ordinal()]) {
            case 1: {
                irBackendInput = this.transformToJvmIr(module2, inputArtifact);
                break;
            }
            case 2: {
                irBackendInput = this.transformToJsIr(module2, inputArtifact);
                break;
            }
            default: {
                AssertionsKt.getAssertions(this.getTestServices()).fail((Function0<String>)((Function0)new Function0<String>(module2){
                    final /* synthetic */ TestModule $module;
                    {
                        this.$module = $module;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Target backend " + (Object)((Object)this.$module.getTargetBackend()) + " not supported for transformation into IR";
                    }
                }));
                throw null;
            }
        }
        return irBackendInput;
    }

    private final IrBackendInput transformToJvmIr(TestModule module2, ClassicFrontendOutputArtifact inputArtifact) {
        Map<TestFile, KtFile> psiFiles = inputArtifact.component1();
        AnalysisResult analysisResult2 = inputArtifact.component2();
        Project project = inputArtifact.component3();
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration(module2);
        List files2 = CollectionsKt.toList((Iterable)psiFiles.values());
        PhaseConfig phaseConfig = configuration2.get(CLIConfigurationKeys.PHASE_CONFIG);
        JvmIrCodegenFactory codegenFactory = new JvmIrCodegenFactory(configuration2, phaseConfig, null, null, null, null, null, 124, null);
        ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.TEST;
        Intrinsics.checkNotNullExpressionValue((Object)classBuilderFactory, (String)"TEST");
        GenerationState state = new GenerationState.Builder(project, classBuilderFactory, analysisResult2.getModuleDescriptor(), analysisResult2.getBindingContext(), files2, configuration2).codegenFactory(codegenFactory).isIrBackend(true).ignoreErrors(module2.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_ERRORS())).diagnosticReporter(DiagnosticReporterFactory.createReporter$default(DiagnosticReporterFactory.INSTANCE, false, 1, null)).build();
        return new IrBackendInput.JvmIrBackendInput(state, codegenFactory.convertToIr(CodegenFactory.IrConversionInput.Companion.fromGenerationState(state)));
    }

    private final IrBackendInput transformToJsIr(TestModule module2, ClassicFrontendOutputArtifact inputArtifact) {
        Map<TestFile, KtFile> psiFiles = inputArtifact.component1();
        AnalysisResult analysisResult2 = inputArtifact.component2();
        Project project = inputArtifact.component3();
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration(module2);
        boolean verifySignatures = !module2.getDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getSKIP_MANGLE_VERIFICATION());
        List icData = new ArrayList();
        Map expectDescriptorToSymbol = new LinkedHashMap();
        IrModuleFragment moduleFragment2 = KlibKt.generateIrForKlibSerialization(project, CollectionsKt.toList((Iterable)psiFiles.values()), configuration2, analysisResult2, KlibKt.sortDependencies(JsEnvironmentConfigurator.Companion.getAllRecursiveLibrariesFor(module2, this.getTestServices())), icData, expectDescriptorToSymbol, IrFactoryImpl.INSTANCE, verifySignatures, (Function1<? super KotlinLibrary, ? extends ModuleDescriptor>)((Function1)new Function1<KotlinLibrary, ModuleDescriptor>(this){
            final /* synthetic */ ClassicFrontend2IrConverter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ModuleDescriptor invoke(@NotNull KotlinLibrary it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return JsLibraryProviderKt.getJsLibraryProvider(this.this$0.getTestServices()).getDescriptorByCompiledLibrary(it);
            }
        }));
        return new IrBackendInput.JsIrBackendInput(moduleFragment2, CollectionsKt.toList((Iterable)psiFiles.values()), analysisResult2.getBindingContext(), icData, expectDescriptorToSymbol);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TargetBackend.values().length];
            nArray[TargetBackend.JVM_IR.ordinal()] = 1;
            nArray[TargetBackend.JS_IR.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

