/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SealedInterfaceAllowedChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class SealedInterfaceAllowedChecker
implements DeclarationChecker {
    @NotNull
    public static final SealedInterfaceAllowedChecker INSTANCE = new SealedInterfaceAllowedChecker();

    private SealedInterfaceAllowedChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (((ClassDescriptor)descriptor2).getKind() != ClassKind.INTERFACE) {
            return;
        }
        KtModifierList ktModifierList = declaration2.getModifierList();
        if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.SEALED_KEYWORD)) == null) {
            return;
        }
        KtModifierList keyword = ktModifierList;
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.SealedInterfaces)) {
            if (!((ClassDescriptor)descriptor2).isFun()) return;
            parametrizedDiagnostic = Errors.UNSUPPORTED.on((PsiElement)keyword, "sealed fun interfaces");
        } else {
            parametrizedDiagnostic = Errors.UNSUPPORTED_FEATURE.on((PsiElement)keyword, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.SealedInterfaces), (Object)context2.getLanguageVersionSettings()));
        }
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic2 = parametrizedDiagnostic;
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic2, (String)"if (context.languageVers\u2026ersionSettings)\n        }");
        ParametrizedDiagnostic<PsiElement> diagnostic = parametrizedDiagnostic2;
        context2.getTrace().report(diagnostic);
    }
}

