/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.jvm.JvmPhasesKt;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.extensions.ScriptEvaluationExtension;
import org.jetbrains.kotlin.cli.common.extensions.ShellExtension;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.modules.ModuleBuilder;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.common.profiling.ProfilingCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.ClassicFrontendSpecificJvmConfigurationKeys;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.java.JavaClassesTracker;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.modules.JavaRootPath;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002'(B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J*\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J*\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0012H\u0016J \u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u001a\u0010\"\u001a\u00020!*\b\u0012\u0004\u0012\u00020\u00120#2\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J\u0014\u0010$\u001a\u00020!*\u00020%2\u0006\u0010&\u001a\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "()V", "defaultPerformanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "getDefaultPerformanceManager", "()Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "createArguments", "createCoreEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "targetDescription", "", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "createPerformanceManager", "arguments", "services", "Lorg/jetbrains/kotlin/config/Services;", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "setupPlatformSpecificArgumentsAndServices", "", "addPlatformOptions", "", "configureFromArgs", "Lorg/jetbrains/kotlin/cli/common/modules/ModuleBuilder;", "args", "Companion", "K2JVMCompilerPerformanceManager", "cli"})
public final class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    @NotNull
    private final CommonCompilerPerformanceManager defaultPerformanceManager = new K2JVMCompilerPerformanceManager();
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments2, @NotNull CompilerConfiguration configuration2, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)rootDisposable, (String)"rootDisposable");
        MessageCollector messageCollector = configuration2.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        String string2 = arguments2.getRepeatCompileModules();
        configuration2.putIfNotNull(CLIConfigurationKeys.REPEAT_COMPILE_MODULES, string2 != null ? StringsKt.toIntOrNull((String)string2) : null);
        configuration2.put(CLIConfigurationKeys.PHASE_CONFIG, CreatePhaseConfigKt.createPhaseConfig((CompilerPhase)JvmPhasesKt.getJvmPhases(), arguments2, messageCollector2));
        if (!JvmArgumentsKt.configureJdkHome(configuration2, arguments2)) {
            return ExitCode.COMPILATION_ERROR;
        }
        configuration2.put(JVMConfigurationKeys.DISABLE_STANDARD_SCRIPT_DEFINITION, arguments2.getDisableStandardScript());
        ExitCode pluginLoadResult = this.loadPlugins(paths, (CommonCompilerArguments)arguments2, configuration2);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        String string3 = arguments2.getModuleName();
        if (string3 == null) {
            string3 = "main";
        }
        String moduleName = string3;
        configuration2.put(CommonConfigurationKeys.MODULE_NAME, moduleName);
        JvmArgumentsKt.configureExplicitContentRoots(configuration2, arguments2);
        JvmArgumentsKt.configureStandardLibs(configuration2, paths, arguments2);
        JvmArgumentsKt.configureAdvancedJvmOptions(configuration2, arguments2);
        JvmArgumentsKt.configureKlibPaths(configuration2, arguments2);
        if (arguments2.getBuildFile() == null && !arguments2.getVersion() && !arguments2.getAllowNoSourceFiles() && (arguments2.getScript() || arguments2.getExpression() != null || arguments2.getFreeArgs().isEmpty())) {
            Object v6;
            KotlinCoreEnvironment.ProjectEnvironment projectEnvironment2;
            block32: {
                Iterable iterable;
                if (arguments2.getScript() && arguments2.getFreeArgs().isEmpty()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Specify script source path to evaluate", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                projectEnvironment2 = new KotlinCoreEnvironment.ProjectEnvironment(rootDisposable, KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForProduction(rootDisposable, configuration2), configuration2);
                projectEnvironment2.registerExtensionsFromPlugins(configuration2);
                if (arguments2.getScript() || arguments2.getExpression() != null) {
                    Object v4;
                    block31: {
                        Iterable iterable2;
                        MockProject mockProject = projectEnvironment2.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"projectEnvironment.project");
                        Iterable iterable3 = iterable2 = (Iterable)ScriptEvaluationExtension.Companion.getInstances((Project)mockProject);
                        for (Object t : iterable3) {
                            ScriptEvaluationExtension it = (ScriptEvaluationExtension)t;
                            boolean bl = false;
                            if (!it.isAccepted(arguments2)) continue;
                            v4 = t;
                            break block31;
                        }
                        v4 = null;
                    }
                    ScriptEvaluationExtension scriptingEvaluator = v4;
                    if (scriptingEvaluator == null) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to evaluate script, no scripting plugin loaded", null, 4, null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                    return scriptingEvaluator.eval(arguments2, configuration2, projectEnvironment2);
                }
                MockProject mockProject = projectEnvironment2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"projectEnvironment.project");
                Iterable iterable4 = iterable = (Iterable)ShellExtension.Companion.getInstances((Project)mockProject);
                for (Object t : iterable4) {
                    ShellExtension it = (ShellExtension)t;
                    boolean bl4 = false;
                    if (!it.isAccepted(arguments2)) continue;
                    v6 = t;
                    break block32;
                }
                v6 = null;
            }
            ShellExtension shell = v6;
            if (shell == null) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to run REPL, no scripting plugin loaded", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            return shell.run(arguments2, configuration2, projectEnvironment2);
        }
        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", null, 4, null);
        try {
            boolean bl;
            void names2;
            Object object;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ModuleChunk moduleChunk2;
            Object object2;
            File buildFile;
            File file2;
            File file3;
            String it;
            String string4 = arguments2.getDestination();
            if (string4 != null) {
                String shell;
                it = shell = string4;
                boolean bl2 = false;
                file3 = new File(it);
            } else {
                file3 = null;
            }
            File destination = file3;
            String string5 = arguments2.getBuildFile();
            if (string5 != null) {
                String it2 = it = string5;
                boolean bl3 = false;
                file2 = new File(it2);
            } else {
                file2 = buildFile = null;
            }
            if (buildFile != null) {
                Function1<String, Unit> $fun$strongWarning$1 = new Function1<String, Unit>(messageCollector2){
                    final /* synthetic */ MessageCollector $messageCollector;

                    public final void invoke(@NotNull String message) {
                        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                        MessageCollector.DefaultImpls.report$default(this.$messageCollector, CompilerMessageSeverity.STRONG_WARNING, message, null, 4, null);
                    }
                    {
                        this.$messageCollector = messageCollector;
                        super(1);
                    }
                };
                if (destination != null) {
                    $fun$strongWarning$1.invoke("The '-d' option with a directory destination is ignored because '-Xbuild-file' is specified");
                }
                if (arguments2.getJavaSourceRoots() != null) {
                    $fun$strongWarning$1.invoke("The '-Xjava-source-roots' option is ignored because '-Xbuild-file' is specified");
                }
                if (arguments2.getJavaPackagePrefix() != null) {
                    $fun$strongWarning$1.invoke("The '-Xjava-package-prefix' option is ignored because '-Xbuild-file' is specified");
                }
                object2 = (Function1)new Function1<CompilerMessageSeverity, Boolean>(CompilerMessageSeverity.VERBOSE){

                    public final boolean invoke(CompilerMessageSeverity p1) {
                        return ((EnumSet)this.receiver).contains((Object)((Object)p1));
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(EnumSet.class);
                    }

                    public final String getName() {
                        return "contains";
                    }

                    public final String getSignature() {
                        return "contains(Ljava/lang/Object;)Z";
                    }
                };
                FilteringMessageCollector sanitizedCollector2 = new FilteringMessageCollector(messageCollector2, new Predicate((Function1)object2){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    public final /* synthetic */ boolean test(Object p0) {
                        Object object = this.function.invoke(p0);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                        return (Boolean)object;
                    }
                });
                configuration2.put(JVMConfigurationKeys.MODULE_XML_FILE, buildFile);
                moduleChunk2 = CompileEnvironmentUtil.loadModuleChunk(buildFile, sanitizedCollector2);
            } else {
                Object object3;
                if (destination != null) {
                    String string6 = destination.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"destination.path");
                    if (StringsKt.endsWith$default((String)string6, (String)".jar", (boolean)false, (int)2, null)) {
                        configuration2.put(JVMConfigurationKeys.OUTPUT_JAR, destination);
                    } else {
                        configuration2.put(JVMConfigurationKeys.OUTPUT_DIRECTORY, destination);
                    }
                }
                if ((object3 = destination) == null || (object3 = ((File)object3).getPath()) == null) {
                    object3 = ".";
                }
                ModuleBuilder module2 = new ModuleBuilder(moduleName, (String)object3, "java-production");
                this.configureFromArgs(module2, arguments2);
                moduleChunk2 = new ModuleChunk(CollectionsKt.listOf((Object)module2));
            }
            Intrinsics.checkNotNullExpressionValue((Object)moduleChunk2, (String)"if (buildFile != null) {\u2026Of(module))\n            }");
            ModuleChunk moduleChunk3 = moduleChunk2;
            List<Module> list2 = moduleChunk3.getModules();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"moduleChunk.modules");
            List<Module> chunk = list2;
            KotlinToJVMBytecodeCompiler.INSTANCE.configureSourceRoots$cli(configuration2, chunk, buildFile);
            object2 = chunk;
            MessageCollector messageCollector3 = messageCollector2;
            CompilerConfiguration compilerConfiguration = configuration2;
            Disposable disposable = rootDisposable;
            K2JVMCompiler k2JVMCompiler = this;
            boolean $i$f$map22 = false;
            void bl4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void input;
                Module module3 = (Module)item$iv$iv;
                object = destination$iv$iv;
                boolean bl5 = false;
                String string7 = input.getModuleName() + "-" + input.getModuleType();
                object.add(string7);
            }
            object = (List)destination$iv$iv;
            Object $i$f$map22 = object2 = object;
            boolean bl6 = false;
            String string8 = (String)CollectionsKt.singleOrNull((List)names2);
            if (string8 == null) {
                string8 = CollectionsKt.joinToString$default((Iterable)((Iterable)names2), null, null, null, (int)0, null, null, (int)63, null);
            }
            object = string8;
            KotlinCoreEnvironment kotlinCoreEnvironment = k2JVMCompiler.createCoreEnvironment(disposable, compilerConfiguration, messageCollector3, (String)object);
            if (kotlinCoreEnvironment == null) {
                return ExitCode.COMPILATION_ERROR;
            }
            KotlinCoreEnvironment environment = kotlinCoreEnvironment;
            boolean it3 = bl = JvmArgumentsKt.registerJavacIfNeeded(environment, arguments2);
            boolean bl7 = false;
            if (!it3) {
                return ExitCode.COMPILATION_ERROR;
            }
            if (environment.getSourceFiles().isEmpty() && !arguments2.getAllowNoSourceFiles() && buildFile == null) {
                if (arguments2.getVersion()) {
                    return ExitCode.OK;
                }
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "No source files", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            KotlinToJVMBytecodeCompiler.compileModules$cli$default(KotlinToJVMBytecodeCompiler.INSTANCE, environment, buildFile, chunk, false, 8, null);
            return ExitCode.OK;
        }
        catch (CompilationException e) {
            String string9 = OutputMessageUtil.renderException(e);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"OutputMessageUtil.renderException(e)");
            messageCollector2.report(CompilerMessageSeverity.EXCEPTION, string9, MessageUtil.psiElementToMessageLocation(e.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
    }

    private final void configureFromArgs(ModuleBuilder $this$configureFromArgs, K2JVMCompilerArguments args) {
        Object object;
        String element$iv;
        int n;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        String[] stringArray = args.getFriendPaths();
        if (stringArray != null) {
            $this$forEach$iv = stringArray;
            $i$f$forEach = false;
            n = ((String[])$this$forEach$iv).length;
            for (int i = 0; i < n; ++i) {
                String it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                $this$configureFromArgs.addFriendDir(it);
            }
        }
        if ((object = args.getClasspath()) != null) {
            CharSequence charSequence2 = (CharSequence)object;
            String[] stringArray2 = new String[1];
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"File.pathSeparator");
            stringArray2[0] = string2;
            object = StringsKt.split$default((CharSequence)charSequence2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (object != null) {
                $this$forEach$iv = (Iterable)object;
                $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv2 = iterator2.next();
                    String it = (String)element$iv2;
                    boolean bl = false;
                    $this$configureFromArgs.addClasspathEntry(it);
                }
            }
        }
        String[] stringArray3 = args.getJavaSourceRoots();
        if (stringArray3 != null) {
            $this$forEach$iv = stringArray3;
            $i$f$forEach = false;
            n = ((String[])$this$forEach$iv).length;
            for (int i = 0; i < n; ++i) {
                String it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                $this$configureFromArgs.addJavaSourceRoot(new JavaRootPath(it, args.getJavaPackagePrefix()));
            }
        }
        Object[] objectArray = args.getCommonSources();
        Set $i$f$forEach2 = objectArray != null ? ArraysKt.toSet((Object[])objectArray) : null;
        Set set = $i$f$forEach2;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Set commonSources = set;
        for (String arg : args.getFreeArgs()) {
            if (StringsKt.endsWith$default((String)arg, (String)".java", (boolean)false, (int)2, null)) {
                $this$configureFromArgs.addJavaSourceRoot(new JavaRootPath(arg, args.getJavaPackagePrefix()));
                continue;
            }
            $this$configureFromArgs.addSourceFiles(arg);
            if (commonSources.contains(arg)) {
                $this$configureFromArgs.addCommonSourceFiles(arg);
            }
            if (!new File(arg).isDirectory()) continue;
            $this$configureFromArgs.addJavaSourceRoot(new JavaRootPath(arg, args.getJavaPackagePrefix()));
        }
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2JVMCompilerArguments arguments2) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter($this$addPlatformOptions, (String)"$this$addPlatformOptions");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        String[] stringArray2 = arguments2.getScriptTemplates();
        if (stringArray2 != null) {
            stringArray = stringArray2;
            if (!(stringArray.length == 0)) {
                StringBuilder stringBuilder2 = new StringBuilder().append("plugin:kotlin.scripting:script-templates=");
                Object[] objectArray = arguments2.getScriptTemplates();
                Intrinsics.checkNotNull((Object)objectArray);
                $this$addPlatformOptions.add(stringBuilder2.append(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).toString());
            }
        }
        String[] stringArray3 = arguments2.getScriptResolverEnvironment();
        if (stringArray3 != null) {
            stringArray = stringArray3;
            if (!(stringArray.length == 0)) {
                StringBuilder stringBuilder3 = new StringBuilder().append("plugin:kotlin.scripting:script-resolver-environment=");
                Object[] objectArray = arguments2.getScriptResolverEnvironment();
                Intrinsics.checkNotNull((Object)objectArray);
                $this$addPlatformOptions.add(stringBuilder3.append(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).toString());
            }
        }
    }

    private final KotlinCoreEnvironment createCoreEnvironment(Disposable rootDisposable, CompilerConfiguration configuration2, MessageCollector messageCollector, String targetDescription) {
        KotlinCoreEnvironment environment;
        block1: {
            if (messageCollector.hasErrors()) {
                return null;
            }
            environment = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration2, EnvironmentConfigFiles.JVM_CONFIG_FILES);
            List<KtFile> sourceFiles2 = environment.getSourceFiles();
            CommonCompilerPerformanceManager commonCompilerPerformanceManager = configuration2.get(CLIConfigurationKeys.PERF_MANAGER);
            if (commonCompilerPerformanceManager == null) break block1;
            commonCompilerPerformanceManager.notifyCompilerInitialized(sourceFiles2.size(), environment.countLinesOfCode$cli(sourceFiles2), targetDescription);
        }
        return messageCollector.hasErrors() ? null : environment;
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration2, @NotNull K2JVMCompilerArguments arguments2, @NotNull Services services) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        CompilerConfiguration $this$with = configuration2;
        boolean bl = false;
        if (IncrementalCompilation.isEnabledForJvm()) {
            $this$with.putIfNotNull(CommonConfigurationKeys.LOOKUP_TRACKER, services.get(LookupTracker.class));
            $this$with.putIfNotNull(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, services.get(ExpectActualTracker.class));
            $this$with.putIfNotNull(CommonConfigurationKeys.INLINE_CONST_TRACKER, services.get(InlineConstTracker.class));
            $this$with.putIfNotNull(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS, services.get(IncrementalCompilationComponents.class));
            $this$with.putIfNotNull(ClassicFrontendSpecificJvmConfigurationKeys.JAVA_CLASSES_TRACKER, services.get(JavaClassesTracker.class));
        }
        JvmArgumentsKt.setupJvmSpecificArguments($this$with, arguments2);
    }

    @Override
    @NotNull
    public K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments k2JVMCompilerArguments;
        K2JVMCompilerArguments $this$apply = k2JVMCompilerArguments = new K2JVMCompilerArguments();
        boolean bl = false;
        if (System.getenv("KOTLIN_REPORT_PERF") != null) {
            $this$apply.setReportPerf(true);
        }
        return k2JVMCompilerArguments;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc-jvm";
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkNotNullParameter((Object)versionArray, (String)"versionArray");
        return new JvmMetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @Override
    @NotNull
    public CommonCompilerPerformanceManager getDefaultPerformanceManager() {
        return this.defaultPerformanceManager;
    }

    @Override
    @NotNull
    protected CommonCompilerPerformanceManager createPerformanceManager(@NotNull K2JVMCompilerArguments arguments2, @NotNull Services services) {
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        CommonCompilerPerformanceManager externalManager = services.get(CommonCompilerPerformanceManager.class);
        if (externalManager != null) {
            return externalManager;
        }
        String string2 = arguments2.getProfileCompilerCommand();
        if (string2 == null) {
            return this.getDefaultPerformanceManager();
        }
        String argument2 = string2;
        return ProfilingCompilerPerformanceManager.Companion.create(argument2);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler$K2JVMCompilerPerformanceManager;", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "()V", "cli"})
    protected static final class K2JVMCompilerPerformanceManager
    extends CommonCompilerPerformanceManager {
        public K2JVMCompilerPerformanceManager() {
            super("Kotlin to JVM Compiler");
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler$Companion;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "cli"})
    public static final class Companion {
        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2JVMCompiler(), args);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

