/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDefaultErrorMessages;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.test.backend.handlers.NoFirCompilationErrorsHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/NoFirCompilationErrorsHandler;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "tests-common-new"})
public final class NoFirCompilationErrorsHandler
extends FirAnalysisHandler {
    public NoFirCompilationErrorsHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices, true, false, 4, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module2, @NotNull FirOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        boolean hasError = false;
        boolean ignoreErrors = module2.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_FIR_DIAGNOSTICS());
        for (Map.Entry<FirFile, List<FirDiagnostic>> entry : info.getFirAnalyzerFacade().runCheckers().entrySet()) {
            FirFile firFile = entry.getKey();
            List<FirDiagnostic> diagnostics2 = entry.getValue();
            for (FirDiagnostic diagnostic : diagnostics2) {
                String string2;
                PsiElement psiElement;
                PsiFile psiFile;
                if (diagnostic.getSeverity() != Severity.ERROR) continue;
                hasError = true;
                if (ignoreErrors) continue;
                String diagnosticText = FirDefaultErrorMessages.Companion.getRendererForDiagnostic(diagnostic).render(diagnostic);
                TextRange range = (TextRange)CollectionsKt.first(diagnostic.getTextRanges());
                FirSourceElement firSourceElement = firFile.getSource();
                PsiFile psiFile2 = firSourceElement == null ? null : (psiFile = (psiElement = FirSourceElementKt.getPsi(firSourceElement)) == null ? null : psiElement.getContainingFile());
                if (psiFile == null) {
                    string2 = firFile.getName() + ':' + range;
                } else {
                    FirSourceElement psiFile3 = firSourceElement = psiFile;
                    boolean bl = false;
                    string2 = PsiDiagnosticUtils.atLocation((PsiFile)psiFile3, range);
                }
                String string3 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"firFile.source?.psi?.con\u2026 \"${firFile.name}:$range\"");
                String locationText = string3;
                throw new IllegalStateException(diagnostic.getFactory().getName() + ": " + diagnosticText + " at " + locationText);
            }
        }
        if (!hasError && ignoreErrors) {
            this.getAssertions().fail((Function0<String>)((Function0)processModule.1.INSTANCE));
            throw null;
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }
}

