/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.DumpKotlinLikeKt;
import org.jetbrains.kotlin.ir.util.FakeOverridesStrategy;
import org.jetbrains.kotlin.ir.util.KotlinLikeDumpOptions;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.handlers.IrTextDumpHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrPrettyKotlinDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "Companion", "tests-common-new"})
public final class IrPrettyKotlinDumpHandler
extends AbstractIrHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiModuleInfoDumper dumper;
    @NotNull
    public static final String DUMP_EXTENSION = "kt.txt";

    public IrPrettyKotlinDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices, false, false, 6, null);
        this.dumper = new MultiModuleInfoDumper("// MODULE: %s");
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        Object[] objectArray = new SimpleDirectivesContainer[]{CodegenTestDirectives.INSTANCE, FirDiagnosticsDirectives.INSTANCE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module2, @NotNull IrBackendInput info) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module2.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_KT_IR()) || module2.getDirectives().contains(CodegenTestDirectives.INSTANCE.getSKIP_KT_DUMP())) {
            return;
        }
        List<IrFile> irFiles2 = info.getBackendInput().getIrModuleFragment().getFiles();
        StringBuilder builder2 = this.dumper.builderForModule(module2);
        Iterable $this$filter$iv = IrTextDumpHandler.Companion.groupWithTestFiles(irFiles2, module2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!((TestFile)it.getFirst()).getDirectives().contains(CodegenTestDirectives.INSTANCE.getEXTERNAL_FILE()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrFile irFile = (IrFile)it.getSecond();
            collection.add(irFile);
        }
        List filteredIrFiles = (List)destination$iv$iv;
        boolean printFileName = filteredIrFiles.size() > 1 || TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules().size() > 1;
        for (IrFile irFile : filteredIrFiles) {
            String dump2 = DumpKotlinLikeKt.dumpKotlinLike(irFile, new KotlinLikeDumpOptions(false, printFileName, false, false, null, FakeOverridesStrategy.NONE, false, 89, null));
            builder2.append(dump2);
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (this.dumper.isEmpty()) {
            return;
        }
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure(this.getTestServices());
        String extension = IrTextDumpHandler.Companion.computeDumpExtension((TestModule)CollectionsKt.first(moduleStructure.getModules()), DUMP_EXTENSION);
        File expectedFile = FileUtilsKt.withExtension((File)CollectionsKt.first(moduleStructure.getOriginalTestDataFiles()), extension);
        Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, this.dumper.generateResultingDump(), null, 4, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrPrettyKotlinDumpHandler$Companion;", "", "()V", "DUMP_EXTENSION", "", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

