/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.protobuf;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.protobuf.ByteString;
import org.jetbrains.kotlin.protobuf.Descriptors;
import org.jetbrains.kotlin.protobuf.ExtensionRegistry;
import org.jetbrains.kotlin.protobuf.Message;
import org.jetbrains.kotlin.protobuf.MessageOrBuilder;
import org.jetbrains.kotlin.protobuf.MessageReflection;
import org.jetbrains.kotlin.protobuf.UnknownFieldSet;
import org.jetbrains.kotlin.protobuf.WireFormat;

public final class TextFormat {
    private static final Logger logger = Logger.getLogger(TextFormat.class.getName());
    private static final Printer DEFAULT_PRINTER = new Printer();
    private static final Printer SINGLE_LINE_PRINTER = Printer.access$100(new Printer(), true);
    private static final Printer UNICODE_PRINTER = Printer.access$200(new Printer(), false);
    private static final Parser PARSER = Parser.newBuilder().build();

    private TextFormat() {
    }

    public static void print(MessageOrBuilder message2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.print(message2, new TextGenerator(output));
    }

    public static void print(UnknownFieldSet fields2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.printUnknownFields(fields2, new TextGenerator(output));
    }

    public static void printUnicode(MessageOrBuilder message2, Appendable output) throws IOException {
        TextFormat.UNICODE_PRINTER.print(message2, new TextGenerator(output));
    }

    public static void printUnicode(UnknownFieldSet fields2, Appendable output) throws IOException {
        TextFormat.UNICODE_PRINTER.printUnknownFields(fields2, new TextGenerator(output));
    }

    public static String shortDebugString(MessageOrBuilder message2) {
        try {
            StringBuilder sb = new StringBuilder();
            TextFormat.SINGLE_LINE_PRINTER.print(message2, new TextGenerator(sb));
            return sb.toString().trim();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String shortDebugString(UnknownFieldSet fields2) {
        try {
            StringBuilder sb = new StringBuilder();
            TextFormat.SINGLE_LINE_PRINTER.printUnknownFields(fields2, new TextGenerator(sb));
            return sb.toString().trim();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToString(MessageOrBuilder message2) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.print(message2, (Appendable)text2);
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToString(UnknownFieldSet fields2) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.print(fields2, (Appendable)text2);
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToUnicodeString(MessageOrBuilder message2) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.UNICODE_PRINTER.print(message2, new TextGenerator(text2));
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToUnicodeString(UnknownFieldSet fields2) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.UNICODE_PRINTER.printUnknownFields(fields2, new TextGenerator(text2));
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void printField(Descriptors.FieldDescriptor field2, Object value2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.printField(field2, value2, new TextGenerator(output));
    }

    public static String printFieldToString(Descriptors.FieldDescriptor field2, Object value2) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.printField(field2, value2, text2);
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void printFieldValue(Descriptors.FieldDescriptor field2, Object value2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.printFieldValue(field2, value2, new TextGenerator(output));
    }

    public static void printUnknownFieldValue(int tag, Object value2, Appendable output) throws IOException {
        TextFormat.printUnknownFieldValue(tag, value2, new TextGenerator(output));
    }

    private static void printUnknownFieldValue(int tag, Object value2, TextGenerator generator2) throws IOException {
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                generator2.print(TextFormat.unsignedToString((Long)value2));
                break;
            }
            case 5: {
                generator2.print(String.format((Locale)null, "0x%08x", (Integer)value2));
                break;
            }
            case 1: {
                generator2.print(String.format((Locale)null, "0x%016x", (Long)value2));
                break;
            }
            case 2: {
                generator2.print("\"");
                generator2.print(TextFormat.escapeBytes((ByteString)value2));
                generator2.print("\"");
                break;
            }
            case 3: {
                TextFormat.DEFAULT_PRINTER.printUnknownFields((UnknownFieldSet)value2, generator2);
                break;
            }
            default: {
                int n = tag;
                throw new IllegalArgumentException(new StringBuilder(20).append("Bad tag: ").append(n).toString());
            }
        }
    }

    public static String unsignedToString(int value2) {
        if (value2 >= 0) {
            return Integer.toString(value2);
        }
        return Long.toString((long)value2 & 0xFFFFFFFFL);
    }

    public static String unsignedToString(long value2) {
        if (value2 >= 0L) {
            return Long.toString(value2);
        }
        return BigInteger.valueOf(value2 & Long.MAX_VALUE).setBit(63).toString();
    }

    public static Parser getParser() {
        return PARSER;
    }

    public static void merge(Readable input, Message.Builder builder2) throws IOException {
        PARSER.merge(input, builder2);
    }

    public static void merge(CharSequence input, Message.Builder builder2) throws ParseException {
        PARSER.merge(input, builder2);
    }

    public static void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder2) throws IOException {
        PARSER.merge(input, extensionRegistry, builder2);
    }

    public static void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder2) throws ParseException {
        PARSER.merge(input, extensionRegistry, builder2);
    }

    private static String escapeBytes(ByteSequence input) {
        StringBuilder builder2 = new StringBuilder(input.size());
        block12: for (int i = 0; i < input.size(); ++i) {
            byte b = input.byteAt(i);
            switch (b) {
                case 7: {
                    builder2.append("\\a");
                    continue block12;
                }
                case 8: {
                    builder2.append("\\b");
                    continue block12;
                }
                case 12: {
                    builder2.append("\\f");
                    continue block12;
                }
                case 10: {
                    builder2.append("\\n");
                    continue block12;
                }
                case 13: {
                    builder2.append("\\r");
                    continue block12;
                }
                case 9: {
                    builder2.append("\\t");
                    continue block12;
                }
                case 11: {
                    builder2.append("\\v");
                    continue block12;
                }
                case 92: {
                    builder2.append("\\\\");
                    continue block12;
                }
                case 39: {
                    builder2.append("\\'");
                    continue block12;
                }
                case 34: {
                    builder2.append("\\\"");
                    continue block12;
                }
                default: {
                    if (b >= 32) {
                        builder2.append((char)b);
                        continue block12;
                    }
                    builder2.append('\\');
                    builder2.append((char)(48 + (b >>> 6 & 3)));
                    builder2.append((char)(48 + (b >>> 3 & 7)));
                    builder2.append((char)(48 + (b & 7)));
                }
            }
        }
        return builder2.toString();
    }

    static String escapeBytes(final ByteString input) {
        return TextFormat.escapeBytes(new ByteSequence(){

            public int size() {
                return input.size();
            }

            public byte byteAt(int offset2) {
                return input.byteAt(offset2);
            }
        });
    }

    static String escapeBytes(final byte[] input) {
        return TextFormat.escapeBytes(new ByteSequence(){

            public int size() {
                return input.length;
            }

            public byte byteAt(int offset2) {
                return input[offset2];
            }
        });
    }

    static ByteString unescapeBytes(CharSequence charString) throws InvalidEscapeSequenceException {
        ByteString input = ByteString.copyFromUtf8(charString.toString());
        byte[] result2 = new byte[input.size()];
        int pos = 0;
        for (int i = 0; i < input.size(); ++i) {
            byte c = input.byteAt(i);
            if (c == 92) {
                if (i + 1 < input.size()) {
                    int code;
                    if (TextFormat.isOctal(c = input.byteAt(++i))) {
                        code = TextFormat.digitValue(c);
                        if (i + 1 < input.size() && TextFormat.isOctal(input.byteAt(i + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.byteAt(++i));
                        }
                        if (i + 1 < input.size() && TextFormat.isOctal(input.byteAt(i + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.byteAt(++i));
                        }
                        result2[pos++] = (byte)code;
                        continue;
                    }
                    switch (c) {
                        case 97: {
                            result2[pos++] = 7;
                            break;
                        }
                        case 98: {
                            result2[pos++] = 8;
                            break;
                        }
                        case 102: {
                            result2[pos++] = 12;
                            break;
                        }
                        case 110: {
                            result2[pos++] = 10;
                            break;
                        }
                        case 114: {
                            result2[pos++] = 13;
                            break;
                        }
                        case 116: {
                            result2[pos++] = 9;
                            break;
                        }
                        case 118: {
                            result2[pos++] = 11;
                            break;
                        }
                        case 92: {
                            result2[pos++] = 92;
                            break;
                        }
                        case 39: {
                            result2[pos++] = 39;
                            break;
                        }
                        case 34: {
                            result2[pos++] = 34;
                            break;
                        }
                        case 120: {
                            code = 0;
                            if (i + 1 >= input.size() || !TextFormat.isHex(input.byteAt(i + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = TextFormat.digitValue(input.byteAt(++i));
                            if (i + 1 < input.size() && TextFormat.isHex(input.byteAt(i + 1))) {
                                code = code * 16 + TextFormat.digitValue(input.byteAt(++i));
                            }
                            result2[pos++] = (byte)code;
                            break;
                        }
                        default: {
                            char c2 = (char)c;
                            throw new InvalidEscapeSequenceException(new StringBuilder(29).append("Invalid escape sequence: '\\").append(c2).append("'").toString());
                        }
                    }
                    continue;
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            result2[pos++] = c;
        }
        return ByteString.copyFrom(result2, 0, pos);
    }

    static String escapeText(String input) {
        return TextFormat.escapeBytes(ByteString.copyFromUtf8(input));
    }

    public static String escapeDoubleQuotesAndBackslashes(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    static String unescapeText(String input) throws InvalidEscapeSequenceException {
        return TextFormat.unescapeBytes(input).toStringUtf8();
    }

    private static boolean isOctal(byte c) {
        return 48 <= c && c <= 55;
    }

    private static boolean isHex(byte c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    private static int digitValue(byte c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 122) {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    static int parseInt32(String text2) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text2, true, false);
    }

    static int parseUInt32(String text2) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text2, false, false);
    }

    static long parseInt64(String text2) throws NumberFormatException {
        return TextFormat.parseInteger(text2, true, true);
    }

    static long parseUInt64(String text2) throws NumberFormatException {
        return TextFormat.parseInteger(text2, false, true);
    }

    private static long parseInteger(String text2, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos = 0;
        boolean negative = false;
        if (text2.startsWith("-", pos)) {
            if (!isSigned) {
                String string2 = String.valueOf(text2);
                throw new NumberFormatException(string2.length() != 0 ? "Number must be positive: ".concat(string2) : new String("Number must be positive: "));
            }
            ++pos;
            negative = true;
        }
        int radix = 10;
        if (text2.startsWith("0x", pos)) {
            pos += 2;
            radix = 16;
        } else if (text2.startsWith("0", pos)) {
            radix = 8;
        }
        String numberText = text2.substring(pos);
        long result2 = 0L;
        if (numberText.length() < 16) {
            result2 = Long.parseLong(numberText, radix);
            if (negative) {
                result2 = -result2;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result2 > Integer.MAX_VALUE || result2 < Integer.MIN_VALUE) {
                        String string3 = String.valueOf(text2);
                        throw new NumberFormatException(string3.length() != 0 ? "Number out of range for 32-bit signed integer: ".concat(string3) : new String("Number out of range for 32-bit signed integer: "));
                    }
                } else if (result2 >= 0x100000000L || result2 < 0L) {
                    String string4 = String.valueOf(text2);
                    throw new NumberFormatException(string4.length() != 0 ? "Number out of range for 32-bit unsigned integer: ".concat(string4) : new String("Number out of range for 32-bit unsigned integer: "));
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        String string5 = String.valueOf(text2);
                        throw new NumberFormatException(string5.length() != 0 ? "Number out of range for 32-bit signed integer: ".concat(string5) : new String("Number out of range for 32-bit signed integer: "));
                    }
                } else if (bigValue.bitLength() > 32) {
                    String string6 = String.valueOf(text2);
                    throw new NumberFormatException(string6.length() != 0 ? "Number out of range for 32-bit unsigned integer: ".concat(string6) : new String("Number out of range for 32-bit unsigned integer: "));
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    String string7 = String.valueOf(text2);
                    throw new NumberFormatException(string7.length() != 0 ? "Number out of range for 64-bit signed integer: ".concat(string7) : new String("Number out of range for 64-bit signed integer: "));
                }
            } else if (bigValue.bitLength() > 64) {
                String string8 = String.valueOf(text2);
                throw new NumberFormatException(string8.length() != 0 ? "Number out of range for 64-bit unsigned integer: ".concat(string8) : new String("Number out of range for 64-bit unsigned integer: "));
            }
            result2 = bigValue.longValue();
        }
        return result2;
    }

    static class InvalidEscapeSequenceException
    extends IOException {
        private static final long serialVersionUID = -8164033650142593304L;

        InvalidEscapeSequenceException(String description2) {
            super(description2);
        }
    }

    private static interface ByteSequence {
        public int size();

        public byte byteAt(int var1);
    }

    public static class Parser {
        private final boolean allowUnknownFields;
        private final SingularOverwritePolicy singularOverwritePolicy;
        private static final int BUFFER_SIZE = 4096;

        private Parser(boolean allowUnknownFields, SingularOverwritePolicy singularOverwritePolicy) {
            this.allowUnknownFields = allowUnknownFields;
            this.singularOverwritePolicy = singularOverwritePolicy;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public void merge(Readable input, Message.Builder builder2) throws IOException {
            this.merge(input, ExtensionRegistry.getEmptyRegistry(), builder2);
        }

        public void merge(CharSequence input, Message.Builder builder2) throws ParseException {
            this.merge(input, ExtensionRegistry.getEmptyRegistry(), builder2);
        }

        public void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder2) throws IOException {
            this.merge(Parser.toStringBuilder(input), extensionRegistry, builder2);
        }

        private static StringBuilder toStringBuilder(Readable input) throws IOException {
            int n;
            StringBuilder text2 = new StringBuilder();
            CharBuffer buffer = CharBuffer.allocate(4096);
            while ((n = input.read(buffer)) != -1) {
                buffer.flip();
                text2.append(buffer, 0, n);
            }
            return text2;
        }

        public void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder2) throws ParseException {
            Tokenizer tokenizer = new Tokenizer(input);
            MessageReflection.BuilderAdapter target = new MessageReflection.BuilderAdapter(builder2);
            while (!tokenizer.atEnd()) {
                this.mergeField(tokenizer, extensionRegistry, target);
            }
        }

        private void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget target) throws ParseException {
            String string2;
            CharSequence name2;
            Descriptors.FieldDescriptor field2 = null;
            Descriptors.Descriptor type2 = target.getDescriptorForType();
            ExtensionRegistry.ExtensionInfo extension = null;
            if (tokenizer.tryConsume("[")) {
                name2 = new StringBuilder(tokenizer.consumeIdentifier());
                while (tokenizer.tryConsume(".")) {
                    ((StringBuilder)name2).append('.');
                    ((StringBuilder)name2).append(tokenizer.consumeIdentifier());
                }
                extension = target.findExtensionByName(extensionRegistry, ((StringBuilder)name2).toString());
                if (extension == null) {
                    if (!this.allowUnknownFields) {
                        String string3 = String.valueOf(String.valueOf(name2));
                        throw tokenizer.parseExceptionPreviousToken(new StringBuilder(48 + string3.length()).append("Extension \"").append(string3).append("\" not found in the ExtensionRegistry.").toString());
                    }
                    string2 = String.valueOf(String.valueOf(name2));
                    logger.warning(new StringBuilder(48 + string2.length()).append("Extension \"").append(string2).append("\" not found in the ExtensionRegistry.").toString());
                } else {
                    if (extension.descriptor.getContainingType() != type2) {
                        String string4 = String.valueOf(String.valueOf(name2));
                        String string5 = String.valueOf(String.valueOf(type2.getFullName()));
                        throw tokenizer.parseExceptionPreviousToken(new StringBuilder(45 + string4.length() + string5.length()).append("Extension \"").append(string4).append("\" does not extend message type \"").append(string5).append("\".").toString());
                    }
                    field2 = extension.descriptor;
                }
                tokenizer.consume("]");
            } else {
                String lowerName;
                name2 = tokenizer.consumeIdentifier();
                field2 = type2.findFieldByName((String)name2);
                if (field2 == null && (field2 = type2.findFieldByName(lowerName = ((String)name2).toLowerCase(Locale.US))) != null && field2.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                    field2 = null;
                }
                if (field2 != null && field2.getType() == Descriptors.FieldDescriptor.Type.GROUP && !field2.getMessageType().getName().equals(name2)) {
                    field2 = null;
                }
                if (field2 == null) {
                    if (!this.allowUnknownFields) {
                        string2 = String.valueOf(String.valueOf(type2.getFullName()));
                        String string6 = String.valueOf(String.valueOf(name2));
                        throw tokenizer.parseExceptionPreviousToken(new StringBuilder(38 + string2.length() + string6.length()).append("Message type \"").append(string2).append("\" has no field named \"").append(string6).append("\".").toString());
                    }
                    string2 = String.valueOf(String.valueOf(type2.getFullName()));
                    String string7 = String.valueOf(String.valueOf(name2));
                    logger.warning(new StringBuilder(38 + string2.length() + string7.length()).append("Message type \"").append(string2).append("\" has no field named \"").append(string7).append("\".").toString());
                }
            }
            if (field2 == null) {
                if (tokenizer.tryConsume(":") && !tokenizer.lookingAt("{") && !tokenizer.lookingAt("<")) {
                    this.skipFieldValue(tokenizer);
                } else {
                    this.skipFieldMessage(tokenizer);
                }
                return;
            }
            if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                tokenizer.tryConsume(":");
            } else {
                tokenizer.consume(":");
            }
            if (field2.isRepeated() && tokenizer.tryConsume("[")) {
                while (true) {
                    this.consumeFieldValue(tokenizer, extensionRegistry, target, field2, extension);
                    if (!tokenizer.tryConsume("]")) {
                        tokenizer.consume(",");
                        continue;
                    }
                    break;
                }
            } else {
                this.consumeFieldValue(tokenizer, extensionRegistry, target, field2, extension);
            }
        }

        private void consumeFieldValue(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget target, Descriptors.FieldDescriptor field2, ExtensionRegistry.ExtensionInfo extension) throws ParseException {
            Object enumType;
            Object value2 = null;
            if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                String endToken;
                if (tokenizer.tryConsume("<")) {
                    endToken = ">";
                } else {
                    tokenizer.consume("{");
                    endToken = "}";
                }
                MessageReflection.MergeTarget subField = target.newMergeTargetForField(field2, extension == null ? null : extension.defaultInstance);
                while (!tokenizer.tryConsume(endToken)) {
                    if (tokenizer.atEnd()) {
                        String string2 = String.valueOf(String.valueOf(endToken));
                        throw tokenizer.parseException(new StringBuilder(12 + string2.length()).append("Expected \"").append(string2).append("\".").toString());
                    }
                    this.mergeField(tokenizer, extensionRegistry, subField);
                }
                value2 = subField.finish();
            } else {
                switch (field2.getType()) {
                    case INT32: 
                    case SINT32: 
                    case SFIXED32: {
                        value2 = tokenizer.consumeInt32();
                        break;
                    }
                    case INT64: 
                    case SINT64: 
                    case SFIXED64: {
                        value2 = tokenizer.consumeInt64();
                        break;
                    }
                    case UINT32: 
                    case FIXED32: {
                        value2 = tokenizer.consumeUInt32();
                        break;
                    }
                    case UINT64: 
                    case FIXED64: {
                        value2 = tokenizer.consumeUInt64();
                        break;
                    }
                    case FLOAT: {
                        value2 = Float.valueOf(tokenizer.consumeFloat());
                        break;
                    }
                    case DOUBLE: {
                        value2 = tokenizer.consumeDouble();
                        break;
                    }
                    case BOOL: {
                        value2 = tokenizer.consumeBoolean();
                        break;
                    }
                    case STRING: {
                        value2 = tokenizer.consumeString();
                        break;
                    }
                    case BYTES: {
                        value2 = tokenizer.consumeByteString();
                        break;
                    }
                    case ENUM: {
                        enumType = field2.getEnumType();
                        if (tokenizer.lookingAtInteger()) {
                            int number2 = tokenizer.consumeInt32();
                            value2 = ((Descriptors.EnumDescriptor)enumType).findValueByNumber(number2);
                            if (value2 != null) break;
                            String string3 = String.valueOf(String.valueOf(((Descriptors.EnumDescriptor)enumType).getFullName()));
                            int n = number2;
                            throw tokenizer.parseExceptionPreviousToken(new StringBuilder(50 + string3.length()).append("Enum type \"").append(string3).append("\" has no value with number ").append(n).append(".").toString());
                        }
                        String id = tokenizer.consumeIdentifier();
                        value2 = ((Descriptors.EnumDescriptor)enumType).findValueByName(id);
                        if (value2 != null) break;
                        String string4 = String.valueOf(String.valueOf(((Descriptors.EnumDescriptor)enumType).getFullName()));
                        String string5 = String.valueOf(String.valueOf(id));
                        throw tokenizer.parseExceptionPreviousToken(new StringBuilder(35 + string4.length() + string5.length()).append("Enum type \"").append(string4).append("\" has no value named \"").append(string5).append("\".").toString());
                    }
                    case MESSAGE: 
                    case GROUP: {
                        throw new RuntimeException("Can't get here.");
                    }
                }
            }
            if (field2.isRepeated()) {
                target.addRepeatedField(field2, value2);
            } else {
                if (this.singularOverwritePolicy == SingularOverwritePolicy.FORBID_SINGULAR_OVERWRITES && target.hasField(field2)) {
                    enumType = String.valueOf(String.valueOf(field2.getFullName()));
                    throw tokenizer.parseExceptionPreviousToken(new StringBuilder(44 + ((String)enumType).length()).append("Non-repeated field \"").append((String)enumType).append("\" cannot be overwritten.").toString());
                }
                if (this.singularOverwritePolicy == SingularOverwritePolicy.FORBID_SINGULAR_OVERWRITES && field2.getContainingOneof() != null && target.hasOneof(field2.getContainingOneof())) {
                    Descriptors.OneofDescriptor oneof = field2.getContainingOneof();
                    String string6 = String.valueOf(String.valueOf(field2.getFullName()));
                    String string7 = String.valueOf(String.valueOf(target.getOneofFieldDescriptor(oneof).getFullName()));
                    String string8 = String.valueOf(String.valueOf(oneof.getName()));
                    throw tokenizer.parseExceptionPreviousToken(new StringBuilder(70 + string6.length() + string7.length() + string8.length()).append("Field \"").append(string6).append("\" is specified along with field \"").append(string7).append("\", another member of oneof \"").append(string8).append("\".").toString());
                }
                target.setField(field2, value2);
            }
        }

        private void skipField(Tokenizer tokenizer) throws ParseException {
            if (tokenizer.tryConsume("[")) {
                do {
                    tokenizer.consumeIdentifier();
                } while (tokenizer.tryConsume("."));
                tokenizer.consume("]");
            } else {
                tokenizer.consumeIdentifier();
            }
            if (tokenizer.tryConsume(":") && !tokenizer.lookingAt("<") && !tokenizer.lookingAt("{")) {
                this.skipFieldValue(tokenizer);
            } else {
                this.skipFieldMessage(tokenizer);
            }
            if (!tokenizer.tryConsume(";")) {
                tokenizer.tryConsume(",");
            }
        }

        private void skipFieldMessage(Tokenizer tokenizer) throws ParseException {
            String delimiter;
            if (tokenizer.tryConsume("<")) {
                delimiter = ">";
            } else {
                tokenizer.consume("{");
                delimiter = "}";
            }
            while (!tokenizer.lookingAt(">") && !tokenizer.lookingAt("}")) {
                this.skipField(tokenizer);
            }
            tokenizer.consume(delimiter);
        }

        private void skipFieldValue(Tokenizer tokenizer) throws ParseException {
            if (tokenizer.tryConsumeString()) {
                while (tokenizer.tryConsumeString()) {
                }
                return;
            }
            if (!(tokenizer.tryConsumeIdentifier() || tokenizer.tryConsumeInt64() || tokenizer.tryConsumeUInt64() || tokenizer.tryConsumeDouble() || tokenizer.tryConsumeFloat())) {
                String string2 = String.valueOf(tokenizer.currentToken);
                throw tokenizer.parseException(string2.length() != 0 ? "Invalid field value: ".concat(string2) : new String("Invalid field value: "));
            }
        }

        public static class Builder {
            private boolean allowUnknownFields = false;
            private SingularOverwritePolicy singularOverwritePolicy = SingularOverwritePolicy.ALLOW_SINGULAR_OVERWRITES;

            public Builder setSingularOverwritePolicy(SingularOverwritePolicy p) {
                this.singularOverwritePolicy = p;
                return this;
            }

            public Parser build() {
                return new Parser(this.allowUnknownFields, this.singularOverwritePolicy);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SingularOverwritePolicy {
            ALLOW_SINGULAR_OVERWRITES,
            FORBID_SINGULAR_OVERWRITES;

        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 3196188060225107702L;
        private final int line;
        private final int column;

        public ParseException(String message2) {
            this(-1, -1, message2);
        }

        public ParseException(int line, int column, String message2) {
            String string2 = String.valueOf(String.valueOf(Integer.toString(line)));
            int n = column;
            String string3 = String.valueOf(String.valueOf(message2));
            super(new StringBuilder(14 + string2.length() + string3.length()).append(string2).append(":").append(n).append(": ").append(string3).toString());
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        private Tokenizer(CharSequence text2) {
            this.text = text2;
            this.matcher = WHITESPACE.matcher(text2);
            this.skipWhitespace();
            this.nextToken();
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String token) {
            if (this.currentToken.equals(token)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String token) throws ParseException {
            if (!this.tryConsume(token)) {
                String string2 = String.valueOf(String.valueOf(token));
                throw this.parseException(new StringBuilder(12 + string2.length()).append("Expected \"").append(string2).append("\".").toString());
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c = this.currentToken.charAt(0);
            return '0' <= c && c <= '9' || c == '-' || c == '+';
        }

        public boolean lookingAt(String text2) {
            return this.currentToken.equals(text2);
        }

        public String consumeIdentifier() throws ParseException {
            for (int i = 0; i < this.currentToken.length(); ++i) {
                char c = this.currentToken.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.') continue;
                String string2 = String.valueOf(String.valueOf(this.currentToken));
                throw this.parseException(new StringBuilder(29 + string2.length()).append("Expected identifier. Found '").append(string2).append("'").toString());
            }
            String result2 = this.currentToken;
            this.nextToken();
            return result2;
        }

        public boolean tryConsumeIdentifier() {
            try {
                this.consumeIdentifier();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public int consumeInt32() throws ParseException {
            try {
                int result2 = TextFormat.parseInt32(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public int consumeUInt32() throws ParseException {
            try {
                int result2 = TextFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeInt64() throws ParseException {
            try {
                long result2 = TextFormat.parseInt64(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public boolean tryConsumeInt64() {
            try {
                this.consumeInt64();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public long consumeUInt64() throws ParseException {
            try {
                long result2 = TextFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public boolean tryConsumeUInt64() {
            try {
                this.consumeUInt64();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double result2 = Double.parseDouble(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public boolean tryConsumeDouble() {
            try {
                this.consumeDouble();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float result2 = Float.parseFloat(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public boolean tryConsumeFloat() {
            try {
                this.consumeFloat();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true") || this.currentToken.equals("t") || this.currentToken.equals("1")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false") || this.currentToken.equals("f") || this.currentToken.equals("0")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\".");
        }

        public String consumeString() throws ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public boolean tryConsumeString() {
            try {
                this.consumeString();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public ByteString consumeByteString() throws ParseException {
            ArrayList<ByteString> list2 = new ArrayList<ByteString>();
            this.consumeByteString(list2);
            while (this.currentToken.startsWith("'") || this.currentToken.startsWith("\"")) {
                this.consumeByteString(list2);
            }
            return ByteString.copyFrom(list2);
        }

        private void consumeByteString(List<ByteString> list2) throws ParseException {
            char quote;
            char c = quote = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (quote != '\"' && quote != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != quote) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String escaped = this.currentToken.substring(1, this.currentToken.length() - 1);
                ByteString result2 = TextFormat.unescapeBytes(escaped);
                this.nextToken();
                list2.add(result2);
            }
            catch (InvalidEscapeSequenceException e) {
                throw this.parseException(e.getMessage());
            }
        }

        public ParseException parseException(String description2) {
            return new ParseException(this.line + 1, this.column + 1, description2);
        }

        public ParseException parseExceptionPreviousToken(String description2) {
            return new ParseException(this.previousLine + 1, this.previousColumn + 1, description2);
        }

        private ParseException integerParseException(NumberFormatException e) {
            String string2 = String.valueOf(e.getMessage());
            return this.parseException(string2.length() != 0 ? "Couldn't parse integer: ".concat(string2) : new String("Couldn't parse integer: "));
        }

        private ParseException floatParseException(NumberFormatException e) {
            String string2 = String.valueOf(e.getMessage());
            return this.parseException(string2.length() != 0 ? "Couldn't parse number: ".concat(string2) : new String("Couldn't parse number: "));
        }
    }

    private static final class TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private boolean atStartOfLine = true;

        private TextGenerator(Appendable output) {
            this.output = output;
        }

        public void indent() {
            this.indent.append("  ");
        }

        public void outdent() {
            int length = this.indent.length();
            if (length == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.delete(length - 2, length);
        }

        public void print(CharSequence text2) throws IOException {
            int size = text2.length();
            int pos = 0;
            for (int i = 0; i < size; ++i) {
                if (text2.charAt(i) != '\n') continue;
                this.write(text2.subSequence(pos, i + 1));
                pos = i + 1;
                this.atStartOfLine = true;
            }
            this.write(text2.subSequence(pos, size));
        }

        private void write(CharSequence data) throws IOException {
            if (data.length() == 0) {
                return;
            }
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.indent);
            }
            this.output.append(data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Printer {
        boolean singleLineMode = false;
        boolean escapeNonAscii = true;

        private Printer() {
        }

        private Printer setSingleLineMode(boolean singleLineMode) {
            this.singleLineMode = singleLineMode;
            return this;
        }

        private Printer setEscapeNonAscii(boolean escapeNonAscii) {
            this.escapeNonAscii = escapeNonAscii;
            return this;
        }

        private void print(MessageOrBuilder message2, TextGenerator generator2) throws IOException {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> field2 : message2.getAllFields().entrySet()) {
                this.printField(field2.getKey(), field2.getValue(), generator2);
            }
            this.printUnknownFields(message2.getUnknownFields(), generator2);
        }

        private void printField(Descriptors.FieldDescriptor field2, Object value2, TextGenerator generator2) throws IOException {
            if (field2.isRepeated()) {
                for (Object element : (List)value2) {
                    this.printSingleField(field2, element, generator2);
                }
            } else {
                this.printSingleField(field2, value2, generator2);
            }
        }

        private void printSingleField(Descriptors.FieldDescriptor field2, Object value2, TextGenerator generator2) throws IOException {
            if (field2.isExtension()) {
                generator2.print("[");
                if (field2.getContainingType().getOptions().getMessageSetWireFormat() && field2.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field2.isOptional() && field2.getExtensionScope() == field2.getMessageType()) {
                    generator2.print(field2.getMessageType().getFullName());
                } else {
                    generator2.print(field2.getFullName());
                }
                generator2.print("]");
            } else if (field2.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator2.print(field2.getMessageType().getName());
            } else {
                generator2.print(field2.getName());
            }
            if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (this.singleLineMode) {
                    generator2.print(" { ");
                } else {
                    generator2.print(" {\n");
                    generator2.indent();
                }
            } else {
                generator2.print(": ");
            }
            this.printFieldValue(field2, value2, generator2);
            if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (this.singleLineMode) {
                    generator2.print("} ");
                } else {
                    generator2.outdent();
                    generator2.print("}\n");
                }
            } else if (this.singleLineMode) {
                generator2.print(" ");
            } else {
                generator2.print("\n");
            }
        }

        private void printFieldValue(Descriptors.FieldDescriptor field2, Object value2, TextGenerator generator2) throws IOException {
            switch (field2.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    generator2.print(((Integer)value2).toString());
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    generator2.print(((Long)value2).toString());
                    break;
                }
                case BOOL: {
                    generator2.print(((Boolean)value2).toString());
                    break;
                }
                case FLOAT: {
                    generator2.print(((Float)value2).toString());
                    break;
                }
                case DOUBLE: {
                    generator2.print(((Double)value2).toString());
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    generator2.print(TextFormat.unsignedToString((Integer)value2));
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    generator2.print(TextFormat.unsignedToString((Long)value2));
                    break;
                }
                case STRING: {
                    generator2.print("\"");
                    generator2.print(this.escapeNonAscii ? TextFormat.escapeText((String)value2) : TextFormat.escapeDoubleQuotesAndBackslashes((String)value2));
                    generator2.print("\"");
                    break;
                }
                case BYTES: {
                    generator2.print("\"");
                    if (value2 instanceof ByteString) {
                        generator2.print(TextFormat.escapeBytes((ByteString)value2));
                    } else {
                        generator2.print(TextFormat.escapeBytes((byte[])value2));
                    }
                    generator2.print("\"");
                    break;
                }
                case ENUM: {
                    generator2.print(((Descriptors.EnumValueDescriptor)value2).getName());
                    break;
                }
                case MESSAGE: 
                case GROUP: {
                    this.print((Message)value2, generator2);
                }
            }
        }

        private void printUnknownFields(UnknownFieldSet unknownFields, TextGenerator generator2) throws IOException {
            for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFields.asMap().entrySet()) {
                int number2 = entry.getKey();
                UnknownFieldSet.Field field2 = entry.getValue();
                this.printUnknownField(number2, 0, field2.getVarintList(), generator2);
                this.printUnknownField(number2, 5, field2.getFixed32List(), generator2);
                this.printUnknownField(number2, 1, field2.getFixed64List(), generator2);
                this.printUnknownField(number2, 2, field2.getLengthDelimitedList(), generator2);
                for (UnknownFieldSet value2 : field2.getGroupList()) {
                    generator2.print(entry.getKey().toString());
                    if (this.singleLineMode) {
                        generator2.print(" { ");
                    } else {
                        generator2.print(" {\n");
                        generator2.indent();
                    }
                    this.printUnknownFields(value2, generator2);
                    if (this.singleLineMode) {
                        generator2.print("} ");
                        continue;
                    }
                    generator2.outdent();
                    generator2.print("}\n");
                }
            }
        }

        private void printUnknownField(int number2, int wireType, List<?> values2, TextGenerator generator2) throws IOException {
            for (Object value2 : values2) {
                generator2.print(String.valueOf(number2));
                generator2.print(": ");
                TextFormat.printUnknownFieldValue(wireType, value2, generator2);
                generator2.print(this.singleLineMode ? " " : "\n");
            }
        }

        static /* synthetic */ Printer access$100(Printer x0, boolean x1) {
            return x0.setSingleLineMode(x1);
        }

        static /* synthetic */ Printer access$200(Printer x0, boolean x1) {
            return x0.setEscapeNonAscii(x1);
        }
    }
}

