/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirImportsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirDeprecationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory1;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirErrorImport;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.scopes.impl.FirClassDeclaredMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J0\u0010\u001b\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00170\u001dH\u0002J\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u0018*\u00020 2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010!\u001a\u00020\u0017*\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkAllUnderFromEnumEntry", "import", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "checkCanBeImported", "checkConflictingImports", "imports", "", "checkDeprecatedImport", "checkOperatorRename", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "canBeImported", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "name", "Lorg/jetbrains/kotlin/name/Name;", "hasFunction", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "resolveToClass", "Lorg/jetbrains/kotlin/name/ClassId;", "resolvesToClass", "checkers"})
public final class FirImportsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirImportsChecker INSTANCE = new FirImportsChecker();

    private FirImportsChecker() {
    }

    @Override
    public void check(@NotNull FirFile declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Iterable $this$forEach$iv = declaration2.getImports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirImport firImport = (FirImport)element$iv;
            boolean bl = false;
            if (firImport instanceof FirErrorImport) continue;
            if (firImport.isAllUnder() && !(firImport instanceof FirResolvedImport)) {
                INSTANCE.checkAllUnderFromEnumEntry(firImport, context2, reporter);
            }
            if (!firImport.isAllUnder()) {
                INSTANCE.checkCanBeImported(firImport, context2, reporter);
                if (firImport instanceof FirResolvedImport) {
                    INSTANCE.checkOperatorRename((FirResolvedImport)firImport, context2, reporter);
                }
            }
            INSTANCE.checkDeprecatedImport(firImport, context2, reporter);
        }
        this.checkConflictingImports(declaration2.getImports(), context2, reporter);
    }

    private final void checkAllUnderFromEnumEntry(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter) {
        FqName fqName2 = firImport.getImportedFqName();
        if (fqName2 == null) {
            return;
        }
        FqName fqName3 = fqName2;
        if (fqName3.isRoot() || fqName3.parent().isRoot()) {
            return;
        }
        ClassId classId = ClassId.topLevel(fqName3.parent());
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(fqName.parent())");
        ClassId classId2 = classId;
        Object object = this.resolveToClass(classId2, context2);
        if (object == null) {
            return;
        }
        FirRegularClassSymbol classSymbol = object;
        FirClassSymbol $this$isEnumClass$iv = classSymbol;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        if (bl) {
            boolean bl2;
            block8: {
                Iterable $this$any$iv = FirHelpersKt.collectEnumEntries(classSymbol);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirEnumEntrySymbol it = (FirEnumEntrySymbol)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getCallableId().getCallableName(), (Object)fqName3.shortName())) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                FirSourceElement firSourceElement = firImport.getSource();
                FirDiagnosticFactory1<Name> firDiagnosticFactory1 = FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON();
                object = classSymbol.getClassId().getShortClassName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classSymbol.classId.shortClassName");
                DiagnosticReporterKt.reportOn$default(reporter, firSourceElement, firDiagnosticFactory1, object, context2, null, 16, null);
            }
        }
    }

    private final void checkCanBeImported(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter) {
        block16: {
            Object object;
            FqName importedFqName;
            block18: {
                block17: {
                    Name importedName;
                    block15: {
                        ClassId classId;
                        block14: {
                            block13: {
                                FqName fqName2 = firImport.getImportedFqName();
                                if (fqName2 == null) {
                                    return;
                                }
                                importedFqName = fqName2;
                                Object object2 = importedFqName.shortName();
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"importedFqName.shortName()");
                                importedName = object2;
                                if (importedName.isSpecial()) break block13;
                                object2 = importedName.getIdentifier();
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"importedName.identifier");
                                if (!(((CharSequence)object2).length() == 0)) break block14;
                            }
                            return;
                        }
                        FirResolvedImport firResolvedImport = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
                        ClassId classId2 = classId = firResolvedImport == null ? null : firResolvedImport.getResolvedClassId();
                        if (classId == null) break block15;
                        FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(classId, context2);
                        if (firRegularClassSymbol == null) {
                            return;
                        }
                        FirRegularClassSymbol classSymbol = firRegularClassSymbol;
                        if (classSymbol.getClassKind().isSingleton()) {
                            return;
                        }
                        if (!this.canBeImported(classSymbol, context2, importedName)) {
                            DiagnosticReporterKt.reportOn$default(reporter, firImport.getSource(), FirErrors.INSTANCE.getCANNOT_BE_IMPORTED(), (Object)importedName, context2, null, 16, null);
                        }
                        break block16;
                    }
                    object = ClassId.topLevel(importedFqName);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topLevel(importedFqName)");
                    ClassId importedClassId = object;
                    if (this.resolveToClass(importedClassId, context2) != null) break block17;
                    FirSymbolProvider firSymbolProvider = MainSessionComponentsKt.getSymbolProvider(context2.getSession());
                    object = importedFqName.parent();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"importedFqName.parent()");
                    if (!(!((Collection)firSymbolProvider.getTopLevelCallableSymbols((FqName)object, importedName)).isEmpty())) break block18;
                }
                return;
            }
            object = MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getPackage(importedFqName);
            if (object != null) {
                Object object3;
                Object it = object3 = object;
                boolean bl = false;
                DiagnosticReporterKt.reportOn$default(reporter, firImport.getSource(), FirErrors.INSTANCE.getPACKAGE_CANNOT_BE_IMPORTED(), context2, null, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConflictingImports(List<? extends FirImport> imports, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$forEach$iv;
        Object it;
        Iterable $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv;
        Name name2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Iterable iterable = imports;
        boolean $i$f$filterIsInstance = false;
        Iterator iterator2 = $this$filterIsInstance$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirResolvedImport)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String string2;
            FirResolvedImport firResolvedImport = (FirResolvedImport)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !firResolvedImport.isAllUnder() && ((name2 = firResolvedImport.getImportedName()) == null ? false : ((string2 = name2.getIdentifierOrNullIfSpecial()) == null ? false : ((CharSequence)string2).length() > 0)) && INSTANCE.resolvesToClass(firResolvedImport, context2);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List interestingImports = (List)destination$iv$iv;
        $this$filter$iv = interestingImports;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Name name3;
            it = (FirResolvedImport)element$iv$iv;
            boolean bl = false;
            name2 = ((FirResolvedImport)it).getAliasName();
            if (name2 == null) {
                Name name4 = ((FirResolvedImport)it).getImportedName();
                name3 = name4;
                Intrinsics.checkNotNull((Object)name4);
            } else {
                name3 = name2;
            }
            Name key$iv$iv = name3;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List conflicts = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = conflicts;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                FirResolvedImport it2 = (FirResolvedImport)element$iv2;
                boolean bl4 = false;
                FirSourceElement firSourceElement = it2.getSource();
                FirDiagnosticFactory1<Name> firDiagnosticFactory1 = FirErrors.INSTANCE.getCONFLICTING_IMPORT();
                Name name5 = it2.getImportedName();
                Intrinsics.checkNotNull((Object)name5);
                DiagnosticReporterKt.reportOn$default(reporter, firSourceElement, firDiagnosticFactory1, (Object)name5, context2, null, 16, null);
            }
        }
    }

    private final void checkOperatorRename(FirResolvedImport firResolvedImport, CheckerContext context2, DiagnosticReporter reporter) {
        boolean illegalRename2;
        block10: {
            boolean bl;
            Name name2 = firResolvedImport.getAliasName();
            if (name2 == null) {
                return;
            }
            Name alias = name2;
            Name name3 = firResolvedImport.getImportedName();
            if (name3 == null) {
                return;
            }
            Name importedName = name3;
            if (!OperatorConventions.isConventionName(alias)) {
                return;
            }
            ClassId classId = firResolvedImport.getResolvedClassId();
            if (classId != null) {
                FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(classId, context2);
                if (firRegularClassSymbol == null) {
                    return;
                }
                FirRegularClassSymbol classFir = firRegularClassSymbol;
                bl = classFir.getClassKind().isSingleton() && this.hasFunction(classFir, context2, importedName, (Function1<? super FirNamedFunctionSymbol, Boolean>)((Function1)checkOperatorRename.illegalRename.1.INSTANCE));
            } else {
                Iterable $this$any$iv = MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getTopLevelFunctionSymbols(firResolvedImport.getPackageFqName(), importedName);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirNamedFunctionSymbol it = (FirNamedFunctionSymbol)element$iv;
                        boolean bl2 = false;
                        FirCallableSymbol $this$isOperator$iv = it;
                        boolean $i$f$isOperator = false;
                        if (!$this$isOperator$iv.getResolvedStatus().isOperator()) continue;
                        bl = true;
                        break block10;
                    }
                    bl = illegalRename2 = false;
                }
            }
        }
        if (illegalRename2) {
            DiagnosticReporterKt.reportOn$default(reporter, firResolvedImport.getSource(), FirErrors.INSTANCE.getOPERATOR_RENAMED_ON_IMPORT(), context2, null, 8, null);
        }
    }

    private final boolean resolvesToClass(FirResolvedImport $this$resolvesToClass, CheckerContext context2) {
        if ($this$resolvesToClass.getResolvedClassId() != null) {
            if ($this$resolvesToClass.isAllUnder()) {
                return true;
            }
            ClassId classId = $this$resolvesToClass.getResolvedClassId();
            Intrinsics.checkNotNull((Object)classId);
            ClassId parentClass = classId;
            FqName fqName2 = $this$resolvesToClass.getRelativeClassName();
            if (fqName2 == null) {
                return false;
            }
            FqName relativeClassName = fqName2;
            Name name2 = $this$resolvesToClass.getImportedName();
            if (name2 == null) {
                return false;
            }
            Name importedName = name2;
            ClassId innerClassId = new ClassId(parentClass.getPackageFqName(), relativeClassName.child(importedName), false);
            return this.resolveToClass(innerClassId, context2) != null;
        }
        FqName relativeClassName = $this$resolvesToClass.getImportedFqName();
        if (relativeClassName == null) {
            return false;
        }
        FqName importedFqName = relativeClassName;
        if (importedFqName.isRoot()) {
            return false;
        }
        ClassId classId = ClassId.topLevel(importedFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(importedFqName)");
        ClassId importedClassId = classId;
        return this.resolveToClass(importedClassId, context2) != null;
    }

    private final FirRegularClassSymbol resolveToClass(ClassId $this$resolveToClass, CheckerContext context2) {
        FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName($this$resolveToClass);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol = firClassLikeSymbol;
        return (firClassLikeSymbol = classSymbol) instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)classSymbol : (firClassLikeSymbol instanceof FirTypeAliasSymbol ? FirHelpersKt.fullyExpandedClass(classSymbol, context2.getSession()) : null);
    }

    private final boolean hasFunction(FirRegularClassSymbol $this$hasFunction, CheckerContext context2, Name name2, Function1<? super FirNamedFunctionSymbol, Boolean> predicate) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$hasFunction).processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(result2, predicate){
            final /* synthetic */ Ref.BooleanRef $result;
            final /* synthetic */ Function1<FirNamedFunctionSymbol, Boolean> $predicate;
            {
                this.$result = $result;
                this.$predicate = $predicate;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol sym) {
                Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
                if (!this.$result.element) {
                    this.$result.element = (Boolean)this.$predicate.invoke((Object)sym);
                }
            }
        }));
        return result2.element;
    }

    private final boolean canBeImported(FirRegularClassSymbol $this$canBeImported, CheckerContext context2, Name name2) {
        Ref.BooleanRef hasStatic = new Ref.BooleanRef();
        Ref.BooleanRef hasIllegal = new Ref.BooleanRef();
        FirClassDeclaredMemberScope scope2 = FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$canBeImported);
        scope2.processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(hasStatic, hasIllegal){
            final /* synthetic */ Ref.BooleanRef $hasStatic;
            final /* synthetic */ Ref.BooleanRef $hasIllegal;
            {
                this.$hasStatic = $hasStatic;
                this.$hasIllegal = $hasIllegal;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol sym) {
                Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
                if (FirCallableSymbolKt.isStatic(sym)) {
                    this.$hasStatic.element = true;
                } else {
                    this.$hasIllegal.element = true;
                }
            }
        }));
        if (hasStatic.element) {
            return true;
        }
        if (hasIllegal.element) {
            return false;
        }
        scope2.processPropertiesByName(name2, (Function1)new Function1<FirVariableSymbol<?>, Unit>(hasStatic, hasIllegal){
            final /* synthetic */ Ref.BooleanRef $hasStatic;
            final /* synthetic */ Ref.BooleanRef $hasIllegal;
            {
                this.$hasStatic = $hasStatic;
                this.$hasIllegal = $hasIllegal;
                super(1);
            }

            public final void invoke(@NotNull FirVariableSymbol<?> sym) {
                Intrinsics.checkNotNullParameter(sym, (String)"sym");
                if (FirCallableSymbolKt.isStatic((FirCallableSymbol)sym)) {
                    this.$hasStatic.element = true;
                } else {
                    this.$hasIllegal.element = true;
                }
            }
        });
        return hasStatic.element || !hasIllegal.element;
    }

    private final void checkDeprecatedImport(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter) {
        Object object;
        ClassId classId;
        Object importedFqName;
        block8: {
            block7: {
                Object object2 = firImport.getImportedFqName();
                if (object2 == null) {
                    return;
                }
                importedFqName = object2;
                if (((FqName)importedFqName).isRoot()) break block7;
                object2 = ((FqName)importedFqName).shortName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"importedFqName.shortName().asString()");
                if (!(((CharSequence)object2).length() == 0)) break block8;
            }
            return;
        }
        Object object3 = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
        ClassId classId2 = classId = object3 == null ? null : ((FirResolvedImport)object3).getResolvedClassId();
        if (classId == null) {
            object3 = ClassId.topLevel((FqName)importedFqName);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"topLevel(importedFqName)");
            object = object3;
        } else {
            object = classId;
        }
        ClassId classId3 = object;
        object3 = this.resolveToClass(classId3, context2);
        if (object3 == null) {
            return;
        }
        Object classLike = object3;
        FirDeprecationChecker.INSTANCE.reportDeprecationIfNeeded$checkers(firImport.getSource(), (FirBasedSymbol)classLike, null, context2, reporter);
    }
}

