/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatforms;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.builders.LanguageVersionSettingsBuilder;
import org.jetbrains.kotlin.test.directives.AdditionalFilesDirectives;
import org.jetbrains.kotlin.test.directives.ModuleStructureDirectives;
import org.jetbrains.kotlin.test.directives.TargetPlatformEnum;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.BackendKinds;
import org.jetbrains.kotlin.test.model.BinaryKind;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.DependencyRelation;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AdditionalSourceProvider;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.DefaultRegisteredDirectivesProviderKt;
import org.jetbrains.kotlin.test.services.DefaultsProvider;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.ExceptionFromModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.ModuleStructureExtractor;
import org.jetbrains.kotlin.test.services.ModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.impl.ModuleStructureExtractorImpl;
import org.jetbrains.kotlin.test.services.impl.ModuleStructureExtractorImplKt;
import org.jetbrains.kotlin.test.services.impl.RegisteredDirectivesParser;
import org.jetbrains.kotlin.test.services.impl.TestModuleStructureImpl;
import org.jetbrains.kotlin.test.util.StringUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl;", "Lorg/jetbrains/kotlin/test/services/ModuleStructureExtractor;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "additionalSourceProviders", "", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "moduleStructureTransformers", "Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;", "environmentConfigurators", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "splitTestDataByModules", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "testDataFileName", "", "directivesContainer", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "Companion", "ModuleNameAndDependencies", "ModuleStructureExtractorWorker", "tests-common-new"})
public final class ModuleStructureExtractorImpl
extends ModuleStructureExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<EnvironmentConfigurator> environmentConfigurators;
    @NotNull
    private static final List<String> allowedExtensionsForFiles;
    @NotNull
    private static final Regex moduleDirectiveRegex;

    public ModuleStructureExtractorImpl(@NotNull TestServices testServices, @NotNull List<? extends AdditionalSourceProvider> additionalSourceProviders, @NotNull List<? extends ModuleStructureTransformer> moduleStructureTransformers, @NotNull List<? extends EnvironmentConfigurator> environmentConfigurators) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter(additionalSourceProviders, (String)"additionalSourceProviders");
        Intrinsics.checkNotNullParameter(moduleStructureTransformers, (String)"moduleStructureTransformers");
        Intrinsics.checkNotNullParameter(environmentConfigurators, (String)"environmentConfigurators");
        super(testServices, additionalSourceProviders, moduleStructureTransformers);
        this.environmentConfigurators = environmentConfigurators;
    }

    @Override
    @NotNull
    public TestModuleStructure splitTestDataByModules(@NotNull String testDataFileName, @NotNull DirectivesContainer directivesContainer) {
        Intrinsics.checkNotNullParameter((Object)testDataFileName, (String)"testDataFileName");
        Intrinsics.checkNotNullParameter((Object)directivesContainer, (String)"directivesContainer");
        File testDataFile = new File(testDataFileName);
        ModuleStructureExtractorWorker extractor = new ModuleStructureExtractorWorker(CollectionsKt.listOf((Object)testDataFile), directivesContainer);
        TestModuleStructure result2 = extractor.splitTestDataByModules();
        for (ModuleStructureTransformer transformer2 : this.getModuleStructureTransformers()) {
            TestModuleStructure testModuleStructure;
            try {
                testModuleStructure = transformer2.transformModuleStructure(result2);
            }
            catch (Throwable e) {
                throw new ExceptionFromModuleStructureTransformer(e, result2);
            }
            result2 = testModuleStructure;
        }
        return result2;
    }

    static {
        Object[] objectArray = new String[]{".kt", ".kts", ".java"};
        allowedExtensionsForFiles = CollectionsKt.listOf((Object[])objectArray);
        moduleDirectiveRegex = new Regex("([\\w-]+)(\\((.*?)\\)(\\((.*?)\\)(\\((.*?)\\))?)?)?");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$Companion;", "", "()V", "allowedExtensionsForFiles", "", "", "moduleDirectiveRegex", "Lkotlin/text/Regex;", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u00104\u001a\u0002052\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0003H\u0002J\u0010\u00106\u001a\u0002052\u0006\u00107\u001a\u00020'H\u0002J\b\u00108\u001a\u000205H\u0002J\u0010\u00109\u001a\u0002052\u0006\u00107\u001a\u00020'H\u0002J\b\u0010:\u001a\u00020\u0011H\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010\u00162\u0006\u0010<\u001a\u00020\rH\u0002J\b\u0010=\u001a\u000205H\u0002J\b\u0010>\u001a\u000205H\u0002J\b\u0010?\u001a\u000205H\u0002J\u001c\u0010@\u001a\b\u0012\u0004\u0012\u0002030\u00032\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0003H\u0002J\u0010\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\rH\u0002J\u0006\u0010D\u001a\u00020EJ\u0012\u0010F\u001a\u0002052\b\u0010G\u001a\u0004\u0018\u00010HH\u0002J\u001a\u0010I\u001a\u00020,2\b\u0010G\u001a\u0004\u0018\u00010H2\u0006\u00107\u001a\u00020'H\u0002J\u0010\u0010J\u001a\u0002052\u0006\u0010K\u001a\u00020\rH\u0002J*\u0010L\u001a\u000205*\u00020M2\b\b\u0002\u0010N\u001a\u00020,2\b\b\u0002\u0010O\u001a\u00020,2\b\b\u0002\u0010P\u001a\u00020,H\u0002R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u0002030\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleStructureExtractorWorker;", "", "testDataFiles", "", "Ljava/io/File;", "directivesContainer", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "(Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl;Ljava/util/List;Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;)V", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "getAssertions", "()Lorg/jetbrains/kotlin/test/Assertions;", "currentFileName", "", "currentModuleFrontendKind", "Lorg/jetbrains/kotlin/test/model/FrontendKind;", "currentModuleLanguageVersionSettingsBuilder", "Lorg/jetbrains/kotlin/test/builders/LanguageVersionSettingsBuilder;", "currentModuleName", "currentModuleTargetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "currentModuleTargetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "currentTestDataFile", "defaultFileName", "getDefaultFileName", "()Ljava/lang/String;", "defaultModuleName", "getDefaultModuleName", "defaultsProvider", "Lorg/jetbrains/kotlin/test/services/DefaultsProvider;", "getDefaultsProvider", "()Lorg/jetbrains/kotlin/test/services/DefaultsProvider;", "dependenciesOfCurrentModule", "", "Lorg/jetbrains/kotlin/test/model/DependencyDescription;", "directivesBuilder", "Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser;", "endLineNumberOfLastFile", "", "fileDirectivesBuilder", "filesOfCurrentModule", "Lorg/jetbrains/kotlin/test/model/TestFile;", "firstFileInModule", "", "globalDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "linesOfCurrentFile", "moduleDirectivesBuilder", "moduleStructureDirectiveBuilder", "modules", "Lorg/jetbrains/kotlin/test/model/TestModule;", "checkCycles", "", "finishFile", "lineNumber", "finishGlobalDirectives", "finishModule", "initLanguageSettingsBuilder", "parseModulePlatformByName", "moduleName", "resetDirectivesBuilder", "resetFileCaches", "resetModuleCaches", "sortModules", "splitRawModuleStringToNameAndDependencies", "Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleNameAndDependencies;", "moduleDirectiveString", "splitTestDataByModules", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "tryParseRegularDirective", "rawDirective", "Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$RawDirective;", "tryParseStructureDirective", "validateFileName", "fileName", "checkDirectiveApplicability", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "contextIsGlobal", "contextIsModule", "contextIsFile", "tests-common-new"})
    private final class ModuleStructureExtractorWorker {
        @NotNull
        private final List<File> testDataFiles;
        @NotNull
        private final DirectivesContainer directivesContainer;
        private File currentTestDataFile;
        @Nullable
        private String currentModuleName;
        @Nullable
        private TargetPlatform currentModuleTargetPlatform;
        @Nullable
        private FrontendKind<?> currentModuleFrontendKind;
        @Nullable
        private TargetBackend currentModuleTargetBackend;
        @NotNull
        private LanguageVersionSettingsBuilder currentModuleLanguageVersionSettingsBuilder;
        @NotNull
        private List<DependencyDescription> dependenciesOfCurrentModule;
        @NotNull
        private List<TestFile> filesOfCurrentModule;
        @Nullable
        private String currentFileName;
        private boolean firstFileInModule;
        @NotNull
        private List<String> linesOfCurrentFile;
        private int endLineNumberOfLastFile;
        @NotNull
        private RegisteredDirectivesParser directivesBuilder;
        @NotNull
        private RegisteredDirectivesParser moduleDirectivesBuilder;
        @Nullable
        private RegisteredDirectivesParser fileDirectivesBuilder;
        @Nullable
        private RegisteredDirectives globalDirectives;
        @NotNull
        private final List<TestModule> modules;
        @NotNull
        private final RegisteredDirectivesParser moduleStructureDirectiveBuilder;

        public ModuleStructureExtractorWorker(@NotNull List<? extends File> testDataFiles, DirectivesContainer directivesContainer) {
            Intrinsics.checkNotNullParameter((Object)ModuleStructureExtractorImpl.this, (String)"this$0");
            Intrinsics.checkNotNullParameter(testDataFiles, (String)"testDataFiles");
            Intrinsics.checkNotNullParameter((Object)directivesContainer, (String)"directivesContainer");
            this.testDataFiles = testDataFiles;
            this.directivesContainer = directivesContainer;
            this.currentModuleLanguageVersionSettingsBuilder = this.initLanguageSettingsBuilder();
            this.dependenciesOfCurrentModule = new ArrayList();
            this.filesOfCurrentModule = new ArrayList();
            this.firstFileInModule = true;
            this.linesOfCurrentFile = new ArrayList();
            this.endLineNumberOfLastFile = -1;
            this.moduleDirectivesBuilder = this.directivesBuilder = new RegisteredDirectivesParser(this.directivesContainer, this.getAssertions());
            this.modules = new ArrayList();
            this.moduleStructureDirectiveBuilder = new RegisteredDirectivesParser(ModuleStructureDirectives.INSTANCE, this.getAssertions());
        }

        private final Assertions getAssertions() {
            return AssertionsKt.getAssertions(ModuleStructureExtractorImpl.this.getTestServices());
        }

        private final DefaultsProvider getDefaultsProvider() {
            return DefaultsProviderKt.getDefaultsProvider(ModuleStructureExtractorImpl.this.getTestServices());
        }

        private final String getDefaultFileName() {
            File file2;
            File file3 = this.currentTestDataFile;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentTestDataFile");
                file2 = null;
            } else {
                file2 = file3;
            }
            String string2 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentTestDataFile.name");
            return string2;
        }

        private final String getDefaultModuleName() {
            return "main";
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TestModuleStructure splitTestDataByModules() {
            Iterator<File> iterator2 = this.testDataFiles.iterator();
            while (iterator2.hasNext()) {
                File testDataFile;
                this.currentTestDataFile = testDataFile = iterator2.next();
                List lines = FilesKt.readLines$default((File)testDataFile, null, (int)1, null);
                Iterable $this$forEachIndexed$iv = lines;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void line;
                    int n = index$iv;
                    index$iv = n + 1;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string2 = (String)item$iv;
                    int lineNumber = n;
                    boolean bl = false;
                    RegisteredDirectivesParser.RawDirective rawDirective = RegisteredDirectivesParser.Companion.parseDirective((String)line);
                    if (this.tryParseStructureDirective(rawDirective, lineNumber + 1)) {
                        this.linesOfCurrentFile.add((String)line);
                        continue;
                    }
                    this.tryParseRegularDirective(rawDirective);
                    this.linesOfCurrentFile.add((String)line);
                }
            }
            this.finishModule(-1);
            List<TestModule> sortedModules = this.sortModules(this.modules);
            this.checkCycles(this.modules);
            return new TestModuleStructureImpl(sortedModules, this.testDataFiles);
        }

        /*
         * WARNING - void declaration
         */
        private final List<TestModule> sortModules(List<TestModule> modules) {
            void $this$mapValuesTo$iv$iv;
            Object answer$iv$iv$iv;
            Object key$iv$iv;
            Map $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = modules;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object object;
                Object element$iv$iv = iterator2.next();
                TestModule it = (TestModule)element$iv$iv;
                boolean bl = false;
                key$iv$iv = it.getName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $dstr$name$modules;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Object k = it$iv$iv.getKey();
                answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map2 = map;
                boolean bl3 = false;
                String name2 = (String)$dstr$name$modules.getKey();
                List modules2 = (List)$dstr$name$modules.getValue();
                TestModule testModule = (TestModule)CollectionsKt.singleOrNull((List)modules2);
                if (testModule == null) {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Duplicated modules with name ", (Object)name2).toString());
                }
                TestModule testModule2 = testModule;
                map2.put(k2, testModule2);
            }
            Map moduleByName = destination$iv$iv;
            List<TestModule> list2 = DFS.topologicalOrder((Iterable)modules, arg_0 -> ModuleStructureExtractorWorker.sortModules$lambda-4(moduleByName, arg_0));
            Intrinsics.checkNotNullExpressionValue(list2, (String)"topologicalOrder(modules\u2026          }\n            }");
            return CollectionsKt.asReversedMutable(list2);
        }

        private final void checkCycles(List<TestModule> modules) {
            Set visited2 = new LinkedHashSet();
            for (TestModule module2 : modules) {
                String moduleName = module2.getName();
                visited2.add(moduleName);
                for (DependencyDescription dependency : module2.getAllDependencies()) {
                    String dependencyName = dependency.getModuleName();
                    if (Intrinsics.areEqual((Object)dependencyName, (Object)moduleName)) {
                        throw new IllegalStateException(("Module " + moduleName + " has dependency to itself").toString());
                    }
                    if (visited2.contains(dependencyName)) continue;
                    throw new IllegalStateException(("There is cycle in modules dependencies. See modules: " + dependencyName + ", " + moduleName).toString());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final boolean tryParseStructureDirective(RegisteredDirectivesParser.RawDirective rawDirective, int lineNumber) {
            if (rawDirective == null) {
                return false;
            }
            RegisteredDirectivesParser.ParsedDirective parsedDirective = this.moduleStructureDirectiveBuilder.convertToRegisteredDirective(rawDirective);
            if (parsedDirective == null) {
                return false;
            }
            RegisteredDirectivesParser.ParsedDirective parsedDirective2 = parsedDirective;
            Directive directive2 = parsedDirective2.component1();
            List<?> values2 = parsedDirective2.component2();
            Directive directive3 = directive2;
            if (Intrinsics.areEqual((Object)directive3, (Object)ModuleStructureDirectives.INSTANCE.getMODULE())) {
                DependencyDescription dependencyDescription;
                String name2;
                Collection collection;
                Iterable $this$mapTo$iv;
                if (this.currentModuleName != null) {
                    this.finishModule(lineNumber);
                } else {
                    this.finishGlobalDirectives();
                }
                ModuleNameAndDependencies moduleNameAndDependencies = this.splitRawModuleStringToNameAndDependencies(CollectionsKt.joinToString$default((Iterable)values2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                String moduleName = moduleNameAndDependencies.component1();
                List<String> dependencies2 = moduleNameAndDependencies.component2();
                List<String> friends = moduleNameAndDependencies.component3();
                List<String> dependsOn = moduleNameAndDependencies.component4();
                this.currentModuleName = moduleName;
                DependencyKind kind = this.getDefaultsProvider().getDefaultDependencyKind();
                Iterable iterable = dependencies2;
                Collection destination$iv = this.dependenciesOfCurrentModule;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    String string2 = (String)item$iv;
                    collection = destination$iv;
                    boolean bl = false;
                    dependencyDescription = new DependencyDescription(name2, kind, DependencyRelation.RegularDependency);
                    collection.add(dependencyDescription);
                }
                $this$mapTo$iv = friends;
                destination$iv = this.dependenciesOfCurrentModule;
                $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    name2 = (String)item$iv;
                    collection = destination$iv;
                    boolean bl = false;
                    dependencyDescription = new DependencyDescription(name2, kind, DependencyRelation.FriendDependency);
                    collection.add(dependencyDescription);
                }
                $this$mapTo$iv = dependsOn;
                destination$iv = this.dependenciesOfCurrentModule;
                $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    name2 = (String)item$iv;
                    collection = destination$iv;
                    boolean bl = false;
                    dependencyDescription = new DependencyDescription(name2, DependencyKind.Source, DependencyRelation.DependsOnDependency);
                    collection.add(dependencyDescription);
                }
            } else if (Intrinsics.areEqual((Object)directive3, (Object)ModuleStructureDirectives.INSTANCE.getDEPENDENCY()) ? true : Intrinsics.areEqual((Object)directive3, (Object)ModuleStructureDirectives.INSTANCE.getDEPENDS_ON())) {
                DependencyRelation dependencyRelation;
                DependencyKind dependencyKind;
                Object friends;
                String name3;
                block42: {
                    Object moduleName = CollectionsKt.first(values2);
                    if (moduleName == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    name3 = (String)moduleName;
                    friends = CollectionsKt.getOrNull(values2, (int)1);
                    if (friends == null) {
                        dependencyKind = null;
                    } else {
                        Object dependsOn;
                        Object it = dependsOn = friends;
                        boolean bl = false;
                        String value$iv = (String)it;
                        boolean $i$f$valueOfOrNull = false;
                        for (DependencyKind enumValue$iv : DependencyKind.values()) {
                            if (!Intrinsics.areEqual((Object)enumValue$iv.name(), (Object)value$iv)) continue;
                            dependencyKind = enumValue$iv;
                            break block42;
                        }
                        dependencyKind = null;
                    }
                }
                DependencyKind dependencies2 = dependencyKind;
                DependencyKind kind = dependencies2 == null ? this.getDefaultsProvider().getDefaultDependencyKind() : dependencies2;
                friends = directive2;
                if (Intrinsics.areEqual((Object)friends, (Object)ModuleStructureDirectives.INSTANCE.getDEPENDENCY())) {
                    dependencyRelation = DependencyRelation.RegularDependency;
                } else if (Intrinsics.areEqual((Object)friends, (Object)ModuleStructureDirectives.INSTANCE.getDEPENDS_ON())) {
                    dependencyRelation = DependencyRelation.DependsOnDependency;
                } else {
                    throw new IllegalStateException("Should not be here".toString());
                }
                DependencyRelation relation = dependencyRelation;
                this.dependenciesOfCurrentModule.add(new DependencyDescription(name3, kind, relation));
            } else if (Intrinsics.areEqual((Object)directive3, (Object)ModuleStructureDirectives.INSTANCE.getTARGET_FRONTEND())) {
                Object kind;
                Object relation = CollectionsKt.singleOrNull(values2);
                Object object = kind = relation instanceof String ? (String)relation : null;
                if (kind == null) {
                    this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(directive2){
                        final /* synthetic */ Directive $directive;
                        {
                            this.$directive = $directive;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return Intrinsics.stringPlus((String)"Target frontend specified incorrectly\nUsage: ", (Object)this.$directive.getDescription());
                        }
                    }));
                    throw null;
                }
                Object name4 = kind;
                if ((kind = FrontendKinds.INSTANCE.fromString((String)name4)) == null) {
                    this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>((String)name4){
                        final /* synthetic */ String $name;
                        {
                            this.$name = $name;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return Intrinsics.stringPlus((String)"Unknown frontend: ", (Object)this.$name);
                        }
                    }));
                    throw null;
                }
                this.currentModuleFrontendKind = kind;
            } else if (Intrinsics.areEqual((Object)directive3, ModuleStructureDirectives.INSTANCE.getTARGET_BACKEND_KIND())) {
                Object name4 = CollectionsKt.single(values2);
                if (name4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.test.TargetBackend");
                }
                this.currentModuleTargetBackend = (TargetBackend)((Object)name4);
            } else if (Intrinsics.areEqual((Object)directive3, (Object)ModuleStructureDirectives.INSTANCE.getFILE())) {
                void p0;
                if (this.currentFileName != null) {
                    this.finishFile(lineNumber);
                } else {
                    this.resetFileCaches();
                }
                Object name4 = CollectionsKt.first(values2);
                if (name4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                Object kind = name4 = (String)name4;
                ModuleStructureExtractorWorker moduleStructureExtractorWorker = this;
                boolean bl = false;
                this.validateFileName((String)p0);
                Unit unit2 = Unit.INSTANCE;
                moduleStructureExtractorWorker.currentFileName = name4;
            } else if (Intrinsics.areEqual((Object)directive3, ModuleStructureDirectives.INSTANCE.getTARGET_PLATFORM())) {
                TargetPlatform targetPlatform;
                Object object;
                Collection $this$mapTo$iv$iv;
                if (this.currentModuleTargetPlatform != null) {
                    this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(this){
                        final /* synthetic */ ModuleStructureExtractorWorker this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return Intrinsics.stringPlus((String)"Target platform already specified twice for module ", (Object)ModuleStructureExtractorWorker.access$getCurrentModuleName$p(this.this$0));
                        }
                    }));
                    throw null;
                }
                Iterable $this$map$iv = values2;
                boolean $i$f$map2 = false;
                Iterable friends = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator bl = $this$mapTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object $i$f$valueOfOrNull = item$iv$iv = bl.next();
                    object = destination$iv$iv;
                    boolean bl2 = false;
                    if (it == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.test.directives.TargetPlatformEnum");
                    }
                    TargetPlatform targetPlatform2 = ((TargetPlatformEnum)it).getTargetPlatform();
                    object.add(targetPlatform2);
                }
                List platforms = (List)destination$iv$iv;
                Object object2 = this;
                int n = platforms.size();
                switch (n) {
                    case 0: {
                        this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(directive2){
                            final /* synthetic */ Directive $directive;
                            {
                                this.$directive = $directive;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return Intrinsics.stringPlus((String)"Target platform specified incorrectly\nUsage: ", (Object)this.$directive.getDescription());
                            }
                        }));
                        throw null;
                    }
                    case 1: {
                        targetPlatform = (TargetPlatform)CollectionsKt.single((List)platforms);
                        break;
                    }
                    default: {
                        void destination$iv;
                        void $this$flatMapTo$iv;
                        if (CollectionsKt.contains((Iterable)values2, (Object)((Object)TargetPlatformEnum.Common))) {
                            this.getAssertions().fail((Function0<String>)((Function0)tryParseStructureDirective.8.INSTANCE));
                            throw null;
                        }
                        Iterable $i$f$map2 = platforms;
                        $this$mapTo$iv$iv = new LinkedHashSet();
                        object = object2;
                        boolean $i$f$flatMapTo = false;
                        for (Object element$iv : $this$flatMapTo$iv) {
                            TargetPlatform it = (TargetPlatform)element$iv;
                            boolean bl3 = false;
                            Iterable list$iv = it.getComponentPlatforms();
                            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                        }
                        void var22_61 = destination$iv;
                        object2 = object;
                        Set set = (Set)var22_61;
                        targetPlatform = new TargetPlatform(set);
                    }
                }
                ((ModuleStructureExtractorWorker)object2).currentModuleTargetPlatform = targetPlatform;
            } else {
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final ModuleNameAndDependencies splitRawModuleStringToNameAndDependencies(String moduleDirectiveString) {
            List list2;
            List list3;
            String[] directives2;
            List list4;
            Object object;
            String[] stringArray;
            MatchResult matchResult = moduleDirectiveRegex.matchEntire((CharSequence)moduleDirectiveString);
            if (matchResult == null) {
                throw new IllegalStateException(('\"' + moduleDirectiveString + "\" doesn't matches with pattern \"moduleName(dep1, dep2)\"").toString());
            }
            MatchResult matchResult2 = matchResult;
            matchResult = matchResult2.getDestructured();
            String name2 = (String)matchResult.getMatch().getGroupValues().get(1);
            String[] dependencies2 = (String[])matchResult.getMatch().getGroupValues().get(3);
            String friends = (String)matchResult.getMatch().getGroupValues().get(5);
            String dependsOn = (String)matchResult.getMatch().getGroupValues().get(7);
            List dependenciesNames = null;
            String[] it = stringArray = dependencies2;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            Object object2 = object = bl2 ? stringArray : null;
            if (object == null) {
                list4 = CollectionsKt.emptyList();
            } else {
                stringArray = new String[]{" "};
                list4 = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            }
            dependenciesNames = list4;
            object = this.globalDirectives;
            if (object != null) {
                directives2 = stringArray = object;
                boolean bl3 = false;
                if (directives2.contains(AdditionalFilesDirectives.INSTANCE.getWITH_COROUTINES())) {
                    List list5;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = dependenciesNames;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it2 = (String)element$iv$iv;
                        boolean bl4 = false;
                        if (!(!Intrinsics.areEqual((Object)it2, (Object)"support"))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    dependenciesNames = list5 = (List)destination$iv$iv;
                }
            }
            directives2 = stringArray = friends;
            List list6 = dependenciesNames;
            String string2 = name2;
            boolean bl5 = false;
            boolean bl6 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            Object object3 = object = bl6 ? stringArray : null;
            if (object == null) {
                list3 = CollectionsKt.emptyList();
            } else {
                stringArray = new String[]{" "};
                list3 = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            }
            it = stringArray = dependsOn;
            List list7 = list3;
            boolean bl7 = false;
            boolean bl8 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            Object object4 = object = bl8 ? stringArray : null;
            if (object == null) {
                list2 = CollectionsKt.emptyList();
            } else {
                stringArray = new String[]{" "};
                list2 = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            }
            List list8 = list2;
            List list9 = list7;
            List list10 = list6;
            String string3 = string2;
            return new ModuleNameAndDependencies(string3, list10, list9, list8);
        }

        /*
         * WARNING - void declaration
         */
        private final void finishGlobalDirectives() {
            void directives2;
            RegisteredDirectives registeredDirectives;
            RegisteredDirectives registeredDirectives2 = registeredDirectives = this.directivesBuilder.build();
            ModuleStructureExtractorWorker moduleStructureExtractorWorker = this;
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)directives2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Directive it = (Directive)element$iv;
                boolean bl2 = false;
                ModuleStructureExtractorWorker.checkDirectiveApplicability$default(this, it, true, false, false, 6, null);
            }
            Unit unit2 = Unit.INSTANCE;
            moduleStructureExtractorWorker.globalDirectives = registeredDirectives;
            this.resetModuleCaches();
            this.resetFileCaches();
        }

        private final void checkDirectiveApplicability(Directive $this$checkDirectiveApplicability, boolean contextIsGlobal, boolean contextIsModule, boolean contextIsFile) {
            List list2;
            if ($this$checkDirectiveApplicability.getApplicability().getForGlobal() && contextIsGlobal) {
                return;
            }
            if ($this$checkDirectiveApplicability.getApplicability().getForModule() && contextIsModule) {
                return;
            }
            if ($this$checkDirectiveApplicability.getApplicability().getForFile() && contextIsFile) {
                return;
            }
            List $this$checkDirectiveApplicability_u24lambda_u2d18 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (contextIsGlobal) {
                $this$checkDirectiveApplicability_u24lambda_u2d18.add("Global");
            }
            if (contextIsModule) {
                $this$checkDirectiveApplicability_u24lambda_u2d18.add("Module");
            }
            if (contextIsFile) {
                $this$checkDirectiveApplicability_u24lambda_u2d18.add("File");
            }
            String context2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.build((List)list2), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalStateException(("Directive " + $this$checkDirectiveApplicability + " has " + (Object)((Object)$this$checkDirectiveApplicability.getApplicability()) + " applicability but it declared in " + context2).toString());
        }

        static /* synthetic */ void checkDirectiveApplicability$default(ModuleStructureExtractorWorker moduleStructureExtractorWorker, Directive directive2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            moduleStructureExtractorWorker.checkDirectiveApplicability(directive2, bl, bl2, bl3);
        }

        /*
         * WARNING - void declaration
         */
        private final void finishModule(int lineNumber) {
            void $this$flatMapTo$iv;
            Object it;
            Object element$iv2;
            this.finishFile(lineNumber);
            boolean isImplicitModule = this.currentModuleName == null;
            RegisteredDirectives moduleDirectives = ModuleStructureExtractorImplKt.access$plus(ModuleStructureExtractorImplKt.access$plus(this.moduleDirectivesBuilder.build(), DefaultRegisteredDirectivesProviderKt.getDefaultDirectives(ModuleStructureExtractorImpl.this.getTestServices())), this.globalDirectives);
            Iterable $this$forEach$iv = moduleDirectives;
            boolean $i$f$forEach22 = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (Directive)element$iv2;
                boolean bl = false;
                ModuleStructureExtractorWorker.checkDirectiveApplicability$default(this, (Directive)it, isImplicitModule, true, false, 4, null);
            }
            TargetBackend $i$f$forEach22 = this.currentModuleTargetBackend;
            TargetBackend targetBackend = $i$f$forEach22 == null ? this.getDefaultsProvider().getDefaultTargetBackend() : $i$f$forEach22;
            this.currentModuleLanguageVersionSettingsBuilder.configureUsingDirectives(moduleDirectives, ModuleStructureExtractorImpl.this.environmentConfigurators, targetBackend);
            String string2 = this.currentModuleName;
            String moduleName = string2 == null ? this.getDefaultModuleName() : string2;
            element$iv2 = this.currentModuleTargetPlatform;
            Object targetPlatform = element$iv2 == null ? ((it = this.parseModulePlatformByName(moduleName)) == null ? this.getDefaultsProvider().getDefaultPlatform() : it) : element$iv2;
            it = this.currentModuleFrontendKind;
            Object object = it == null ? this.getDefaultsProvider().getDefaultFrontend() : it;
            it = this.getDefaultsProvider().getDefaultArtifactKind();
            TestModule testModule = new TestModule(moduleName, (TargetPlatform)targetPlatform, targetBackend, (FrontendKind<?>)object, BackendKinds.INSTANCE.fromTargetBackend(targetBackend), (BinaryKind<?>)(it == null ? TestModuleStructureImpl.Companion.toArtifactKind((TargetPlatform)targetPlatform) : it), this.filesOfCurrentModule, this.dependenciesOfCurrentModule, moduleDirectives, this.currentModuleLanguageVersionSettingsBuilder.build());
            it = this;
            Collection bl = ((ModuleStructureExtractorWorker)it).modules;
            bl.add(testModule);
            it = ModuleStructureExtractorImpl.this.getAdditionalSourceProviders();
            Collection destination$iv = this.filesOfCurrentModule;
            boolean $i$f$flatMapTo = false;
            for (Object element$iv3 : $this$flatMapTo$iv) {
                boolean bl2;
                Iterable<Directive> iterable;
                AdditionalSourceProvider additionalSourceProvider;
                block6: {
                    boolean bl3;
                    additionalSourceProvider = (AdditionalSourceProvider)element$iv3;
                    boolean bl4 = false;
                    iterable = this.globalDirectives;
                    Iterable<Directive> additionalFiles = iterable = additionalSourceProvider.produceAdditionalFiles(iterable == null ? (RegisteredDirectives)RegisteredDirectives.Companion.getEmpty() : iterable, testModule);
                    boolean bl5 = false;
                    Iterable $this$all$iv = additionalFiles;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv4 : $this$all$iv) {
                            TestFile it2 = (TestFile)element$iv4;
                            boolean bl6 = false;
                            if (it2.isAdditional()) continue;
                            bl3 = false;
                            break block6;
                        }
                        bl3 = bl2 = true;
                    }
                }
                if (!bl2) {
                    boolean bl7 = false;
                    String string3 = "Files produced by " + Reflection.getOrCreateKotlinClass(additionalSourceProvider.getClass()).getQualifiedName() + " should have flag `isAdditional = true`";
                    throw new IllegalArgumentException(string3.toString());
                }
                Iterable list$iv = iterable;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            this.firstFileInModule = true;
            this.resetModuleCaches();
        }

        private final TargetPlatform parseModulePlatformByName(String moduleName) {
            TargetPlatform targetPlatform;
            String string2 = StringsKt.substringAfterLast((String)moduleName, (String)"-", (String)"").toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String nameSuffix = string2;
            if (Intrinsics.areEqual((Object)nameSuffix, (Object)"COMMON")) {
                targetPlatform = CommonPlatforms.INSTANCE.getDefaultCommonPlatform();
            } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"JVM")) {
                targetPlatform = JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
            } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"JS")) {
                targetPlatform = JsPlatforms.INSTANCE.getDefaultJsPlatform();
            } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"NATIVE")) {
                targetPlatform = NativePlatforms.INSTANCE.getUnspecifiedNativePlatform();
            } else if (((CharSequence)nameSuffix).length() == 0) {
                targetPlatform = null;
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Can't determine platform by name ", (Object)nameSuffix));
            }
            return targetPlatform;
        }

        private final void finishFile(int lineNumber) {
            Object object;
            Object v1;
            Object element$iv;
            Object object2;
            boolean bl;
            Object $this$any$iv;
            String filename;
            String actualDefaultFileName;
            block10: {
                actualDefaultFileName = this.currentModuleName == null ? this.getDefaultFileName() : "module_" + this.currentModuleName + '_' + this.getDefaultFileName();
                String string2 = this.currentFileName;
                filename = string2 == null ? actualDefaultFileName : string2;
                $this$any$iv = this.filesOfCurrentModule;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    object2 = $this$any$iv.iterator();
                    while (object2.hasNext()) {
                        element$iv = object2.next();
                        TestFile it = (TestFile)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)filename)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalStateException(("File with name \"" + filename + "\" already defined in module " + (String)(($this$any$iv = this.currentModuleName) == null ? actualDefaultFileName : $this$any$iv)).toString());
            }
            RegisteredDirectivesParser $i$f$any = this.fileDirectivesBuilder;
            if ($i$f$any == null) {
                v1 = null;
            } else {
                object2 = $i$f$any.build();
                Object directives2 = element$iv = object2;
                boolean bl3 = false;
                Iterable $this$forEach$iv = (Iterable)directives2;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Directive it = (Directive)element$iv2;
                    boolean bl4 = false;
                    ModuleStructureExtractorWorker.checkDirectiveApplicability$default(this, it, false, false, true, 3, null);
                }
                v1 = element$iv;
            }
            Object directives3 = v1;
            Object $this$finishFile_u24lambda_u2d27 = object2 = new StringBuilder();
            boolean bl5 = false;
            int n = 0;
            int n2 = this.endLineNumberOfLastFile;
            while (n < n2) {
                int i = n++;
                StringBuilder stringBuilder2 = ((StringBuilder)$this$finishFile_u24lambda_u2d27).append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append('\\n')");
            }
            StringBuilder stringBuilder3 = ((StringBuilder)$this$finishFile_u24lambda_u2d27).append(CollectionsKt.joinToString$default((Iterable)this.linesOfCurrentFile, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringBuilder stringBuilder4 = stringBuilder3.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append('\\n')");
            String string3 = ((StringBuilder)object2).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
            String fileContent = string3;
            object2 = this.currentTestDataFile;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentTestDataFile");
                object = null;
            } else {
                object = object2;
            }
            object2 = directives3;
            this.filesOfCurrentModule.add(new TestFile(filename, fileContent, (File)object, this.endLineNumberOfLastFile, false, (RegisteredDirectives)(object2 == null ? (RegisteredDirectives)RegisteredDirectives.Companion.getEmpty() : object2)));
            this.firstFileInModule = false;
            this.endLineNumberOfLastFile = lineNumber - 1;
            this.resetFileCaches();
        }

        private final void resetModuleCaches() {
            this.firstFileInModule = true;
            this.currentModuleName = null;
            this.currentModuleTargetPlatform = null;
            this.currentModuleTargetBackend = null;
            this.currentModuleFrontendKind = null;
            this.currentModuleLanguageVersionSettingsBuilder = this.initLanguageSettingsBuilder();
            this.filesOfCurrentModule = new ArrayList();
            this.dependenciesOfCurrentModule = new ArrayList();
            this.resetDirectivesBuilder();
            this.moduleDirectivesBuilder = this.directivesBuilder;
        }

        private final void resetDirectivesBuilder() {
            this.directivesBuilder = new RegisteredDirectivesParser(this.directivesContainer, this.getAssertions());
        }

        private final void resetFileCaches() {
            if (!this.firstFileInModule) {
                this.linesOfCurrentFile = new ArrayList();
            }
            if (this.firstFileInModule) {
                this.moduleDirectivesBuilder = this.directivesBuilder;
            }
            this.currentFileName = null;
            this.resetDirectivesBuilder();
            this.fileDirectivesBuilder = this.directivesBuilder;
        }

        private final void tryParseRegularDirective(RegisteredDirectivesParser.RawDirective rawDirective) {
            if (rawDirective == null) {
                return;
            }
            RegisteredDirectivesParser.ParsedDirective parsedDirective = this.directivesBuilder.convertToRegisteredDirective(rawDirective);
            if (parsedDirective == null) {
                return;
            }
            RegisteredDirectivesParser.ParsedDirective parsedDirective2 = parsedDirective;
            this.directivesBuilder.addParsedDirective(parsedDirective2);
        }

        private final void validateFileName(String fileName) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = allowedExtensionsForFiles;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.endsWith$default((String)fileName, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(fileName){
                    final /* synthetic */ String $fileName;
                    {
                        this.$fileName = $fileName;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Filename " + this.$fileName + " is not valid. Allowed extensions: " + StringUtilsKt.joinToArrayString(ModuleStructureExtractorImpl.access$getAllowedExtensionsForFiles$cp());
                    }
                }));
                throw null;
            }
        }

        private final LanguageVersionSettingsBuilder initLanguageSettingsBuilder() {
            return this.getDefaultsProvider().newLanguageSettingsBuilder();
        }

        /*
         * WARNING - void declaration
         */
        private static final Iterable sortModules$lambda-4(Map $moduleByName, TestModule module2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$moduleByName, (String)"$moduleByName");
            Iterable $this$map$iv = module2.getAllDependencies();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String moduleName = it.getModuleName();
                TestModule testModule = (TestModule)$moduleByName.get(moduleName);
                if (testModule == null) {
                    throw new IllegalStateException(("Module \"" + moduleName + "\" not found while observing dependencies of \"" + module2.getName() + '\"').toString());
                }
                TestModule testModule2 = testModule;
                collection.add(testModule2);
            }
            return (List)destination$iv$iv;
        }

        public static final /* synthetic */ String access$getCurrentModuleName$p(ModuleStructureExtractorWorker $this) {
            return $this.currentModuleName;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003JC\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleNameAndDependencies;", "", "name", "", "dependencies", "", "friends", "dependsOn", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getDependencies", "()Ljava/util/List;", "getDependsOn", "getFriends", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "tests-common-new"})
    private static final class ModuleNameAndDependencies {
        @NotNull
        private final String name;
        @NotNull
        private final List<String> dependencies;
        @NotNull
        private final List<String> friends;
        @NotNull
        private final List<String> dependsOn;

        public ModuleNameAndDependencies(@NotNull String name2, @NotNull List<String> dependencies2, @NotNull List<String> friends, @NotNull List<String> dependsOn) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
            Intrinsics.checkNotNullParameter(friends, (String)"friends");
            Intrinsics.checkNotNullParameter(dependsOn, (String)"dependsOn");
            this.name = name2;
            this.dependencies = dependencies2;
            this.friends = friends;
            this.dependsOn = dependsOn;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<String> getDependencies() {
            return this.dependencies;
        }

        @NotNull
        public final List<String> getFriends() {
            return this.friends;
        }

        @NotNull
        public final List<String> getDependsOn() {
            return this.dependsOn;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<String> component2() {
            return this.dependencies;
        }

        @NotNull
        public final List<String> component3() {
            return this.friends;
        }

        @NotNull
        public final List<String> component4() {
            return this.dependsOn;
        }

        @NotNull
        public final ModuleNameAndDependencies copy(@NotNull String name2, @NotNull List<String> dependencies2, @NotNull List<String> friends, @NotNull List<String> dependsOn) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
            Intrinsics.checkNotNullParameter(friends, (String)"friends");
            Intrinsics.checkNotNullParameter(dependsOn, (String)"dependsOn");
            return new ModuleNameAndDependencies(name2, dependencies2, friends, dependsOn);
        }

        public static /* synthetic */ ModuleNameAndDependencies copy$default(ModuleNameAndDependencies moduleNameAndDependencies, String string2, List list2, List list3, List list4, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = moduleNameAndDependencies.name;
            }
            if ((n & 2) != 0) {
                list2 = moduleNameAndDependencies.dependencies;
            }
            if ((n & 4) != 0) {
                list3 = moduleNameAndDependencies.friends;
            }
            if ((n & 8) != 0) {
                list4 = moduleNameAndDependencies.dependsOn;
            }
            return moduleNameAndDependencies.copy(string2, list2, list3, list4);
        }

        @NotNull
        public String toString() {
            return "ModuleNameAndDependencies(name=" + this.name + ", dependencies=" + this.dependencies + ", friends=" + this.friends + ", dependsOn=" + this.dependsOn + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + ((Object)this.dependencies).hashCode();
            result2 = result2 * 31 + ((Object)this.friends).hashCode();
            result2 = result2 * 31 + ((Object)this.dependsOn).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleNameAndDependencies)) {
                return false;
            }
            ModuleNameAndDependencies moduleNameAndDependencies = (ModuleNameAndDependencies)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)moduleNameAndDependencies.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.dependencies, moduleNameAndDependencies.dependencies)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.friends, moduleNameAndDependencies.friends)) {
                return false;
            }
            return Intrinsics.areEqual(this.dependsOn, moduleNameAndDependencies.dependsOn);
        }
    }
}

