/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.DependencyProvider;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J3\u0010\u0013\u001a\u0002H\u0014\"\u000e\b\u0000\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00140\u000b2\u0006\u0010\u0015\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\nH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J,\u0010\u001a\u001a\u00020\u001b\"\u000e\b\u0000\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00140\u000b2\u0006\u0010\u0015\u001a\u00020\u00062\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00140\u000bJO\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u0002H\u001f0\t\"\u0004\b\u0000\u0010 \"\u0004\b\u0001\u0010\u001e\"\u0004\b\u0002\u0010\u001f*\u001a\u0012\u0004\u0012\u0002H \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u0002H\u001f0\t0\t2\u0006\u0010!\u001a\u0002H H\u0002\u00a2\u0006\u0002\u0010\"R.\u0010\b\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00060\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/test/services/DependencyProviderImpl;", "Lorg/jetbrains/kotlin/test/services/DependencyProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "testModules", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;)V", "artifactsByModule", "", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "getAssertions", "()Lorg/jetbrains/kotlin/test/Assertions;", "testModulesByName", "", "", "getArtifact", "A", "module", "kind", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/TestArtifactKind;)Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "getTestModule", "name", "registerArtifact", "", "artifact", "getMap", "V", "R", "K", "key", "(Ljava/util/Map;Ljava/lang/Object;)Ljava/util/Map;", "test-infrastructure"})
public final class DependencyProviderImpl
extends DependencyProvider {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Map<String, TestModule> testModulesByName;
    @NotNull
    private final Map<TestModule, Map<TestArtifactKind<?>, ResultingArtifact<?>>> artifactsByModule;

    /*
     * WARNING - void declaration
     */
    public DependencyProviderImpl(@NotNull TestServices testServices, @NotNull List<TestModule> testModules) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter(testModules, (String)"testModules");
        this.testServices = testServices;
        Iterable iterable = testModules;
        DependencyProviderImpl dependencyProviderImpl = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TestModule testModule = (TestModule)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        dependencyProviderImpl.testModulesByName = MapsKt.toMap((Iterable)collection);
        this.artifactsByModule = new LinkedHashMap();
    }

    private final Assertions getAssertions() {
        return AssertionsKt.getAssertions(this.testServices);
    }

    @Override
    @NotNull
    public TestModule getTestModule(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        TestModule testModule = this.testModulesByName.get(name2);
        if (testModule == null) {
            this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(name2){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Module " + this.$name + " is not defined";
                }
            }));
            throw null;
        }
        return testModule;
    }

    @Override
    @NotNull
    public <A extends ResultingArtifact<A>> A getArtifact(@NotNull TestModule module2, @NotNull TestArtifactKind<A> kind) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        ResultingArtifact<?> resultingArtifact = this.getMap(this.artifactsByModule, module2).get(kind);
        if (resultingArtifact == null) {
            throw new IllegalStateException(("Artifact with kind " + kind + " is not registered for module " + module2.getName()).toString());
        }
        ResultingArtifact<?> artifact = resultingArtifact;
        return (A)artifact;
    }

    public final <A extends ResultingArtifact<A>> void registerArtifact(@NotNull TestModule module2, @NotNull ResultingArtifact<A> artifact) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter(artifact, (String)"artifact");
        TestArtifactKind<A> kind = artifact.getKind();
        ResultingArtifact<A> previousValue = this.getMap(this.artifactsByModule, module2).put(kind, artifact);
        if (previousValue != null) {
            throw new IllegalStateException(("Artifact with kind " + kind + " already registered for module " + module2.getName()).toString());
        }
    }

    private final <K, V, R> Map<V, R> getMap(Map<K, Map<V, R>> $this$getMap, K key) {
        Map map;
        Map<K, Map<Map, R>> $this$getOrPut$iv = $this$getMap;
        boolean $i$f$getOrPut = false;
        Map value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key, answer$iv);
            map = answer$iv;
        } else {
            map = value$iv;
        }
        return map;
    }
}

