/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.Condition;
import org.jetbrains.kotlin.test.util.ConditionKt;
import org.jetbrains.kotlin.test.util.Conditions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000f0\t\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0012H\u0002J(\u0010\u0014\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u000bR2\u0010\u0005\u001a&\u0012\u0004\u0012\u00020\u0007\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/services/DiagnosticsService;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "conditionsPerModule", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/test/util/Condition;", "", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "computeCondition", "T", "", "enabled", "", "disabled", "computeDiagnosticConditionForModule", "module", "shouldRenderDiagnostic", "", "name", "severity", "Companion", "tests-common-new"})
public final class DiagnosticsService
implements TestService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Map<TestModule, Pair<Condition<String>, Condition<Severity>>> conditionsPerModule;
    @NotNull
    private static final Map<String, Severity> severityNameMapping;

    public DiagnosticsService(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.testServices = testServices;
        this.conditionsPerModule = new LinkedHashMap();
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    public final boolean shouldRenderDiagnostic(@NotNull TestModule module2, @NotNull String name2, @NotNull Severity severity) {
        Pair<Condition<String>, Condition<Severity>> pair;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Map<TestModule, Pair<Condition<String>, Condition<Severity>>> $this$getOrPut$iv = this.conditionsPerModule;
        boolean $i$f$getOrPut = false;
        Pair<Condition<String>, Condition<Severity>> value$iv = $this$getOrPut$iv.get(module2);
        if (value$iv == null) {
            boolean bl = false;
            Pair<Condition<String>, Condition<Severity>> answer$iv = this.computeDiagnosticConditionForModule(module2);
            $this$getOrPut$iv.put(module2, answer$iv);
            pair = answer$iv;
        } else {
            pair = value$iv;
        }
        Pair<Condition<String>, Condition<Severity>> pair2 = pair;
        Condition nameCondition = (Condition)pair2.component1();
        Condition severityCondition = (Condition)pair2.component2();
        return severityCondition.invoke(severity) && nameCondition.invoke(name2);
    }

    private final Pair<Condition<String>, Condition<Severity>> computeDiagnosticConditionForModule(TestModule module2) {
        List<String> diagnosticsInDirective = module2.getDirectives().get(DiagnosticsDirectives.INSTANCE.getDIAGNOSTICS());
        Set enabledNames = new LinkedHashSet();
        Set disabledNames = new LinkedHashSet();
        Set enabledSeverities = new LinkedHashSet();
        Set disabledSeverities = new LinkedHashSet();
        for (String diagnosticInDirective : diagnosticsInDirective) {
            Set collection;
            boolean bl;
            if (StringsKt.startsWith$default((String)diagnosticInDirective, (String)"+", (boolean)false, (int)2, null)) {
                bl = true;
            } else if (StringsKt.startsWith$default((String)diagnosticInDirective, (String)"-", (boolean)false, (int)2, null)) {
                bl = false;
            } else {
                String string2 = Intrinsics.stringPlus((String)"Incorrect diagnostics directive syntax. See reference:\n", (Object)DiagnosticsDirectives.INSTANCE.getDIAGNOSTICS().getDescription());
                throw new IllegalStateException(string2.toString());
            }
            boolean enabled2 = bl;
            String string3 = diagnosticInDirective;
            int n = 1;
            Object object = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).substring(startIndex)");
            String name2 = object;
            Severity severity = severityNameMapping.get(name2);
            if (severity != null) {
                collection = enabled2 ? enabledSeverities : disabledSeverities;
                object = collection;
                object.add(severity);
                continue;
            }
            collection = enabled2 ? enabledNames : disabledNames;
            object = collection;
            object.add(name2);
        }
        return TuplesKt.to(this.computeCondition(enabledNames, disabledNames), this.computeCondition(enabledSeverities, disabledSeverities));
    }

    private final <T> Condition<T> computeCondition(Set<? extends T> enabled2, Set<? extends T> disabled) {
        if (disabled.isEmpty()) {
            return Conditions.INSTANCE.alwaysTrue();
        }
        Condition condition = ConditionKt.not(Conditions.INSTANCE.oneOf((Collection)disabled));
        if (!((Collection)enabled2).isEmpty()) {
            condition = ConditionKt.or(condition, Conditions.INSTANCE.oneOf((Collection)enabled2));
        }
        return ConditionKt.cached(condition);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"infos", (Object)((Object)Severity.INFO)), TuplesKt.to((Object)"warnings", (Object)((Object)Severity.WARNING)), TuplesKt.to((Object)"errors", (Object)((Object)Severity.ERROR))};
        severityNameMapping = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/services/DiagnosticsService$Companion;", "", "()V", "severityNameMapping", "", "", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

