/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic.handlers;

import com.google.common.collect.ImmutableCollection;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.PackageDescriptorUtilKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendOutputArtifact;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicFrontendAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u000201B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J(\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020/2\u0006\u0010)\u001a\u00020*H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ConstantValuesHandler;", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicFrontendAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "metaInfoHandler", "Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "checkConstant", "", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "checkIsPure", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "project", "Lcom/intellij/openapi/project/Project;", "checkVariableAsConstant", "evaluateInitializer", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "context", "property", "getLocalVarDescriptor", "name", "getPropertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processFile", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "info", "Lorg/jetbrains/kotlin/test/frontend/classic/ClassicFrontendOutputArtifact;", "mode", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ConstantValuesHandler$Mode;", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Companion", "Mode", "tests-common-new"})
public final class ConstantValuesHandler
extends ClassicFrontendAnalysisHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalMetadataInfoHandler metaInfoHandler;
    @NotNull
    private static final String DEBUG_INFO_CONSTANT = "DEBUG_INFO_CONSTANT_VALUE";
    @NotNull
    private static final Regex propertyNameMatchingRegex = new Regex("val ([\\w\\d]+)(: .*)? =");

    public ConstantValuesHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices, false, false, 6, null);
        this.metaInfoHandler = GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)DiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module2, @NotNull ClassicFrontendOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Mode mode = DirectiveKt.singleOrZeroValue(module2.getDirectives(), DiagnosticsDirectives.INSTANCE.getCHECK_COMPILE_TIME_VALUES());
        if (mode == null) {
            return;
        }
        Mode mode2 = mode;
        for (Map.Entry entry : info.getKtFiles().entrySet()) {
            TestFile file2 = (TestFile)entry.getKey();
            KtFile ktFile = (KtFile)entry.getValue();
            this.processFile(file2, ktFile, info, mode2);
        }
    }

    private final void processFile(TestFile file2, KtFile ktFile, ClassicFrontendOutputArtifact info, Mode mode) {
        PackageFragmentDescriptor $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.metaInfoHandler.getExistingMetaInfosForFile(file2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            ParsedCodeMetaInfo it = (ParsedCodeMetaInfo)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTag(), (Object)DEBUG_INFO_CONSTANT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List expectedMetaInfos = (List)destination$iv$iv;
        String fileText = ktFile.getText();
        $this$filterTo$iv$iv = PackageDescriptorUtilKt.findPackageFragmentForFile(info.getAnalysisResult().getModuleDescriptor(), ktFile);
        if ($this$filterTo$iv$iv == null) {
            return;
        }
        PackageFragmentDescriptor packageFragmentDescriptor = $this$filterTo$iv$iv;
        BindingContext bindingContext = info.getAnalysisResult().getBindingContext();
        Project project = info.getProject();
        List actualMetaInfos = new ArrayList();
        for (ParsedCodeMetaInfo expectedMetaInfo : expectedMetaInfos) {
            String string2;
            VariableDescriptor variableDescriptor;
            Object object;
            MatchGroup matchGroup;
            int start = expectedMetaInfo.getStart();
            int end = expectedMetaInfo.getEnd();
            Intrinsics.checkNotNullExpressionValue((Object)fileText, (String)"fileText");
            String string3 = fileText;
            String string4 = string3.substring(start, end);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String markedText = string4;
            Object object2 = Regex.find$default((Regex)propertyNameMatchingRegex, (CharSequence)markedText, (int)0, (int)2, null);
            if (object2 == null) {
                matchGroup = null;
            } else {
                object = object2.getGroups();
                matchGroup = object.get(1);
            }
            if ((string4 = matchGroup) == null) continue;
            String propertyName = string4.getValue();
            object2 = this.getPropertyDescriptor(packageFragmentDescriptor, propertyName);
            if (object2 == null) {
                object = this.getLocalVarDescriptor(bindingContext, propertyName);
                if (object == null) continue;
                variableDescriptor = object;
            } else {
                variableDescriptor = (VariableDescriptor)object2;
            }
            VariableDescriptor propertyDescriptor = variableDescriptor;
            object = mode;
            int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
            switch (n) {
                case 1: {
                    string2 = this.checkConstant(propertyDescriptor);
                    break;
                }
                case 2: {
                    string2 = this.checkIsPure(bindingContext, propertyDescriptor, project);
                    break;
                }
                case 3: {
                    string2 = this.checkVariableAsConstant(bindingContext, propertyDescriptor, project);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String actualValue = string2;
            object = actualMetaInfos;
            ParsedCodeMetaInfo parsedCodeMetaInfo = new ParsedCodeMetaInfo(start, end, new ArrayList(), DEBUG_INFO_CONSTANT, actualValue);
            object.add(parsedCodeMetaInfo);
        }
        this.metaInfoHandler.addMetadataInfosForFile(file2, actualMetaInfos);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }

    private final String checkConstant(VariableDescriptor variableDescriptor) {
        ConstantValue<?> compileTimeConstant = variableDescriptor.getCompileTimeInitializer();
        return compileTimeConstant instanceof StringValue ? "\\\"" + (String)((StringValue)compileTimeConstant).getValue() + "\\\"" : String.valueOf(compileTimeConstant);
    }

    private final String checkIsPure(BindingContext bindingContext, VariableDescriptor variableDescriptor, Project project) {
        CompileTimeConstant<?> compileTimeConstant = this.evaluateInitializer(bindingContext, variableDescriptor, project);
        return String.valueOf(compileTimeConstant == null ? null : Boolean.valueOf(compileTimeConstant.isPure()));
    }

    private final String checkVariableAsConstant(BindingContext bindingContext, VariableDescriptor variableDescriptor, Project project) {
        CompileTimeConstant<?> compileTimeConstant = this.evaluateInitializer(bindingContext, variableDescriptor, project);
        return String.valueOf(compileTimeConstant == null ? null : Boolean.valueOf(compileTimeConstant.getUsesVariableAsConstant()));
    }

    private final CompileTimeConstant<?> evaluateInitializer(BindingContext context2, VariableDescriptor property2, Project project) {
        Object object = DescriptorToSourceUtils.descriptorToDeclaration(property2);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
        }
        KtProperty propertyDeclaration = (KtProperty)object;
        ConstantExpressionEvaluator constantExpressionEvaluator = new ConstantExpressionEvaluator(DescriptorUtilsKt.getModule(property2), LanguageVersionSettingsImpl.DEFAULT, project);
        KtExpression ktExpression = propertyDeclaration.getInitializer();
        Intrinsics.checkNotNull((Object)ktExpression);
        object = ktExpression;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"propertyDeclaration.initializer!!");
        return ConstantExpressionEvaluator.evaluateExpression$default(constantExpressionEvaluator, (KtExpression)object, new DelegatingBindingTrace(context2, "trace for evaluating compile time constant", false, null, false, null, 60, null), property2.getType(), false, 8, null);
    }

    private final PropertyDescriptor getPropertyDescriptor(PackageFragmentDescriptor packageView, String name2) {
        Name name3 = Name.identifier(name2);
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(name)");
        Name propertyName = name3;
        MemberScope memberScope2 = packageView.getMemberScope();
        Collection<? extends PropertyDescriptor> properties2 = memberScope2.getContributedVariables(propertyName, NoLookupLocation.FROM_TEST);
        if (properties2.isEmpty()) {
            for (DeclarationDescriptor descriptor2 : DescriptorUtils.getAllDescriptors(memberScope2)) {
                Collection<? extends PropertyDescriptor> classProperties;
                if (!(descriptor2 instanceof ClassDescriptor) || (classProperties = ((ClassDescriptor)descriptor2).getMemberScope(CollectionsKt.emptyList()).getContributedVariables(propertyName, NoLookupLocation.FROM_TEST)).isEmpty()) continue;
                properties2 = classProperties;
                break;
            }
        }
        if (properties2.size() != 1) {
            return null;
        }
        return properties2.iterator().next();
    }

    private final VariableDescriptor getLocalVarDescriptor(BindingContext context2, String name2) {
        for (VariableDescriptor descriptor2 : (ImmutableCollection)context2.getSliceContents(BindingContext.VARIABLE).values()) {
            if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)name2)) continue;
            return descriptor2;
        }
        TestCase.fail((String)Intrinsics.stringPlus((String)"Failed to find local variable ", (Object)name2));
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ConstantValuesHandler$Companion;", "", "()V", "DEBUG_INFO_CONSTANT", "", "propertyNameMatchingRegex", "Lkotlin/text/Regex;", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ConstantValuesHandler$Mode;", "", "(Ljava/lang/String;I)V", "Constant", "IsPure", "UsesVariableAsConstant", "tests-common-new"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Constant = new Mode();
        public static final /* enum */ Mode IsPure = new Mode();
        public static final /* enum */ Mode UsesVariableAsConstant = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value2) {
            return Enum.valueOf(Mode.class, value2);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.Constant, Mode.IsPure, Mode.UsesVariableAsConstant};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            nArray[Mode.Constant.ordinal()] = 1;
            nArray[Mode.IsPure.ordinal()] = 2;
            nArray[Mode.UsesVariableAsConstant.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

