/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.util;

import java.util.Collection;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.util.Condition;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004*+,-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u0007J\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u0007J.\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004J\u001c\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00042\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rJ \u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004J:\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0004\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0004J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rJ3\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\u001a\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\r0\u001d\"\u0006\u0012\u0002\b\u00030\r\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\u0006\u0010\u001b\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010 J \u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rJ\u0012\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u0007J+\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\u001d\"\u0002H\u0007\u00a2\u0006\u0002\u0010'J \u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00070(J.\u0010)\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004\"\u0004\b\u0000\u0010\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0004R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/test/util/Conditions;", "", "()V", "FALSE", "Lorg/jetbrains/kotlin/test/util/Condition;", "TRUE", "alwaysFalse", "T", "alwaysTrue", "and", "c1", "c2", "assignableTo", "Ljava/lang/Class;", "clazz", "cached", "c", "compose", "A", "B", "func", "Lkotlin/Function1;", "condition", "constant", "value", "", "equalTo", "option", "instanceOf", "", "([Ljava/lang/Class;)Lorg/jetbrains/kotlin/test/util/Condition;", "is", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/test/util/Condition;", "not", "notEqualTo", "notInstanceOf", "notNull", "oneOf", "options", "([Ljava/lang/Object;)Lorg/jetbrains/kotlin/test/util/Condition;", "", "or", "And", "Not", "Or", "SoftRefCache", "test-infrastructure-utils"})
public final class Conditions {
    @NotNull
    public static final Conditions INSTANCE = new Conditions();
    @NotNull
    private static final Condition<Object> TRUE = Conditions::TRUE$lambda-0;
    @NotNull
    private static final Condition<Object> FALSE = Conditions::FALSE$lambda-1;

    private Conditions() {
    }

    @NotNull
    public final <T> Condition<T> alwaysTrue() {
        return TRUE;
    }

    @NotNull
    public final <T> Condition<T> alwaysFalse() {
        return FALSE;
    }

    @NotNull
    public final <T> Condition<T> notNull() {
        return Conditions::notNull$lambda-2;
    }

    @NotNull
    public final <T> Condition<T> constant(boolean value2) {
        return value2 ? this.alwaysTrue() : this.alwaysFalse();
    }

    @NotNull
    public final <T> Condition<T> instanceOf(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return arg_0 -> Conditions.instanceOf$lambda-3(clazz, arg_0);
    }

    @NotNull
    public final <T> Condition<T> notInstanceOf(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return arg_0 -> Conditions.notInstanceOf$lambda-4(clazz, arg_0);
    }

    @NotNull
    public final Condition<Class<?>> assignableTo(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return arg_0 -> Conditions.assignableTo$lambda-5(clazz, arg_0);
    }

    @NotNull
    public final <T> Condition<T> instanceOf(Class<?> ... clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return arg_0 -> Conditions.instanceOf$lambda-6(clazz, arg_0);
    }

    @NotNull
    public final <T> Condition<T> is(T option) {
        return this.equalTo(option);
    }

    @NotNull
    public final <T> Condition<T> equalTo(@Nullable Object option) {
        return arg_0 -> Conditions.equalTo$lambda-7(option, arg_0);
    }

    @NotNull
    public final <T> Condition<T> notEqualTo(@Nullable Object option) {
        return arg_0 -> Conditions.notEqualTo$lambda-8(option, arg_0);
    }

    @NotNull
    public final <T> Condition<T> oneOf(T ... options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.oneOf(ArraysKt.toList((Object[])options));
    }

    @NotNull
    public final <T> Condition<T> oneOf(@NotNull Collection<? extends T> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return arg_0 -> Conditions.oneOf$lambda-9(options, arg_0);
    }

    @NotNull
    public final <T> Condition<T> not(@NotNull Condition<? super T> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (c == this.alwaysTrue()) {
            return this.alwaysFalse();
        }
        if (c == this.alwaysFalse()) {
            return this.alwaysTrue();
        }
        return c instanceof Not ? ((Not)c).getC() : (Condition)new Not<T>(c);
    }

    @NotNull
    public final <T> Condition<T> and(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
        Intrinsics.checkNotNullParameter(c1, (String)"c1");
        Intrinsics.checkNotNullParameter(c2, (String)"c2");
        if (c1 == this.alwaysTrue() || c2 == this.alwaysFalse()) {
            return c2;
        }
        return c2 == this.alwaysTrue() || c1 == this.alwaysFalse() ? c1 : (Condition)new And<T>(c1, c2);
    }

    @NotNull
    public final <T> Condition<T> or(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
        Intrinsics.checkNotNullParameter(c1, (String)"c1");
        Intrinsics.checkNotNullParameter(c2, (String)"c2");
        if (c1 == this.alwaysFalse() || c2 == this.alwaysTrue()) {
            return c2;
        }
        return c2 == this.alwaysFalse() || c1 == this.alwaysTrue() ? c1 : (Condition)new Or<T>(c1, c2);
    }

    @NotNull
    public final <A, B> Condition<A> compose(@NotNull Function1<? super A, ? extends B> func, @NotNull Condition<? super B> condition) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        return arg_0 -> Conditions.compose$lambda-10(condition, func, arg_0);
    }

    @NotNull
    public final <T> Condition<T> cached(@NotNull Condition<? super T> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return new SoftRefCache<T>(c);
    }

    private static final boolean TRUE$lambda-0(Object it) {
        return true;
    }

    private static final boolean FALSE$lambda-1(Object it) {
        return false;
    }

    private static final boolean notNull$lambda-2(Object it) {
        return it != null;
    }

    private static final boolean instanceOf$lambda-3(Class $clazz, Object t) {
        Intrinsics.checkNotNullParameter((Object)$clazz, (String)"$clazz");
        return $clazz.isInstance(t);
    }

    private static final boolean notInstanceOf$lambda-4(Class $clazz, Object t) {
        Intrinsics.checkNotNullParameter((Object)$clazz, (String)"$clazz");
        return !$clazz.isInstance(t);
    }

    private static final boolean assignableTo$lambda-5(Class $clazz, Class t) {
        Intrinsics.checkNotNullParameter((Object)$clazz, (String)"$clazz");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return $clazz.isAssignableFrom(t);
    }

    private static final boolean instanceOf$lambda-6(Class[] $clazz, Object t) {
        Intrinsics.checkNotNullParameter((Object)$clazz, (String)"$clazz");
        for (Class aClass : $clazz) {
            if (!aClass.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    private static final boolean equalTo$lambda-7(Object $option, Object t) {
        return Intrinsics.areEqual((Object)t, (Object)$option);
    }

    private static final boolean notEqualTo$lambda-8(Object $option, Object t) {
        return !Intrinsics.areEqual((Object)t, (Object)$option);
    }

    private static final boolean oneOf$lambda-9(Collection $options, Object t) {
        Intrinsics.checkNotNullParameter((Object)$options, (String)"$options");
        return $options.contains(t);
    }

    private static final boolean compose$lambda-10(Condition $condition, Function1 $func, Object it) {
        Intrinsics.checkNotNullParameter((Object)$condition, (String)"$condition");
        Intrinsics.checkNotNullParameter((Object)$func, (String)"$func");
        return $condition.invoke($func.invoke(it));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/test/util/Conditions$Not;", "T", "Lorg/jetbrains/kotlin/test/util/Condition;", "c", "(Lorg/jetbrains/kotlin/test/util/Condition;)V", "getC", "()Lorg/jetbrains/kotlin/test/util/Condition;", "invoke", "", "value", "(Ljava/lang/Object;)Z", "test-infrastructure-utils"})
    private static final class Not<T>
    implements Condition<T> {
        @NotNull
        private final Condition<T> c;

        public Not(@NotNull Condition<? super T> c) {
            Intrinsics.checkNotNullParameter(c, (String)"c");
            this.c = c;
        }

        @NotNull
        public final Condition<T> getC() {
            return this.c;
        }

        @Override
        public boolean invoke(T value2) {
            return !this.c.invoke(value2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/test/util/Conditions$And;", "T", "Lorg/jetbrains/kotlin/test/util/Condition;", "c1", "c2", "(Lorg/jetbrains/kotlin/test/util/Condition;Lorg/jetbrains/kotlin/test/util/Condition;)V", "getC1", "()Lorg/jetbrains/kotlin/test/util/Condition;", "getC2", "invoke", "", "value", "(Ljava/lang/Object;)Z", "test-infrastructure-utils"})
    private static final class And<T>
    implements Condition<T> {
        @NotNull
        private final Condition<T> c1;
        @NotNull
        private final Condition<T> c2;

        public And(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
            Intrinsics.checkNotNullParameter(c1, (String)"c1");
            Intrinsics.checkNotNullParameter(c2, (String)"c2");
            this.c1 = c1;
            this.c2 = c2;
        }

        @NotNull
        public final Condition<T> getC1() {
            return this.c1;
        }

        @NotNull
        public final Condition<T> getC2() {
            return this.c2;
        }

        @Override
        public boolean invoke(T value2) {
            return this.c1.invoke(value2) && this.c2.invoke(value2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/test/util/Conditions$Or;", "T", "Lorg/jetbrains/kotlin/test/util/Condition;", "c1", "c2", "(Lorg/jetbrains/kotlin/test/util/Condition;Lorg/jetbrains/kotlin/test/util/Condition;)V", "getC1", "()Lorg/jetbrains/kotlin/test/util/Condition;", "getC2", "invoke", "", "value", "(Ljava/lang/Object;)Z", "test-infrastructure-utils"})
    private static final class Or<T>
    implements Condition<T> {
        @NotNull
        private final Condition<T> c1;
        @NotNull
        private final Condition<T> c2;

        public Or(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
            Intrinsics.checkNotNullParameter(c1, (String)"c1");
            Intrinsics.checkNotNullParameter(c2, (String)"c2");
            this.c1 = c1;
            this.c2 = c2;
        }

        @NotNull
        public final Condition<T> getC1() {
            return this.c1;
        }

        @NotNull
        public final Condition<T> getC2() {
            return this.c2;
        }

        @Override
        public boolean invoke(T value2) {
            return this.c1.invoke(value2) || this.c2.invoke(value2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\nR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/test/util/Conditions$SoftRefCache;", "T", "Lorg/jetbrains/kotlin/test/util/Condition;", "myCondition", "(Lorg/jetbrains/kotlin/test/util/Condition;)V", "myCache", "Ljava/util/WeakHashMap;", "", "invoke", "value", "(Ljava/lang/Object;)Z", "test-infrastructure-utils"})
    private static final class SoftRefCache<T>
    implements Condition<T> {
        @NotNull
        private final Condition<T> myCondition;
        @NotNull
        private final WeakHashMap<T, Boolean> myCache;

        public SoftRefCache(@NotNull Condition<? super T> myCondition) {
            Intrinsics.checkNotNullParameter(myCondition, (String)"myCondition");
            this.myCondition = myCondition;
            this.myCache = new WeakHashMap();
        }

        @Override
        public boolean invoke(T value2) {
            Boolean bl = this.myCache.computeIfAbsent(value2, arg_0 -> SoftRefCache.invoke$lambda-0(this, value2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"myCache.computeIfAbsent(\u2026e) { myCondition(value) }");
            return bl;
        }

        private static final Boolean invoke$lambda-0(SoftRefCache this$0, Object $value, Object it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.myCondition.invoke($value);
        }
    }
}

