/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.KotlinTestInfoKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManager;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl;", "Lorg/jetbrains/kotlin/test/services/TemporaryDirectoryManager;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "cache", "", "", "Ljava/io/File;", "rootTempDir", "cleanupTemporaryDirectories", "", "getOrCreateTempDirectory", "name", "tests-common-new"})
public final class TemporaryDirectoryManagerImpl
extends TemporaryDirectoryManager {
    @NotNull
    private final Map<String, File> cache;
    @NotNull
    private final File rootTempDir;

    public TemporaryDirectoryManagerImpl(@NotNull TestServices testServices) {
        TemporaryDirectoryManagerImpl temporaryDirectoryManagerImpl;
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
        this.cache = new LinkedHashMap();
        TemporaryDirectoryManagerImpl temporaryDirectoryManagerImpl2 = temporaryDirectoryManagerImpl = this;
        TemporaryDirectoryManagerImpl temporaryDirectoryManagerImpl3 = this;
        boolean bl = false;
        KotlinTestInfo testInfo = KotlinTestInfoKt.getTestInfo(testServices);
        File file2 = KtTestUtil.tmpDirForTest(testInfo.getClassName(), testInfo.getMethodName());
        File file3 = file2;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"run {\n        val testIn\u2026estInfo.methodName)\n    }");
        temporaryDirectoryManagerImpl3.rootTempDir = file3;
    }

    @Override
    @NotNull
    public File getOrCreateTempDirectory(@NotNull String name2) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Map<String, File> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(name2);
        if (value$iv == null) {
            boolean bl = false;
            File file3 = KtTestUtil.tmpDir(this.rootTempDir, name2);
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"tmpDir(rootTempDir, name)");
            File answer$iv = file3;
            $this$getOrPut$iv.put(name2, answer$iv);
            file2 = answer$iv;
        } else {
            file2 = value$iv;
        }
        return file2;
    }

    @Override
    public void cleanupTemporaryDirectories() {
        this.cache.clear();
        FileUtil.delete((File)this.rootTempDir);
    }
}

