/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.directives.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;
import org.jetbrains.kotlin.test.util.StringUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0002\u0018\u00002\u00020\u0001BK\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006\u0012\u001c\u0010\t\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\u0006\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u000f\u001a\u00020\u0007H\u0096\u0002J'\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0003\"\b\b\u0000\u0010\u0012*\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00120\nH\u0096\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectivesImpl;", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "simpleDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "stringDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "", "valueDirectives", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "", "(Ljava/util/List;Ljava/util/Map;Ljava/util/Map;)V", "contains", "", "directive", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "get", "T", "isEmpty", "iterator", "", "toString", "test-infrastructure"})
public final class RegisteredDirectivesImpl
extends RegisteredDirectives {
    @NotNull
    private final List<SimpleDirective> simpleDirectives;
    @NotNull
    private final Map<StringDirective, List<String>> stringDirectives;
    @NotNull
    private final Map<ValueDirective<?>, List<Object>> valueDirectives;

    public RegisteredDirectivesImpl(@NotNull List<SimpleDirective> simpleDirectives, @NotNull Map<StringDirective, ? extends List<String>> stringDirectives, @NotNull Map<ValueDirective<?>, ? extends List<? extends Object>> valueDirectives) {
        Intrinsics.checkNotNullParameter(simpleDirectives, (String)"simpleDirectives");
        Intrinsics.checkNotNullParameter(stringDirectives, (String)"stringDirectives");
        Intrinsics.checkNotNullParameter(valueDirectives, (String)"valueDirectives");
        this.simpleDirectives = simpleDirectives;
        this.stringDirectives = stringDirectives;
        this.valueDirectives = valueDirectives;
    }

    @Override
    public boolean contains(@NotNull Directive directive2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)directive2, (String)"directive");
        Directive directive3 = directive2;
        if (directive3 instanceof SimpleDirective) {
            bl = this.simpleDirectives.contains(directive2);
        } else if (directive3 instanceof StringDirective) {
            Map<StringDirective, List<String>> map = this.stringDirectives;
            bl = map.containsKey(directive2);
        } else if (directive3 instanceof ValueDirective) {
            Map<ValueDirective<?>, List<Object>> map = this.valueDirectives;
            bl = map.containsKey(directive2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    @NotNull
    public List<String> get(@NotNull StringDirective directive2) {
        Intrinsics.checkNotNullParameter((Object)directive2, (String)"directive");
        List<String> list2 = this.stringDirectives.get(directive2);
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    @Override
    @NotNull
    public <T> List<T> get(@NotNull ValueDirective<T> directive2) {
        Intrinsics.checkNotNullParameter(directive2, (String)"directive");
        List<Object> list2 = this.valueDirectives.get(directive2);
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    @Override
    public boolean isEmpty() {
        return this.simpleDirectives.isEmpty() && this.stringDirectives.isEmpty() && this.valueDirectives.isEmpty();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3;
        List v;
        Directive d;
        Object $dstr$d$v;
        Object element$iv;
        StringBuilder stringBuilder4;
        StringBuilder $this$toString_u24lambda_u2d3 = stringBuilder4 = new StringBuilder();
        boolean bl = false;
        Map<ValueDirective<?>, List<Object>> $this$forEach$iv = this.simpleDirectives;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            SimpleDirective it = (SimpleDirective)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder5 = $this$toString_u24lambda_u2d3.append(Intrinsics.stringPlus((String)"  ", (Object)it));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            StringBuilder stringBuilder6 = stringBuilder5.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append('\\n')");
        }
        $this$forEach$iv = this.stringDirectives;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            $dstr$d$v = element$iv = (Map.Entry)iterator2.next();
            boolean bl3 = false;
            d = (StringDirective)$dstr$d$v.getKey();
            v = (List)$dstr$d$v.getValue();
            stringBuilder3 = $this$toString_u24lambda_u2d3.append("  " + d + ": " + StringUtilsKt.joinToArrayString(v));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            stringBuilder2 = stringBuilder3.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append('\\n')");
        }
        $this$forEach$iv = this.valueDirectives;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            $dstr$d$v = element$iv = (Map.Entry)iterator2.next();
            boolean bl4 = false;
            d = (ValueDirective)$dstr$d$v.getKey();
            v = (List)$dstr$d$v.getValue();
            stringBuilder3 = $this$toString_u24lambda_u2d3.append("  " + d + ": " + StringUtilsKt.joinToArrayString(v));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            stringBuilder2 = stringBuilder3.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append('\\n')");
        }
        String string2 = stringBuilder4.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Override
    @NotNull
    public Iterator<Directive> iterator() {
        List list2;
        List $this$iterator_u24lambda_u2d4 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$iterator_u24lambda_u2d4.addAll((Collection)this.simpleDirectives);
        $this$iterator_u24lambda_u2d4.addAll((Collection)this.stringDirectives.keySet());
        $this$iterator_u24lambda_u2d4.addAll((Collection)this.valueDirectives.keySet());
        return CollectionsKt.build((List)list2).iterator();
    }
}

