/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.clientserver;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.clientserver.MessageHeader;
import org.jetbrains.kotlin.test.clientserver.TestProcessServerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/test/clientserver/ServerTest;", "Ljava/lang/Runnable;", "clientSocket", "Ljava/net/Socket;", "suppressOutput", "", "(Ljava/net/Socket;Z)V", "className", "", "getClientSocket", "()Ljava/net/Socket;", "getSuppressOutput", "()Z", "testMethod", "executeTest", "classLoader", "Ljava/lang/ClassLoader;", "run", "", "Companion", "tests-common-jvm6"})
final class ServerTest
implements Runnable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Socket clientSocket;
    private final boolean suppressOutput;
    private String className;
    private String testMethod;
    @NotNull
    private static final ClassLoader JDK_EXT_JARS_CLASS_LOADER;

    public ServerTest(@NotNull Socket clientSocket, boolean suppressOutput) {
        Intrinsics.checkNotNullParameter((Object)clientSocket, (String)"clientSocket");
        this.clientSocket = clientSocket;
        this.suppressOutput = suppressOutput;
    }

    @NotNull
    public final Socket getClientSocket() {
        return this.clientSocket;
    }

    public final boolean getSuppressOutput() {
        return this.suppressOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object message2;
        ObjectInputStream input = new ObjectInputStream(this.clientSocket.getInputStream());
        ObjectOutputStream output = this.suppressOutput ? null : new ObjectOutputStream(this.clientSocket.getOutputStream());
        try {
            boolean bl;
            Object object;
            boolean bl2;
            message2 = null;
            Object object2 = input.readObject();
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.test.clientserver.MessageHeader");
            }
            message2 = (MessageHeader)((Object)object2);
            boolean bl3 = bl2 = message2 == MessageHeader.NEW_TEST;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-ServerTest$run$32 = false;
                String $i$a$-assert-ServerTest$run$32 = "New test marker missed, but " + (Object)message2 + " received";
                throw new AssertionError((Object)$i$a$-assert-ServerTest$run$32);
            }
            Object object3 = input.readObject();
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            this.className = (String)object3;
            object3 = input.readObject();
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            this.testMethod = (String)object3;
            object3 = this.className;
            if (object3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"className");
                object = null;
            } else {
                object = object3;
            }
            System.out.println((Object)Intrinsics.stringPlus((String)"Preparing to execute test ", (Object)object));
            object3 = input.readObject();
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.test.clientserver.MessageHeader");
            }
            message2 = (MessageHeader)((Object)object3);
            boolean bl4 = bl = message2 == MessageHeader.CLASS_PATH;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-ServerTest$run$42 = false;
                String $i$a$-assert-ServerTest$run$42 = "Class path marker missed, but " + (Object)message2 + " received";
                throw new AssertionError((Object)$i$a$-assert-ServerTest$run$42);
            }
            Object $i$a$-assert-ServerTest$run$42 = input.readObject();
            if ($i$a$-assert-ServerTest$run$42 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<java.net.URL>");
            }
            URL[] classPath2 = (URL[])$i$a$-assert-ServerTest$run$42;
            String result2 = this.executeTest(new URLClassLoader(classPath2, JDK_EXT_JARS_CLASS_LOADER));
            ObjectOutputStream objectOutputStream = output;
            if (objectOutputStream != null) {
                objectOutputStream.writeObject((Object)MessageHeader.RESULT);
            }
            objectOutputStream = output;
            if (objectOutputStream == null) {
            } else {
                objectOutputStream.writeObject(result2);
            }
        }
        catch (Throwable e) {
            ObjectOutputStream objectOutputStream = output;
            if (objectOutputStream != null) {
                objectOutputStream.writeObject((Object)MessageHeader.ERROR);
            }
            objectOutputStream = output;
            if (objectOutputStream == null) {
            } else {
                objectOutputStream.writeObject(e);
            }
        }
        finally {
            message2 = output;
            if (message2 != null) {
                ((ObjectOutputStream)message2).close();
            }
            input.close();
            this.clientSocket.close();
        }
    }

    @NotNull
    public final String executeTest(@NotNull ClassLoader classLoader) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        String string3 = this.className;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"className");
            string2 = null;
        } else {
            string2 = string3;
        }
        Class<?> clazz = TestProcessServerKt.getGeneratedClass(classLoader, string2);
        Method method = TestProcessServerKt.getBoxMethodOrNull(clazz);
        Intrinsics.checkNotNull((Object)method);
        string3 = TestProcessServerKt.runBoxMethod(method);
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    static {
        List list2;
        File[] listFiles;
        Companion = new Companion(null);
        String javaHome = System.getProperty("java.home");
        File extFolder = new File(Intrinsics.stringPlus((String)javaHome, (Object)"/lib/ext/"));
        System.out.println((Object)extFolder.getCanonicalPath());
        File[] fileArray = listFiles = extFolder.listFiles();
        if (fileArray == null) {
            list2 = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                void it = element$iv$iv;
                boolean bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                if (!StringsKt.endsWith$default((String)string2, (String)".jar", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                URL uRL = it.toURI().toURL();
                collection.add(uRL);
            }
            list2 = (List)destination$iv$iv;
        }
        List additionalJars = list2;
        Collection $this$toTypedArray$iv = additionalJars;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        JDK_EXT_JARS_CLASS_LOADER = new URLClassLoader(uRLArray, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/clientserver/ServerTest$Companion;", "", "()V", "JDK_EXT_JARS_CLASS_LOADER", "Ljava/lang/ClassLoader;", "getJDK_EXT_JARS_CLASS_LOADER", "()Ljava/lang/ClassLoader;", "tests-common-jvm6"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClassLoader getJDK_EXT_JARS_CLASS_LOADER() {
            return JDK_EXT_JARS_CLASS_LOADER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

