/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCallGenerator;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCodegenUtilsKt;
import org.jetbrains.kotlin.backend.jvm.codegen.IrTypeMappingKt;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.overrides.IrOverridingUtilKt;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u001dH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/JvmInvokeDynamic;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "()V", "generateBootstrapMethodArg", "", "element", "Lorg/jetbrains/kotlin/ir/expressions/IrVarargElement;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "generateMethodHandle", "Lorg/jetbrains/org/objectweb/asm/Handle;", "irRawFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRawFunctionReference;", "generateOriginalMethodType", "Lorg/jetbrains/org/objectweb/asm/Type;", "irCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "generateSubstitutedMethodType", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "replaceTypeArgumentsWithNullable", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "substitutedType", "getIntConst", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Ljava/lang/Integer;", "getStringConst", "", "backend.jvm"})
public final class JvmInvokeDynamic
extends IntrinsicMethod {
    @NotNull
    public static final JvmInvokeDynamic INSTANCE = new JvmInvokeDynamic();

    private JvmInvokeDynamic() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        IrExpression irExpression;
        Integer n;
        IrCall irCall;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrExpression irExpression2 = expression2.getValueArgument(0);
        IrCall irCall2 = irCall = irExpression2 instanceof IrCall ? (IrCall)irExpression2 : null;
        if (irCall == null) {
            JvmInvokeDynamic.invoke$fail(expression2, "'dynamicCall' is expected to be a call");
            throw null;
        }
        IrCall dynamicCall = irCall;
        IrSimpleFunction dynamicCallee = (IrSimpleFunction)dynamicCall.getSymbol().getOwner();
        if (!Intrinsics.areEqual((Object)dynamicCallee.getParent(), (Object)codegen2.getContext().getIr().getSymbols().getKotlinJvmInternalInvokeDynamicPackage()) || !Intrinsics.areEqual((Object)dynamicCallee.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INVOVEDYNAMIC_CALL_TARGET.INSTANCE)) {
            JvmInvokeDynamic.invoke$fail(expression2, "Unexpected dynamicCallee: '" + RenderIrElementKt.render(dynamicCallee) + '\'');
            throw null;
        }
        IrExpression irExpression3 = expression2.getValueArgument(1);
        Integer n2 = n = irExpression3 == null ? null : this.getIntConst(irExpression3);
        if (n == null) {
            JvmInvokeDynamic.invoke$fail(expression2, "'bootstrapMethodTag' is expected to be an int const");
            throw null;
        }
        int bootstrapMethodTag = n;
        IrExpression irExpression4 = expression2.getValueArgument(2);
        IrExpression irExpression5 = irExpression3 = irExpression4 == null ? null : this.getStringConst(irExpression4);
        if (irExpression3 == null) {
            JvmInvokeDynamic.invoke$fail(expression2, "'bootstrapMethodOwner' is expected to be a string const");
            throw null;
        }
        IrExpression bootstrapMethodOwner = irExpression3;
        IrExpression irExpression6 = expression2.getValueArgument(3);
        IrExpression irExpression7 = irExpression4 = irExpression6 == null ? null : this.getStringConst(irExpression6);
        if (irExpression4 == null) {
            JvmInvokeDynamic.invoke$fail(expression2, "'bootstrapMethodName' is expected to be a string const");
            throw null;
        }
        IrExpression bootstrapMethodName = irExpression4;
        IrExpression irExpression8 = expression2.getValueArgument(4);
        IrExpression irExpression9 = irExpression6 = irExpression8 == null ? null : this.getStringConst(irExpression8);
        if (irExpression6 == null) {
            JvmInvokeDynamic.invoke$fail(expression2, "'bootstrapMethodDesc' is expected to be a string const");
            throw null;
        }
        IrExpression bootstrapMethodDesc = irExpression6;
        Object object = expression2.getValueArgument(5);
        if (object == null) {
            irExpression = null;
        } else {
            IrExpression $this$safeAs$iv = object;
            boolean $i$f$safeAs = false;
            IrExpression irExpression10 = $this$safeAs$iv;
            if (!(irExpression10 instanceof IrVararg)) {
                irExpression10 = null;
            }
            irExpression = irExpression8 = (IrVararg)irExpression10;
        }
        if (irExpression8 == null) {
            JvmInvokeDynamic.invoke$fail(expression2, "'bootstrapMethodArgs' is expected to be a vararg");
            throw null;
        }
        IrExpression bootstrapMethodArgs = irExpression8;
        object = ((IrVararg)bootstrapMethodArgs).getElements();
        boolean $i$f$map = false;
        void $i$f$safeAs = $this$map$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
            Object[] objectArray = destination$iv$iv;
            boolean bl = false;
            Object object2 = INSTANCE.generateBootstrapMethodArg((IrVarargElement)it, codegen2);
            objectArray.add(object2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        destination$iv$iv = thisCollection$iv.toArray(new Object[0]);
        if (destination$iv$iv == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        Object[] asmBootstrapMethodArgs = destination$iv$iv;
        Method dynamicCalleeMethod = codegen2.getMethodSignatureMapper().mapAsmMethod(dynamicCallee);
        Handle bootstrapMethodHandle = new Handle(bootstrapMethodTag, (String)((Object)bootstrapMethodOwner), (String)((Object)bootstrapMethodName), (String)((Object)bootstrapMethodDesc), false);
        IrCallGenerator.DefaultCallGenerator dynamicCallGenerator = IrCallGenerator.DefaultCallGenerator.INSTANCE;
        Object[] dynamicCalleeArgumentTypes = dynamicCalleeMethod.getArgumentTypes();
        int n3 = 0;
        int n4 = dynamicCallee.getValueParameters().size();
        while (n3 < n4) {
            int i = n3++;
            IrValueParameter dynamicCalleeParameter = dynamicCallee.getValueParameters().get(i);
            IrExpression irExpression11 = dynamicCall.getValueArgument(i);
            if (irExpression11 == null) {
                JvmInvokeDynamic.invoke$fail(expression2, "No argument #" + i + " in 'dynamicCall'");
                throw null;
            }
            IrExpression dynamicCalleeArgument = irExpression11;
            Intrinsics.checkNotNullExpressionValue((Object)dynamicCalleeArgumentTypes, (String)"dynamicCalleeArgumentTypes");
            Object[] objectArray = dynamicCalleeArgumentTypes;
            if (i < 0 || i > ArraysKt.getLastIndex((Object[])objectArray)) {
                int it = i;
                boolean bl = false;
                JvmInvokeDynamic.invoke$fail(expression2, "No argument type #" + i + " in dynamic callee: " + dynamicCalleeMethod);
                throw null;
            }
            Object dynamicCalleeArgumentType = objectArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)dynamicCalleeArgumentType, (String)"dynamicCalleeArgumentType");
            dynamicCallGenerator.genValueAndPut(dynamicCalleeParameter, dynamicCalleeArgument, (Type)dynamicCalleeArgumentType, codegen2, data);
        }
        codegen2.getMv().invokedynamic(dynamicCalleeMethod.getName(), dynamicCalleeMethod.getDescriptor(), bootstrapMethodHandle, asmBootstrapMethodArgs);
        Type type2 = dynamicCalleeMethod.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"dynamicCalleeMethod.returnType");
        return new MaterialValue(codegen2, type2, expression2.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object generateBootstrapMethodArg(IrVarargElement element, ExpressionCodegen codegen2) {
        Object object;
        IrVarargElement irVarargElement = element;
        if (irVarargElement instanceof IrRawFunctionReference) {
            object = this.generateMethodHandle((IrRawFunctionReference)element, codegen2);
            return object;
        } else if (irVarargElement instanceof IrCall) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = ((IrCall)element).getSymbol();
            if (Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)codegen2.getContext().getIr().getSymbols().getJvmOriginalMethodTypeIntrinsic())) {
                object = this.generateOriginalMethodType((IrCall)element, codegen2);
                return object;
            } else {
                if (!Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)codegen2.getContext().getIr().getSymbols().getJvmSubstitutedMethodTypeIntrinsic())) throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected callee in bootstrap method argument:\n", (Object)DumpIrTreeKt.dump$default(element, false, false, 3, null)));
                object = this.generateSubstitutedMethodType((IrCall)element, codegen2);
            }
            return object;
        } else {
            if (!(irVarargElement instanceof IrConst)) throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected bootstrap method argument:\n", (Object)DumpIrTreeKt.dump$default(element, false, false, 3, null)));
            IrConstKind irConstKind = ((IrConst)element).getKind();
            if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Byte.INSTANCE)) {
                Object t = ((IrConst)element).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                }
                object = Integer.valueOf(((Byte)t).byteValue());
                return object;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Short.INSTANCE)) {
                Object t = ((IrConst)element).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                }
                object = Integer.valueOf(((Short)t).shortValue());
                return object;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Int.INSTANCE)) {
                Object t = ((IrConst)element).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                object = (Integer)t;
                return object;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Long.INSTANCE)) {
                Object t = ((IrConst)element).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                }
                object = (Long)t;
                return object;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Float.INSTANCE)) {
                Object t = ((IrConst)element).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                object = Float.valueOf(((Float)t).floatValue());
                return object;
            } else if (Intrinsics.areEqual(irConstKind, (Object)IrConstKind.Double.INSTANCE)) {
                Object t = ((IrConst)element).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                }
                object = (Double)t;
                return object;
            } else {
                if (!Intrinsics.areEqual(irConstKind, (Object)IrConstKind.String.INSTANCE)) throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected constant expression in bootstrap method argument:\n", (Object)DumpIrTreeKt.dump$default(element, false, false, 3, null)));
                Object t = ((IrConst)element).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                object = (String)t;
            }
        }
        return object;
    }

    private final Handle generateMethodHandle(IrRawFunctionReference irRawFunctionReference, ExpressionCodegen codegen2) {
        IrClass irClass2;
        IrFunction irFunction2;
        IrFunction irFun0 = irRawFunctionReference.getSymbol().getOwner();
        if (irFun0 instanceof IrConstructor) {
            irFunction2 = irFun0;
        } else if (irFun0 instanceof IrSimpleFunction) {
            irFunction2 = codegen2.getMethodSignatureMapper().findSuperDeclaration$backend_jvm((IrSimpleFunction)irFun0, false);
        } else {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Simple function or constructor expected: ", (Object)RenderIrElementKt.render(irFun0)));
        }
        IrFunction irFun = irFunction2;
        IrDeclarationParent irDeclarationParent = irFun.getParent();
        IrClass irClass3 = irClass2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass2 == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected parent: ", (Object)RenderIrElementKt.render(irFun.getParent())));
        }
        IrClass irParentClass = irClass2;
        Type owner = IrTypeMappingKt.mapOwner(codegen2.getTypeMapper(), irParentClass);
        Method asmMethod2 = codegen2.getMethodSignatureMapper().mapAsmMethod(irFun);
        int handleTag = irFun instanceof IrConstructor ? 8 : (irFun.getDispatchReceiverParameter() == null ? 6 : (IrCodegenUtilsKt.isJvmInterface(irParentClass) ? 9 : 5));
        return new Handle(handleTag, owner.getInternalName(), asmMethod2.getName(), asmMethod2.getDescriptor(), IrCodegenUtilsKt.isJvmInterface(irParentClass));
    }

    private final Type generateOriginalMethodType(IrCall irCall, ExpressionCodegen codegen2) {
        IrRawFunctionReference irRawFunctionReference;
        IrExpression irExpression = irCall.getValueArgument(0);
        IrRawFunctionReference irRawFunctionReference2 = irRawFunctionReference = irExpression instanceof IrRawFunctionReference ? (IrRawFunctionReference)irExpression : null;
        if (irRawFunctionReference == null) {
            throw new AssertionError((Object)("Argument in " + ((IrSimpleFunction)irCall.getSymbol().getOwner()).getName() + " call is expected to be a raw function reference:\n" + DumpIrTreeKt.dump$default(irCall, false, false, 3, null)));
        }
        IrRawFunctionReference irRawFunRef = irRawFunctionReference;
        IrFunction irFun = irRawFunRef.getSymbol().getOwner();
        Method asmMethod2 = codegen2.getMethodSignatureMapper().mapAsmMethod(irFun);
        Type type2 = Type.getMethodType((String)asmMethod2.getDescriptor());
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getMethodType(asmMethod.descriptor)");
        return type2;
    }

    private final Type generateSubstitutedMethodType(IrCall irCall, ExpressionCodegen codegen2) {
        IrClassBuilder irClassBuilder;
        IrRawFunctionReference irRawFunctionReference;
        IrElementBase irElementBase = irCall.getValueArgument(0);
        IrRawFunctionReference irRawFunctionReference2 = irRawFunctionReference = irElementBase instanceof IrRawFunctionReference ? (IrRawFunctionReference)irElementBase : null;
        if (irRawFunctionReference == null) {
            JvmInvokeDynamic.generateSubstitutedMethodType$fail-2(irCall, "Argument in " + ((IrSimpleFunction)irCall.getSymbol().getOwner()).getName() + " call is expected to be a raw function reference");
            throw null;
        }
        IrRawFunctionReference irRawFunRef = irRawFunctionReference;
        IrAnnotationContainer irAnnotationContainer = irRawFunRef.getSymbol().getOwner();
        IrElementBase irElementBase2 = irElementBase = irAnnotationContainer instanceof IrSimpleFunction ? (IrSimpleFunction)irAnnotationContainer : null;
        if (irElementBase == null) {
            JvmInvokeDynamic.generateSubstitutedMethodType$fail-2(irCall, Intrinsics.stringPlus((String)"IrSimpleFunction expected: ", (Object)RenderIrElementKt.render(irRawFunRef.getSymbol().getOwner())));
            throw null;
        }
        IrElementBase irOriginalFun = irElementBase;
        IrType irType = irCall.getTypeArgument(0);
        IrAnnotationContainer irAnnotationContainer2 = irAnnotationContainer = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irAnnotationContainer == null) {
            JvmInvokeDynamic.generateSubstitutedMethodType$fail-2(irCall, "Type argument expected");
            throw null;
        }
        IrAnnotationContainer superType2 = irAnnotationContainer;
        IrSimpleType patchedSuperType = this.replaceTypeArgumentsWithNullable((IrSimpleType)superType2);
        IrFactory $this$buildClass$iv = codegen2.getContext().getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u2d1$iv = irClassBuilder = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$generateSubstitutedMethodType_u24lambda_u2d3 = $this$buildClass_u24lambda_u2d1$iv;
        boolean bl2 = false;
        Name name2 = Name.special("<fake>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<fake>\")");
        $this$generateSubstitutedMethodType_u24lambda_u2d3.setName(name2);
        IrClass fakeClass = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u2d1$iv);
        fakeClass.setParent(codegen2.getContext().getIr().getSymbols().getKotlinJvmInternalInvokeDynamicPackage());
        IrSimpleFunction irFakeOverride = (IrSimpleFunction)IrOverridingUtilKt.buildFakeOverrideMember(patchedSuperType, (IrOverridableMember)((Object)irOriginalFun), fakeClass);
        irFakeOverride.setOverriddenSymbols(CollectionsKt.listOf((Object)((IrSimpleFunction)irOriginalFun).getSymbol()));
        Method asmMethod2 = codegen2.getMethodSignatureMapper().mapAsmMethod(irFakeOverride);
        irClassBuilder = Type.getMethodType((String)asmMethod2.getDescriptor());
        Intrinsics.checkNotNullExpressionValue((Object)irClassBuilder, (String)"getMethodType(asmMethod.descriptor)");
        return irClassBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleType replaceTypeArgumentsWithNullable(IrSimpleType substitutedType) {
        Collection<void> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = substitutedType.getArguments();
        IrClassifierSymbol irClassifierSymbol = substitutedType.getClassifier();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument;
            void typeArgument;
            IrTypeArgument irTypeArgument2 = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void var11_12 = typeArgument;
            if (var11_12 instanceof IrStarProjection) {
                irTypeArgument = typeArgument;
            } else if (var11_12 instanceof IrTypeProjection) {
                IrType type2 = ((IrTypeProjection)typeArgument).getType();
                irTypeArgument = !(type2 instanceof IrSimpleType) || ((IrSimpleType)type2).getHasQuestionMark() ? (IrTypeProjection)typeArgument : IrSimpleTypeImplKt.makeTypeProjection(IrTypesKt.withHasQuestionMark((IrSimpleType)type2, true), ((IrTypeProjection)typeArgument).getVariance());
            } else {
                throw new AssertionError((Object)("Unexpected type argument '" + typeArgument + "' :: " + Reflection.getOrCreateKotlinClass(typeArgument.getClass()).getSimpleName()));
            }
            void var15_15 = irTypeArgument;
            collection.add(var15_15);
        }
        collection = (List)destination$iv$iv;
        return IrTypesKt.typeWithArguments(irClassifierSymbol, (List<? extends IrTypeArgument>)collection);
    }

    private final Integer getIntConst(IrExpression $this$getIntConst) {
        Integer n;
        if ($this$getIntConst instanceof IrConst && Intrinsics.areEqual(((IrConst)$this$getIntConst).getKind(), (Object)IrConstKind.Int.INSTANCE)) {
            Object t = ((IrConst)$this$getIntConst).getValue();
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            n = (int)((Integer)t);
        } else {
            n = null;
        }
        return n;
    }

    private final String getStringConst(IrExpression $this$getStringConst) {
        String string2;
        if ($this$getStringConst instanceof IrConst && Intrinsics.areEqual(((IrConst)$this$getStringConst).getKind(), (Object)IrConstKind.String.INSTANCE)) {
            Object t = ((IrConst)$this$getStringConst).getValue();
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            string2 = (String)t;
        } else {
            string2 = null;
        }
        return string2;
    }

    private static final Void invoke$fail(IrFunctionAccessExpression $expression, String message2) {
        throw new AssertionError((Object)(message2 + "; expression:\n" + DumpIrTreeKt.dump$default($expression, false, false, 3, null)));
    }

    private static final Void generateSubstitutedMethodType$fail-2(IrCall $irCall, String message2) {
        throw new AssertionError((Object)(message2 + "; irCall:\n" + DumpIrTreeKt.dump$default($irCall, false, false, 3, null)));
    }
}

