/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners.codegen;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.codegen.AbstractBytecodeListingTest;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="compiler/testData/codegen/bytecodeListing")
@TestDataPath(value="$PROJECT_ROOT")
public class BytecodeListingTestGenerated
extends AbstractBytecodeListingTest {
    @Test
    @TestMetadata(value="accessorForProtectedPropertyWithPrivateSetter.kt")
    public void testAccessorForProtectedPropertyWithPrivateSetter() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/accessorForProtectedPropertyWithPrivateSetter.kt");
    }

    @Test
    @TestMetadata(value="accessorForProtectedPropertyWithPrivateSetterInObjectLiteral.kt")
    public void testAccessorForProtectedPropertyWithPrivateSetterInObjectLiteral() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/accessorForProtectedPropertyWithPrivateSetterInObjectLiteral.kt");
    }

    @Test
    @TestMetadata(value="accessorForTopLevelMembers.kt")
    public void testAccessorForTopLevelMembers() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/accessorForTopLevelMembers.kt");
    }

    @Test
    @TestMetadata(value="accessorsForProtectedStaticJavaFieldInOtherPackage.kt")
    public void testAccessorsForProtectedStaticJavaFieldInOtherPackage() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/accessorsForProtectedStaticJavaFieldInOtherPackage.kt");
    }

    @Test
    public void testAllFilesPresentInBytecodeListing() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
    }

    @Test
    @TestMetadata(value="anonymousObjectInGenericFun.kt")
    public void testAnonymousObjectInGenericFun() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/anonymousObjectInGenericFun.kt");
    }

    @Test
    @TestMetadata(value="callableNameIntrinsic.kt")
    public void testCallableNameIntrinsic() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/callableNameIntrinsic.kt");
    }

    @Test
    @TestMetadata(value="callableReferenceArrayConstructorArguments.kt")
    public void testCallableReferenceArrayConstructorArguments() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/callableReferenceArrayConstructorArguments.kt");
    }

    @Test
    @TestMetadata(value="cloneable.kt")
    public void testCloneable() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/cloneable.kt");
    }

    @Test
    @TestMetadata(value="companionObjectVisibility_after.kt")
    public void testCompanionObjectVisibility_after() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/companionObjectVisibility_after.kt");
    }

    @Test
    @TestMetadata(value="companionObjectVisibility_before.kt")
    public void testCompanionObjectVisibility_before() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/companionObjectVisibility_before.kt");
    }

    @Test
    @TestMetadata(value="defaultImpls.kt")
    public void testDefaultImpls() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/defaultImpls.kt");
    }

    @Test
    @TestMetadata(value="delegationToJavaInterfaceWithWildcardType.kt")
    public void testDelegationToJavaInterfaceWithWildcardType() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/delegationToJavaInterfaceWithWildcardType.kt");
    }

    @Test
    @TestMetadata(value="enum.kt")
    public void testEnum() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/enum.kt");
    }

    @Test
    @TestMetadata(value="extension.kt")
    public void testExtension() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/extension.kt");
    }

    @Test
    @TestMetadata(value="fileClassWithPrivateDeclarationsOnly_after.kt")
    public void testFileClassWithPrivateDeclarationsOnly_after() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/fileClassWithPrivateDeclarationsOnly_after.kt");
    }

    @Test
    @TestMetadata(value="fileClassWithPrivateDeclarationsOnly_before.kt")
    public void testFileClassWithPrivateDeclarationsOnly_before() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/fileClassWithPrivateDeclarationsOnly_before.kt");
    }

    @Test
    @TestMetadata(value="immutableCollection.kt")
    public void testImmutableCollection() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/immutableCollection.kt");
    }

    @Test
    @TestMetadata(value="javaDeprecated.kt")
    public void testJavaDeprecated() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/javaDeprecated.kt");
    }

    @Test
    @TestMetadata(value="jvmOverloadsAndParametersAnnotations.kt")
    public void testJvmOverloadsAndParametersAnnotations() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/jvmOverloadsAndParametersAnnotations.kt");
    }

    @Test
    @TestMetadata(value="jvmOverloadsExternal.kt")
    public void testJvmOverloadsExternal() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/jvmOverloadsExternal.kt");
    }

    @Test
    @TestMetadata(value="jvmRecordStructure.kt")
    public void testJvmRecordStructure() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/jvmRecordStructure.kt");
    }

    @Test
    @TestMetadata(value="jvmStaticExternal.kt")
    public void testJvmStaticExternal() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/jvmStaticExternal.kt");
    }

    @Test
    @TestMetadata(value="jvmStaticWithDefaultParameters.kt")
    public void testJvmStaticWithDefaultParameters() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/jvmStaticWithDefaultParameters.kt");
    }

    @Test
    @TestMetadata(value="kt31389.kt")
    public void testKt31389() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/kt31389.kt");
    }

    @Test
    @TestMetadata(value="kt42137.kt")
    public void testKt42137() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/kt42137.kt");
    }

    @Test
    @TestMetadata(value="kt42879.kt")
    public void testKt42879() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/kt42879.kt");
    }

    @Test
    @TestMetadata(value="kt43217.kt")
    public void testKt43217() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/kt43217.kt");
    }

    @Test
    @TestMetadata(value="kt43440.kt")
    public void testKt43440() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/kt43440.kt");
    }

    @Test
    @TestMetadata(value="kt45853.kt")
    public void testKt45853() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/kt45853.kt");
    }

    @Test
    @TestMetadata(value="kt45853a.kt")
    public void testKt45853a() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/kt45853a.kt");
    }

    @Test
    @TestMetadata(value="kt45934.kt")
    public void testKt45934() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/kt45934.kt");
    }

    @Test
    @TestMetadata(value="kt47328.kt")
    public void testKt47328() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/kt47328.kt");
    }

    @Test
    @TestMetadata(value="noCollectionStubMethodsInInterface.kt")
    public void testNoCollectionStubMethodsInInterface() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/noCollectionStubMethodsInInterface.kt");
    }

    @Test
    @TestMetadata(value="noDelegationsToPrivateInterfaceMembers.kt")
    public void testNoDelegationsToPrivateInterfaceMembers() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/noDelegationsToPrivateInterfaceMembers.kt");
    }

    @Test
    @TestMetadata(value="noReceiverInCallableReferenceClasses.kt")
    public void testNoReceiverInCallableReferenceClasses() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/noReceiverInCallableReferenceClasses.kt");
    }

    @Test
    @TestMetadata(value="noRemoveAtInReadOnly.kt")
    public void testNoRemoveAtInReadOnly() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/noRemoveAtInReadOnly.kt");
    }

    @Test
    @TestMetadata(value="overrideWithPrimitiveUpperBound.kt")
    public void testOverrideWithPrimitiveUpperBound() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/overrideWithPrimitiveUpperBound.kt");
    }

    @Test
    @TestMetadata(value="overrideWithPrimitiveUpperBound2.kt")
    public void testOverrideWithPrimitiveUpperBound2() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/overrideWithPrimitiveUpperBound2.kt");
    }

    @Test
    @TestMetadata(value="privateCompanionFields.kt")
    public void testPrivateCompanionFields() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/privateCompanionFields.kt");
    }

    @Test
    @TestMetadata(value="privateDefaultImpls.kt")
    public void testPrivateDefaultImpls() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/privateDefaultImpls.kt");
    }

    @Test
    @TestMetadata(value="privateDefaultSetter.kt")
    public void testPrivateDefaultSetter() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/privateDefaultSetter.kt");
    }

    @Test
    @TestMetadata(value="privateNestedClassInInterface.kt")
    public void testPrivateNestedClassInInterface() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/privateNestedClassInInterface.kt");
    }

    @Test
    @TestMetadata(value="rawTypeInSignature.kt")
    public void testRawTypeInSignature() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/rawTypeInSignature.kt");
    }

    @Test
    @TestMetadata(value="strictfpFlag.kt")
    public void testStrictfpFlag() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/strictfpFlag.kt");
    }

    @Test
    @TestMetadata(value="synchronizedFlag.kt")
    public void testSynchronizedFlag() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/synchronizedFlag.kt");
    }

    @Test
    @TestMetadata(value="varargsBridge.kt")
    public void testVarargsBridge() throws Exception {
        this.runTest("compiler/testData/codegen/bytecodeListing/varargsBridge.kt");
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/specialBridges")
    @TestDataPath(value="$PROJECT_ROOT")
    public class SpecialBridges {
        @Test
        @TestMetadata(value="abstractCollections.kt")
        public void testAbstractCollections() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractCollections.kt");
        }

        @Test
        @TestMetadata(value="abstractIterables.kt")
        public void testAbstractIterables() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractIterables.kt");
        }

        @Test
        @TestMetadata(value="abstractLists.kt")
        public void testAbstractLists() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractLists.kt");
        }

        @Test
        @TestMetadata(value="abstractListsWithJavaBase.kt")
        public void testAbstractListsWithJavaBase() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractListsWithJavaBase.kt");
        }

        @Test
        @TestMetadata(value="abstractMutableCollectionOfPrimitive.kt")
        public void testAbstractMutableCollectionOfPrimitive() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableCollectionOfPrimitive.kt");
        }

        @Test
        @TestMetadata(value="abstractMutableListOfPrimitive.kt")
        public void testAbstractMutableListOfPrimitive() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableListOfPrimitive.kt");
        }

        @Test
        @TestMetadata(value="abstractMutableLists.kt")
        public void testAbstractMutableLists() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableLists.kt");
        }

        @Test
        @TestMetadata(value="abstractSets.kt")
        public void testAbstractSets() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractSets.kt");
        }

        @Test
        public void testAllFilesPresentInSpecialBridges() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/specialBridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="charSequence.kt")
        public void testCharSequence() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/charSequence.kt");
        }

        @Test
        @TestMetadata(value="contains.kt")
        public void testContains() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/contains.kt");
        }

        @Test
        @TestMetadata(value="kt41123.kt")
        public void testKt41123() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/kt41123.kt");
        }

        @Test
        @TestMetadata(value="mutableCollectionOfPrimitive.kt")
        public void testMutableCollectionOfPrimitive() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/mutableCollectionOfPrimitive.kt");
        }

        @Test
        @TestMetadata(value="mutableListOfPrimitive.kt")
        public void testMutableListOfPrimitive() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/mutableListOfPrimitive.kt");
        }

        @Test
        @TestMetadata(value="noDefaultImplsOnEmptySubInterface.kt")
        public void testNoDefaultImplsOnEmptySubInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/noDefaultImplsOnEmptySubInterface.kt");
        }

        @Test
        @TestMetadata(value="noSpecialBridgeIfPresentInSuperClass.kt")
        public void testNoSpecialBridgeIfPresentInSuperClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/noSpecialBridgeIfPresentInSuperClass.kt");
        }

        @Test
        @TestMetadata(value="number.kt")
        public void testNumber() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/number.kt");
        }

        @Test
        @TestMetadata(value="redundantStubForSize.kt")
        public void testRedundantStubForSize() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/redundantStubForSize.kt");
        }

        @Test
        @TestMetadata(value="removeAtTwoSpecialBridges.kt")
        public void testRemoveAtTwoSpecialBridges() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/removeAtTwoSpecialBridges.kt");
        }

        @Test
        @TestMetadata(value="unsignedArray.kt")
        public void testUnsignedArray() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/unsignedArray.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/specialBridges/signatures")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Signatures {
            @Test
            public void testAllFilesPresentInSignatures() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/specialBridges/signatures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="genericClass.kt")
            public void testGenericClass() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/genericClass.kt");
            }

            @Test
            @TestMetadata(value="implementsJavaMap.kt")
            public void testImplementsJavaMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsJavaMap.kt");
            }

            @Test
            @TestMetadata(value="implementsJavaMapWithCustomEntries.kt")
            public void testImplementsJavaMapWithCustomEntries() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsJavaMapWithCustomEntries.kt");
            }

            @Test
            @TestMetadata(value="implementsMap.kt")
            public void testImplementsMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsMap.kt");
            }

            @Test
            @TestMetadata(value="implementsSortedMap.kt")
            public void testImplementsSortedMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsSortedMap.kt");
            }

            @Test
            @TestMetadata(value="kt43610.kt")
            public void testKt43610() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/kt43610.kt");
            }

            @Test
            @TestMetadata(value="nonGenericClass.kt")
            public void testNonGenericClass() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/nonGenericClass.kt");
            }

            @Test
            @TestMetadata(value="partiallySpecializedClass.kt")
            public void testPartiallySpecializedClass() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/partiallySpecializedClass.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/sealed")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Sealed {
        @Test
        public void testAllFilesPresentInSealed() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/sealed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="annotationsOnSealedConstructor.kt")
        public void testAnnotationsOnSealedConstructor() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sealed/annotationsOnSealedConstructor.kt");
        }

        @Test
        @TestMetadata(value="sealedClassConstructor_1_4.kt")
        public void testSealedClassConstructor_1_4() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sealed/sealedClassConstructor_1_4.kt");
        }

        @Test
        @TestMetadata(value="sealedClassConstructor_1_5.kt")
        public void testSealedClassConstructor_1_5() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sealed/sealedClassConstructor_1_5.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/sam")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Sam {
        @Test
        public void testAllFilesPresentInSam() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="callableRefGenericFunInterface.kt")
        public void testCallableRefGenericFunInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefGenericFunInterface.kt");
        }

        @Test
        @TestMetadata(value="callableRefGenericSamInterface.kt")
        public void testCallableRefGenericSamInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefGenericSamInterface.kt");
        }

        @Test
        @TestMetadata(value="callableRefSpecializedFunInterface.kt")
        public void testCallableRefSpecializedFunInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefSpecializedFunInterface.kt");
        }

        @Test
        @TestMetadata(value="callableRefSpecializedSamInterface.kt")
        public void testCallableRefSpecializedSamInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefSpecializedSamInterface.kt");
        }

        @Test
        @TestMetadata(value="genericFunInterface.kt")
        public void testGenericFunInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/genericFunInterface.kt");
        }

        @Test
        @TestMetadata(value="genericSamInterface.kt")
        public void testGenericSamInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/genericSamInterface.kt");
        }

        @Test
        @TestMetadata(value="kt16650.kt")
        public void testKt16650() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/kt16650.kt");
        }

        @Test
        @TestMetadata(value="lambdaGenericFunInterface.kt")
        public void testLambdaGenericFunInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaGenericFunInterface.kt");
        }

        @Test
        @TestMetadata(value="lambdaGenericSamInterface.kt")
        public void testLambdaGenericSamInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaGenericSamInterface.kt");
        }

        @Test
        @TestMetadata(value="lambdaSpecializedFunInterface.kt")
        public void testLambdaSpecializedFunInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaSpecializedFunInterface.kt");
        }

        @Test
        @TestMetadata(value="lambdaSpecializedSamInterface.kt")
        public void testLambdaSpecializedSamInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaSpecializedSamInterface.kt");
        }

        @Test
        @TestMetadata(value="nonApproxToValidSupertype.kt")
        public void testNonApproxToValidSupertype() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/nonApproxToValidSupertype.kt");
        }

        @Test
        @TestMetadata(value="nonApproxToValidSupertype2.kt")
        public void testNonApproxToValidSupertype2() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/nonApproxToValidSupertype2.kt");
        }

        @Test
        @TestMetadata(value="privateInlineSamAdapter.kt")
        public void testPrivateInlineSamAdapter() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/privateInlineSamAdapter.kt");
        }

        @Test
        @TestMetadata(value="reusedSamWrapperClasses.kt")
        public void testReusedSamWrapperClasses() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/reusedSamWrapperClasses.kt");
        }

        @Test
        @TestMetadata(value="samAdapterAndInlinedOne.kt")
        public void testSamAdapterAndInlinedOne() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/samAdapterAndInlinedOne.kt");
        }

        @Test
        @TestMetadata(value="samAdapterInInlineLambda.kt")
        public void testSamAdapterInInlineLambda() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/samAdapterInInlineLambda.kt");
        }

        @Test
        @TestMetadata(value="specializedFunInterface.kt")
        public void testSpecializedFunInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/specializedFunInterface.kt");
        }

        @Test
        @TestMetadata(value="specializedSamInterface.kt")
        public void testSpecializedSamInterface() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/specializedSamInterface.kt");
        }

        @Test
        @TestMetadata(value="wrapperInlinedFromAnotherClass.kt")
        public void testWrapperInlinedFromAnotherClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/wrapperInlinedFromAnotherClass.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/nullabilityAnnotations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class NullabilityAnnotations {
        @Test
        public void testAllFilesPresentInNullabilityAnnotations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="lateInitNotNull.kt")
        public void testLateInitNotNull() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/lateInitNotNull.kt");
        }

        @Test
        @TestMetadata(value="nullabilityAnnotationsForReturnType.kt")
        public void testNullabilityAnnotationsForReturnType() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/nullabilityAnnotationsForReturnType.kt");
        }

        @Test
        @TestMetadata(value="nullabilityAnnotationsOnDelegatedMembers.kt")
        public void testNullabilityAnnotationsOnDelegatedMembers() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/nullabilityAnnotationsOnDelegatedMembers.kt");
        }

        @Test
        @TestMetadata(value="platformTypes.kt")
        public void testPlatformTypes() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/platformTypes.kt");
        }

        @Test
        @TestMetadata(value="samAdapterForJavaInterfaceWithNullability.kt")
        public void testSamAdapterForJavaInterfaceWithNullability() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/samAdapterForJavaInterfaceWithNullability.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/multiplatform")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Multiplatform {
        @Test
        public void testAllFilesPresentInMultiplatform() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="optionalExpectation.kt")
        public void testOptionalExpectation() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multiplatform/optionalExpectation.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/multifileClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class MultifileClasses {
        @Test
        public void testAllFilesPresentInMultifileClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="emptyMultifileFacade.kt")
        public void testEmptyMultifileFacade() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/emptyMultifileFacade.kt");
        }

        @Test
        @TestMetadata(value="jvmSynthetic.kt")
        public void testJvmSynthetic() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/jvmSynthetic.kt");
        }

        @Test
        @TestMetadata(value="kt43519.kt")
        public void testKt43519() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/kt43519.kt");
        }

        @Test
        @TestMetadata(value="multiClassPartSourceMultipleParts.kt")
        public void testMultiClassPartSourceMultipleParts() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/multiClassPartSourceMultipleParts.kt");
        }

        @Test
        @TestMetadata(value="multiClassPartSourceSinglePart.kt")
        public void testMultiClassPartSourceSinglePart() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/multiClassPartSourceSinglePart.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/main")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Main {
        @Test
        public void testAllFilesPresentInMain() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/main"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="multifileSuspend.kt")
        public void testMultifileSuspend() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/main/multifileSuspend.kt");
        }

        @Test
        @TestMetadata(value="parameterlessMain.kt")
        public void testParameterlessMain() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/main/parameterlessMain.kt");
        }

        @Test
        @TestMetadata(value="parameterlessMain_before.kt")
        public void testParameterlessMain_before() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/main/parameterlessMain_before.kt");
        }

        @Test
        @TestMetadata(value="suspendMain.kt")
        public void testSuspendMain() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/main/suspendMain.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/localFunctions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class LocalFunctions {
        @Test
        public void testAllFilesPresentInLocalFunctions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/localFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="genericClass.kt")
        public void testGenericClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericClass.kt");
        }

        @Test
        @TestMetadata(value="genericInnerClass.kt")
        public void testGenericInnerClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericInnerClass.kt");
        }

        @Test
        @TestMetadata(value="genericLocalClass.kt")
        public void testGenericLocalClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericLocalClass.kt");
        }

        @Test
        @TestMetadata(value="inInitBlock.kt")
        public void testInInitBlock() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/inInitBlock.kt");
        }

        @Test
        @TestMetadata(value="simple.kt")
        public void testSimple() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/simple.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Jvm8 {
        @Test
        public void testAllFilesPresentInJvm8() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Defaults {
            @Test
            public void testAllFilesPresentInDefaults() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl")
            @TestDataPath(value="$PROJECT_ROOT")
            public class NoDefaultImpl {
                @Test
                public void testAllFilesPresentInNoDefaultImpl() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
                }

                @Test
                @TestMetadata(value="interfaceProperty.kt")
                public void testInterfaceProperty() throws Exception {
                    BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl/interfaceProperty.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults/enable")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Enable {
                @Test
                public void testAllFilesPresentInEnable() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/enable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
                }

                @Test
                @TestMetadata(value="interfaceProperty.kt")
                public void testInterfaceProperty() throws Exception {
                    BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/enable/interfaceProperty.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility")
            @TestDataPath(value="$PROJECT_ROOT")
            public class AllCompatibility {
                @Test
                public void testAllFilesPresentInAllCompatibility() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
                }

                @Test
                @TestMetadata(value="deprecation.kt")
                public void testDeprecation() throws Exception {
                    BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/deprecation.kt");
                }

                @Test
                @TestMetadata(value="deprecationWithDefault.kt")
                public void testDeprecationWithDefault() throws Exception {
                    BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/deprecationWithDefault.kt");
                }

                @Test
                @TestMetadata(value="interfaceProperty.kt")
                public void testInterfaceProperty() throws Exception {
                    BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/interfaceProperty.kt");
                }

                @Test
                @TestMetadata(value="jvmDefaultWithoutCompatibility.kt")
                public void testJvmDefaultWithoutCompatibility() throws Exception {
                    BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/jvmDefaultWithoutCompatibility.kt");
                }

                @Test
                @TestMetadata(value="noDefaultImplsOnEmptySubInterface.kt")
                public void testNoDefaultImplsOnEmptySubInterface() throws Exception {
                    BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/noDefaultImplsOnEmptySubInterface.kt");
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Specialization {
                    @Test
                    public void testAllFilesPresentInSpecialization() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="primitiveAndAny.kt")
                    public void testPrimitiveAndAny() throws Exception {
                        BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization/primitiveAndAny.kt");
                    }

                    @Test
                    @TestMetadata(value="primitiveAndNullable.kt")
                    public void testPrimitiveAndNullable() throws Exception {
                        BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization/primitiveAndNullable.kt");
                    }
                }
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InlineClasses {
        @Test
        public void testAllFilesPresentInInlineClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="annotatedPropertyWithInlineClassTypeInSignature.kt")
        public void testAnnotatedPropertyWithInlineClassTypeInSignature() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotatedPropertyWithInlineClassTypeInSignature.kt");
        }

        @Test
        @TestMetadata(value="annotationGetters.kt")
        public void testAnnotationGetters() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotationGetters.kt");
        }

        @Test
        @TestMetadata(value="annotationsOnHiddenConstructor.kt")
        public void testAnnotationsOnHiddenConstructor() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotationsOnHiddenConstructor.kt");
        }

        @Test
        @TestMetadata(value="companionObjectInsideInlineClass.kt")
        public void testCompanionObjectInsideInlineClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/companionObjectInsideInlineClass.kt");
        }

        @Test
        @TestMetadata(value="computablePropertiesInsideInlineClass.kt")
        public void testComputablePropertiesInsideInlineClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/computablePropertiesInsideInlineClass.kt");
        }

        @Test
        @TestMetadata(value="constructor.kt")
        public void testConstructor() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/constructor.kt");
        }

        @Test
        @TestMetadata(value="constructorsWithDefaultParameterValues.kt")
        public void testConstructorsWithDefaultParameterValues() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/constructorsWithDefaultParameterValues.kt");
        }

        @Test
        @TestMetadata(value="defaultInterfaceMethodsInInlineClass.kt")
        public void testDefaultInterfaceMethodsInInlineClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMethodsInInlineClass.kt");
        }

        @Test
        @TestMetadata(value="genericChild.kt")
        public void testGenericChild() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/genericChild.kt");
        }

        @Test
        @TestMetadata(value="hiddenConstructor.kt")
        public void testHiddenConstructor() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/hiddenConstructor.kt");
        }

        @Test
        @TestMetadata(value="inlineCharSequence.kt")
        public void testInlineCharSequence() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCharSequence.kt");
        }

        @Test
        @TestMetadata(value="inlineClassMembersVisibility.kt")
        public void testInlineClassMembersVisibility() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassMembersVisibility.kt");
        }

        @Test
        @TestMetadata(value="inlineClassTypeParametersInConstructor.kt")
        public void testInlineClassTypeParametersInConstructor() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassTypeParametersInConstructor.kt");
        }

        @Test
        @TestMetadata(value="inlineClassWithInlineClassUnderlyingType.kt")
        public void testInlineClassWithInlineClassUnderlyingType() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassWithInlineClassUnderlyingType.kt");
        }

        @Test
        @TestMetadata(value="inlineClassWithManyKindsOfMembers.kt")
        public void testInlineClassWithManyKindsOfMembers() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassWithManyKindsOfMembers.kt");
        }

        @Test
        @TestMetadata(value="jvmName.kt")
        public void testJvmName() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/jvmName.kt");
        }

        @Test
        @TestMetadata(value="jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt")
        public void testJvmOverloadsOnTopLevelFunctionReturningInlineClassValue() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt");
        }

        @Test
        @TestMetadata(value="memberExtensionProperty.kt")
        public void testMemberExtensionProperty() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/memberExtensionProperty.kt");
        }

        @Test
        @TestMetadata(value="noArgConstructorForInlineClassParameter.kt")
        public void testNoArgConstructorForInlineClassParameter() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/noArgConstructorForInlineClassParameter.kt");
        }

        @Test
        @TestMetadata(value="noBridgesForErasedInlineClass.kt")
        public void testNoBridgesForErasedInlineClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/noBridgesForErasedInlineClass.kt");
        }

        @Test
        @TestMetadata(value="nullabilityAnnotationsOnInlineClassMembers.kt")
        public void testNullabilityAnnotationsOnInlineClassMembers() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullabilityAnnotationsOnInlineClassMembers.kt");
        }

        @Test
        @TestMetadata(value="nullabilityInExpansion.kt")
        public void testNullabilityInExpansion() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullabilityInExpansion.kt");
        }

        @Test
        @TestMetadata(value="nullableAndNotNullPrimitive.kt")
        public void testNullableAndNotNullPrimitive() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullableAndNotNullPrimitive.kt");
        }

        @Test
        @TestMetadata(value="overridingGenericMethodWithInlineClassParameterType.kt")
        public void testOverridingGenericMethodWithInlineClassParameterType() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/overridingGenericMethodWithInlineClassParameterType.kt");
        }

        @Test
        @TestMetadata(value="overridingGenericMethodWithInlineClassReturnType.kt")
        public void testOverridingGenericMethodWithInlineClassReturnType() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/overridingGenericMethodWithInlineClassReturnType.kt");
        }

        @Test
        @TestMetadata(value="primaryValsWithDifferentVisibilities.kt")
        public void testPrimaryValsWithDifferentVisibilities() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/primaryValsWithDifferentVisibilities.kt");
        }

        @Test
        @TestMetadata(value="publishedApiAnnotationOnInlineClassConstructor.kt")
        public void testPublishedApiAnnotationOnInlineClassConstructor() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/publishedApiAnnotationOnInlineClassConstructor.kt");
        }

        @Test
        @TestMetadata(value="shapeOfInlineClassWithPrimitive.kt")
        public void testShapeOfInlineClassWithPrimitive() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/shapeOfInlineClassWithPrimitive.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430")
        @TestDataPath(value="$PROJECT_ROOT")
        public class StdlibManglingIn1430 {
            @Test
            public void testAllFilesPresentInStdlibManglingIn1430() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="new.kt")
            public void testNew() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430/new.kt");
            }

            @Test
            @TestMetadata(value="old.kt")
            public void testOld() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430/old.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ReturnResult {
            @Test
            public void testAllFilesPresentInReturnResult() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="class.kt")
            public void testClass() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/class.kt");
            }

            @Test
            @TestMetadata(value="classAnyOverride.kt")
            public void testClassAnyOverride() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classAnyOverride.kt");
            }

            @Test
            @TestMetadata(value="classGenericOverride.kt")
            public void testClassGenericOverride() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classGenericOverride.kt");
            }

            @Test
            @TestMetadata(value="classResultOverride.kt")
            public void testClassResultOverride() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classResultOverride.kt");
            }

            @Test
            @TestMetadata(value="interface.kt")
            public void testInterface() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/interface.kt");
            }

            @Test
            @TestMetadata(value="topLevel.kt")
            public void testTopLevel() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/topLevel.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineCollectionOfInlineClass {
            @Test
            public void testAllFilesPresentInInlineCollectionOfInlineClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="collection.kt")
            public void testCollection() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/collection.kt");
            }

            @Test
            @TestMetadata(value="iterable.kt")
            public void testIterable() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/iterable.kt");
            }

            @Test
            @TestMetadata(value="iterator.kt")
            public void testIterator() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/iterator.kt");
            }

            @Test
            @TestMetadata(value="list.kt")
            public void testList() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/list.kt");
            }

            @Test
            @TestMetadata(value="map.kt")
            public void testMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/map.kt");
            }

            @Test
            @TestMetadata(value="mapEntry.kt")
            public void testMapEntry() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mapEntry.kt");
            }

            @Test
            @TestMetadata(value="mutableCollection.kt")
            public void testMutableCollection() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableCollection.kt");
            }

            @Test
            @TestMetadata(value="mutableIterable.kt")
            public void testMutableIterable() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableIterable.kt");
            }

            @Test
            @TestMetadata(value="mutableIterator.kt")
            public void testMutableIterator() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableIterator.kt");
            }

            @Test
            @TestMetadata(value="mutableList.kt")
            public void testMutableList() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableList.kt");
            }

            @Test
            @TestMetadata(value="mutableMap.kt")
            public void testMutableMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableMap.kt");
            }

            @Test
            @TestMetadata(value="mutableMapEntry.kt")
            public void testMutableMapEntry() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableMapEntry.kt");
            }

            @Test
            @TestMetadata(value="mutableSet.kt")
            public void testMutableSet() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableSet.kt");
            }

            @Test
            @TestMetadata(value="mutableSet2.kt")
            public void testMutableSet2() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableSet2.kt");
            }

            @Test
            @TestMetadata(value="set.kt")
            public void testSet() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/set.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineCollection {
            @Test
            public void testAllFilesPresentInInlineCollection() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="collection.kt")
            public void testCollection() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/collection.kt");
            }

            @Test
            @TestMetadata(value="iterable.kt")
            public void testIterable() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/iterable.kt");
            }

            @Test
            @TestMetadata(value="iterator.kt")
            public void testIterator() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/iterator.kt");
            }

            @Test
            @TestMetadata(value="list.kt")
            public void testList() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/list.kt");
            }

            @Test
            @TestMetadata(value="map.kt")
            public void testMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/map.kt");
            }

            @Test
            @TestMetadata(value="mapEntry.kt")
            public void testMapEntry() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mapEntry.kt");
            }

            @Test
            @TestMetadata(value="mutableCollection.kt")
            public void testMutableCollection() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableCollection.kt");
            }

            @Test
            @TestMetadata(value="mutableIterable.kt")
            public void testMutableIterable() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableIterable.kt");
            }

            @Test
            @TestMetadata(value="mutableIterator.kt")
            public void testMutableIterator() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableIterator.kt");
            }

            @Test
            @TestMetadata(value="mutableList.kt")
            public void testMutableList() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableList.kt");
            }

            @Test
            @TestMetadata(value="mutableMap.kt")
            public void testMutableMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableMap.kt");
            }

            @Test
            @TestMetadata(value="mutableMapEntry.kt")
            public void testMutableMapEntry() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableMapEntry.kt");
            }

            @Test
            @TestMetadata(value="mutableSet.kt")
            public void testMutableSet() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableSet.kt");
            }

            @Test
            @TestMetadata(value="set.kt")
            public void testSet() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/set.kt");
            }

            @Test
            @TestMetadata(value="UIntArrayWithFullJdk.kt")
            public void testUIntArrayWithFullJdk() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/UIntArrayWithFullJdk.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DefaultInterfaceMembers {
            @Test
            public void testAllFilesPresentInDefaultInterfaceMembers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="javaDefaultInterfaceMember.kt")
            public void testJavaDefaultInterfaceMember() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/javaDefaultInterfaceMember.kt");
            }

            @Test
            @TestMetadata(value="jvmDefaultAll.kt")
            public void testJvmDefaultAll() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/jvmDefaultAll.kt");
            }

            @Test
            @TestMetadata(value="jvmDefaultEnable.kt")
            public void testJvmDefaultEnable() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/jvmDefaultEnable.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inline")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Inline {
        @Test
        public void testAllFilesPresentInInline() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="genericReified.kt")
        public void testGenericReified() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/genericReified.kt");
        }

        @Test
        @TestMetadata(value="inlineOnly.kt")
        public void testInlineOnly() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineOnly.kt");
        }

        @Test
        @TestMetadata(value="InlineOnlyMultifile.kt")
        public void testInlineOnlyMultifile() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/InlineOnlyMultifile.kt");
        }

        @Test
        @TestMetadata(value="inlineOnlyProperty.kt")
        public void testInlineOnlyProperty() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineOnlyProperty.kt");
        }

        @Test
        @TestMetadata(value="InlineOnlyPropertyMultifile.kt")
        public void testInlineOnlyPropertyMultifile() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/InlineOnlyPropertyMultifile.kt");
        }

        @Test
        @TestMetadata(value="inlineReified.kt")
        public void testInlineReified() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReified.kt");
        }

        @Test
        @TestMetadata(value="InlineReifiedMultifile.kt")
        public void testInlineReifiedMultifile() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/InlineReifiedMultifile.kt");
        }

        @Test
        @TestMetadata(value="inlineReifiedProperty.kt")
        public void testInlineReifiedProperty() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedProperty.kt");
        }

        @Test
        @TestMetadata(value="InlineReifiedPropertyMultifile.kt")
        public void testInlineReifiedPropertyMultifile() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/InlineReifiedPropertyMultifile.kt");
        }

        @Test
        @TestMetadata(value="inlineReifiedPropertyVisibility.kt")
        public void testInlineReifiedPropertyVisibility() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedPropertyVisibility.kt");
        }

        @Test
        @TestMetadata(value="inlineReifiedVisibility.kt")
        public void testInlineReifiedVisibility() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedVisibility.kt");
        }

        @Test
        @TestMetadata(value="simpleNamed.kt")
        public void testSimpleNamed() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/simpleNamed.kt");
        }

        @Test
        @TestMetadata(value="suspendInlineReified.kt")
        public void testSuspendInlineReified() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/suspendInlineReified.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inline/enclosingInfo")
        @TestDataPath(value="$PROJECT_ROOT")
        public class EnclosingInfo {
            @Test
            public void testAllFilesPresentInEnclosingInfo() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="crossinlineLambdaChain.kt")
            public void testCrossinlineLambdaChain() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/crossinlineLambdaChain.kt");
            }

            @Test
            @TestMetadata(value="kt10259.kt")
            public void testKt10259() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/kt10259.kt");
            }

            @Test
            @TestMetadata(value="lambdaInInitBlockNoPrimaryConstructor.kt")
            public void testLambdaInInitBlockNoPrimaryConstructor() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/lambdaInInitBlockNoPrimaryConstructor.kt");
            }

            @Test
            @TestMetadata(value="lambdaInInnerClassConstructor.kt")
            public void testLambdaInInnerClassConstructor() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/lambdaInInnerClassConstructor.kt");
            }

            @Test
            @TestMetadata(value="transformedConstructor.kt")
            public void testTransformedConstructor() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/transformedConstructor.kt");
            }

            @Test
            @TestMetadata(value="transformedConstructorWithNestedInline.kt")
            public void testTransformedConstructorWithNestedInline() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/transformedConstructorWithNestedInline.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/deprecated")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Deprecated {
        @Test
        public void testAllFilesPresentInDeprecated() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/deprecated"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="deprecatedClass.kt")
        public void testDeprecatedClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedClass.kt");
        }

        @Test
        @TestMetadata(value="deprecatedEnumEntryFields.kt")
        public void testDeprecatedEnumEntryFields() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedEnumEntryFields.kt");
        }

        @Test
        @TestMetadata(value="deprecatedInMultifileClass.kt")
        public void testDeprecatedInMultifileClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedInMultifileClass.kt");
        }

        @Test
        @TestMetadata(value="deprecatedLateinitVar.kt")
        public void testDeprecatedLateinitVar() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedLateinitVar.kt");
        }

        @Test
        @TestMetadata(value="deprecatedProperty.kt")
        public void testDeprecatedProperty() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedProperty.kt");
        }

        @Test
        @TestMetadata(value="hidden.kt")
        public void testHidden() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/hidden.kt");
        }

        @Test
        @TestMetadata(value="inheritingDeprecation.kt")
        public void testInheritingDeprecation() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/inheritingDeprecation.kt");
        }

        @Test
        @TestMetadata(value="inlineClassTypesInSignature.kt")
        public void testInlineClassTypesInSignature() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/inlineClassTypesInSignature.kt");
        }

        @Test
        @TestMetadata(value="jvmStaticDeprecatedProperty.kt")
        public void testJvmStaticDeprecatedProperty() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/jvmStaticDeprecatedProperty.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/delegatedProperty")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DelegatedProperty {
        @Test
        public void testAllFilesPresentInDelegatedProperty() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="delegateMethodIsNonOverridable.kt")
        public void testDelegateMethodIsNonOverridable() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/delegateMethodIsNonOverridable.kt");
        }

        @Test
        @TestMetadata(value="delegatedPropertiesInCompanionObject.kt")
        public void testDelegatedPropertiesInCompanionObject() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/delegatedPropertiesInCompanionObject.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/defaultArguments")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DefaultArguments {
        @Test
        public void testAllFilesPresentInDefaultArguments() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="functionInMultifileClass.kt")
        public void testFunctionInMultifileClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/functionInMultifileClass.kt");
        }

        @Test
        @TestMetadata(value="functionInMultifileClassWithInheritedParts.kt")
        public void testFunctionInMultifileClassWithInheritedParts() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/functionInMultifileClassWithInheritedParts.kt");
        }

        @Test
        @TestMetadata(value="internalNameMangling.kt")
        public void testInternalNameMangling() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/internalNameMangling.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/coroutines")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Coroutines {
        @Test
        public void testAllFilesPresentInCoroutines() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="coroutineContextIntrinsic.kt")
        public void testCoroutineContextIntrinsic() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/coroutineContextIntrinsic.kt");
        }

        @Test
        @TestMetadata(value="coroutineFields.kt")
        public void testCoroutineFields() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/coroutineFields.kt");
        }

        @Test
        @TestMetadata(value="oomInReturnUnit.kt")
        public void testOomInReturnUnit() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/oomInReturnUnit.kt");
        }

        @Test
        @TestMetadata(value="privateAccessor.kt")
        public void testPrivateAccessor() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/privateAccessor.kt");
        }

        @Test
        @TestMetadata(value="privateSuspendFun.kt")
        public void testPrivateSuspendFun() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/privateSuspendFun.kt");
        }

        @Test
        @TestMetadata(value="suspendConversion.kt")
        public void testSuspendConversion() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendConversion.kt");
        }

        @Test
        @TestMetadata(value="suspendImpl.kt")
        public void testSuspendImpl() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendImpl.kt");
        }

        @Test
        @TestMetadata(value="suspendReifiedFun.kt")
        public void testSuspendReifiedFun() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendReifiedFun.kt");
        }

        @Test
        @TestMetadata(value="tcoContinuation.kt")
        public void testTcoContinuation() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/tcoContinuation.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/coroutines/spilling")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Spilling {
            @Test
            public void testAllFilesPresentInSpilling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/coroutines/spilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="booleanParameter.kt")
            public void testBooleanParameter() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/booleanParameter.kt");
            }

            @Test
            @TestMetadata(value="component1.kt")
            public void testComponent1() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/component1.kt");
            }

            @Test
            @TestMetadata(value="destructured.kt")
            public void testDestructured() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/destructured.kt");
            }

            @Test
            @TestMetadata(value="field.kt")
            public void testField() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/field.kt");
            }

            @Test
            @TestMetadata(value="lambda.kt")
            public void testLambda() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/lambda.kt");
            }

            @Test
            @TestMetadata(value="select.kt")
            public void testSelect() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/select.kt");
            }

            @Test
            @TestMetadata(value="unreachable.kt")
            public void testUnreachable() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/unreachable.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/collectionStubs")
    @TestDataPath(value="$PROJECT_ROOT")
    public class CollectionStubs {
        @Test
        @TestMetadata(value="abstractMapRedefiningGetAny.kt")
        public void testAbstractMapRedefiningGetAny() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractMapRedefiningGetAny.kt");
        }

        @Test
        public void testAllFilesPresentInCollectionStubs() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="collectionByDelegation.kt")
        public void testCollectionByDelegation() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation.kt");
        }

        @Test
        @TestMetadata(value="collectionByDelegation2.kt")
        public void testCollectionByDelegation2() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation2.kt");
        }

        @Test
        @TestMetadata(value="collectionByDelegation2WithFullJdk.kt")
        public void testCollectionByDelegation2WithFullJdk() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation2WithFullJdk.kt");
        }

        @Test
        @TestMetadata(value="collectionByDelegation3.kt")
        public void testCollectionByDelegation3() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation3.kt");
        }

        @Test
        @TestMetadata(value="collectionByDelegation3WithFullJdk.kt")
        public void testCollectionByDelegation3WithFullJdk() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation3WithFullJdk.kt");
        }

        @Test
        @TestMetadata(value="collectionByDelegationWithFullJdk.kt")
        public void testCollectionByDelegationWithFullJdk() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegationWithFullJdk.kt");
        }

        @Test
        @TestMetadata(value="collectionWithInternalRemove.kt")
        public void testCollectionWithInternalRemove() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionWithInternalRemove.kt");
        }

        @Test
        @TestMetadata(value="collectionsWithFullJdk.kt")
        public void testCollectionsWithFullJdk() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionsWithFullJdk.kt");
        }

        @Test
        @TestMetadata(value="customListIterator.kt")
        public void testCustomListIterator() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/customListIterator.kt");
        }

        @Test
        @TestMetadata(value="customMutableListIterator.kt")
        public void testCustomMutableListIterator() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/customMutableListIterator.kt");
        }

        @Test
        @TestMetadata(value="emptyList.kt")
        public void testEmptyList() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/emptyList.kt");
        }

        @Test
        @TestMetadata(value="extendingAbstractCollection.kt")
        public void testExtendingAbstractCollection() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/extendingAbstractCollection.kt");
        }

        @Test
        @TestMetadata(value="inheritingFromAbstractCollections.kt")
        public void testInheritingFromAbstractCollections() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractCollections.kt");
        }

        @Test
        @TestMetadata(value="inheritingFromAbstractMap.kt")
        public void testInheritingFromAbstractMap() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractMap.kt");
        }

        @Test
        @TestMetadata(value="inheritingFromAbstractMutableList.kt")
        public void testInheritingFromAbstractMutableList() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractMutableList.kt");
        }

        @Test
        @TestMetadata(value="kt44233.kt")
        public void testKt44233() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/kt44233.kt");
        }

        @Test
        @TestMetadata(value="ListAndSet.kt")
        public void testListAndSet() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/ListAndSet.kt");
        }

        @Test
        @TestMetadata(value="mapOfPrimitivesFullJdk.kt")
        public void testMapOfPrimitivesFullJdk() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/mapOfPrimitivesFullJdk.kt");
        }

        @Test
        @TestMetadata(value="noStubsForCollection.kt")
        public void testNoStubsForCollection() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForCollection.kt");
        }

        @Test
        @TestMetadata(value="noStubsForMapImplementations.kt")
        public void testNoStubsForMapImplementations() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForMapImplementations.kt");
        }

        @Test
        @TestMetadata(value="noStubsForMutableSetIterators.kt")
        public void testNoStubsForMutableSetIterators() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForMutableSetIterators.kt");
        }

        @Test
        @TestMetadata(value="noStubsForSetIterators.kt")
        public void testNoStubsForSetIterators() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForSetIterators.kt");
        }

        @Test
        @TestMetadata(value="noStubsInIterable.kt")
        public void testNoStubsInIterable() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInIterable.kt");
        }

        @Test
        @TestMetadata(value="noStubsInJavaSuperClass.kt")
        public void testNoStubsInJavaSuperClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInJavaSuperClass.kt");
        }

        @Test
        @TestMetadata(value="noStubsInMutableIterable.kt")
        public void testNoStubsInMutableIterable() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInMutableIterable.kt");
        }

        @Test
        @TestMetadata(value="observableMutableMap.kt")
        public void testObservableMutableMap() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/observableMutableMap.kt");
        }

        @Test
        @TestMetadata(value="stubForAbstractFun.kt")
        public void testStubForAbstractFun() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFun.kt");
        }

        @Test
        @TestMetadata(value="stubForAbstractFunInAbstractClass.kt")
        public void testStubForAbstractFunInAbstractClass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunInAbstractClass.kt");
        }

        @Test
        @TestMetadata(value="stubForAbstractFunInAbstractClassWithCovariantOverride.kt")
        public void testStubForAbstractFunInAbstractClassWithCovariantOverride() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunInAbstractClassWithCovariantOverride.kt");
        }

        @Test
        @TestMetadata(value="stubForAbstractFunWithCovariantOverride.kt")
        public void testStubForAbstractFunWithCovariantOverride() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunWithCovariantOverride.kt");
        }

        @Test
        @TestMetadata(value="stubLikeMethodSignatures.kt")
        public void testStubLikeMethodSignatures() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubLikeMethodSignatures.kt");
        }

        @Test
        @TestMetadata(value="stubsFromSuperclass.kt")
        public void testStubsFromSuperclass() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubsFromSuperclass.kt");
        }

        @Test
        @TestMetadata(value="stubsFromSuperclassNoBridges.kt")
        public void testStubsFromSuperclassNoBridges() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubsFromSuperclassNoBridges.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/collectionStubs/toArray")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ToArray {
            @Test
            public void testAllFilesPresentInToArray() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="customNonGenericToArray.kt")
            public void testCustomNonGenericToArray() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/customNonGenericToArray.kt");
            }

            @Test
            @TestMetadata(value="internalGenericToArray.kt")
            public void testInternalGenericToArray() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/internalGenericToArray.kt");
            }

            @Test
            @TestMetadata(value="noToArrayInJava.kt")
            public void testNoToArrayInJava() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/noToArrayInJava.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures")
        @TestDataPath(value="$PROJECT_ROOT")
        public class AbstractStubSignatures {
            @Test
            public void testAllFilesPresentInAbstractStubSignatures() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }

            @Test
            @TestMetadata(value="byteShortMap.kt")
            public void testByteShortMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/byteShortMap.kt");
            }

            @Test
            @TestMetadata(value="byteShortMutableMap.kt")
            public void testByteShortMutableMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/byteShortMutableMap.kt");
            }

            @Test
            @TestMetadata(value="collection.kt")
            public void testCollection() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/collection.kt");
            }

            @Test
            @TestMetadata(value="genericCollection.kt")
            public void testGenericCollection() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericCollection.kt");
            }

            @Test
            @TestMetadata(value="genericMap.kt")
            public void testGenericMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMap.kt");
            }

            @Test
            @TestMetadata(value="genericMutableCollection.kt")
            public void testGenericMutableCollection() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableCollection.kt");
            }

            @Test
            @TestMetadata(value="genericMutableList.kt")
            public void testGenericMutableList() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableList.kt");
            }

            @Test
            @TestMetadata(value="genericMutableMap.kt")
            public void testGenericMutableMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableMap.kt");
            }

            @Test
            @TestMetadata(value="genericStringMap.kt")
            public void testGenericStringMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericStringMap.kt");
            }

            @Test
            @TestMetadata(value="genericStringMutableMap.kt")
            public void testGenericStringMutableMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericStringMutableMap.kt");
            }

            @Test
            @TestMetadata(value="iterable.kt")
            public void testIterable() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/iterable.kt");
            }

            @Test
            @TestMetadata(value="iterator.kt")
            public void testIterator() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/iterator.kt");
            }

            @Test
            @TestMetadata(value="list.kt")
            public void testList() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/list.kt");
            }

            @Test
            @TestMetadata(value="listIterator.kt")
            public void testListIterator() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/listIterator.kt");
            }

            @Test
            @TestMetadata(value="mapEntry.kt")
            public void testMapEntry() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mapEntry.kt");
            }

            @Test
            @TestMetadata(value="mutableCollection.kt")
            public void testMutableCollection() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableCollection.kt");
            }

            @Test
            @TestMetadata(value="mutableIterable.kt")
            public void testMutableIterable() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableIterable.kt");
            }

            @Test
            @TestMetadata(value="mutableIterator.kt")
            public void testMutableIterator() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableIterator.kt");
            }

            @Test
            @TestMetadata(value="mutableList.kt")
            public void testMutableList() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableList.kt");
            }

            @Test
            @TestMetadata(value="mutableListIterator.kt")
            public void testMutableListIterator() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableListIterator.kt");
            }

            @Test
            @TestMetadata(value="mutableMapEntry.kt")
            public void testMutableMapEntry() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableMapEntry.kt");
            }

            @Test
            @TestMetadata(value="numberStringMap.kt")
            public void testNumberStringMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/numberStringMap.kt");
            }

            @Test
            @TestMetadata(value="numberStringMutableMap.kt")
            public void testNumberStringMutableMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/numberStringMutableMap.kt");
            }

            @Test
            @TestMetadata(value="set.kt")
            public void testSet() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/set.kt");
            }

            @Test
            @TestMetadata(value="specializedGenericMap.kt")
            public void testSpecializedGenericMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/specializedGenericMap.kt");
            }

            @Test
            @TestMetadata(value="stringGenericMap.kt")
            public void testStringGenericMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/stringGenericMap.kt");
            }

            @Test
            @TestMetadata(value="stringGenericMutableMap.kt")
            public void testStringGenericMutableMap() throws Exception {
                BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/stringGenericMutableMap.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/callableReference")
    @TestDataPath(value="$PROJECT_ROOT")
    public class CallableReference {
        @Test
        @TestMetadata(value="adaptedReference.kt")
        public void testAdaptedReference() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/callableReference/adaptedReference.kt");
        }

        @Test
        public void testAllFilesPresentInCallableReference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/annotations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Annotations {
        @Test
        public void testAllFilesPresentInAnnotations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
        }

        @Test
        @TestMetadata(value="annotationCtorCallGenerateSynthetic.kt")
        public void testAnnotationCtorCallGenerateSynthetic() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationCtorCallGenerateSynthetic.kt");
        }

        @Test
        @TestMetadata(value="annotationCtorCallNoSynthetic.kt")
        public void testAnnotationCtorCallNoSynthetic() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationCtorCallNoSynthetic.kt");
        }

        @Test
        @TestMetadata(value="annotationsOnDelegatedMembers.kt")
        public void testAnnotationsOnDelegatedMembers() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationsOnDelegatedMembers.kt");
        }

        @Test
        @TestMetadata(value="defaultTargets.kt")
        public void testDefaultTargets() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/defaultTargets.kt");
        }

        @Test
        @TestMetadata(value="deprecatedJvmOverloads.kt")
        public void testDeprecatedJvmOverloads() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/deprecatedJvmOverloads.kt");
        }

        @Test
        @TestMetadata(value="internalPropertyOrTypealias.kt")
        public void testInternalPropertyOrTypealias() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/internalPropertyOrTypealias.kt");
        }

        @Test
        @TestMetadata(value="JvmSynthetic.kt")
        public void testJvmSynthetic() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/JvmSynthetic.kt");
        }

        @Test
        @TestMetadata(value="kt27895.kt")
        public void testKt27895() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt27895.kt");
        }

        @Test
        @TestMetadata(value="kt43399.kt")
        public void testKt43399() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt43399.kt");
        }

        @Test
        @TestMetadata(value="kt43459.kt")
        public void testKt43459() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt43459.kt");
        }

        @Test
        @TestMetadata(value="kt9320.kt")
        public void testKt9320() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt9320.kt");
        }

        @Test
        @TestMetadata(value="literals.kt")
        public void testLiterals() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/literals.kt");
        }

        @Test
        @TestMetadata(value="localClassWithCapturedParams.kt")
        public void testLocalClassWithCapturedParams() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/localClassWithCapturedParams.kt");
        }

        @Test
        @TestMetadata(value="noAdditionalAnnotationsInAccessors.kt")
        public void testNoAdditionalAnnotationsInAccessors() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/noAdditionalAnnotationsInAccessors.kt");
        }

        @Test
        @TestMetadata(value="noAnnotationsInSyntheticAccessors.kt")
        public void testNoAnnotationsInSyntheticAccessors() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/noAnnotationsInSyntheticAccessors.kt");
        }

        @Test
        @TestMetadata(value="onProperties.kt")
        public void testOnProperties() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/onProperties.kt");
        }

        @Test
        @TestMetadata(value="onReceiver.kt")
        public void testOnReceiver() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/onReceiver.kt");
        }

        @Test
        @TestMetadata(value="unsignedTypes.kt")
        public void testUnsignedTypes() throws Exception {
            BytecodeListingTestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/unsignedTypes.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/annotations/repeatable")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Repeatable {
            @Test
            public void testAllFilesPresentInRepeatable() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/annotations/repeatable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM, true, new String[0]);
            }
        }
    }
}

