/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.signature;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureComputer;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.overrides.IrOverridingUtilKt;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001fH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureComputer;", "publicSignatureBuilder", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "table", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "(Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;)V", "startIndex", "", "(Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;I)V", "localIndex", "", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "scopeIndex", "composeContainerIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "compatibleMode", "", "composeFileLocalIdSignature", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "composeSignatureForDeclaration", "computeSignature", "inFile", "", "file", "Lorg/jetbrains/kotlin/ir/symbols/IrFileSymbol;", "block", "Lkotlin/Function0;", "ir.serialization.common"})
public final class IdSignatureSerializer
implements IdSignatureComputer {
    @NotNull
    private final PublicIdSignatureComputer publicSignatureBuilder;
    @NotNull
    private final DeclarationTable table;
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    private long localIndex;
    private int scopeIndex;

    public IdSignatureSerializer(@NotNull PublicIdSignatureComputer publicSignatureBuilder, @NotNull DeclarationTable table, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)publicSignatureBuilder, (String)"publicSignatureBuilder");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.publicSignatureBuilder = publicSignatureBuilder;
        this.table = table;
        this.mangler = this.publicSignatureBuilder.getMangler();
        this.localIndex = startIndex;
        this.scopeIndex = startIndex;
    }

    public IdSignatureSerializer(@NotNull PublicIdSignatureComputer publicSignatureBuilder, @NotNull DeclarationTable table) {
        Intrinsics.checkNotNullParameter((Object)publicSignatureBuilder, (String)"publicSignatureBuilder");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this(publicSignatureBuilder, table, 0);
    }

    @Override
    @NotNull
    public IdSignature computeSignature(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.publicSignatureBuilder.computeSignature(declaration2);
    }

    @NotNull
    public final IdSignature composeSignatureForDeclaration(@NotNull IrDeclaration declaration2, boolean compatibleMode) {
        KotlinMangler.IrMangler irMangler;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KotlinMangler.IrMangler $this$composeSignatureForDeclaration_u24lambda_u2d0 = irMangler = this.mangler;
        boolean bl = false;
        return $this$composeSignatureForDeclaration_u24lambda_u2d0.isExported(declaration2, compatibleMode) ? this.publicSignatureBuilder.composePublicIdSignature(declaration2, compatibleMode) : this.composeFileLocalIdSignature(declaration2, compatibleMode);
    }

    @Override
    public void inFile(@Nullable IrFileSymbol file2, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.publicSignatureBuilder.inFile(file2, block);
    }

    private final IdSignature composeContainerIdSignature(IrDeclarationParent container2, boolean compatibleMode) {
        IdSignature idSignature;
        IrDeclarationParent irDeclarationParent = container2;
        if (irDeclarationParent instanceof IrPackageFragment) {
            String string2 = ((IrPackageFragment)container2).getFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"container.fqName.asString()");
            idSignature = new IdSignature.CommonSignature(string2, "", null, 0L);
        } else if (irDeclarationParent instanceof IrDeclaration) {
            idSignature = this.table.signatureByDeclaration((IrDeclaration)((Object)container2), compatibleMode);
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected container ", (Object)RenderIrElementKt.render(container2)).toString());
        }
        return idSignature;
    }

    @NotNull
    public final IdSignature composeFileLocalIdSignature(@NotNull IrDeclaration declaration2, boolean compatibleMode) {
        boolean bl;
        KotlinMangler.IrMangler irMangler;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KotlinMangler.IrMangler $this$composeFileLocalIdSignature_u24lambda_u2d1 = irMangler = this.mangler;
        boolean bl2 = false;
        boolean bl3 = bl = !$this$composeFileLocalIdSignature_u24lambda_u2d1.isExported(declaration2, compatibleMode);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return this.table.privateDeclarationSignature(declaration2, compatibleMode, (Function0<? extends IdSignature>)((Function0)new Function0<IdSignature>(declaration2, this, compatibleMode){
            final /* synthetic */ IrDeclaration $declaration;
            final /* synthetic */ IdSignatureSerializer this$0;
            final /* synthetic */ boolean $compatibleMode;
            {
                this.$declaration = $declaration;
                this.this$0 = $receiver;
                this.$compatibleMode = $compatibleMode;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IdSignature invoke() {
                IdSignature idSignature;
                IrDeclaration irDeclaration2 = this.$declaration;
                if (irDeclaration2 instanceof IrValueDeclaration) {
                    IdSignatureSerializer idSignatureSerializer = this.this$0;
                    int n = IdSignatureSerializer.access$getScopeIndex$p(idSignatureSerializer);
                    IdSignatureSerializer.access$setScopeIndex$p(idSignatureSerializer, n + 1);
                    idSignature = new IdSignature.ScopeLocalDeclaration(n, ((IrValueDeclaration)this.$declaration).getName().asString());
                } else if (irDeclaration2 instanceof IrAnonymousInitializer) {
                    IdSignatureSerializer idSignatureSerializer = this.this$0;
                    int n = IdSignatureSerializer.access$getScopeIndex$p(idSignatureSerializer);
                    IdSignatureSerializer.access$setScopeIndex$p(idSignatureSerializer, n + 1);
                    idSignature = new IdSignature.ScopeLocalDeclaration(n, "ANON INIT");
                } else if (irDeclaration2 instanceof IrLocalDelegatedProperty) {
                    IdSignatureSerializer idSignatureSerializer = this.this$0;
                    int n = IdSignatureSerializer.access$getScopeIndex$p(idSignatureSerializer);
                    IdSignatureSerializer.access$setScopeIndex$p(idSignatureSerializer, n + 1);
                    idSignature = new IdSignature.ScopeLocalDeclaration(n, ((IrLocalDelegatedProperty)this.$declaration).getName().asString());
                } else if (irDeclaration2 instanceof IrField) {
                    IdSignature idSignature2;
                    Object object = ((IrField)this.$declaration).getCorrespondingPropertySymbol();
                    if (object == null) {
                        idSignature2 = IdSignatureSerializer.access$composeContainerIdSignature(this.this$0, this.$declaration.getParent(), this.$compatibleMode);
                    } else {
                        IrPropertySymbol irPropertySymbol = object;
                        IdSignatureSerializer idSignatureSerializer = this.this$0;
                        IrPropertySymbol it = irPropertySymbol;
                        boolean bl = false;
                        idSignature2 = idSignatureSerializer.composeSignatureForDeclaration((IrDeclaration)it.getOwner(), true);
                    }
                    IdSignature p = idSignature2;
                    object = this.this$0;
                    IdSignatureSerializer.access$setLocalIndex$p((IdSignatureSerializer)object, IdSignatureSerializer.access$getLocalIndex$p((IdSignatureSerializer)object) + 1L);
                    idSignature = new IdSignature.FileLocalSignature(p, IdSignatureSerializer.access$getLocalIndex$p((IdSignatureSerializer)object), null, 4, null);
                } else if (irDeclaration2 instanceof IrSimpleFunction) {
                    long l;
                    IdSignature p;
                    Object it;
                    Object object;
                    IdSignature idSignature3;
                    IrDeclarationParent parent2 = this.$declaration.getParent();
                    Object object2 = ((IrSimpleFunction)this.$declaration).getCorrespondingPropertySymbol();
                    if (object2 == null) {
                        idSignature3 = IdSignatureSerializer.access$composeContainerIdSignature(this.this$0, parent2, this.$compatibleMode);
                    } else {
                        object = object2;
                        it = this.this$0;
                        IrPropertySymbol it2 = object;
                        boolean bl = false;
                        idSignature3 = ((IdSignatureSerializer)it).composeSignatureForDeclaration((IrDeclaration)it2.getOwner(), true);
                    }
                    IdSignature idSignature4 = p = idSignature3;
                    if (IrOverridingUtilKt.isOverridableFunction((IrSimpleFunction)this.$declaration)) {
                        void $this$invoke_u24lambda_u2d2;
                        object2 = IdSignatureSerializer.access$getMangler$p(this.this$0);
                        object = this.$declaration;
                        it = object2;
                        IdSignature idSignature5 = idSignature4;
                        boolean bl = false;
                        long l2 = $this$invoke_u24lambda_u2d2.signatureMangle(object);
                        idSignature4 = idSignature5;
                        l = l2;
                    } else {
                        object2 = this.this$0;
                        IdSignatureSerializer.access$setLocalIndex$p((IdSignatureSerializer)object2, IdSignatureSerializer.access$getLocalIndex$p((IdSignatureSerializer)object2) + 1L);
                        l = IdSignatureSerializer.access$getLocalIndex$p((IdSignatureSerializer)object2);
                    }
                    String string2 = RenderIrElementKt.render(this.$declaration);
                    long l3 = l;
                    IdSignature idSignature6 = idSignature4;
                    idSignature = new IdSignature.FileLocalSignature(idSignature6, l3, string2);
                } else if (irDeclaration2 instanceof IrProperty) {
                    long l;
                    IrDeclarationParent parent3 = this.$declaration.getParent();
                    IdSignature idSignature7 = IdSignatureSerializer.access$composeContainerIdSignature(this.this$0, parent3, this.$compatibleMode);
                    if (IrOverridingUtilKt.isOverridableProperty((IrProperty)this.$declaration)) {
                        void $this$invoke_u24lambda_u2d3;
                        KotlinMangler.IrMangler irMangler = IdSignatureSerializer.access$getMangler$p(this.this$0);
                        IrDeclaration irDeclaration3 = this.$declaration;
                        KotlinMangler.IrMangler irMangler2 = irMangler;
                        IdSignature idSignature8 = idSignature7;
                        boolean bl = false;
                        long l4 = $this$invoke_u24lambda_u2d3.signatureMangle(irDeclaration3);
                        idSignature7 = idSignature8;
                        l = l4;
                    } else {
                        IdSignatureSerializer idSignatureSerializer = this.this$0;
                        IdSignatureSerializer.access$setLocalIndex$p(idSignatureSerializer, IdSignatureSerializer.access$getLocalIndex$p(idSignatureSerializer) + 1L);
                        l = IdSignatureSerializer.access$getLocalIndex$p(idSignatureSerializer);
                    }
                    String string3 = RenderIrElementKt.render(this.$declaration);
                    long l5 = l;
                    IdSignature idSignature9 = idSignature7;
                    idSignature = new IdSignature.FileLocalSignature(idSignature9, l5, string3);
                } else {
                    IdSignature idSignature10 = IdSignatureSerializer.access$composeContainerIdSignature(this.this$0, this.$declaration.getParent(), this.$compatibleMode);
                    IdSignatureSerializer idSignatureSerializer = this.this$0;
                    IdSignatureSerializer.access$setLocalIndex$p(idSignatureSerializer, IdSignatureSerializer.access$getLocalIndex$p(idSignatureSerializer) + 1L);
                    idSignature = new IdSignature.FileLocalSignature(idSignature10, IdSignatureSerializer.access$getLocalIndex$p(idSignatureSerializer), RenderIrElementKt.render(this.$declaration));
                }
                return idSignature;
            }
        }));
    }

    public static final /* synthetic */ int access$getScopeIndex$p(IdSignatureSerializer $this) {
        return $this.scopeIndex;
    }

    public static final /* synthetic */ void access$setScopeIndex$p(IdSignatureSerializer $this, int n) {
        $this.scopeIndex = n;
    }

    public static final /* synthetic */ IdSignature access$composeContainerIdSignature(IdSignatureSerializer $this, IrDeclarationParent container2, boolean compatibleMode) {
        return $this.composeContainerIdSignature(container2, compatibleMode);
    }

    public static final /* synthetic */ void access$setLocalIndex$p(IdSignatureSerializer $this, long l) {
        $this.localIndex = l;
    }

    public static final /* synthetic */ long access$getLocalIndex$p(IdSignatureSerializer $this) {
        return $this.localIndex;
    }

    public static final /* synthetic */ KotlinMangler.IrMangler access$getMangler$p(IdSignatureSerializer $this) {
        return $this.mangler;
    }
}

