/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.clientserver;

import java.io.Closeable;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.clientserver.MessageHeader;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/test/clientserver/TestProxy;", "", "serverPort", "", "testClass", "", "classPath", "", "Ljava/net/URL;", "(ILjava/lang/String;Ljava/util/List;)V", "getClassPath", "()Ljava/util/List;", "getServerPort", "()I", "getTestClass", "()Ljava/lang/String;", "filterOutJdkJars", "runTest", "runTestNoOutput", "tests-common-jvm6"})
public final class TestProxy {
    private final int serverPort;
    @NotNull
    private final String testClass;
    @NotNull
    private final List<URL> classPath;

    public TestProxy(int serverPort, @NotNull String testClass, @NotNull List<URL> classPath2) {
        Intrinsics.checkNotNullParameter((Object)testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter(classPath2, (String)"classPath");
        this.serverPort = serverPort;
        this.testClass = testClass;
        this.classPath = classPath2;
    }

    public final int getServerPort() {
        return this.serverPort;
    }

    @NotNull
    public final String getTestClass() {
        return this.testClass;
    }

    @NotNull
    public final List<URL> getClassPath() {
        return this.classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String runTest() {
        String string2;
        Closeable closeable = new Socket("localhost", this.serverPort);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            String string3;
            Socket clientSocket = (Socket)closeable;
            boolean bl3 = false;
            ObjectOutputStream output = new ObjectOutputStream(clientSocket.getOutputStream());
            ObjectInputStream input = new ObjectInputStream(clientSocket.getInputStream());
            try {
                output.writeObject((Object)MessageHeader.NEW_TEST);
                output.writeObject(this.getTestClass());
                output.writeObject("box");
                output.writeObject((Object)MessageHeader.CLASS_PATH);
                Collection $this$toTypedArray$iv = this.filterOutJdkJars(this.getClassPath());
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
                if (uRLArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                output.writeObject(uRLArray);
                Object object = input.readObject();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.test.clientserver.MessageHeader");
                }
                MessageHeader message2 = (MessageHeader)((Object)object);
                if (message2 == MessageHeader.RESULT) {
                    object = input.readObject();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                } else {
                    if (message2 == MessageHeader.ERROR) {
                        object = input.readObject();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                        }
                        throw (Throwable)object;
                    }
                    AssertionsKt.fail((String)Intrinsics.stringPlus((String)"Unknown message: ", (Object)((Object)message2)));
                    throw null;
                }
                string3 = (String)object;
            }
            finally {
                output.close();
                input.close();
            }
            string2 = string3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String runTestNoOutput() {
        Closeable closeable = new Socket("localhost", this.serverPort);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            String string2;
            Socket clientSocket = (Socket)closeable;
            boolean bl3 = false;
            ObjectOutputStream output = new ObjectOutputStream(clientSocket.getOutputStream());
            try {
                output.writeObject((Object)MessageHeader.NEW_TEST);
                output.writeObject(this.getTestClass());
                output.writeObject("box");
                output.writeObject((Object)MessageHeader.CLASS_PATH);
                Collection $this$toTypedArray$iv = this.filterOutJdkJars(this.getClassPath());
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
                if (uRLArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                output.writeObject(uRLArray);
                string2 = "OK";
            }
            catch (Throwable throwable2) {
                try {
                    output.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            output.close();
            String string3 = string2;
            return string3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<URL> filterOutJdkJars(@NotNull List<URL> classPath2) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(classPath2, (String)"classPath");
        String javaHome = System.getProperty("java.home");
        File javaFolder = new File(javaHome);
        Iterable $this$filterNot$iv = classPath2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            URL it = (URL)element$iv$iv;
            boolean bl = false;
            if (FilesKt.startsWith((File)new File(it.getFile()), (File)javaFolder)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

