/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.clientserver;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u001a\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0001\u001a;\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\f\u001a\u00020\b2\u001a\u0010\r\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u000e\"\u0006\u0012\u0002\b\u00030\u0003H\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u001a\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003*\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"getBoxMethodOrNull", "Ljava/lang/reflect/Method;", "aClass", "Ljava/lang/Class;", "getGeneratedClass", "classLoader", "Ljava/lang/ClassLoader;", "className", "", "runBoxMethod", "method", "getMethodOrNull", "name", "parameterTypes", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "loadClassOrNull", "tests-common-jvm6"})
public final class TestProcessServerKt {
    private static final Class<?> loadClassOrNull(ClassLoader $this$loadClassOrNull, String name2) {
        Class clazz;
        try {
            clazz = $this$loadClassOrNull.loadClass(name2);
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        return clazz;
    }

    private static final Method getMethodOrNull(Class<?> $this$getMethodOrNull, String name2, Class<?> ... parameterTypes) {
        Method method;
        try {
            method = $this$getMethodOrNull.getMethod(name2, Arrays.copyOf(parameterTypes, parameterTypes.length));
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        return method;
    }

    @NotNull
    public static final Class<?> getGeneratedClass(@NotNull ClassLoader classLoader, @NotNull String className2) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        Class<?> clazz = TestProcessServerKt.loadClassOrNull(classLoader, className2);
        if (clazz == null) {
            String string2 = Intrinsics.stringPlus((String)"No class file was generated for: ", (Object)className2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return clazz;
    }

    @Nullable
    public static final Method getBoxMethodOrNull(@NotNull Class<?> aClass) {
        Method method;
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        Method method2 = TestProcessServerKt.getMethodOrNull(aClass, "box", new Class[0]);
        if (method2 == null) {
            Class[] classArray;
            Class<?> it;
            boolean bl;
            boolean bl2;
            Method method3;
            Class<?> clazz = aClass.getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"aClass.classLoader");
            Class<?> clazz2 = TestProcessServerKt.loadClassOrNull((ClassLoader)((Object)clazz), "kotlin.coroutines.Continuation");
            if (clazz2 == null) {
                method3 = null;
            } else {
                clazz = clazz2;
                bl2 = false;
                bl = false;
                it = clazz;
                boolean bl3 = false;
                classArray = new Class[]{it};
                method3 = TestProcessServerKt.getMethodOrNull(aClass, "box", classArray);
            }
            Method method4 = method3;
            if (method4 == null) {
                clazz = aClass.getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"aClass.classLoader");
                clazz2 = TestProcessServerKt.loadClassOrNull((ClassLoader)((Object)clazz), "kotlin.coroutines.experimental.Continuation");
                if (clazz2 == null) {
                    method = null;
                } else {
                    clazz = clazz2;
                    bl2 = false;
                    bl = false;
                    it = clazz;
                    boolean bl4 = false;
                    classArray = new Class[]{it};
                    method = TestProcessServerKt.getMethodOrNull(aClass, "box", classArray);
                }
            } else {
                method = method4;
            }
        } else {
            method = method2;
        }
        return method;
    }

    @Nullable
    public static final String runBoxMethod(@NotNull Method method) {
        Object resultAfterSuspend;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Object object = method.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(object, (String)"method.parameterTypes");
        object = object;
        boolean bl = false;
        if (((Object[])object).length == 0) {
            object = method.invoke(null, new Object[0]);
            return object instanceof String ? (String)object : null;
        }
        Class<?> emptyContinuationClass = method.getDeclaringClass().getClassLoader().loadClass("helpers.ResultContinuation");
        Constructor<?>[] constructorArray = emptyContinuationClass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"emptyContinuationClass.declaredConstructors");
        Object emptyContinuation = ((Constructor)ArraysKt.single((Object[])constructorArray)).newInstance(new Object[0]);
        Object[] objectArray = new Object[]{emptyContinuation};
        Object result2 = method.invoke(null, objectArray);
        Object object2 = resultAfterSuspend = emptyContinuationClass.getField("result").get(emptyContinuation);
        Object object3 = object2 == null ? result2 : object2;
        return object3 instanceof String ? (String)object3 : null;
    }
}

