/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JVMConstructorCallNormalizationMode;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.JvmStringConcat;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.MockLibraryUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestJavacVersion;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.DirectiveToConfigurationKeyExtractor;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.SourceFileProvider;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManager;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManagerKt;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.util.StringUtilsKt;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006H\u0002J2\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006H\u0002J \u0010 \u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010$\u001a\u00020\u000e*\u00020%H\u0016J\u0014\u0010&\u001a\u00020\u000e*\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0006*\b\u0012\u0004\u0012\u00020(0\u0006H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\t\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JvmEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "additionalServices", "", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "()Ljava/util/List;", "directivesContainers", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectivesContainers", "addJavaBinaryRootsByJavaModules", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "configurationKind", "Lorg/jetbrains/kotlin/test/ConfigurationKind;", "moduleInfoFiles", "Lorg/jetbrains/kotlin/test/model/TestFile;", "addJavaCompiledModule", "moduleName", "", "bySources", "", "targetDir", "Ljava/io/File;", "addJavaCompiledModulesFromDependentKotlinModules", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "addJavaSourceRootsByJavaModules", "compileJavaFilesToModularJar", "sourcesDir", "configureCompilerConfiguration", "configureDefaultJvmTarget", "provideConfigurationKeys", "Lorg/jetbrains/kotlin/test/services/DirectiveToConfigurationKeyExtractor;", "registerModuleDependencies", "toFileList", "Lorg/jetbrains/kotlin/test/model/DependencyDescription;", "Companion", "tests-common-new"})
public final class JvmEnvironmentConfigurator
extends EnvironmentConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CompilerConfigurationKey<ConfigurationKind> TEST_CONFIGURATION_KIND_KEY;
    @Nullable
    private static final String DEFAULT_JVM_TARGET_FROM_PROPERTY;
    @NotNull
    private static final String JAVA_BINARIES_JAR_NAME = "java-binaries";

    public JvmEnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectivesContainers() {
        return CollectionsKt.listOf((Object)JvmEnvironmentConfigurationDirectives.INSTANCE);
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        Function1 serviceConstructor$iv = additionalServices.1.INSTANCE;
        boolean $i$f$service = false;
        return CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(CompiledClassesManager.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
    }

    @Override
    public void provideConfigurationKeys(@NotNull DirectiveToConfigurationKeyExtractor $this$provideConfigurationKeys) {
        Intrinsics.checkNotNullParameter((Object)$this$provideConfigurationKeys, (String)"<this>");
        ValueDirective<JvmStringConcat> valueDirective2 = JvmEnvironmentConfigurationDirectives.INSTANCE.getSTRING_CONCAT();
        CompilerConfigurationKey<Object> compilerConfigurationKey = JVMConfigurationKeys.STRING_CONCAT;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"STRING_CONCAT");
        $this$provideConfigurationKeys.register(valueDirective2, compilerConfigurationKey);
        ValueDirective<JVMAssertionsMode> valueDirective3 = JvmEnvironmentConfigurationDirectives.INSTANCE.getASSERTIONS_MODE();
        compilerConfigurationKey = JVMConfigurationKeys.ASSERTIONS_MODE;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"ASSERTIONS_MODE");
        $this$provideConfigurationKeys.register(valueDirective3, compilerConfigurationKey);
        ValueDirective<JVMConstructorCallNormalizationMode> valueDirective4 = JvmEnvironmentConfigurationDirectives.INSTANCE.getCONSTRUCTOR_CALL_NORMALIZATION_MODE();
        compilerConfigurationKey = JVMConfigurationKeys.CONSTRUCTOR_CALL_NORMALIZATION_MODE;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"CONSTRUCTOR_CALL_NORMALIZATION_MODE");
        $this$provideConfigurationKeys.register(valueDirective4, compilerConfigurationKey);
        ValueDirective<JvmClosureGenerationScheme> valueDirective5 = JvmEnvironmentConfigurationDirectives.INSTANCE.getSAM_CONVERSIONS();
        compilerConfigurationKey = JVMConfigurationKeys.SAM_CONVERSIONS;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"SAM_CONVERSIONS");
        $this$provideConfigurationKeys.register(valueDirective5, compilerConfigurationKey);
        ValueDirective<JvmClosureGenerationScheme> valueDirective6 = JvmEnvironmentConfigurationDirectives.INSTANCE.getLAMBDAS();
        compilerConfigurationKey = JVMConfigurationKeys.LAMBDAS;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"LAMBDAS");
        $this$provideConfigurationKeys.register(valueDirective6, compilerConfigurationKey);
        SimpleDirective simpleDirective = JvmEnvironmentConfigurationDirectives.INSTANCE.getUSE_OLD_INLINE_CLASSES_MANGLING_SCHEME();
        compilerConfigurationKey = JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"USE_OLD_INLINE_CLASSES_MANGLING_SCHEME");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective, compilerConfigurationKey, false, 4, null);
        SimpleDirective simpleDirective2 = LanguageSettingsDirectives.INSTANCE.getENABLE_JVM_PREVIEW();
        compilerConfigurationKey = JVMConfigurationKeys.ENABLE_JVM_PREVIEW;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"ENABLE_JVM_PREVIEW");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective2, compilerConfigurationKey, false, 4, null);
        SimpleDirective simpleDirective3 = LanguageSettingsDirectives.INSTANCE.getEMIT_JVM_TYPE_ANNOTATIONS();
        compilerConfigurationKey = JVMConfigurationKeys.EMIT_JVM_TYPE_ANNOTATIONS;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"EMIT_JVM_TYPE_ANNOTATIONS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective3, compilerConfigurationKey, false, 4, null);
        SimpleDirective simpleDirective4 = LanguageSettingsDirectives.INSTANCE.getNO_OPTIMIZED_CALLABLE_REFERENCES();
        compilerConfigurationKey = JVMConfigurationKeys.NO_OPTIMIZED_CALLABLE_REFERENCES;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"NO_OPTIMIZED_CALLABLE_REFERENCES");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective4, compilerConfigurationKey, false, 4, null);
        SimpleDirective simpleDirective5 = LanguageSettingsDirectives.INSTANCE.getDISABLE_PARAM_ASSERTIONS();
        compilerConfigurationKey = JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"DISABLE_PARAM_ASSERTIONS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective5, compilerConfigurationKey, false, 4, null);
        SimpleDirective simpleDirective6 = LanguageSettingsDirectives.INSTANCE.getDISABLE_CALL_ASSERTIONS();
        compilerConfigurationKey = JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"DISABLE_CALL_ASSERTIONS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective6, compilerConfigurationKey, false, 4, null);
        SimpleDirective simpleDirective7 = LanguageSettingsDirectives.INSTANCE.getNO_UNIFIED_NULL_CHECKS();
        compilerConfigurationKey = JVMConfigurationKeys.NO_UNIFIED_NULL_CHECKS;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"NO_UNIFIED_NULL_CHECKS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective7, compilerConfigurationKey, false, 4, null);
        SimpleDirective simpleDirective8 = LanguageSettingsDirectives.INSTANCE.getPARAMETERS_METADATA();
        compilerConfigurationKey = JVMConfigurationKeys.PARAMETERS_METADATA;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"PARAMETERS_METADATA");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective8, compilerConfigurationKey, false, 4, null);
        ValueDirective<JvmTarget> valueDirective7 = JvmEnvironmentConfigurationDirectives.INSTANCE.getJVM_TARGET();
        compilerConfigurationKey = JVMConfigurationKeys.JVM_TARGET;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"JVM_TARGET");
        $this$provideConfigurationKeys.register(valueDirective7, compilerConfigurationKey);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureCompilerConfiguration(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module2) {
        Collection moduleInfoFiles;
        void $this$filterTo$iv$iv;
        Object element$iv2;
        Iterable $this$forEach$iv;
        Iterator $this$filterTo$iv$iv2;
        Object object;
        CompilerConfiguration compilerConfiguration;
        Object object2;
        boolean useJava9ToCompileIncludedJavaFiles;
        List list2;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        if (!JvmPlatforms.INSTANCE.getAllJvmPlatforms().contains(module2.getTargetPlatform())) {
            return;
        }
        this.configureDefaultJvmTarget(configuration2);
        RegisteredDirectives registeredDirectives = module2.getDirectives();
        TestJdkKind testJdkKind = Companion.extractJdkKind(registeredDirectives);
        int n = WhenMappings.$EnumSwitchMapping$0[testJdkKind.ordinal()];
        switch (n) {
            case 1: {
                File file2 = KtTestUtil.findMockJdkRtJar();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"findMockJdkRtJar()");
                JvmContentRootsKt.addJvmClasspathRoot(configuration2, file2);
                configuration2.put(JVMConfigurationKeys.NO_JDK, true);
                break;
            }
            case 2: {
                File file2 = KtTestUtil.findMockJdkRtModified();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"findMockJdkRtModified()");
                JvmContentRootsKt.addJvmClasspathRoot(configuration2, file2);
                configuration2.put(JVMConfigurationKeys.NO_JDK, true);
                break;
            }
            case 3: {
                String string2 = System.getenv("JDK_16");
                if (string2 == null) {
                    String string3 = "Environment variable JDK_16 is not set";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                Object jdk6 = string2;
                configuration2.put(JVMConfigurationKeys.JDK_HOME, new File((String)jdk6));
                break;
            }
            case 4: {
                configuration2.put(JVMConfigurationKeys.JDK_HOME, KtTestUtil.getJdk9Home());
                break;
            }
            case 5: {
                configuration2.put(JVMConfigurationKeys.JDK_HOME, KtTestUtil.getJdk15Home());
                break;
            }
            case 6: {
                if (!SystemInfo.IS_AT_LEAST_JAVA9) break;
                configuration2.put(JVMConfigurationKeys.JDK_HOME, new File(System.getProperty("java.home")));
                break;
            }
            case 7: {
                Object jdk6 = KtTestUtil.findAndroidApiJar();
                Intrinsics.checkNotNullExpressionValue((Object)jdk6, (String)"findAndroidApiJar()");
                JvmContentRootsKt.addJvmClasspathRoot(configuration2, (File)jdk6);
                configuration2.put(JVMConfigurationKeys.NO_JDK, true);
            }
        }
        ConfigurationKind configurationKind = Companion.extractConfigurationKind(registeredDirectives);
        boolean jdk6 = false;
        boolean bl = false;
        ConfigurationKind it = configurationKind;
        boolean bl22 = false;
        configuration2.put(TEST_CONFIGURATION_KIND_KEY, it);
        ConfigurationKind configurationKind2 = configurationKind;
        TestJavacVersion javaVersionToCompile = (TestJavacVersion)((Object)CollectionsKt.singleOrNull(registeredDirectives.get(JvmEnvironmentConfigurationDirectives.INSTANCE.getCOMPILE_JAVA_USING())));
        if (!registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getALL_JAVA_AS_BINARY())) {
            void $this$filterTo$iv$iv3;
            Iterable $this$filter$iv = CompilerConfigurationProviderKt.getJavaFiles(module2);
            boolean $i$f$filter = false;
            Iterable bl22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                TestFile it2 = (TestFile)element$iv$iv;
                boolean bl3 = false;
                if (!it2.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getINCLUDE_JAVA_AS_BINARY())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CompilerConfigurationProviderKt.getJavaFiles(module2);
        }
        List javaBinaryFiles = list2;
        boolean bl4 = useJava9ToCompileIncludedJavaFiles = javaVersionToCompile == TestJavacVersion.JAVAC_9;
        if (configurationKind2.getWithRuntime()) {
            void it3;
            K2JVMCompilerArguments $i$f$filter = new K2JVMCompilerArguments();
            boolean $this$filterTo$iv$iv3 = false;
            boolean destination$iv$iv = false;
            K2JVMCompilerArguments $i$f$filterTo = $i$f$filter;
            object2 = PathUtil.getKotlinPathsForDistDirectory();
            compilerConfiguration = configuration2;
            boolean bl5 = false;
            it3.setNoReflect(true);
            object = Unit.INSTANCE;
            JvmArgumentsKt.configureStandardLibs(compilerConfiguration, (KotlinPaths)object2, $i$f$filter);
        }
        JvmContentRootsKt.addJvmClasspathRoots(configuration2, Companion.getLibraryFilesExceptRealRuntime(configurationKind2, module2.getDirectives()));
        TargetBackend $this$filterTo$iv$iv3 = module2.getTargetBackend();
        boolean isIr = $this$filterTo$iv$iv3 == null ? false : $this$filterTo$iv$iv3.isIR();
        configuration2.put(JVMConfigurationKeys.IR, isIr);
        Iterable $this$filter$iv = CompilerConfigurationProviderKt.getJavaFiles(module2);
        boolean $i$f$filter = false;
        Iterable bl5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator bl3 = $this$filterTo$iv$iv2.iterator();
        while (bl3.hasNext()) {
            Object element$iv$iv = bl3.next();
            TestFile it4 = (TestFile)element$iv$iv;
            boolean bl6 = false;
            if (!(!it4.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getINCLUDE_JAVA_AS_BINARY()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List javaSourceFiles = (List)destination$iv$iv;
        $this$filter$iv = javaSourceFiles;
        $i$f$filter = false;
        if (!$this$filter$iv.isEmpty() && !module2.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getSKIP_JAVA_SOURCES()) && !registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getALL_JAVA_AS_BINARY())) {
            $this$forEach$iv = javaSourceFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                TestFile it5 = (TestFile)element$iv2;
                boolean bl7 = false;
                SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getRealFileForSourceFile(it5);
            }
            this.addJavaCompiledModulesFromDependentKotlinModules(configuration2, configurationKind2, module2, true);
            Iterable $this$filter$iv2 = javaSourceFiles;
            boolean $i$f$filter2 = false;
            element$iv2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TestFile it6 = (TestFile)element$iv$iv;
                boolean bl8 = false;
                if (!Intrinsics.areEqual((Object)it6.getName(), (Object)"module-info.java")) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            moduleInfoFiles = (List)destination$iv$iv2;
            $this$filter$iv2 = moduleInfoFiles;
            $i$f$filter2 = false;
            if (!$this$filter$iv2.isEmpty()) {
                this.addJavaSourceRootsByJavaModules(configuration2, (List<TestFile>)moduleInfoFiles);
            } else {
                JvmContentRootsKt.addJavaSourceRoot$default(configuration2, SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getJavaSourceDirectory(), null, 2, null);
            }
        }
        moduleInfoFiles = javaBinaryFiles;
        boolean $this$filter$iv2 = false;
        if (!moduleInfoFiles.isEmpty()) {
            $this$forEach$iv = javaBinaryFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                TestFile it7 = (TestFile)element$iv2;
                boolean bl9 = false;
                SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getRealFileForBinaryFile(it7);
            }
            this.addJavaCompiledModulesFromDependentKotlinModules(configuration2, configurationKind2, module2, false);
            Object $this$filter$iv3 = javaBinaryFiles;
            boolean $i$f$filter3 = false;
            element$iv2 = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TestFile it8 = (TestFile)element$iv$iv;
                boolean bl10 = false;
                if (!Intrinsics.areEqual((Object)it8.getName(), (Object)"module-info.java")) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            moduleInfoFiles = (List)destination$iv$iv3;
            $this$filter$iv3 = moduleInfoFiles;
            $i$f$filter3 = false;
            if (!$this$filter$iv3.isEmpty()) {
                this.addJavaBinaryRootsByJavaModules(configuration2, configurationKind2, (List<TestFile>)moduleInfoFiles);
            } else {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$filter$iv3 = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getJavaBinaryDirectory().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)$this$filter$iv3, (String)"testServices.sourceFileP\u2026.javaBinaryDirectory.path");
                Object object3 = $this$filter$iv3;
                $this$filter$iv3 = JvmContentRootsKt.getJvmClasspathRoots(configuration2);
                List list3 = null;
                boolean bl11 = false;
                object = JAVA_BINARIES_JAR_NAME;
                object2 = object3;
                compilerConfiguration = configuration2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    File it8 = (File)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl12 = false;
                    String string4 = it8.getAbsolutePath();
                    collection.add(string4);
                }
                collection = (List)destination$iv$iv3;
                JvmContentRootsKt.addJvmClasspathRoot(compilerConfiguration, MockLibraryUtil.compileJavaFilesLibraryToJar$default((String)object2, (String)object, bl11, list3, collection, null, JUnit5Assertions.INSTANCE, useJava9ToCompileIncludedJavaFiles, 44, null));
            }
        }
        this.registerModuleDependencies(configuration2, module2);
        if (module2.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getUSE_PSI_CLASS_FILES_READING())) {
            configuration2.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, true);
        }
        if (module2.getDirectives().contains(LanguageSettingsDirectives.INSTANCE.getALLOW_KOTLIN_PACKAGE())) {
            configuration2.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, true);
        }
    }

    private final void addJavaSourceRootsByJavaModules(CompilerConfiguration configuration2, List<TestFile> moduleInfoFiles) {
        File javaSourceDirectory = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getJavaSourceDirectory();
        for (TestFile moduleInfoFile : moduleInfoFiles) {
            String moduleName = StringsKt.substringBefore$default((String)moduleInfoFile.getRelativePath(), (char)'/', null, (int)2, null);
            File file2 = new File(javaSourceDirectory.getPath() + '/' + moduleName);
            boolean bl = false;
            boolean bl2 = false;
            File it = file2;
            boolean bl3 = false;
            it.mkdir();
            File moduleDir = file2;
            JvmContentRootsKt.addJavaSourceRoot$default(configuration2, moduleDir, null, 2, null);
        }
    }

    private final void addJavaBinaryRootsByJavaModules(CompilerConfiguration configuration2, ConfigurationKind configurationKind, List<TestFile> moduleInfoFiles) {
        File javaBinaryDirectory = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getJavaBinaryDirectory();
        for (TestFile moduleInfoFile : moduleInfoFiles) {
            String moduleName = StringsKt.substringBefore$default((String)moduleInfoFile.getRelativePath(), (char)'/', null, (int)2, null);
            this.addJavaCompiledModule(configuration2, configurationKind, moduleName, true, javaBinaryDirectory);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addJavaCompiledModulesFromDependentKotlinModules(CompilerConfiguration configuration2, ConfigurationKind configurationKind, TestModule module2, boolean bySources) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = module2.getAllDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TestModule testModule = DependencyProviderKt.getDependencyProvider(this.getTestServices()).getTestModule(it.getModuleName());
            collection.add(testModule);
        }
        List moduleDependencies2 = (List)destination$iv$iv;
        Function1 filterJavaModuleInfoFiles2 = (Function1)new Function1<TestFile, Boolean>(module2, bySources){
            final /* synthetic */ TestModule $module;
            final /* synthetic */ boolean $bySources;
            {
                this.$module = $module;
                this.$bySources = $bySources;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TestFile testFile) {
                Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
                boolean binaryFilesFilter = testFile.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getINCLUDE_JAVA_AS_BINARY()) || this.$module.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getALL_JAVA_AS_BINARY());
                boolean includeOrExcludeBinaryFilesFilter = this.$bySources && !binaryFilesFilter || !this.$bySources && binaryFilesFilter;
                return includeOrExcludeBinaryFilesFilter && Intrinsics.areEqual((Object)testFile.getName(), (Object)"module-info.java");
            }
        };
        Iterable $this$mapNotNull$iv = moduleDependencies2;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$mapTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TestFile testFile;
            Object v0;
            block5: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                TestModule it = (TestModule)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$singleOrNull$iv = CompilerConfigurationProviderKt.getJavaFiles(it);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    if (!((Boolean)filterJavaModuleInfoFiles2.invoke(element$iv)).booleanValue()) continue;
                    if (found$iv) {
                        v0 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            if ((TestFile)v0 == null) continue;
            boolean bl = false;
            boolean bl3 = false;
            TestFile it$iv$iv = testFile;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List moduleInfoFilesFromDependencies = (List)destination$iv$iv2;
        for (TestFile dependentModuleInfoFile : moduleInfoFilesFromDependencies) {
            String moduleName = StringsKt.substringBefore$default((String)dependentModuleInfoFile.getRelativePath(), (char)'/', null, (int)2, null);
            JvmEnvironmentConfigurator.addJavaCompiledModule$default(this, configuration2, configurationKind, moduleName, bySources, null, 16, null);
        }
    }

    private final void addJavaCompiledModule(CompilerConfiguration configuration2, ConfigurationKind configurationKind, String moduleName, boolean bySources, File targetDir) {
        File moduleDir = new File(targetDir.getPath() + '/' + moduleName);
        File javaBinaries = bySources ? this.compileJavaFilesToModularJar(configuration2, configurationKind, moduleDir) : new File(Intrinsics.stringPlus((String)moduleDir.getPath(), (Object)"/java-binaries.jar"));
        JvmArgumentsKt.addModularRootIfNotNull(configuration2, true, moduleName, javaBinaries);
    }

    static /* synthetic */ void addJavaCompiledModule$default(JvmEnvironmentConfigurator jvmEnvironmentConfigurator, CompilerConfiguration compilerConfiguration, ConfigurationKind configurationKind, String string2, boolean bl, File file2, int n, Object object) {
        if ((n & 0x10) != 0) {
            SourceFileProvider sourceFileProvider = SourceFileProviderKt.getSourceFileProvider(jvmEnvironmentConfigurator.getTestServices());
            boolean bl2 = false;
            boolean bl3 = false;
            SourceFileProvider $this$addJavaCompiledModule_u24lambda_u2d12 = sourceFileProvider;
            boolean bl4 = false;
            file2 = bl ? $this$addJavaCompiledModule_u24lambda_u2d12.getJavaSourceDirectory() : $this$addJavaCompiledModule_u24lambda_u2d12.getJavaBinaryDirectory();
        }
        jvmEnvironmentConfigurator.addJavaCompiledModule(compilerConfiguration, configurationKind, string2, bl, file2);
    }

    /*
     * WARNING - void declaration
     */
    private final File compileJavaFilesToModularJar(CompilerConfiguration configuration2, ConfigurationKind configurationKind, File sourcesDir) {
        void $this$mapTo$iv$iv;
        Collection<String> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        Object object = CollectionsKt.createListBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        List $this$compileJavaFilesToModularJar_u24lambda_u2d14 = object;
        boolean bl5 = false;
        Iterable iterable = JvmContentRootsKt.getJvmModularRoots(configuration2);
        List list2 = $this$compileJavaFilesToModularJar_u24lambda_u2d14;
        boolean $i$f$map3 = false;
        void var15_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            String string2 = it.getAbsolutePath();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        list2.addAll((Collection)collection);
        if (configurationKind.getWithRuntime()) {
            $this$compileJavaFilesToModularJar_u24lambda_u2d14.add(ForTestCompileRuntime.runtimeJarForTests().getPath());
        }
        List modulePath = CollectionsKt.build((List)object);
        String string3 = sourcesDir.getPath();
        Iterable $this$map$iv2 = JvmContentRootsKt.getJvmClasspathRoots(configuration2);
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File $i$f$map3 = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl7 = false;
            String string4 = it.getAbsolutePath();
            collection2.add(string4);
        }
        List list3 = (List)destination$iv$iv2;
        object = JUnit5Assertions.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"path");
        return MockLibraryUtil.compileLibraryToJar$default(string3, sourcesDir, JAVA_BINARIES_JAR_NAME, false, false, null, list3, modulePath, true, (Assertions)object, 56, null);
    }

    private final void configureDefaultJvmTarget(CompilerConfiguration configuration2) {
        if (DEFAULT_JVM_TARGET_FROM_PROPERTY == null) {
            return;
        }
        JvmTarget jvmTarget = JvmTarget.Companion.fromString(DEFAULT_JVM_TARGET_FROM_PROPERTY);
        if (jvmTarget == null) {
            String string2 = Intrinsics.stringPlus((String)"Can't construct JvmTarget for ", (Object)DEFAULT_JVM_TARGET_FROM_PROPERTY);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        JvmTarget customDefaultTarget = jvmTarget;
        JvmTarget originalTarget = configuration2.get(JVMConfigurationKeys.JVM_TARGET);
        if (originalTarget == null || customDefaultTarget.getMajorVersion() > originalTarget.getMajorVersion()) {
            configuration2.put(JVMConfigurationKeys.JVM_TARGET, customDefaultTarget);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerModuleDependencies(CompilerConfiguration $this$registerModuleDependencies, TestModule module2) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv;
        Iterable iterable = module2.getAllDependencies();
        Object object = this;
        CompilerConfiguration compilerConfiguration = $this$registerModuleDependencies;
        boolean $i$f$filter = false;
        void var5_8 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            DependencyDescription it = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == DependencyKind.Binary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<String> collection = (List)destination$iv$iv;
        JvmContentRootsKt.addJvmClasspathRoots(compilerConfiguration, ((JvmEnvironmentConfigurator)object).toFileList((List<DependencyDescription>)collection));
        Iterable $this$filter$iv2 = module2.getFriendDependencies();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DependencyDescription it = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == DependencyKind.Binary)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List binaryFriends = (List)destination$iv$iv2;
        $this$filter$iv2 = binaryFriends;
        $i$f$filter2 = false;
        if (!$this$filter$iv2.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$filter$iv2 = this.toFileList(binaryFriends);
            object = JVMConfigurationKeys.FRIEND_PATHS;
            compilerConfiguration = $this$registerModuleDependencies;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File it = (File)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                String string2 = it.getAbsolutePath();
                collection.add(string2);
            }
            collection = (List)destination$iv$iv2;
            compilerConfiguration.put(object, collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> toFileList(List<DependencyDescription> $this$toFileList) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$toFileList;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DependencyDescription dependency = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            TestModule friendModule = DependencyProviderKt.getDependencyProvider(this.getTestServices()).getTestModule(dependency.getModuleName());
            Object[] objectArray = new File[]{CompiledClassesManager.getCompiledKotlinDirForModule$default(CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()), friendModule, null, 2, null), CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()).getCompiledJavaDirForModule(friendModule)};
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        CompilerConfigurationKey compilerConfigurationKey = CompilerConfigurationKey.create("ConfigurationKind");
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"create<ConfigurationKind>(\"ConfigurationKind\")");
        TEST_CONFIGURATION_KIND_KEY = compilerConfigurationKey;
        DEFAULT_JVM_TARGET_FROM_PROPERTY = System.getProperty("kotlin.test.default.jvm.target");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000eR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JvmEnvironmentConfigurator$Companion;", "", "()V", "DEFAULT_JVM_TARGET_FROM_PROPERTY", "", "JAVA_BINARIES_JAR_NAME", "TEST_CONFIGURATION_KIND_KEY", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "Lorg/jetbrains/kotlin/test/ConfigurationKind;", "kotlin.jvm.PlatformType", "getTEST_CONFIGURATION_KIND_KEY", "()Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "extractConfigurationKind", "registeredDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "extractJdkKind", "Lorg/jetbrains/kotlin/test/TestJdkKind;", "getLibraryFilesExceptRealRuntime", "", "Ljava/io/File;", "configurationKind", "directives", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompilerConfigurationKey<ConfigurationKind> getTEST_CONFIGURATION_KIND_KEY() {
            return TEST_CONFIGURATION_KIND_KEY;
        }

        @NotNull
        public final ConfigurationKind extractConfigurationKind(@NotNull RegisteredDirectives registeredDirectives) {
            Intrinsics.checkNotNullParameter((Object)registeredDirectives, (String)"registeredDirectives");
            boolean withRuntime = registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getWITH_RUNTIME()) || registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getWITH_STDLIB());
            boolean withReflect = registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getWITH_REFLECT());
            boolean noRuntime = registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getNO_RUNTIME());
            if (noRuntime && withRuntime) {
                String string2 = "NO_RUNTIME and WITH_RUNTIME can not be used together";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return withRuntime && !withReflect ? ConfigurationKind.NO_KOTLIN_REFLECT : (withRuntime || withReflect ? ConfigurationKind.ALL : (noRuntime ? ConfigurationKind.JDK_NO_RUNTIME : ConfigurationKind.JDK_ONLY));
        }

        @NotNull
        public final TestJdkKind extractJdkKind(@NotNull RegisteredDirectives registeredDirectives) {
            TestJdkKind testJdkKind;
            Intrinsics.checkNotNullParameter((Object)registeredDirectives, (String)"registeredDirectives");
            boolean fullJdkEnabled = registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getFULL_JDK());
            List<TestJdkKind> jdkKinds = registeredDirectives.get(JvmEnvironmentConfigurationDirectives.INSTANCE.getJDK_KIND());
            if (fullJdkEnabled) {
                Object object = jdkKinds;
                boolean bl = false;
                if (!object.isEmpty()) {
                    object = "FULL_JDK and JDK_KIND can not be used together";
                    bl = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                return TestJdkKind.FULL_JDK;
            }
            int n = jdkKinds.size();
            switch (n) {
                case 0: {
                    testJdkKind = TestJdkKind.MOCK_JDK;
                    break;
                }
                case 1: {
                    testJdkKind = (TestJdkKind)((Object)CollectionsKt.single(jdkKinds));
                    break;
                }
                default: {
                    String string2 = Intrinsics.stringPlus((String)"Too many jdk kinds passed: ", (Object)StringUtilsKt.joinToArrayString((Iterable)jdkKinds));
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
            }
            return testJdkKind;
        }

        @NotNull
        public final List<File> getLibraryFilesExceptRealRuntime(@NotNull ConfigurationKind configurationKind, @NotNull RegisteredDirectives directives2) {
            Intrinsics.checkNotNullParameter((Object)((Object)configurationKind), (String)"configurationKind");
            Intrinsics.checkNotNullParameter((Object)directives2, (String)"directives");
            boolean bl = false;
            List files2 = new ArrayList();
            if (configurationKind.getWithRuntime()) {
                File file2 = ForTestCompileRuntime.kotlinTestJarForTests();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"kotlinTestJarForTests()");
                files2.add(file2);
            } else if (configurationKind.getWithMockRuntime()) {
                File file3 = ForTestCompileRuntime.minimalRuntimeJarForTests();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"minimalRuntimeJarForTests()");
                files2.add(file3);
                file3 = ForTestCompileRuntime.scriptRuntimeJarForTests();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"scriptRuntimeJarForTests()");
                files2.add(file3);
            }
            if (configurationKind.getWithReflection()) {
                File file4 = ForTestCompileRuntime.reflectJarForTests();
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"reflectJarForTests()");
                files2.add(file4);
            }
            File file5 = KtTestUtil.getAnnotationsJar();
            Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"getAnnotationsJar()");
            files2.add(file5);
            if (directives2.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getSTDLIB_JDK8())) {
                file5 = ForTestCompileRuntime.runtimeJarForTestsWithJdk8();
                Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"runtimeJarForTestsWithJdk8()");
                files2.add(file5);
            }
            file5 = KtTestUtil.getAnnotationsJar();
            Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"getAnnotationsJar()");
            files2.add(file5);
            return files2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestJdkKind.values().length];
            nArray[TestJdkKind.MOCK_JDK.ordinal()] = 1;
            nArray[TestJdkKind.MODIFIED_MOCK_JDK.ordinal()] = 2;
            nArray[TestJdkKind.FULL_JDK_6.ordinal()] = 3;
            nArray[TestJdkKind.FULL_JDK_9.ordinal()] = 4;
            nArray[TestJdkKind.FULL_JDK_15.ordinal()] = 5;
            nArray[TestJdkKind.FULL_JDK.ordinal()] = 6;
            nArray[TestJdkKind.ANDROID_API.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

