/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic.handlers;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.utils.DiagnosticsRenderingConfiguration;
import org.jetbrains.kotlin.codeMetaInfo.model.DiagnosticCodeMetaInfo;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicMetaInfoUtils;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J2\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticReporter;", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "globalMetadataInfoHandler", "Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "getGlobalMetadataInfoHandler", "()Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "createConfiguration", "Lorg/jetbrains/kotlin/checkers/utils/DiagnosticsRenderingConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "reportDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "configuration", "withNewInferenceModeEnabled", "", "toMetaInfo", "", "Lorg/jetbrains/kotlin/codeMetaInfo/model/DiagnosticCodeMetaInfo;", "newInferenceEnabled", "tests-common-new"})
public final class ClassicDiagnosticReporter {
    @NotNull
    private final TestServices testServices;

    public ClassicDiagnosticReporter(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.testServices = testServices;
    }

    private final GlobalMetadataInfoHandler getGlobalMetadataInfoHandler() {
        return GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(this.testServices);
    }

    @NotNull
    public final DiagnosticsRenderingConfiguration createConfiguration(@NotNull TestModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return new DiagnosticsRenderingConfiguration(null, module2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference), module2.getLanguageVersionSettings(), CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.testServices).getCompilerConfiguration(module2).getBoolean(JVMConfigurationKeys.IR));
    }

    public final void reportDiagnostic(@NotNull Diagnostic diagnostic, @NotNull TestModule module2, @NotNull TestFile file2, @NotNull DiagnosticsRenderingConfiguration configuration2, boolean withNewInferenceModeEnabled) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.getGlobalMetadataInfoHandler().addMetadataInfosForFile(file2, this.toMetaInfo(diagnostic, module2, file2, configuration2.getWithNewInference(), withNewInferenceModeEnabled));
    }

    /*
     * WARNING - void declaration
     */
    private final List<DiagnosticCodeMetaInfo> toMetaInfo(Diagnostic $this$toMetaInfo, TestModule module2, TestFile file2, boolean newInferenceEnabled, boolean withNewInferenceModeEnabled) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toMetaInfo.getTextRanges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            boolean bl;
            DiagnosticCodeMetaInfo metaInfo;
            Collection collection;
            block15: {
                Object object;
                Object object2;
                void range;
                TextRange textRange = (TextRange)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                metaInfo = new DiagnosticCodeMetaInfo((TextRange)range, ClassicMetaInfoUtils.INSTANCE.getRenderDiagnosticNoArgs(), $this$toMetaInfo);
                if (withNewInferenceModeEnabled) {
                    DiagnosticCodeMetaInfo diagnosticCodeMetaInfo = metaInfo;
                    object2 = diagnosticCodeMetaInfo.getAttributes();
                    object = newInferenceEnabled ? "NI" : "OI";
                    boolean bl3 = false;
                    object2.add(object);
                }
                if (!module2.getFiles().contains(file2)) {
                    String string2;
                    TargetPlatform targetPlatform = module2.getTargetPlatform();
                    object2 = metaInfo;
                    object = ((DiagnosticCodeMetaInfo)object2).getAttributes();
                    if (JvmPlatformKt.isJvm(targetPlatform)) {
                        string2 = "JVM";
                    } else if (JsPlatformKt.isJs(targetPlatform)) {
                        string2 = "JS";
                    } else if (NativePlatformKt.isNative(targetPlatform)) {
                        string2 = "NATIVE";
                    } else if (TargetPlatformKt.isCommon(targetPlatform)) {
                        string2 = "COMMON";
                    } else {
                        String string3 = "Should not be here";
                        boolean bl4 = false;
                        throw (Throwable)new IllegalStateException(string3.toString());
                    }
                    String string4 = string2;
                    boolean bl5 = false;
                    object.add(string4);
                }
                List<ParsedCodeMetaInfo> existing = this.getGlobalMetadataInfoHandler().getExistingMetaInfosForActualMetadata(file2, metaInfo);
                Iterable $this$any$iv = existing;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ParsedCodeMetaInfo it = (ParsedCodeMetaInfo)element$iv;
                        boolean bl6 = false;
                        if (!(it.getDescription() != null)) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl) {
                metaInfo.replaceRenderConfiguration(ClassicMetaInfoUtils.INSTANCE.getRenderDiagnosticWithArgs());
            }
            DiagnosticCodeMetaInfo diagnosticCodeMetaInfo = metaInfo;
            collection.add(diagnosticCodeMetaInfo);
        }
        return (List)destination$iv$iv;
    }
}

