/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.InterfaceDefaultMethodCallChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InterfaceDefaultMethodCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findInterfaceMember", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptorToSearch", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "startExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getSuperCallLabelTarget", "expression", "isDefaultCallsProhibited", "", "frontend.java"})
public final class InterfaceDefaultMethodCallChecker
implements CallChecker {
    @NotNull
    private final JvmTarget jvmTarget;

    public InterfaceDefaultMethodCallChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        this.jvmTarget = jvmTarget;
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        ClassDescriptor classDescriptor;
        CallableMemberDescriptor callableMemberDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean supportDefaults = this.jvmTarget.compareTo((Enum)JvmTarget.JVM_1_8) >= 0;
        Object object = resolvedCall2.getResultingDescriptor();
        CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor = object instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)object : null;
        if (callableMemberDescriptor == null) {
            return;
        }
        CallableMemberDescriptor descriptor2 = callableMemberDescriptor;
        if (descriptor2 instanceof JavaPropertyDescriptor) {
            return;
        }
        if (!supportDefaults && DescriptorUtils.isStaticDeclaration(descriptor2) && DescriptorUtils.isInterface(descriptor2.getContainingDeclaration()) && descriptor2 instanceof JavaCallableMemberDescriptor) {
            DiagnosticFactory0<PsiElement> diagnostic = this.isDefaultCallsProhibited(context2) ? ErrorsJvm.INTERFACE_STATIC_METHOD_CALL_FROM_JAVA6_TARGET_ERROR : ErrorsJvm.INTERFACE_STATIC_METHOD_CALL_FROM_JAVA6_TARGET;
            context2.getTrace().report(diagnostic.on(reportOn));
        }
        Object object2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"resolvedCall.call");
        object = CallResolverUtilKt.getSuperCallExpression((Call)object2);
        if (object == null) {
            return;
        }
        Object superCallExpression = object;
        if (!DescriptorUtils.isInterface(descriptor2.getOriginal().getContainingDeclaration())) {
            return;
        }
        object2 = DescriptorUtils.unwrapFakeOverride(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"unwrapFakeOverride(descriptor)");
        Object realDescriptor = object2;
        DeclarationDescriptor declarationDescriptor = realDescriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor2 = classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor realDescriptorOwner = classDescriptor;
        JvmDefaultMode jvmDefaultMode = context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getJvmDefaultMode());
        if (DescriptorUtils.isInterface(realDescriptorOwner) && (realDescriptor instanceof JavaCallableMemberDescriptor || JvmAnnotationUtilKt.isCompiledToJvmDefault((CallableMemberDescriptor)realDescriptor, jvmDefaultMode))) {
            CallableMemberDescriptor declarationWithCall;
            CallableMemberDescriptor callableMemberDescriptor3;
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
            BindingContext bindingContext2 = bindingContext;
            ClassDescriptor thisForSuperCall = this.getSuperCallLabelTarget(bindingContext2, (KtSuperExpression)superCallExpression);
            if (thisForSuperCall != null && DescriptorUtils.isInterface(thisForSuperCall) && ((callableMemberDescriptor3 = (declarationWithCall = this.findInterfaceMember(thisForSuperCall, (KtSuperExpression)superCallExpression, bindingContext2))) == null ? false : !JvmAnnotationUtilKt.isCompiledToJvmDefault(callableMemberDescriptor3, jvmDefaultMode))) {
                context2.getTrace().report(ErrorsJvm.INTERFACE_CANT_CALL_DEFAULT_METHOD_VIA_SUPER.on(reportOn));
                return;
            }
            if (!supportDefaults) {
                DiagnosticFactory0<PsiElement> diagnostic = this.isDefaultCallsProhibited(context2) ? ErrorsJvm.DEFAULT_METHOD_CALL_FROM_JAVA6_TARGET_ERROR : ErrorsJvm.DEFAULT_METHOD_CALL_FROM_JAVA6_TARGET;
                context2.getTrace().report(diagnostic.on(reportOn));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CallableMemberDescriptor findInterfaceMember(ClassDescriptor descriptorToSearch, KtSuperExpression startExpression, BindingContext bindingContext) {
        Sequence parents2;
        Sequence $this$fold$iv = parents2 = SequencesKt.generateSequence((Function0)((Function0)new Function0<PsiElement>(startExpression){
            final /* synthetic */ KtSuperExpression $startExpression;
            {
                this.$startExpression = $startExpression;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                return this.$startExpression.getParent();
            }
        }), (Function1)findInterfaceMember.parents.2.INSTANCE);
        boolean $i$f$fold = false;
        KtSuperExpression accumulator$iv = startExpression;
        for (Object element$iv : $this$fold$iv) {
            void parent2;
            PsiElement psiElement = (PsiElement)element$iv;
            PsiElement child = (PsiElement)accumulator$iv;
            boolean bl = false;
            if (parent2 instanceof KtClassBody && Intrinsics.areEqual((Object)descriptorToSearch, bindingContext.get(BindingContext.CLASS, ((KtClassBody)parent2).getParent()))) {
                Object v;
                PsiElement psiElement2 = child;
                return psiElement2 instanceof KtNamedFunction ? (CallableMemberDescriptor)bindingContext.get(BindingContext.FUNCTION, child) : (psiElement2 instanceof KtProperty ? (CallableMemberDescriptor)((v = bindingContext.get(BindingContext.VARIABLE, child)) instanceof PropertyDescriptor ? (PropertyDescriptor)v : null) : null);
            }
            accumulator$iv = parent2;
        }
        return null;
    }

    private final boolean isDefaultCallsProhibited(CallCheckerContext context2) {
        return context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.DefaultMethodsCallFromJava6TargetError);
    }

    private final ClassDescriptor getSuperCallLabelTarget(BindingContext bindingContext, KtSuperExpression expression2) {
        KotlinType kotlinType = (KotlinType)bindingContext.get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType kotlinType2 = kotlinType;
        KotlinType thisTypeForSuperCall = kotlinType2;
        ClassifierDescriptor descriptor2 = thisTypeForSuperCall.getConstructor().getDeclarationDescriptor();
        return descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
    }
}

